package webmaj;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.StringTokenizer;

import org.opensi.webmanager.utils.ToolsMAJ;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class QuartzManager
{

	private File aEcrire;
	private static String type="QuartzManager";
	
	private String login_bd;
	private String mdp_bd;
	private String driver_bd;
	private String url_bd;
	private String dossier_root;

	private static Scheduler scheduler;
	
	public QuartzManager()
	{
		try
		{		
			aEcrire=new File("ServeurQuartz.log");//le fichier de log
			SchedulerFactory schedFact = new org.quartz.impl.StdSchedulerFactory();
			scheduler = schedFact.getScheduler();
			scheduler.start();
	
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		
	}
	
	/*
		Initialise les paramtres pour la connection  la base de donnes de OpenSi
	*/
	public void init(String loginBd,String mdpBd,String driverBd,String urlBd,String dossierRoot)
	{
		try
		{
			if(scheduler==null)
			{
				SchedulerFactory schedFact = new org.quartz.impl.StdSchedulerFactory();
				scheduler = schedFact.getScheduler();
				scheduler.start();
			}
		}
		catch(Exception e)
		{
			ToolsMAJ.ecrireLog(aEcrire,type,"(init)ERREUR:"+e);
		}
	
		login_bd=loginBd;
		mdp_bd=mdpBd;
		driver_bd=driverBd;
		url_bd=urlBd;
		dossier_root=dossierRoot;
		
		try
		{
			Class.forName(driverBd);
			ToolsMAJ.ecrireLog(aEcrire,type,"(init)Timeout BD:"+DriverManager.getLoginTimeout());
			DriverManager.setLoginTimeout(5);
			
		}
		catch(Exception e)
		{
			ToolsMAJ.ecrireLog(aEcrire,type,"(init)ERREUR:"+e);
		}	
	}
	
	
	
	public void ajouterJob(String id_maj, String nom_base, String dossier_id,String timeout,String nbRapports,String taillePaquets)
	{
		ToolsMAJ.ecrireLog(aEcrire,type,"ajout de Job");
		boolean toutOK=true;
		
		try
		{
		
			/* ******* Rcupration des paramtres **** */
			ToolsMAJ.ecrireLog(aEcrire,type,"(ajouterJob) -1- url_bd:"+url_bd+", login_bd"+login_bd+", mdp_bd"+mdp_bd);
			Connection connexion = DriverManager.getConnection(url_bd,login_bd,mdp_bd);
			Statement state=connexion.createStatement();

			String requete="SELECT Nom_Service, Groupe_Service, Type_Maj, Type_Periode, Valeur_Periode, Heure_Depart, URL_Service, m.Site_Id";
			requete+=" FROM "+nom_base+".MAJ_AUTO m, "+nom_base+".SITE_WEB s";
			requete+=" WHERE m.Maj_Id="+id_maj+" AND s.Site_Id=m.Site_Id";
			ToolsMAJ.ecrireLog(aEcrire,type,"(ajouterJob) -2-");
			String code_maj="";
			String nom_job="";
			String groupe_job="";
			String mesure="";
			String valeur_periode="";
			int depart=0;
			String url_webservice="";
			int site_id=0;
			ToolsMAJ.ecrireLog(aEcrire,type,"(ajouterJob) -3-");
			ResultSet res=state.executeQuery(requete);
			if(res.next())
			{
				code_maj=res.getString("Type_Maj");
				nom_job=res.getString("Nom_Service");
				groupe_job=res.getString("Groupe_Service");
				mesure=res.getString("Type_Periode");
				valeur_periode=res.getString("Valeur_Periode");
				depart=res.getInt("Heure_Depart");
				url_webservice=res.getString("URL_Service");
				site_id=res.getInt("Site_Id");

			}
			connexion.close();

			ToolsMAJ.ecrireLog(aEcrire,type,"(ajouterJob) -4-");
			/* *********** Dtails du JOB ************* */
			JobDetail jobDetail=null;
			if(code_maj.equals("COM"))
			{
				ToolsMAJ.ecrireLog(aEcrire,type,"(lancerJob) Upload commande");	
				jobDetail = new JobDetail(nom_job,groupe_job,JobUploadCommandes.class);
			}
			else if(code_maj.equals("CLI"))
			{
				ToolsMAJ.ecrireLog(aEcrire,type,"(lancerJob) Upload client");	
				jobDetail = new JobDetail(nom_job,groupe_job,JobUploadClients.class);
			}
			else if(code_maj.equals("PRIX"))
			{
				ToolsMAJ.ecrireLog(aEcrire,type,"(lancerJob) Maj PRIX");
				jobDetail = new JobDetail(nom_job,groupe_job,JobMajPrix.class);
			}
			else if(code_maj.equals("STOCK"))
			{
				ToolsMAJ.ecrireLog(aEcrire,type,"(lancerJob) Maj STOCK");
				jobDetail = new JobDetail(nom_job,groupe_job,JobMajStock.class);
			}
			else if(code_maj.equals("STAT"))
			{
				ToolsMAJ.ecrireLog(aEcrire,type,"(lancerJob) Maj STAT");
				jobDetail = new JobDetail(nom_job,groupe_job,JobMajStatutCom.class);
			}	
			else if(code_maj.equals("INFO"))
			{
				ToolsMAJ.ecrireLog(aEcrire,type,"(lancerJob) Maj INFO");
				jobDetail = new JobDetail(nom_job,groupe_job,JobMajInfo.class);
			}
			else if(code_maj.equals("MAJCLI"))
			{
				ToolsMAJ.ecrireLog(aEcrire,type,"(lancerJob) Maj CLIENTS");
				jobDetail = new JobDetail(nom_job,groupe_job,JobMajClients.class);
			}
			else
			{
				ToolsMAJ.ecrireLog(aEcrire,type,"(lancerJob)ERREUR: le code de mise  jour:"+code_maj+" est incorrect");
				toutOK=false;
			}
			ToolsMAJ.ecrireLog(aEcrire,type,"(ajouterJob) -5-");
			/* *********** Dtails du TRIGGER ************* */
			Trigger trigger=null;
			ToolsMAJ.ecrireLog(aEcrire,type,"(ajouterJob)MESURE:"+mesure);
			
			if(mesure.equals("MINUTE"))
			{
				int periode_int=Integer.parseInt(valeur_periode);
				trigger = TriggerUtils.makeMinutelyTrigger(periode_int);

			}
			else if(mesure.equals("HEURE"))
			{
				int periode_int=Integer.parseInt(valeur_periode);
				trigger = TriggerUtils.makeHourlyTrigger(periode_int);
				
			}
			else if(mesure.equals("JOUR"))
			{
				trigger = TriggerUtils.makeDailyTrigger(depart,0);//heure, minute
			}
			else if(mesure.equals("SEMAINE"))
			{
				String liste_jour_cron="";
				StringTokenizer tok=new StringTokenizer(valeur_periode,",");
				int nb=tok.countTokens();
			
				String jour="";
				if(nb>0)
				{
					jour=ToolsMAJ.convertirJour(tok.nextToken());
					if(jour!=null)
					{
						liste_jour_cron=jour;
					}
					
				}
				for(int i=0;i<nb-1;i++)
				{
					jour=ToolsMAJ.convertirJour(tok.nextToken());
					liste_jour_cron+=(jour!=null)?","+jour:"";
					
				}
			
				String cron_expression="0 0 "+depart+" ? * "+liste_jour_cron;
				
				trigger=new CronTrigger();
				((CronTrigger)trigger).setCronExpression(cron_expression);
			
			}
			else
			{
				ToolsMAJ.ecrireLog(aEcrire,type,"(LancerJob)ERREUR la mesure:"+mesure+" est incorrecte");
				toutOK=false;
			}
			ToolsMAJ.ecrireLog(aEcrire,type,"(ajouterJob) -6-");
			
			trigger.setName("T_"+nom_job);
			
			
			/* *************** Passage des paramtres au JOB **************** */
				
			JobDataMap params=new JobDataMap();
			params.put("url_bd",url_bd);
			params.put("nom_bd",nom_base);
			params.put("login",login_bd);
			params.put("mdp",mdp_bd);
			params.put("site_id",""+site_id);
			params.put("dossier_id",dossier_id);
			params.put("url_serveur",url_webservice);
			params.put("dossier_root",dossier_root);
			params.put("pilote_bd",driver_bd);
			params.put("nom_job",nom_job);
			params.put("timeout",timeout);
			params.put("nb_rapports",nbRapports);
			params.put("taille_paquets",taillePaquets);

			jobDetail.setJobDataMap(params);
			ToolsMAJ.ecrireLog(aEcrire,type,"(ajouterJob) -7-");
			
			if(toutOK)
			{
				ToolsMAJ.ecrireLog(aEcrire,type,"(lancerJob)Tout est ok, je lance");
				trigger.setStartTime(TriggerUtils.getEvenSecondDate(new java.util.Date()));
				ToolsMAJ.ecrireLog(aEcrire,type,"(lancerJob)Trigger:"+trigger);
				ToolsMAJ.ecrireLog(aEcrire,type,"scheduler...");
				
				scheduler.scheduleJob(jobDetail, trigger);//lancement du service d'automatisation
				
				ToolsMAJ.ecrireLog(aEcrire,type,"(ajouterJob) -7,5-");
			}
			else
			{
				ToolsMAJ.ecrireLog(aEcrire,type,"(lancerJob)Pas tout ok");
			}
			ToolsMAJ.ecrireLog(aEcrire,type,"(ajouterJob) -8-");
		}
		catch(Exception e)
		{
			ToolsMAJ.ecrireLog(aEcrire,type,"(ajouterJob)ERREUR:"+e);
		}
		
	}
	
	
	
	public void retirerJob(String nom_job, String nom_groupe)
	{
		try
		{
		
			ToolsMAJ.ecrireLog(aEcrire,type,"(retirerJob)C'est parti, sched?:"+scheduler);
			scheduler.deleteJob(nom_job,nom_groupe);
		}
		catch(Exception e)
		{
			ToolsMAJ.ecrireLog(aEcrire,type,"(retirerJob)ERREUR:"+e);
		}
		
	}
	
	
	
	public boolean estActif(String nom_job, String nom_groupe)
	{
		ToolsMAJ.ecrireLog(aEcrire,type,"Dbut de est actif");
		boolean reponse=false;
		try
		{
		
			Trigger[] tab=scheduler.getTriggersOfJob(nom_job, nom_groupe);

			reponse=tab.length>0;
			ToolsMAJ.ecrireLog(aEcrire,type,"(estActif)nb de triggers:"+tab.length+" job:"+nom_job);

			for(int i=0;i<tab.length;i++)
			{
				reponse=reponse&&(tab[i].getNextFireTime()!=null);
			}
			
		}
		catch(Exception e)
		{
			ToolsMAJ.ecrireLog(aEcrire,type,"(estActif)ERREUR:"+e);
		}
		
		ToolsMAJ.ecrireLog(aEcrire,type,"Fin de est actif");
		return reponse;
	}

}



