/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.lite;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;
import org.experlog.base.ESCookie;
import org.experlog.base.ESServlet;
import org.experlog.base.ESServletRequest;
import org.experlog.base.ESStore;
import org.experlog.base.OpenClient;
import org.experlog.db.ESDbFormHandler;
import org.experlog.util.AppConfiguration;
import org.experlog.util.ESCategory;

public class OpenEAS
extends ESServlet {
    private static final long serialVersionUID = -1564888231101340876L;

    public void getRequest(OpenClient session, ESServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.logger = ESCategory.getCategory("openeas.servlet.OpenEAS");
        String page = null;
        try {
            String cac = req.getParameter("Cache");
            if (cac != null && cac.equalsIgnoreCase("n")) {
                this.setNoStore(res);
            }
            if ((page = req.getParameter("Page")) == null || page.length() < 1) {
                String homepage = session.getAppConfiguration().get("app.HomePage");
                if (homepage == null) {
                    homepage = session.getAppConfiguration().get("shop.HomePage");
                }
                if (homepage == null) {
                    homepage = "index.tmpl";
                }
                page = new String(homepage);
            }
            if (!AppConfiguration.isSecurePath(page)) {
                throw new ServletException("Access forbidden for security reasons (wildcard in page name)");
            }
            String failurePage = req.getParameter("ActionFailed");
            if (this.actionFailed()) {
                if (failurePage == null) {
                    throw new ServletException("Action " + req.getParameter("Action") + " failed, with no ActionFailed template page defined");
                }
                page = failurePage;
            }
            if (page.equals("this")) {
                this.setNoContent(res);
            } else {
                PrintWriter out = null;
                String ctyp = req.getParameter("ContentType");
                if (!"none".equalsIgnoreCase(ctyp)) {
                    out = res.getWriter();
                } else {
                    this.setNoContent(res);
                }
                if (out != null && !session.noComment() && ctyp == null) {
                    out.println("<!-- Generated by openeas http://www.experlog.com -->");
                }
                ESDbFormHandler dbf = new ESDbFormHandler(session, req);
                dbf.defineDataObject("Cookie", (ESCookie)session.getCookie());
                dbf.defineDataObject("ShopConfig", session.getAppConfiguration());
                dbf.defineDataObject("AppConfig", session.getAppConfiguration());
                dbf.defineDataObject("DbMap", session.getDbMapper());
                String lang = session.getCookie().get("L_");
                if (lang != null) {
                    session.getAppConfiguration().setLocale(lang);
                    if (!"false".equalsIgnoreCase(session.getAppConfiguration().get("app.UseLocaleInPath"))) {
                        dbf.displayDbForm(out, "ESTemplates/Shop/" + lang + "/" + page);
                    } else {
                        dbf.displayDbForm(out, "ESTemplates/Shop/" + page);
                    }
                } else {
                    dbf.displayDbForm(out, "ESTemplates/Shop/" + page);
                }
            }
        }
        catch (Exception e) {
            if (session != null) {
                Category logger = ESCategory.getCategory(ESStore.getInstance().getShopName(), "openeas.lite");
                logger.error((Object)("ERROR IN TEMPLATE " + page + " " + e));
                e.printStackTrace();
            }
            throw new ServletException(e.getMessage());
        }
    }

    public void postRequest(OpenClient session, ESServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.getRequest(session, req, res);
    }

    public String getServletInfo() {
        return "openeas servlet";
    }
}

