/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.StringTokenizer;

public class ESMailer {
    String mailhost;
    String helohost;
    String result = "";
    String subject = null;
    String message;
    String lastline;
    int port = 25;
    BufferedReader in;
    String ctype_ = null;
    boolean legacy_ = false;

    public ESMailer(String mhost) {
        try {
            this.mailhost = mhost == null ? InetAddress.getLocalHost().getHostAddress() : mhost;
        }
        catch (Exception e) {
            System.err.println("ESMailer Exception " + e);
        }
    }

    void expect(String expected, String msg) throws IOException {
        this.lastline = this.in.readLine();
        if (!this.lastline.startsWith(expected)) {
            throw new IOException(msg + ":" + this.lastline);
        }
        while (this.lastline.startsWith(expected + "-")) {
            this.lastline = this.in.readLine();
        }
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setContentType(String ctype) {
        this.ctype_ = ctype;
    }

    public Socket open() throws IOException {
        return new Socket(this.mailhost, this.port);
    }

    public PrintWriter beginMessage(Socket s, String from, String to, String subject) throws IOException {
        if (subject == null) {
            subject = "(no subject)";
        }
        PrintWriter p = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(s.getOutputStream())), true);
        this.in = new BufferedReader(new InputStreamReader(s.getInputStream()));
        this.expect("220", "no greeting");
        this.helohost = InetAddress.getLocalHost().getHostAddress();
        p.println("HELO " + this.helohost + "\r");
        this.expect("250", "helo");
        p.println("MAIL FROM: <" + from + ">\r");
        this.expect("250", "mail from");
        StringTokenizer st = new StringTokenizer(to, ",");
        while (st.hasMoreTokens()) {
            p.println("RCPT TO: <" + st.nextToken().trim() + ">\r");
            this.expect("250", "rcpt to");
        }
        p.println("DATA\r");
        this.expect("354", "data");
        if (this.legacy_) {
            p.println("Subject: " + subject + "\r");
        } else {
            p.println("Subject: " + subject);
            p.println();
        }
        if (this.ctype_ != null) {
            p.print("Content-type: " + this.ctype_);
            p.println(this.ctype_.endsWith(";") ? "" : ";");
            p.println("\r");
        }
        return p;
    }

    public void endMessage(PrintWriter p) throws IOException {
        if (this.legacy_) {
            p.println("\r\n.\r");
        } else {
            p.println();
            p.print(".");
            p.println();
            p.flush();
        }
        this.expect("250", "end of data");
        p.println("QUIT\r");
        this.expect("221", "quit");
    }

    public void close(Socket s) throws IOException {
        s.close();
    }

    public void setLegacy(boolean l) {
        this.legacy_ = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMail(String from, String to, String subject, BufferedReader msgreader) {
        Socket s = null;
        try {
            String ln;
            if (subject == null) {
                subject = "(no subject)";
            }
            s = this.open();
            PrintWriter p = this.beginMessage(s, from, to, subject);
            while ((ln = msgreader.readLine()) != null) {
                if (ln.equals(".")) {
                    ln = "..";
                }
                p.println(ln + "\r");
            }
            this.endMessage(p);
            this.close(s);
        }
        catch (Exception e) {
            System.err.println("ESMailer:sendMail Exception " + e);
            this.result = e.getMessage();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (s != null) {
                    this.close(s);
                }
            }
            catch (Exception e) {
                System.err.println("ESMailer:sendMail Exception " + e);
                this.result = e.getMessage();
            }
        }
        return true;
    }

    public boolean sendMail(String from, String to, String subject, Object o) {
        return this.sendMail(from, to, subject, new BufferedReader(new StringReader(o.toString())));
    }

    public static void main(String[] args) {
        try {
            String from;
            if (args.length <= 0) {
                System.err.println("Usage: java ESMailer to [mailhost] [from]");
                System.exit(1);
            }
            String host = args.length > 1 ? args[1] : null;
            String string = from = args.length > 2 ? args[2] : "test@experlog.com";
            if (args.length == 2 && host.indexOf(64) > 0) {
                from = host;
                host = null;
            }
            boolean legacy = false;
            if (host != null && host.startsWith("[legacy]")) {
                host = host.substring(8);
                legacy = true;
            }
            System.out.println("host: " + host);
            System.out.println("from: " + from);
            System.out.println("to: " + args[0]);
            if (legacy) {
                System.out.println("legacy flag is set...");
            }
            ESMailer m = new ESMailer(host);
            m.setLegacy(legacy);
            if (!m.sendMail(from, args[0], "ESMailer test program", new BufferedReader(new StringReader("Seems to work...")))) {
                System.err.println("Error while sending mail (no exception thrown).");
            }
        }
        catch (Exception e) {
            System.err.println("ESMailer Exception: " + e);
            e.printStackTrace(System.err);
        }
    }
}

