/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.comptes;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.bo.BO_Comptes;
import org.opensi.bo.BO_Dossiers;


public class CopyComptes implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		String baseExo = sosi.getBaseExo();
		
		String dossierId = param.getParameter("Dossier_Id");
		
		BO_Comptes boComptes = new BO_Comptes(con, baseDossier, baseExo);
		BO_Dossiers boDossiers = new BO_Dossiers(con);				
				
		if (!boDossiers.existDossier(dossierId)) {
			error.addError(1, "Impossible de copier les comptes : dossier source invalide !");
		}
		else {		
			boComptes.copyComptesFromDossier(dossierId, sosi.getDossierId(), sosi.getEntrepriseId());
		}
	}		

} // fin CopyComptes

