/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.ecritures;


import java.sql.*;

import java.util.Iterator;
import java.util.HashMap;

import org.opensi.api.*;

import org.opensi.dbm.exercice.DBM_Ecriture;
import org.opensi.dbm.exercice.DBM_Operation;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;

import org.opensi.bo.BO_Ecritures;

import org.opensi.util.tools.DateTime;


public class SaveEcriture implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		String baseExo = sosi.getBaseExo();
				
		String listeOp = param.getParameter("ListeOp");
		String codeJournal = param.getParameter("Code_Journal");
		long periode = param.getPeriodeParameter("Periode");
		int ecritureId = param.getIntParameter("Ecriture_Id");
		
		DBM_Ecriture dbmEcriture = new DBM_Ecriture(con, baseExo);
		DBM_Operation dbmOperation = new DBM_Operation(con, baseExo);
		
		Ecriture ecriture = new Ecriture();		
		
		if (ecritureId==0) {
			ecriture.setDateEcriture(periode);
			ecriture.setCodeJournal(codeJournal);
		}
		else {		
			ecriture = dbmEcriture.load(ecritureId);
		}
		
		String elemsOp[] = listeOp.split("\\|",-1);
		
		int i = 0;
		
		while (i<elemsOp.length-1) {
			
			int opId = Integer.parseInt(elemsOp[i++]);
		
			Operation operation = new Operation();
			
			if (opId!=0) {
				operation = dbmOperation.load(opId);
			}	
			
			DateTime dt = new DateTime(ecriture.getDateEcriture());
			dt.setDay(Integer.parseInt(elemsOp[i++]));
			
			operation.setDateOp(dt.getDateInMillis());
			operation.setNumeroCompte(elemsOp[i++]);
			operation.setLibelle(elemsOp[i++]);
			operation.setContrepartie(elemsOp[i++]);
			operation.setDateEcheance(elemsOp[i].isEmpty()?0:DateTime.parseDate(elemsOp[i], "dd/MM/yyyy"));
			i++;
			operation.setModeRegId(elemsOp[i].isEmpty()?0:Integer.parseInt(elemsOp[i]));
			i++;
			operation.setCommentaire(elemsOp[i++]);
			operation.setMontantD(elemsOp[i].isEmpty()?0:Double.parseDouble(elemsOp[i]));
			i++;
			operation.setMontantC(elemsOp[i].isEmpty()?0:Double.parseDouble(elemsOp[i]));
			i++;
			operation.setNumPiece(elemsOp[i++]);
					
			ecriture.addOperation(operation);
		}
		
		BO_Ecritures boEcritures = new BO_Ecritures(con, baseDossier, baseExo);
		boEcritures.saveEcriture(ecriture);
		
		String listeOpId = "";
		
		HashMap<Integer, Operation> operations = ecriture.getOperations();
		Iterator it = operations.keySet().iterator();

		while (it.hasNext()) {		
			listeOpId += operations.get(it.next()).getOpId() +",";
		}
		
		result.addEntity("Ecriture_Id", ecriture.getEcritureId());
		result.addEntity("Numero", ecriture.getNumero());
		result.addEntity("Liste_Op_Id", listeOpId);
	}
		

} // fin SaveEcriture

