/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.exercice;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.dbm.dossier.DBM_Exercice;
import org.opensi.data.dossier.Exercice;

import org.opensi.bo.BO_Exercices;
import org.opensi.bo.BO_Journaux;


public class CloturerExercice implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		int exerciceId = sosi.getExerciceId();
		String baseExo = sosi.getBaseExo();
		
		String journalAN = param.getParameter("JournalAN");
		long dateEX = param.getPeriodeParameter("DateEX");
		String journalEX = param.getParameter("JournalEX");
		boolean aExtourner = param.getBooleanParameter("AExtourner");
		boolean detailTiers = param.getBooleanParameter("DetailTiers");
		boolean detailAux = param.getBooleanParameter("DetailAux");
		
		BO_Exercices boExercices = new BO_Exercices(con, baseDossier, baseExo);
		BO_Journaux boJournaux = new BO_Journaux(con, baseDossier);
		DBM_Exercice dbmExercice = new DBM_Exercice(con, baseDossier);
		
		Exercice exerciceN1 = dbmExercice.load(exerciceId);
		Exercice exerciceN = boExercices.getExerciceSuivant(exerciceN1);
		
		if (aExtourner && !boExercices.checkPeriodeInExo(dateEX)) {
			error.addError(1, "Impossible de cl\u00F4turer l'exercice : la p\u00E9riode d'extourne est invalide !");
		}
		else if (aExtourner && !boJournaux.isJournalOD(journalEX)) {
			error.addError(1, "Impossible de cl\u00F4turer l'exercice : le journal d'extourne est invalide !");
		}
		else if (!boJournaux.isJournalAN(journalAN)) {
			error.addError(1, "Impossible de cl\u00F4turer l'exercice : le journal d'\u00E0 nouveau est invalide !");
		}
		else if (exerciceN1.getCloture()) {
			error.addError(1, "Impossible de cl\u00F4turer l'exercice : l'exercice est d\u00E9j\u00E0 cl\u00F4tur\u00E9 !");
		}
		else if (!boExercices.isExoPrecClos(exerciceId)) {
			error.addError(1, "Impossible de cl\u00F4turer l'exercice : l'exercice pr\u00E9c\u00E9dent n'est pas cl\u00F4tur\u00E9 !");
		}
		else if (exerciceN==null) {
			error.addError(1, "Impossible de cl\u00F4turer l'exercice : l'exercice suivant n'existe pas !");
		}
		else {
			boExercices.cloturerExercice(exerciceN, exerciceN1, journalAN, detailTiers, detailAux, aExtourner, journalEX, dateEX);
		}
	}	


} // fin CloturerExercice

