/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.exercice;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.dbm.exercice.DBM_PeriodeExercice;
import org.opensi.data.exercice.PeriodeExercice;
import org.opensi.bo.BO_Exercices;


public class CloturerPeriode implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		String baseExo = sosi.getBaseExo();
		
		int periodeId = Integer.parseInt(param.getParameter("Periode_Id"));
		
		DBM_PeriodeExercice dbmPeriodeExercice = new DBM_PeriodeExercice(con, baseExo);
		PeriodeExercice periodeExercice = dbmPeriodeExercice.load(periodeId);
		
		if (periodeExercice==null) {
			error.addError(1003, "La p\u00E9riode n'existe pas.");
		} else {
			BO_Exercices boExercices = new BO_Exercices(con, baseDossier, baseExo);
			boExercices.cloturerPeriodeExercice(periodeExercice.getPeriode());
		}
	}		


} // fin CloturerExercice

