/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.exercice;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.bo.BO_Exercices;

import org.opensi.util.tools.Formatter;
import org.opensi.util.tools.Arrondi;


public class GetCoherenceResultat implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		String baseExo = sosi.getBaseExo();		
		
		BO_Exercices boExercices = new BO_Exercices(con, baseDossier, baseExo);
		
		double resultatBilan = boExercices.resultat12345(baseExo);
		double resultatGestion = boExercices.resultat67(baseExo);
				
		Formatter form = new Formatter("0.00", true);
		
		Arrondi r = new Arrondi(2);
				
		result.addEntity("Resultat", form.get(resultatBilan));
		result.addEntity("Resultat_Coherent", r.round(resultatBilan + resultatGestion)==0?"1":"0");		
	}		


} // fin GetCoherenceResultat

