/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.bo;


import java.sql.*;
import java.util.ArrayList;

import org.opensi.dbm.dossier.DBM_Compte;
import org.opensi.dbm.dossier.DBM_Exercice;
import org.opensi.dbm.dossier.DBM_TrancheCollectif;
import org.opensi.dbm.exercice.DBM_SoldeCompte;
import org.opensi.dbm.general.DBM_Dossier;

import org.opensi.data.dossier.Compte;
import org.opensi.data.dossier.TrancheCollectif;
import org.opensi.data.exercice.SoldeCompte;


public class BO_Comptes {


	private Connection con;
	private String baseDossier;
	private String baseExo;


	public BO_Comptes(Connection con, String baseDossier, String baseExo) {
		this.con = con;
		this.baseDossier = baseDossier;
		this.baseExo = baseExo;
	}


	public boolean isAssignableCompte(String numeroCompte) throws SQLException {
		
		DBM_Compte dbmCompte = new DBM_Compte(con, baseDossier);
		
		return dbmCompte.exist(numeroCompte, false);
	}


	public void saveCompte(Compte compte, String dossierId, int entrepriseId) throws SQLException {
		
		if (compte.isValid()) {
		
			DBM_Compte dbmCompte = new DBM_Compte(con, baseDossier);		
				
			if (dbmCompte.exist(compte.getNumeroCompte())) {				
				
				dbmCompte.update(compte);
			}
			else {			
				
				dbmCompte.insert(compte);
				
				
				DBM_Exercice dbmExercice = new DBM_Exercice(con, baseDossier);				
				
				ArrayList<String> listeExos = dbmExercice.getBasesExercices();
				
				for (int i=0; i<listeExos.size(); i++) {
				
					DBM_SoldeCompte dbmSoldeCompte = new DBM_SoldeCompte(con, listeExos.get(i));
					SoldeCompte soldeCompte = new SoldeCompte();
					soldeCompte.setNumeroCompte(compte.getNumeroCompte());
					dbmSoldeCompte.insert(soldeCompte);
				}				
				
				PreparedStatement psNewPDC = con.prepareStatement("insert into PROFIL_DOSSIER_COMPTE (Profil_Id, Dossier_Id, Numero_Compte) values (?,?,?)");
				
				psNewPDC.setString(2, dossierId);
				psNewPDC.setString(3, compte.getNumeroCompte());				
				
				PreparedStatement psProfils = con.prepareStatement("select p.Profil_Id from PROFIL p join ENTREPRISE_DOSSIER e on p.Entreprise_Id=e.Entreprise_Id where e.Entreprise_Id=? and e.Dossier_Id=? order by Nom");
				
				psProfils.setInt(1, entrepriseId);
				psProfils.setString(2, dossierId);
				
				ResultSet rsP = psProfils.executeQuery();
				
				while (rsP.next()) {
					psNewPDC.setInt(1, rsP.getInt("Profil_Id"));
					psNewPDC.executeUpdate();					
				}
				rsP.close();				
			}
		}
	}


	public boolean isUsed(String numeroCompte) throws SQLException {
		
		boolean ok = false;
		
		String reqCompte = "select 1 from "+ baseDossier +".COMPTE where Collectif=?";
		reqCompte += " union select 2 from "+ baseDossier +".JOURNAL where Contrepartie=?";
		reqCompte += " union select 3 from "+ baseDossier +".TAUX_TVA where Compte_TVA_Achat=? or Compte_TVA_Vente=? or Compte_Achat=? or Compte_Vente=?";
		reqCompte += " union select 4 from "+ baseDossier +".VENTIL_TVA_NATIONAL_UE where Compte_Vente=?";
		reqCompte += " union select 5 from "+ baseDossier +".FICHE_CLIENT where Numero_Compte=?";
		reqCompte += " union select 6 from "+ baseDossier +".FICHE_FOURNISSEUR where Numero_Compte=?";
		reqCompte += " union select 7 from "+ baseDossier +".FAMILLE_ARTICLE where Compte_Achat_UE=? or Compte_Achat_I=?";
		reqCompte += " union select 8 from "+ baseDossier +".FICHE_ARTICLE where Compte_Achat_UE=? or Compte_Achat_I=?";
		reqCompte += " union select 9 from "+ baseDossier +".COMPTE_ARTICLE where Compte_Vente=? or Compte_Achat=?";
		reqCompte += " union select 10 from "+ baseDossier +".COMPTE_ARTICLE_TVA_NATIONAL_UE where Compte_Vente=?";
		reqCompte += " union select 11 from "+ baseDossier +".COMPTE_FAMILLE_ARTICLE where Compte_Vente=? or Compte_Achat=?";
		reqCompte += " union select 12 from "+ baseDossier +".COMPTE_FAMILLE_ARTICLE_TVA_NATIONAL_UE where Compte_Vente=?";
		reqCompte += " union select 14 from "+ baseDossier +".RAPPROCHEMENT where Numero_Compte=?";
		reqCompte += " union select 15 from "+ baseDossier +".PARAM_DOSSIER where Numero_Compte_Clients=? or Numero_Compte_Fournisseurs=? or Numero_Compte_Achat_UE=?";
		reqCompte += " or Numero_Compte_Achat_I=? or Numero_Compte_Port_AC=? or Numero_Compte_Port_VE=? or Numero_Compte_Escompte_AC=? or Numero_Compte_Escompte_VE=? or Numero_Compte_Acompte_VE=?";
		reqCompte += " or Numero_Compte_Regul_AC=? or Numero_Compte_Regul_VE=? or Numero_Compte_Tva_Due_IC=? or Numero_Compte_Tva_Ded_IC=? or Numero_Compte_Especes=?";
		PreparedStatement psCompteUsed = con.prepareStatement(reqCompte);
		psCompteUsed.setString(1, numeroCompte);
		psCompteUsed.setString(2, numeroCompte);
		psCompteUsed.setString(3, numeroCompte);
		psCompteUsed.setString(4, numeroCompte);
		psCompteUsed.setString(5, numeroCompte);
		psCompteUsed.setString(6, numeroCompte);
		psCompteUsed.setString(7, numeroCompte);
		psCompteUsed.setString(8, numeroCompte);
		psCompteUsed.setString(9, numeroCompte);
		psCompteUsed.setString(10, numeroCompte);
		psCompteUsed.setString(11, numeroCompte);
		psCompteUsed.setString(12, numeroCompte);
		psCompteUsed.setString(13, numeroCompte);
		psCompteUsed.setString(14, numeroCompte);
		psCompteUsed.setString(15, numeroCompte);
		psCompteUsed.setString(16, numeroCompte);
		psCompteUsed.setString(17, numeroCompte);
		psCompteUsed.setString(18, numeroCompte);
		psCompteUsed.setString(19, numeroCompte);
		psCompteUsed.setString(20, numeroCompte);
		psCompteUsed.setString(21, numeroCompte);
		psCompteUsed.setString(22, numeroCompte);
		psCompteUsed.setString(23, numeroCompte);
		psCompteUsed.setString(24, numeroCompte);
		psCompteUsed.setString(25, numeroCompte);
		psCompteUsed.setString(26, numeroCompte);
		psCompteUsed.setString(27, numeroCompte);
		psCompteUsed.setString(28, numeroCompte);
		psCompteUsed.setString(29, numeroCompte);
		psCompteUsed.setString(30, numeroCompte);
		psCompteUsed.setString(31, numeroCompte);
		psCompteUsed.setString(32, numeroCompte);
		psCompteUsed.setString(33, numeroCompte);
		psCompteUsed.setString(34, numeroCompte);
		ResultSet rset = psCompteUsed.executeQuery();
		if (rset.next()) { ok = true; }
		rset.close();
		psCompteUsed.close();
		
		DBM_Exercice dbmExercice = new DBM_Exercice(con, baseDossier);
		ArrayList<String> listeBE = dbmExercice.getBasesExercices();
		int i=0;
		int nbExercices = listeBE.size();
		
		while (!ok && i<nbExercices) {
			PreparedStatement psCpteUsed = con.prepareStatement("select 1 from "+ listeBE.get(i) +".OPERATION where Numero_Compte=?");	
			psCpteUsed.setString(1, numeroCompte);
			ResultSet rsCU = psCpteUsed.executeQuery();
			if (rsCU.next()) { ok = true; }
			rsCU.close();
			psCpteUsed.close();
			i++;
		}
		
		return ok;
	}
	
	
	private void deleteSoldes(String numeroCompte) throws SQLException {
	
		DBM_Exercice dbmExercice = new DBM_Exercice(con, baseDossier);
		
		ArrayList<String> listeBE = dbmExercice.getBasesExercices();
				
		for (int i=0; i<listeBE.size(); i++) {
			
			DBM_SoldeCompte dbmSoldeCompte = new DBM_SoldeCompte(con, listeBE.get(i));
			
			dbmSoldeCompte.delete(numeroCompte);
		}
	}
	
	
	public void deleteCompte(String numeroCompte) throws SQLException {
	
		PreparedStatement psSupProfil = con.prepareStatement("delete from PROFIL_DOSSIER_COMPTE where Numero_Compte=?");
		psSupProfil.setString(1, numeroCompte);
		psSupProfil.executeUpdate();
		
		deleteSoldes(numeroCompte);
		
		DBM_Compte dbmCompte = new DBM_Compte(con, baseDossier);
		dbmCompte.delete(numeroCompte);		
	}
	
	
	public void updateSoldesCompte(String numeroCompte) throws SQLException {

		PreparedStatement psCpte = con.prepareStatement("select Collectif, Type_Compte from "+ baseDossier +".COMPTE where Numero_Compte=?");

		psCpte.setString(1, numeroCompte);
		ResultSet rsC = psCpte.executeQuery();

		if (rsC.next()) {	

			// mise  jour des soldes du compte

			PreparedStatement psUpSC = con.prepareStatement("update "+ baseExo +".SOLDE_COMPTE set Total_Debit=?, Total_Credit=?, Solde=Total_Debit-Total_Credit where Numero_Compte=?");

			PreparedStatement psSolde = con.prepareStatement("select sum(Montant_D) as Debit, sum(Montant_C) as Credit from "+ baseExo +".OPERATION where Numero_Compte=?");

			psSolde.setString(1, numeroCompte);
			ResultSet rsS = psSolde.executeQuery();      
			if (rsS.next()) {
				psUpSC.setDouble(1, rsS.getDouble("Debit"));
				psUpSC.setDouble(2, rsS.getDouble("Credit"));
				psUpSC.setString(3, numeroCompte);
				psUpSC.executeUpdate();
			}
			rsS.close();

			psSolde.close();

			// mise  jour des soldes du compte collectif

			String collectif = rsC.getString("Collectif");

			if (collectif!=null) {

				PreparedStatement psSoldeAux = con.prepareStatement("select sum(Montant_D) as Debit, sum(Montant_C) as Credit from "+ baseExo +".OPERATION o join "+ baseDossier +".COMPTE c on c.Numero_Compte=o.Numero_Compte where c.Collectif=?");

				psSoldeAux.setString(1, collectif);
				ResultSet rsSA = psSoldeAux.executeQuery();			 
				if (rsSA.next()) {
					psUpSC.setDouble(1, rsSA.getDouble("Debit"));
					psUpSC.setDouble(2, rsSA.getDouble("Credit"));
					psUpSC.setString(3, collectif);
					psUpSC.executeUpdate();
				}
				rsSA.close();

				psSoldeAux.close();
			}

			psUpSC.close();				
		}

		rsC.close();
		psCpte.close();			
  }
	
	
	public void copyComptesFromDossier(String dossierSrc, String dossierId, int entrepriseId) throws SQLException {
				
		// A FAIRE attention aux collectifs ! importer aussi les tranches --> faut que ca reste valide !!!!!!!!
		DBM_Dossier dbmDossier = new DBM_Dossier(con);
		
		String fromBase = dbmDossier.getBase(dossierSrc);
		
		DBM_Compte dbmCompte = new DBM_Compte(con, fromBase);
		
		PreparedStatement psComptes = con.prepareStatement("select a.Numero_Compte from "+ fromBase +".COMPTE a left join "+ baseDossier +".COMPTE b on a.Numero_Compte=b.Numero_Compte where b.Numero_Compte is null");
		ResultSet rset = psComptes.executeQuery();
		
		while (rset.next()) {
			Compte compte = dbmCompte.load(rset.getString(1));
			this.saveCompte(compte, dossierId, entrepriseId);
		}		
	}
	
	
	public void saveTrancheCollectif(TrancheCollectif trancheCollectif, String dossierId) throws SQLException {
		if (trancheCollectif.isValid()) {
		
			DBM_TrancheCollectif dbmTrancheCollectif = new DBM_TrancheCollectif(con, baseDossier);
			if (dbmTrancheCollectif.exist(trancheCollectif.getTrancheId())) {
				dbmTrancheCollectif.update(trancheCollectif);
			}
			else {
				dbmTrancheCollectif.insert(trancheCollectif);
			}
		}
	}
	
	
	public void deleteTrancheCollectif(int trancheId) throws SQLException {
		DBM_TrancheCollectif dbmTrancheCollectif = new DBM_TrancheCollectif(con, baseDossier);
		dbmTrancheCollectif.delete(trancheId);
	}
	
	
	public boolean isCentralisateurValide(String numCompte) throws SQLException {
		boolean valide = false;

		PreparedStatement psTranches = con.prepareStatement("select Min_Compte, Max_Compte from "+ baseDossier +".TRANCHE_COLLECTIF where Min_Compte<=? and Max_Compte>=?");
		psTranches.setString(1, numCompte);
		psTranches.setString(2, numCompte);
		ResultSet rset = psTranches.executeQuery();
		if (rset.next()) {
			valide = true;
		}
		rset.close();
		psTranches.close();
		
		return valide;
	}

	
	public boolean isCompteGeneral(String numCompte) throws SQLException {
		boolean valide = checkStxCpteG(numCompte);
		if (valide) {
			PreparedStatement psCompteCollectif = con.prepareStatement("select 1 from "+ baseDossier +".COMPTE where Numero_Compte=? and Collectif is not null");
			psCompteCollectif.setString(1, numCompte);
			ResultSet rset = psCompteCollectif.executeQuery();
			valide = !rset.next();
			rset.close();
			psCompteCollectif.close();
		}
		
		return valide;
	}
	
	
	public boolean isPlageValide(String minCompte, String maxCompte) throws SQLException {
		PreparedStatement psVerifPlage = con.prepareStatement("select 1 from "+ baseDossier +".COMPTE where Numero_Compte>=? and Numero_Compte<=? and Centralisateur=0");
		psVerifPlage.setString(1, minCompte);
		psVerifPlage.setString(2, maxCompte);
		ResultSet rset = psVerifPlage.executeQuery();
		boolean valide = !rset.next();
		rset.close();
		psVerifPlage.close();
		
		return valide;
	}
	
	
	public boolean hasPlageComptes(String minCompte, String maxCompte) throws SQLException {
		PreparedStatement psVerifPlage = con.prepareStatement("select 1 from "+ baseDossier +".COMPTE where Numero_Compte>=? and Numero_Compte<=?");
		psVerifPlage.setString(1, minCompte);
		psVerifPlage.setString(2, maxCompte);
		ResultSet rset = psVerifPlage.executeQuery();
		boolean valide = rset.next();
		rset.close();
		psVerifPlage.close();
		
		return valide;
	}
	
	
	public boolean isReductionPlageValide(String minCompte, String maxCompte, int trancheId) throws SQLException {
		boolean valide = true;
		if (minCompte.compareTo(maxCompte)<0) {
			PreparedStatement psComptes = con.prepareStatement("select Numero_Compte from "+ baseDossier +".COMPTE where Numero_Compte>=? and Numero_Compte<=? and Centralisateur=1");
			PreparedStatement psVerifCompte = con.prepareStatement("select 1 from "+ baseDossier +".TRANCHE_COLLECTIF where Min_Compte>=? and Max_Compte<=? and Tranche_Id<>"+ trancheId);
			
			psComptes.setString(1, minCompte);
			psComptes.setString(2, maxCompte);
			ResultSet rset = psComptes.executeQuery();
			while (valide && rset.next()) {
				String numCompte = rset.getString("Numero_Compte");
				
				psVerifCompte.setString(1, numCompte);
				psVerifCompte.setString(2, numCompte);
				ResultSet rset2 = psVerifCompte.executeQuery();
				if (!rset2.next()) { valide = false; }
				rset2.close();
			}
			rset.close();
			psVerifCompte.close();
			psComptes.close();
		}
		
		return valide;
	}

	
	public static boolean checkStxCpteG(String numeroCompte) {
	
		return numeroCompte!=null && java.util.regex.Pattern.matches("[1-7][0-9]{7}", numeroCompte);
	}
	
	
	public static boolean checkStxCpteCFA(String numeroCompte) {
	
		return numeroCompte!=null && java.util.regex.Pattern.matches("[\\w&&[^1-8]]\\w{7}", numeroCompte);
	}
	
	
	public static boolean isTypeCompte(String typeCompte) {
	
		return typeCompte!=null && java.util.regex.Pattern.matches("(G)|(C)|(F)|(A)", typeCompte);
	}

} // fin BO_Comptes
