/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un tat des stocks en csv
 */

package org.opensi.compta.actions.etats;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;


public class CsvPlanComptableDossier {

	public CsvPlanComptableDossier(String buffer, String fichier, DataPlanComptableDossier dataPCD) throws Exception {

		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Compte");
		lf.addToLine("Intitul\u00E9");
		lf.addToLine("Type");
		lf.addToLine("Contrepartie");
		
		int nbLignes = dataPCD.getNbLignes();

		for (int i=0; i<nbLignes; i++) {
			LignePlanDossier lpcd = dataPCD.lignes.get(i);

			lf.newLine();
			lf.addToLine(lpcd.numCompte);
			lf.addToLine("" + lpcd.intitule);
			lf.addToLine(("" + lpcd.type));
			if (lpcd.contrepartie!=null){
				lf.addToLine(("" + lpcd.contrepartie));	
			}
			
			
		}

		lf.write(buffer, fichier, true);
	}



} // fin CsvEtatStock
