/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Edition des journaux.
 */

package org.opensi.compta.actions.etats;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;


public class GenCsvJournaux extends Action {


	private DecimalFormat numFormat = new DecimalFormat("0.00");
	private String codeJournal;
	private Connection con;


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


	  	con = s.getConnection(null);
		
		String base = s.getCookie().get("BaseExo");
		String baseDossier = s.getCookie().get("BaseDossier");

		String debutExercice = r.getParameter("Debut_Exercice");
		String finExercice = r.getParameter("Fin_Exercice");
		String dateDebut = r.getParameter("Date_Debut");
		String dateFin = r.getParameter("Date_Fin");
		String journal = r.getParameter("Code_Journal");
		
		ResultSet rset;  // operations
		ResultSet rset2; // journaux
		ResultSet rset3; // ecritures
		
		double creditPeriode = 0;
		double debitPeriode = 0;
		double creditJournal;
		double debitJournal;
		double creditGeneraux = 0;
		double debitGeneraux = 0;
		double creditClients = 0;
		double debitClients = 0;
		double creditFournisseurs = 0;
		double debitFournisseurs = 0;
		double debitOp;
		double creditOp;

		boolean journalVide;

		String intitule;
		String typeCompte;

		Calendar calendar = Calendar.getInstance();
		calendar.clear();

		long debutPeriode;
		long finPeriode;

		int moisEcriture;
		int i;
		int fyy;
		int fmm;
		int dyy;
		int dmm;
		
		if (dateFin.length() == 0 && dateDebut.length() == 0) {
			debutPeriode = Long.parseLong(debutExercice);
			finPeriode = Long.parseLong(finExercice) + 216000000;  // on ajoute un jour
		}
		else {
			dyy = 2000 + Integer.parseInt(dateDebut.substring(2,4));
			dmm = Integer.parseInt(dateDebut.substring(0,2))-1;

			if(dateFin.length() == 0) {
				calendar.set(dyy,dmm,1,0,0,0);
				debutPeriode = calendar.getTimeInMillis();
				calendar.set(dyy,dmm+1,1,0,0,0);
				finPeriode = calendar.getTimeInMillis();
			}
			else {
				fyy = 2000 + Integer.parseInt(dateFin.substring(2,4));
				fmm = Integer.parseInt(dateFin.substring(0,2));
				calendar.set(dyy,dmm,1,0,0,0);
				debutPeriode = calendar.getTimeInMillis();
				calendar.set(fyy,fmm,1,0,0,0);
				finPeriode = calendar.getTimeInMillis();
			}
		}

		String buffer = s.getAppConfiguration().get("opensi.absdir") + "/iobuffer/";
		String fichier = r.getParameter("FichierCSV");

		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("N\u00B0");
		lf.addToLine("Date");
		lf.addToLine("Compte");
		lf.addToLine("Intitul\u00E9");
		lf.addToLine("Libell\u00E9");
		lf.addToLine("D\u00E9bit");
		lf.addToLine("Cr\u00E9dit");
		
		
		String reqLesJournaux = "select Code_Journal from "+ baseDossier +".JOURNAL";


		if (!journal.equalsIgnoreCase("tous")) {
			reqLesJournaux += " where Code_Journal='"+ journal +"'";
		}


		Statement stt2 = con.createStatement();


		String reqLesEcritures = "select e.Date_Ecriture, e.Ecriture_Id, min(o.Date_Op) as mindate ";
    reqLesEcritures += " from " + base + ".ECRITURE e, " + base + ".OPERATION o ";
    reqLesEcritures += " where ";
    reqLesEcritures += " o.Ecriture_Id = e.Ecriture_Id ";
    reqLesEcritures += " and Code_Journal=? ";
    reqLesEcritures += " and Date_Ecriture<? and Date_Ecriture>=? ";
    reqLesEcritures += " group by e.Ecriture_Id, e.Date_Ecriture ";
    reqLesEcritures += " order by mindate, e.Date_Ecriture, e.Ecriture_Id ";

		PreparedStatement psEcr = con.prepareStatement(reqLesEcritures);

		String reqLesOperations = "select c.Type_Compte, ";
    reqLesOperations += " c.Intitule, ";
    reqLesOperations += " o.Lettre, ";
    reqLesOperations += " o.Numero_Compte, ";
    reqLesOperations += " o.Montant_D, ";
    reqLesOperations += " o.Montant_C, ";
    reqLesOperations += " o.Date_Op, ";
    reqLesOperations += " o.Num_Ligne, ";
    reqLesOperations += " o.Libelle, ";
    reqLesOperations += " from " + base + ".OPERATION o, " + baseDossier + ".COMPTE c ";
    reqLesOperations += " where o.Numero_Compte=c.Numero_Compte ";
    reqLesOperations += " and o.Ecriture_Id=? ";
    reqLesOperations += " order by o.Date_Op, o.Num_Ligne";

		PreparedStatement psOp = con.prepareStatement(reqLesOperations);


		rset2 = stt2.executeQuery(reqLesJournaux);

		while (rset2.next()) {

			this.codeJournal = rset2.getString("Code_Journal");

			creditJournal = 0;
			debitJournal = 0;

			creditFournisseurs = 0;
			debitFournisseurs = 0;
			creditClients = 0;
			debitClients = 0;
			creditGeneraux = 0;
			debitGeneraux = 0;

			creditPeriode = 0;
			debitPeriode = 0;

			journalVide = true;


			long numEcriture = 0;
			long dateEcriture = 0;
			moisEcriture = 0;

			i = 1;

			psEcr.setString(1, codeJournal);
			psEcr.setLong(2, finPeriode);
			psEcr.setLong(3, debutPeriode);
			rset3 = psEcr.executeQuery();

			while (rset3.next()) {


				numEcriture = rset3.getLong("Ecriture_Id");
				dateEcriture = rset3.getLong("Date_Ecriture");

				journalVide = false;

				calendar.setTimeInMillis(dateEcriture);


				// on change de periode
				if (moisEcriture != (calendar.get(Calendar.MONTH)+1) && moisEcriture != 0) {

					putTotalCpte(lf, "Fournisseurs", debitFournisseurs, creditFournisseurs);
					putTotalCpte(lf, "Clients", debitClients, creditClients);
					putTotalCpte(lf, "G\u00E9n\u00E9raux", debitGeneraux, creditGeneraux);

					putTotalPeriode(lf, debitPeriode, creditPeriode);

					creditFournisseurs = 0;
					debitFournisseurs = 0;
					creditClients = 0;
					debitClients = 0;
					creditGeneraux = 0;
					debitGeneraux = 0;

					creditPeriode = 0;
					debitPeriode = 0;

					i = 1;
				}

				moisEcriture = calendar.get(Calendar.MONTH)+1;


				psOp.setLong(1, numEcriture);
				rset = psOp.executeQuery();


				while (rset.next()) {

					intitule = rset.getString("Intitule");
					intitule = intitule.substring(0,intitule.length()<18?intitule.length():18);

					creditOp = rset.getDouble("Montant_C");
					debitOp = rset.getDouble("Montant_D");

					typeCompte = rset.getString("Type_Compte");

					if (typeCompte.equalsIgnoreCase("G")) {
						debitGeneraux += debitOp;
						creditGeneraux += creditOp;
					}
					else if (typeCompte.equalsIgnoreCase("F")) {
						debitFournisseurs += debitOp;
						creditFournisseurs += creditOp;
					}
					else if (typeCompte.equalsIgnoreCase("C")) {
						debitClients += debitOp;
						creditClients += creditOp;
					}

					creditJournal += creditOp;
					debitJournal += debitOp;

					creditPeriode += creditOp;
					debitPeriode += debitOp;

					putLigneJournal(lf, rset.getString("Lettre"), i++, rset.getLong("Date_Op"), rset.getString("Numero_Compte"), intitule, rset.getString("Libelle"), debitOp, creditOp);
				}
				rset.close();
				
				putFinEcriture(lf);

			}
			rset3.close();


			if (!journalVide) {

				putTotalCpte(lf, "Fournisseurs", debitFournisseurs, creditFournisseurs);
				putTotalCpte(lf, "Clients", debitClients, creditClients);
				putTotalCpte(lf, "G\u00E9n\u00E9raux", debitGeneraux, creditGeneraux);

				putTotalPeriode(lf, debitPeriode, creditPeriode);

				putTotalJournal(lf, this.codeJournal, debitJournal, creditJournal);
			}
		}

		stt2.close();
		psEcr.close();
		psOp.close();
		
		lf.write(buffer, fichier, true);

		s.closeConnection(con, null);


		return true;


	} // fin service



	/** Ajoute une ligne d'operation au listing */

	private void putLigneJournal(ListingFile lf, String Lettre, int ligne, long dateOp, String numCompte, String intitule, String libelle, double debit, double credit) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd.MM.yy");

		lf.newLine();
		lf.addToLine(""+ligne);
		lf.addToLine(formatDatePoint.format(new Date(dateOp)));
		lf.addToLine(numCompte);
		lf.addToLine(intitule);
		lf.addToLine(libelle);
		lf.addToLine(""+(debit==0?Lettre:numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine(""+(credit==0?Lettre:numFormat.format(credit)).replaceAll("\\.", ","));

	}
	
	
	/** fin ecriture */

	private void putFinEcriture(ListingFile lf) {

		lf.newLine();
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");

	}


	/** Ajoute une ligne de total pour un journal au listing */

	private void putTotalJournal(ListingFile lf, String codeJ, double debit, double credit) {

		lf.newLine();
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("Total du journal " + codeJ);
		lf.addToLine(("" + numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine(("" + numFormat.format(credit)).replaceAll("\\.", ","));

	}


	/** Ajoute une ligne de total pour un compte centralis (gnraux, clients, fournisseurs) d'un journal au listing */

	private void putTotalCpte(ListingFile lf, String entete, double debit, double credit) {

		lf.newLine();
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine(entete);
		lf.addToLine(("" + numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine(("" + numFormat.format(credit)).replaceAll("\\.", ","));

	}


	/** Ajoute une ligne de total de la periode d'edition du journal au listing */

	private void putTotalPeriode(ListingFile lf, double debit, double credit) {

		lf.newLine();
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("Total p\u00E9riode");
		lf.addToLine(("" + numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine(("" + numFormat.format(credit)).replaceAll("\\.", ","));

	}

} // fin GenCsvJournaux




