/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.compta.actions.etats;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.Arrondi;
import org.opensi.util.tools.DateTime;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfSIG extends Action {


	class MyPageEvent implements PdfPageEvent {


	private String dateCourante;

	private String dossierId;
	private String raisonSociale;
	private String adresse;
	private String compAdresse;
	private String codePostal;
	private String ville;
	private String monnaie;

	private String debutExercice;
	private String finExercice;
	private String finPeriodeStr;
	private String finExerciceN1Str;
	private boolean dateHeure;
	private boolean numDossier;
	private boolean projet;


		public MyPageEvent(String dossierId, String debutExercice, String finExercice, String dateHeure, String numDossier, String projet) throws SQLException {

			this.dossierId = dossierId;
			this.dateHeure = dateHeure.equalsIgnoreCase("y");
			this.numDossier = numDossier.equalsIgnoreCase("n");
			this.projet = projet.equalsIgnoreCase("y");

			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ baseDossier +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";

			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery(reqLeDossier);

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse = rset.getString("Adresse_1");
			this.compAdresse = rset.getString("Adresse_2");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.monnaie = rset.getString("Devise");

			rset.close();

			stt.close();

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			this.finPeriodeStr = formatDate.format(new Date(finPeriode));
			this.debutExercice = formatDate.format(new Date(Long.parseLong(debutExercice)));
			this.finExercice = formatDate.format(new Date(Long.parseLong(finExercice)));
			this.finExerciceN1Str = formatDate.format(new Date(finExerciceN1));
		}


    public void onStartPage(PdfWriter writer, Document document) {

    	try {

				if (projet) {
					try {
						PdfContentByte dcu = writer.getDirectContentUnder();
						Image fond = Image.getInstance(cheminImages +"projet.jpg");
						fond.scaleAbsolute(324, 468);
						fond.setAbsolutePosition(135,100);
						dcu.addImage(fond);
					}
					catch(java.net.MalformedURLException mfue) { System.err.println(mfue.getMessage()); }
					catch(IOException ioe) { System.err.println(ioe.getMessage()); }
				}

				// Entete Gnrale


				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase(numDossier?"Dossier : "+this.dossierId:"", fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase(dateHeure?"Date : "+this.dateCourante:"", fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.adresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Exercice du " + this.debutExercice + " au " + this.finExercice, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.compAdresse, fontGen));
				cellEntete.setColspan(1);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.codePostal + " " + this.ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(detailSIG?"D\u00E9tail des Soldes Interm\u00E9diaires de Gestion":"Soldes Interm\u00E9diaires de Gestion", new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(10);
				entete.addCell(cellEntete);


				cellEntete.setPhrase(new Phrase("Au " + this.finPeriodeStr, fontGen));
				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete Gnrale


				// Titres de colonnes

				PdfPTable titresColonnes = new PdfPTable(nbColListing);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widthsListing);
				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(10);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setColspan(nbColListing);
				titresColonnes.addCell(cellTitre);

				cellTitre.setColspan(1);
				cellTitre.setMinimumHeight(16);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.BOTTOM);
				cellTitre.setPhrase(new Phrase(""));
				titresColonnes.addCell(cellTitre);

				Phrase exon = new Phrase("Exercice N", fontLine);
				exon.add(new Chunk("\n("+ dureeN +" mois)", fontMini));

				cellTitre.setPhrase(exon);
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("%", fontLine));
				titresColonnes.addCell(cellTitre);

				if (compareN1) {
					Phrase exon1 = new Phrase("Exercice N-1", fontLine);
					exon1.add(new Chunk("\n("+ dureeN1 +" mois)", fontMini));

					cellTitre.setPhrase(exon1);
					titresColonnes.addCell(cellTitre);

					cellTitre.setPhrase(new Phrase("%", fontLine));
					titresColonnes.addCell(cellTitre);

					cellTitre.setColspan(2);
					cellTitre.setBorder(PdfPCell.BOX);

					Phrase enn1 = new Phrase("Ecart N / N-1", fontLine);

					if (proratisation) {
						enn1.add(new Chunk("\n(proratis\u00E9)", fontMini));
					}

					cellTitre.setPhrase(enn1);
					titresColonnes.addCell(cellTitre);
				}

				cellTitre.setColspan(1);
				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.TOP);

				cellTitre.setPhrase(new Phrase("", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase(this.finPeriodeStr, fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("CA", fontLine));
				titresColonnes.addCell(cellTitre);

				if (compareN1) {
					cellTitre.setPhrase(new Phrase(this.finExerciceN1Str, fontLine));
					titresColonnes.addCell(cellTitre);

					cellTitre.setPhrase(new Phrase("CA", fontLine));
					titresColonnes.addCell(cellTitre);

					cellTitre.setBorder(PdfPCell.BOX);
					cellTitre.setPhrase(new Phrase(this.monnaie.toUpperCase() + "S", fontLine));
					titresColonnes.addCell(cellTitre);

					cellTitre.setPhrase(new Phrase("%", fontLine));
					titresColonnes.addCell(cellTitre);
				}

				document.add(titresColonnes);

				// fin Titres de colonnes

			}
			catch(DocumentException de) {	de.printStackTrace(); }

		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
    public void onCloseDocument(PdfWriter writer, Document document) {}
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
    public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
    public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
    public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontLine = new Font(Font.HELVETICA , 9, Font.NORMAL);		// font pour lignes de listing
private static final Font fontMini = new Font(Font.HELVETICA , 7, Font.NORMAL);		// font pour prcisions
private DecimalFormat numFormat = new DecimalFormat("0");
private DecimalFormat numFormat2 = new DecimalFormat("0.00");

private int widthsListing[];

private String base;
private String baseN1;
private String baseDossier;
private boolean detailSIG;
private boolean compareN1;
private boolean proratisation;
private long finExerciceN1;
private long debutPeriode;
private long finPeriode;
private int nbColListing;
private int dureeN1 = 0;
private int dureeN = 0;

private Connection con;
private String cheminImages;


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		con = s.getConnection(null);

		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);

		numFormat2.setDecimalFormatSymbols(dfs);
		numFormat2.setGroupingUsed(true);
		numFormat2.setGroupingSize(3);

		String dossierId = s.getCookie().get("Dossier_Id");
		String debutExercice = r.getParameter("Debut_Exercice");
		String finExercice = r.getParameter("Fin_Exercice");
		String dateFin = r.getParameter("Date_Fin");
		String base = s.getCookie().get("BaseExo");
		baseDossier = s.getCookie().get("BaseDossier");
		String type = r.getParameter("Type");
		String numDossier = r.getParameter("Num_Dossier");
		String dateHeure = r.getParameter("Date_Heure");
		String comparatif = r.getParameter("Comparatif");
		String proratiser = r.getParameter("Proratisation");
		String projet = r.getParameter("Projet");
		String detail = r.getParameter("Detail");
		int numExerciceN1 = Integer.parseInt(r.getParameter("Num_Exercice"))-1;

		int widthsListing3[] = {50,38,12};          // largeurs colonnes sans comparatif N-1
		int widthsListing7[] = {41,13,7,13,7,11,8}; // largeurs de colonnes avec comparatif N-1

		PdfPTable listing;

		if (type.equalsIgnoreCase("D")) {
			this.finPeriode = DateTime.parseDate(dateFin, "dd/MM/yy");
		}
		else {
			this.finPeriode = Long.parseLong(finExercice);
		}

		this.debutPeriode = Long.parseLong(debutExercice);
		this.base = base;
		this.detailSIG = detail.equalsIgnoreCase("y");
		this.compareN1 = comparatif.equalsIgnoreCase("n");
		this.proratisation = proratiser.equalsIgnoreCase("y");

		// base si comparatif et exercice n-1 existe

		String reqExoN1 = "select Nom_Base, Duree_Exercice, Fin_Exercice from "+ baseDossier +".EXERCICE where Num_Exercice="+ numExerciceN1;


		Statement stt = con.createStatement();
		ResultSet rsetN1 = stt.executeQuery(reqExoN1);

		if (rsetN1.next()) {
			baseN1 = rsetN1.getString("Nom_Base");
			dureeN1 = rsetN1.getInt("Duree_Exercice");
			finExerciceN1 = rsetN1.getLong("Fin_Exercice");
			Arrondi rd = new Arrondi(0);
			dureeN = (int)rd.round((((double)finPeriode-debutPeriode)/86400000)/30);
		}
		else {
			this.compareN1 = false; // on force a faux si pas d'exo precedent
		}

		rsetN1.close();
		stt.close();


		if (compareN1) {
			this.nbColListing = 7;
			this.widthsListing = widthsListing7;
		}
		else {
			this.nbColListing = 3;
			this.widthsListing = widthsListing3;
		}

		Document document = new Document(PageSize.A4, 25, 25, 25, 25);

		String chemin = s.getAppConfiguration().get("opensi.absdir") +"/pdf/";

		this.cheminImages = s.getAppConfiguration().get("opensi.absdir") +"/images/";

		String fichierPdf = r.getParameter("FichierPDF");

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

		MyPageEvent event = new MyPageEvent(dossierId, debutExercice, finExercice, dateHeure, numDossier, projet);

		writer.setPageEvent(event);


		document.open();


		listing = new PdfPTable(this.nbColListing);
		listing.setWidthPercentage(100);
		listing.setWidths(widthsListing);

		putSIG(listing);

		document.add(listing);

		document.close();

		s.closeConnection(con, null);


		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier  supprimer");
			se.printStackTrace();
		}


		return true;


	} // fin service


	private void putSIG(PdfPTable listing) throws SQLException, Exception {

		double valN = 0;
		double valN1 = 0;
		double totalN = 0;
		double totalN1 = 0;

		valN = getSumCompte("70%")
				 + getSumCompte("71%")
				 + getSumCompte("72%")
				 + getSumCompte("73%");

		if (compareN1) {
			valN1 = getSumCompteN1("70%")
				 		+ getSumCompteN1("71%")
				 		+ getSumCompteN1("72%")
				 		+ getSumCompteN1("73%");
		}

		double refVP = valN;
		double refVPN1 = valN1;

		putTotalSection(listing, refVP, refVPN1, "VENTES DE MARCHANDISES + PRODUCTIONS", valN, valN1);

		putEspacement(listing, 4);

		valN = getSumCompte("707%")
				 + getSumCompte("7097%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("707%")
				 		+ getSumCompteN1("7097%");

			totalN1 += valN1;
		}

		double refVM = valN;
		double refVMN1 = valN1;

		putLigneSIG(listing, refVM, refVMN1, "Ventes de marchandises", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVM, refVMN1, "707%");
			putDetailSection(listing, refVM, refVMN1, "7097%");
			putEspacement(listing, 5);
		}

		valN = - (getSumCompte("607%")
				 + getSumCompte("6037%")
				 + getSumCompte("6087%")
				 + getSumCompte("6097%"));

		totalN -= valN;

		if (compareN1) {
			valN1 = - (getSumCompteN1("607%")
					 	+ getSumCompteN1("6037%")
					 	+ getSumCompteN1("6087%")
					 	+ getSumCompteN1("6097%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refVM, refVMN1, "Cot d'achat des marchandises vendues", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVM, refVMN1, "6037%");
			putDetailSection(listing, refVM, refVMN1, "607%");
			putDetailSection(listing, refVM, refVMN1, "6087%");
			putDetailSection(listing, refVM, refVMN1, "6097%");
		}

		putEspacement(listing, 5);

		double ligne4 = totalN;
		double ligne4N1 = totalN1;

		putTotalSection(listing, refVM, refVMN1, "MARGE COMMERCIALE", totalN, totalN1);

		putEspacement(listing, 4);

		valN = getSumCompte("70%")
				 - getSumCompte("707%")
				 - getSumCompte("7097%")
				 + getSumCompte("73%");

		totalN = valN;

		if (compareN1) {
			valN1 = getSumCompteN1("70%")
						- getSumCompteN1("707%")
				 		- getSumCompteN1("7097%")
				 		+ getSumCompteN1("73%");

			totalN1 = valN1;
		}

		double refPV = valN;
		double refPVN1 = valN1;

		putLigneSIG(listing, refPV, refPVN1, "Production vendue", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refPV, refPVN1, "70%' and Numero_Compte not like '707%' and Numero_Compte not like '7097%");
			putDetailSection(listing, refPV, refPVN1, "73%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("71%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("71%");
			totalN1 += valN1;
		}

		putLigneSIG(listing, refPV, refPVN1, "Production stock\u00E9e ou d\u00E9stockage", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refPV, refPVN1, "71%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("72%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("72%");
			totalN1 += valN1;
		}

		putLigneSIG(listing, refPV, refPVN1, "Production immobilis\u00E9e", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refPV, refPVN1, "72%");
		}

		putEspacement(listing, 5);

		double refPE = totalN;
		double refPEN1 = totalN1;

		putTotalSection(listing, refPE, refPEN1, "PRODUCTION DE L'EXERCICE", totalN, totalN1);

		putEspacement(listing, 4);

		valN = - (getSumCompte("600%")
				 + getSumCompte("601%")
				 + getSumCompte("602%")
				 + getSumCompte("603%")
				 + getSumCompte("6080%")
				 + getSumCompte("6081%")
				 + getSumCompte("6082%")
				 + getSumCompte("6090%")
				 + getSumCompte("6091%")
				 + getSumCompte("6092%")
				 - getSumCompte("6037%"));

		totalN -= valN;

		if (compareN1) {
			valN1 = - (getSumCompteN1("600%")
				 		+ getSumCompteN1("601%")
				 		+ getSumCompteN1("602%")
				 		+ getSumCompteN1("603%")
				 		+ getSumCompteN1("6080%")
				 		+ getSumCompteN1("6081%")
				 		+ getSumCompteN1("6082%")
				 		+ getSumCompteN1("6090%")
				 		+ getSumCompteN1("6091%")
				 		+ getSumCompteN1("6092%")
				 		- getSumCompteN1("6037%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refPE, refPEN1, "Mati\u00E8res premi\u00E8res, approvisionnements consomm\u00E9s", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refPE, refPEN1, "600%");
			putDetailSection(listing, refPE, refPEN1, "601%");
			putDetailSection(listing, refPE, refPEN1, "602%");
			putDetailSection(listing, refPE, refPEN1, "603%' and Numero_Compte not like '6037%");
			putDetailSection(listing, refPE, refPEN1, "6080%");
			putDetailSection(listing, refPE, refPEN1, "6081%");
			putDetailSection(listing, refPE, refPEN1, "6082%");
			putDetailSection(listing, refPE, refPEN1, "6090%");
			putDetailSection(listing, refPE, refPEN1, "6091%");
			putDetailSection(listing, refPE, refPEN1, "6092%");
			putEspacement(listing, 5);
		}

		valN = - (getSumCompte("604%")
				 + getSumCompte("605%")
				 + getSumCompte("6084%")
				 + getSumCompte("6085%")
				 + getSumCompte("6094%")
				 + getSumCompte("6095%"));

		totalN -= valN;

		if (compareN1) {
			valN1 = - (getSumCompteN1("604%")
				 		+ getSumCompteN1("605%")
				 		+ getSumCompteN1("6084%")
				 		+ getSumCompteN1("6085%")
				 		+ getSumCompteN1("6094%")
				 		+ getSumCompteN1("6095%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refPE, refPEN1, "Sous traitance directe", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refPE, refPEN1, "604%");
			putDetailSection(listing, refPE, refPEN1, "605%");
			putDetailSection(listing, refPE, refPEN1, "6084%");
			putDetailSection(listing, refPE, refPEN1, "6085%");
			putDetailSection(listing, refPE, refPEN1, "6094%");
			putDetailSection(listing, refPE, refPEN1, "6095%");
		}

		putEspacement(listing, 5);

		putTotalSection(listing, refPE, refPEN1, "MARGE BRUTE DE PRODUCTION", totalN, totalN1);

		totalN += ligne4;
		totalN1 += ligne4N1;

		putTotalSection(listing, refVP, refVPN1, "MARGE BRUTE GLOBALE", totalN, totalN1);

		putEspacement(listing, 4);

		valN = - (getSumCompte("606%")
				 + getSumCompte("6083%")
				 + getSumCompte("6086%")
				 + getSumCompte("6088%")
				 + getSumCompte("6089%")
				 + getSumCompte("61%")
				 + getSumCompte("62%")
				 + getSumCompte("6093%")
				 + getSumCompte("6096%")
				 + getSumCompte("6098%")
				 + getSumCompte("6099%"));

		totalN -= valN;

		if (compareN1) {
			valN1 = - (getSumCompteN1("606%")
					 	+ getSumCompteN1("6083%")
					 	+ getSumCompteN1("6086%")
					 	+ getSumCompteN1("6088%")
					 	+ getSumCompteN1("6089%")
					 	+ getSumCompteN1("61%")
					 	+ getSumCompteN1("62%")
					 	+ getSumCompteN1("6093%")
					 	+ getSumCompteN1("6096%")
					 	+ getSumCompteN1("6098%")
					 	+ getSumCompteN1("6099%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Autres achats et charges externes", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "606%");
			putDetailSection(listing, refVP, refVPN1, "6083%");
			putDetailSection(listing, refVP, refVPN1, "6086%");
			putDetailSection(listing, refVP, refVPN1, "6088%");
			putDetailSection(listing, refVP, refVPN1, "6089%");
			putDetailSection(listing, refVP, refVPN1, "6093%");
			putDetailSection(listing, refVP, refVPN1, "6096%");
			putDetailSection(listing, refVP, refVPN1, "6098%");
			putDetailSection(listing, refVP, refVPN1, "6099%");
			putDetailSection(listing, refVP, refVPN1, "61%");
			putDetailSection(listing, refVP, refVPN1, "62%");
		}

		putEspacement(listing, 5);

		putTotalSection(listing, refVP, refVPN1, "VALEUR AJOUTEE", totalN, totalN1);

		putEspacement(listing, 4);

		valN = getSumCompte("74%");

		totalN += valN; // +15

		if (compareN1) {
			valN1 = getSumCompteN1("74%");
			totalN1 += valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Subventions d'exploitation", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "74%");
			putEspacement(listing, 5);
		}

		valN = - getSumCompte("63%");

		totalN -= valN; // -16

		if (compareN1) {
			valN1 = - getSumCompteN1("63%");
			totalN1 -= valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Impts, taxes et versements assimil\u00E9s", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "63%");
			putEspacement(listing, 5);
		}



		/*
		valN = - (getSumCompte("64%")
				 - getSumCompte("644%")
				 - getSumCompte("646%"));

		totalN -= valN; // -17

		if (compareN1) {
			valN1	= - (getSumCompteN1("64%")
				 		- getSumCompteN1("644%")
				 		- getSumCompteN1("646%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Charges de personnel", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "64%' and Numero_Compte not like '644%' and Numero_Compte not like '646%");
			putEspacement(listing, 5);
		}*/



		valN = - (getSumCompte("641%"));

		totalN -= valN; // -17

		if (compareN1) {
			valN1	= - (getSumCompteN1("641%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Salaires du personnel", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "641%");
			putEspacement(listing, 5);
		}


		valN = - (getSumCompte("64%")
				 - getSumCompte("641%")
				 - getSumCompte("644%")
				 - getSumCompte("646%"));

		totalN -= valN; // -17

		if (compareN1) {
			valN1	= - (getSumCompteN1("64%")
						- getSumCompteN1("641%")
				 		- getSumCompteN1("644%")
				 		- getSumCompteN1("646%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Charges sociales du personnel", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "64%' and Numero_Compte not like '641%' and Numero_Compte not like '644%' and Numero_Compte not like '646%");
			putEspacement(listing, 5);
		}



		valN = - (getSumCompte("644%")
				 + getSumCompte("646%"));

		totalN -= valN; // -18

		if (compareN1) {
			valN1 = - (getSumCompteN1("644%")
					 + getSumCompteN1("646%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Charges de l'exploitant", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "644%");
			putDetailSection(listing, refVP, refVPN1, "646%");
		}

		putEspacement(listing, 5);

		putTotalSection(listing, refVP, refVPN1, "EXCEDENT BRUT D'EXPLOITATION", totalN, totalN1);

		putEspacement(listing, 4);

		valN = getSumCompte("75%")
				 - getSumCompte("755%");

		totalN += valN; // +20

		if (compareN1) {
			valN1 = getSumCompteN1("75%")
					 	- getSumCompteN1("755%");

			totalN1 += valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Autres produits de gestion courante", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "75%' and Numero_Compte not like '755%");
			putEspacement(listing, 5);
		}

		valN = - (getSumCompte("65%")
				 - getSumCompte("655%"));

		totalN -= valN; // -21

		if (compareN1) {
			valN1 = - (getSumCompteN1("65%")
				 		- getSumCompteN1("655%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Autres charges de gestion courante", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "65%' and Numero_Compte not like '655%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("78%")
				 + getSumCompte("79%")
				 - getSumCompte("786%")
				 - getSumCompte("787%")
				 - getSumCompte("789%")
				 - getSumCompte("796%")
				 - getSumCompte("797%");

		totalN += valN; // +22

		if (compareN1) {
			valN1 = getSumCompteN1("78%")
					 + getSumCompteN1("79%")
					 - getSumCompteN1("786%")
					 - getSumCompteN1("787%")
					 - getSumCompteN1("789%")
					 - getSumCompteN1("796%")
					 - getSumCompteN1("797%");

			totalN1 += valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Reprises sur amortissements et provisions", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "78%' and Numero_Compte not like '786%' and Numero_Compte not like '787%' and Numero_Compte not like '789%");
			putDetailSection(listing, refVP, refVPN1, "79%' and Numero_Compte not like '796%' and Numero_Compte not like '797%");
			putEspacement(listing, 5);
		}

		valN = - (getSumCompte("68%")
				 - getSumCompte("6815%")
				 - getSumCompte("6816%")
				 - getSumCompte("6817%")
				 - getSumCompte("686%")
				 - getSumCompte("687%")
				 - getSumCompte("689%"));

		totalN -= valN; // -23

		if (compareN1) {
			valN1 = - (getSumCompteN1("68%")
					 	- getSumCompteN1("6815%")
					 	- getSumCompteN1("6816%")
					 	- getSumCompteN1("6817%")
					 	- getSumCompteN1("686%")
					 	- getSumCompteN1("687%")
						- getSumCompteN1("689%"));

			totalN1 -= valN1; // -23
		}

		putLigneSIG(listing, refVP, refVPN1, "Dotations aux amortissements", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "68%' and Numero_Compte not like '6815%' and Numero_Compte not like '6816%' and Numero_Compte not like '6817%' and Numero_Compte not like '686%' and Numero_Compte not like '687%' and Numero_Compte not like '689%");
			putEspacement(listing, 5);
		}

		valN = - (getSumCompte("6815%")
				 + getSumCompte("6816%")
				 + getSumCompte("6817%"));

		totalN -= valN; // -24

		if (compareN1) {
			valN1 = - (getSumCompteN1("6815%")
					  + getSumCompteN1("6816%")
					  + getSumCompteN1("6817%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Dotations aux provisions", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "6815%");
			putDetailSection(listing, refVP, refVPN1, "6816%");
			putDetailSection(listing, refVP, refVPN1, "6817%");
		}

		putEspacement(listing, 5);

		putTotalSection(listing, refVP, refVPN1, "RESULTAT D'EXPLOITATION", totalN, totalN1);

		putEspacement(listing, 4);

		valN = getSumCompte("755%")
				 + getSumCompte("655%");

		totalN += valN; // +26

		if (compareN1) {
			valN1 = getSumCompteN1("755%")
					 + getSumCompteN1("655%");

			totalN1 += valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Quotes parts de r\u00E9sultat sur op\u00E9rations en commun", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "655%");
			putDetailSection(listing, refVP, refVPN1, "755%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("76%")
				 + getSumCompte("786%")
				 + getSumCompte("796%");

		totalN += valN; // +27

		if (compareN1) {
			valN1 = getSumCompteN1("76%")
					 + getSumCompteN1("786%")
					 + getSumCompteN1("796%");

			totalN1 += valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Produits financiers", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "76%");
			putDetailSection(listing, refVP, refVPN1, "786%");
			putDetailSection(listing, refVP, refVPN1, "796%");
			putEspacement(listing, 5);
		}

		valN = - (getSumCompte("66%")
				 + getSumCompte("686%"));

		totalN -= valN; // -28

		if (compareN1) {
			valN1 = - (getSumCompteN1("66%")
					 	+ getSumCompteN1("686%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Charges financi\u00E8res", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "66%");
			putDetailSection(listing, refVP, refVPN1, "686%");
		}

		putEspacement(listing, 5);

		double ligne29 = totalN;
		double ligne29N1 = totalN1;

		putTotalSection(listing, refVP, refVPN1, "RESULTAT COURANT", totalN, totalN1);

		putEspacement(listing, 4);

		valN = getSumCompte("77%")
				 + getSumCompte("787%")
				 + getSumCompte("797%");

		totalN = valN; // 30

		if (compareN1) {
			valN1 = getSumCompteN1("77%")
					 	+ getSumCompteN1("787%")
					 	+ getSumCompteN1("797%");

			totalN1 = valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Produits exceptionnels", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "77%");
			putDetailSection(listing, refVP, refVPN1, "787%");
			putDetailSection(listing, refVP, refVPN1, "797%");
			putEspacement(listing, 5);
		}

		valN = - (getSumCompte("67%")
				 + getSumCompte("687%"));

		totalN -= valN; // -31

		if (compareN1) {
			valN1 = - (getSumCompteN1("67%")
				 		+ getSumCompteN1("687%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Charges exceptionnelles", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "67%");
			putDetailSection(listing, refVP, refVPN1, "687%");
		}

		putEspacement(listing, 5);

		putTotalSection(listing, refVP, refVPN1, "RESULTAT EXCEPTIONNEL", totalN, totalN1);

		putEspacement(listing, 4);

		valN = - (getSumCompte("689%")
				 + getSumCompte("695%")
				 + getSumCompte("696%")
				 + getSumCompte("697%")
				 + getSumCompte("698%")
				 + getSumCompte("699%")
				 + getSumCompte("789%"));

		totalN -= valN; // -33

		if (compareN1) {
			valN1 = - (getSumCompteN1("689%")
						+ getSumCompteN1("695%")
					 	+ getSumCompteN1("696%")
					 	+ getSumCompteN1("697%")
					 	+ getSumCompteN1("698%")
					 	+ getSumCompteN1("699%")
						+ getSumCompteN1("789%"));

			totalN1 -= valN1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Impts sur les b\u00E9n\u00E9fices", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "689%");
			putDetailSection(listing, refVP, refVPN1, "695%");
			putDetailSection(listing, refVP, refVPN1, "696%");
			putDetailSection(listing, refVP, refVPN1, "697%");
			putDetailSection(listing, refVP, refVPN1, "698%");
			putDetailSection(listing, refVP, refVPN1, "699%");
			putDetailSection(listing, refVP, refVPN1, "789%");
			putEspacement(listing, 5);
		}

		valN = - (getSumCompte("69%")
				 - getSumCompte("695%")
				 - getSumCompte("696%")
				 - getSumCompte("697%")
				 - getSumCompte("698%")
				 - getSumCompte("699%"));

		totalN -= valN; // -34
		totalN += ligne29;

		if (compareN1) {
			valN1 = - (getSumCompteN1("69%")
					 	- getSumCompteN1("695%")
					 	- getSumCompteN1("696%")
					 	- getSumCompteN1("697%")
					 	- getSumCompteN1("698%")
					 	- getSumCompteN1("699%"));

			totalN1 -= valN1;
			totalN1 += ligne29N1;
		}

		putLigneSIG(listing, refVP, refVPN1, "Participation des salari\u00E9s", valN, valN1);

		if (detailSIG) {
			putDetailSection(listing, refVP, refVPN1, "69%' and Numero_Compte not like '695%' and Numero_Compte not like '696%' and Numero_Compte not like '697%' and Numero_Compte not like '698%' and Numero_Compte not like '699%");
		}

		putEspacement(listing, 5);

		putTotalSection(listing, refVP, refVPN1, "RESULTAT NET", totalN, totalN1);

	}

	private double getSumCompte(String like) throws SQLException, Exception {

		double val = 0;
		String request = "select sum(Montant_D) as debit, sum(Montant_C) as credit from "+ baseDossier +".COMPTE c,"+ base +".OPERATION o where o.Date_Op>="+ debutPeriode +" and o.Date_Op<="+ finPeriode +" and c.Numero_Compte=o.Numero_Compte and c.Numero_Compte like '"+ like +"'";

		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery(request);

		if (rset.next()) {

			val = rset.getDouble("credit") - rset.getDouble("debit");
		}
		rset.close();

		stt.close();

		return val;
	}


	private double getSumCompteN1(String like) throws SQLException, Exception {

		double val = 0;
		String request = "select sum(Total_Debit) as debit, sum(Total_Credit) as credit from "+ baseN1 +".SOLDE_COMPTE where Numero_Compte like '"+ like +"'";

		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery(request);

		if (rset.next()) {

			val = rset.getDouble("credit") - rset.getDouble("debit");
		}
		rset.close();

		stt.close();

		return val;
	}


	private void putDetailSection(PdfPTable listing, double reference, double referenceN1, String like) throws SQLException, Exception {

		double solde = 0;
		double soldeN1 = 0;
		String libelle;
		String numero;
		ResultSet rsetN1;
		ResultSet rsetN;


		String request = "select Intitule, Numero_Compte from "+ baseDossier +".COMPTE where Numero_Compte like '"+ like +"'";

		Statement stt = con.createStatement();
		PreparedStatement ps = con.prepareStatement("select sum(Montant_D) as debit, sum(Montant_C) as credit from "+ baseDossier +".COMPTE c,"+ base +".OPERATION o where o.Date_Op>="+ debutPeriode +" and o.Date_Op<="+	finPeriode +" and c.Numero_Compte=o.Numero_Compte and c.Numero_Compte=?");
		PreparedStatement ps1 = con.prepareStatement("select Total_Debit, Total_Credit from "+ baseN1 +".SOLDE_COMPTE where Numero_Compte=?");

		ResultSet rset = stt.executeQuery(request);

		while (rset.next()) {
			libelle = rset.getString("Intitule");
			numero = rset.getString("Numero_Compte");

			ps.clearParameters();
			ps.setString(1, numero);

			rsetN = ps.executeQuery();

			if (rsetN.next()) {

				solde = rsetN.getDouble("credit") - rsetN.getDouble("debit");
				solde = numero.charAt(0)=='6'?-solde:solde;
			}
			rsetN.close();

			if (compareN1) {

				ps1.clearParameters();
				ps1.setString(1, numero);

				rsetN1 = ps1.executeQuery();

				if (rsetN1.next()) {

					soldeN1 = rsetN1.getDouble("Total_Credit") - rsetN1.getDouble("Total_Debit");
					soldeN1 = numero.charAt(0)=='6'?-soldeN1:soldeN1;
				}
				rsetN1.close();
			}

			solde = (solde>=0.01 || solde<=-0.01)?solde:0;
			soldeN1 = (soldeN1>=0.01 || soldeN1<=-0.01)?soldeN1:0;

			if (solde!=0 || soldeN1!=0) {
				putLigneDetail(listing, reference, referenceN1, numero, libelle, solde, soldeN1);
			}

		}
		rset.close();

		stt.close();
	}


	private void putLigneDetail(PdfPTable listing, double reference, double referenceN1, String numero, String libelle, double soldeN, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPaddingLeft(25);
		cellListing.setPhrase(new Phrase(numero +" "+ libelle, fontLine));
		listing.addCell(cellListing);

		cellListing.setPaddingLeft(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		double perCA = soldeN*100/reference;

		cellListing.setPhrase(new Phrase(perCA==0?"":numFormat2.format(perCA), fontLine));
		listing.addCell(cellListing);

		if (this.compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double perCA1 = soldeN1*100/referenceN1;

			cellListing.setPhrase(new Phrase(perCA1==0?"":numFormat2.format(perCA1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}
	}


	private void putLigneSIG(PdfPTable listing, double reference, double referenceN1, String intitule, double soldeN, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		if (this.detailSIG) {
			intitule = intitule.toUpperCase();
		}

		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase(intitule, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);

		if (detailSIG) {
			cellListing.setBackgroundColor(new Color(210,210,210));
		}

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		double perCA = soldeN*100/reference;

		cellListing.setPhrase(new Phrase(perCA==0?"":numFormat2.format(perCA), fontLine));
		listing.addCell(cellListing);

		if (this.compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double perCA1 = soldeN1*100/referenceN1;

			cellListing.setPhrase(new Phrase(perCA1==0?"":numFormat2.format(perCA1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}
	}


	private void putTotalSection(PdfPTable listing, double reference, double referenceN1, String intitule, double soldeN, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(Color.LIGHT_GRAY);
		cellListing.setFixedHeight(20);

		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPhrase(new Phrase(intitule, new Font(Font.HELVETICA, 9, Font.BOLD)));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		double perCA = soldeN*100/reference;

		cellListing.setPhrase(new Phrase(perCA==0?"":numFormat2.format(perCA), fontLine));
		listing.addCell(cellListing);

		if (this.compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double perCA1 = soldeN1*100/referenceN1;

			cellListing.setPhrase(new Phrase(perCA1==0?"":numFormat2.format(perCA1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}
	}


	private void putEspacement(PdfPTable listing, int space) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(space);
		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase("", fontLine));

		listing.addCell(cellListing);
		listing.addCell(cellListing);
		listing.addCell(cellListing);

		if (this.compareN1) {
			listing.addCell(cellListing);
			listing.addCell(cellListing);
			listing.addCell(cellListing);
			listing.addCell(cellListing);
		}
	}


} // fin GenPdfSIG
