/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.compta.actions.rapprochementBancaire;

import java.awt.Color;
import java.io.*;
import java.sql.*;

import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;

import java.text.SimpleDateFormat;
import java.text.DecimalFormatSymbols;
import java.text.DecimalFormat;
import java.util.Date;

import com.lowagie.text.*;
import com.lowagie.text.pdf.*;


public class GenPdfRapprochement extends Action {

	// ATTRIBUTS DE CLASSE
	private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
	private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);		// font pour lignes de listing
	private DecimalFormat numFormat = new DecimalFormat("0.00");

	private int widths[] = {10,10,10,10,10,10,10}; // largeurs des colonnes du listing

	public boolean serverSide() { return true; }

	public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		Connection con = s.getConnection(null);

		String base = s.getCookie().get("BaseExo");
		String baseDossier=s.getCookie().get("BaseDossier");
		try {

			double solde_comptable=0.0;
			double	soldebanque=0;
			double	soldeini=0;

			int rapproid = new Integer(r.getParameter("rapproid"));	
			Document document = new Document(PageSize.A4, 25, 25, 25, 25);
			String chemin = s.getAppConfiguration().get("opensi.absdir") + "/pdf/";

			String fichierPdf = "rappro.pdf";
			PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

			PdfPTable listing;
			Rapprochement rappro=new Rapprochement(rapproid,con,base,baseDossier);		
			rappro.loadRappro(rapproid);
			String typerappro = typerappro=rappro.getType_Rappro();

			MyPageEvent event = new MyPageEvent(rappro,base,con, baseDossier, s.getCookie().get("Dossier_Id"));

			writer.setPageEvent(event);
			if (!document.isOpen()) {
				document.open();
			}
			//si le rapprochement est clotur on prend la valeur stock dans la base RAPPROCHEMENT
			int iscloture=0;
			if (rappro.isCloture()){
				iscloture=1;
			}
			
			double soldefinal = rappro.getSoldeFinal(); 
			String list = rappro.getListop();
			String listrb = rappro.getListopsaisie();


			rappro.calculSoldesop();

			soldeini=rappro.getSoldeINI();		
			solde_comptable=rappro.getSolde();
			soldebanque=rappro.getSoldeReleve();
			if (iscloture==0){
				soldefinal=rappro.getSoldeFinal();
			}		

			String baseexo2="";
			if (iscloture==0){
				//si l'exercice n'est pas clotur on vrifie si les dates se trouvent  cheval sur deux exercices
				baseexo2 = rappro.sEncoursSurDeuxExo(s);
				//sinon on verifie que les opid des lignes de rapprochement se trouvent toutes sur la meme base
				if (baseexo2.equals("")){
					baseexo2=rappro.sClotureSurDeuxExo(s);
				}
			}
			else if (iscloture==1){
				//si l'exercice est cltur on vrifie si sur ce rappro, plusieurs Nom_Base sont insres (opid sur plusieurs bases)
				baseexo2=rappro.sClotureSurDeuxExo(s);  
			}

			if (list.equals("")){
				list="''";
			}
			if (listrb.equals("")){
				listrb="''";
			}
			String list2="";
			String listrb2="";			
			if (!baseexo2.equals("")){
				Rapprochement rappro2=new Rapprochement(rapproid,con,baseexo2,baseDossier);	
				rappro2.loadRappro(rapproid);
				list2=rappro2.getListop();
				listrb2=rappro2.getListopsaisie();
				rappro2.calculSoldesop();

				//soldefinal = soldefinal - (rappro2.getSoldenonppointe()-rappro2.getSoldeRBnonppointe());
				if (list2.equals("")){
					list2="''";
				}
				if (listrb2.equals("")){
					listrb2="''";
				}
			}

			String INFO_LIGNES ="";
			if (iscloture==1){	      									   		
				INFO_LIGNES = "(select distinct o.Op_Id as op,o.Date_Op as dop,o.Libelle as l,o.Date_Echeance de,o.Montant_D as md,lr.Pointage as p, o.Montant_C as mc,o.Num_Piece as np ,e.Code_Journal as cj,j.Type_Journal as tj, 0 as typerb, o.Numero_Compte as compte from "+base+".OPERATION o, "+base+".ECRITURE e,  "+baseDossier+".JOURNAL j, "+baseDossier+".LIGNE_RAPPROCHEMENT	lr	 ";	
				INFO_LIGNES += "where o.Op_Id=lr.Op_Id and o.Ecriture_Id=e.Ecriture_Id and e.Code_Journal=j.Code_Journal and o.Op_Id IN ("+list+") and lr.Pointage=0 and lr.Nom_Base='"+base+"' and Rappro_Id="+rapproid+" order by Date_Op )"	;   
				INFO_LIGNES += " UNION (select distinct Ligne_RB_Id as op,Date_Op as dop, Libelle as l, 0 as de, Montant_D as md, Pointage as p ,Montant_C as mc ,'saisie RB' as np,'' as cj,'' as tj, 1 as typerb,'' as compte from "+baseDossier+".LIGNE_RB  where Ligne_RB_Id IN ("+listrb+") and  Pointage=0)";
				if (!baseexo2.equals("")){
					INFO_LIGNES += "UNION (select distinct o.Op_Id as op,o.Date_Op as dop,o.Libelle as l,o.Date_Echeance de,o.Montant_D as md,lr.Pointage as p, o.Montant_C as mc,o.Num_Piece as np ,e.Code_Journal as cj,j.Type_Journal as tj, 3 as typerb, o.Numero_Compte as compte from "+baseexo2+".OPERATION o, "+baseexo2+".ECRITURE e, "+baseDossier+".JOURNAL j, "+baseDossier+".LIGNE_RAPPROCHEMENT	lr  ";
					INFO_LIGNES += "where o.Op_Id=lr.Op_Id and o.Ecriture_Id=e.Ecriture_Id and e.Code_Journal=j.Code_Journal and o.Op_Id IN ("+list2+") and lr.Pointage=0 and lr.Nom_Base='"+baseexo2+"' and Rappro_Id="+rapproid+" order by Date_Op) order by dop	";

				}
			}
			else{
				INFO_LIGNES = "(select distinct o.Op_Id as op,o.Date_Op as dop,o.Libelle as l,o.Date_Echeance de,o.Montant_D as md,o.Pointage as p, o.Montant_C as mc,o.Num_Piece as np ,e.Code_Journal as cj,j.Type_Journal as tj, 0 as typerb, o.Numero_Compte as compte from "+base+".OPERATION o, "+base+".ECRITURE e,  "+baseDossier+".JOURNAL j ";	
				INFO_LIGNES += "where o.Ecriture_Id=e.Ecriture_Id and e.Code_Journal=j.Code_Journal and o.Op_Id IN ("+list+") and o.Pointage=0 order by Date_Op ) "	;   
				INFO_LIGNES += " UNION (select distinct Ligne_RB_Id as op,Date_Op as dop, Libelle as l, 0 as de, Montant_D as md, Pointage as p ,Montant_C as mc ,'saisie RB' as np,'' as cj,'' as tj, 1 as typerb,'' as compte from "+baseDossier+".LIGNE_RB  where Ligne_RB_Id IN ("+listrb+") and  Pointage=0)"; 
				if (!baseexo2.equals("")){					
					INFO_LIGNES += "UNION (select distinct o.Op_Id as op,o.Date_Op as dop,o.Libelle as l,o.Date_Echeance de,o.Montant_D as md,o.Pointage as p, o.Montant_C as mc,o.Num_Piece as np ,e.Code_Journal as cj,j.Type_Journal as tj, 3 as typerb, o.Numero_Compte as compte from "+baseexo2+".OPERATION o, "+baseexo2+".ECRITURE e, "+baseDossier+".JOURNAL j ";
					INFO_LIGNES += "where o.Ecriture_Id=e.Ecriture_Id and e.Code_Journal=j.Code_Journal and o.Op_Id IN ("+list2+")	and o.Pointage=0 order by Date_Op) order by dop";

				}
			}

			ResultSet rs2;			
			Statement stt = con.createStatement();
			rs2 = stt.executeQuery(INFO_LIGNES);

			listing = new PdfPTable(7);
			listing.setWidthPercentage(100);
			listing.setWidths(widths);		

			long dateOp =0;
			String contrepartie ="";
			String journalligne ="";
			String compteligne ="";
			String libelle ="";
			String piece ="";
			double debit =0;
			double credit =0;
			double totcredit=0;
			double totdebit=0;	
			while (rs2.next()) {		
				dateOp = rs2.getLong(2);
				journalligne = rs2.getString(9);
				compteligne=rs2.getString(11);
				libelle = rs2.getString(3);
				piece = rs2.getString(8);
				debit = rs2.getDouble(5);
				credit = rs2.getDouble(7);
				if (typerappro.equals("C")){
					contrepartie=journalligne;
				}
				if (typerappro.equals("J")){
					contrepartie=compteligne;
				}
				putLigneRapprochement(listing,dateOp,contrepartie,libelle,piece,debit,credit);
				totdebit += debit;
				totcredit += credit;
			}
			double ecart=0;

			ecart=soldefinal -soldebanque;
			putTotalPeriode(listing,totcredit,totdebit,solde_comptable,soldebanque,soldeini,soldefinal,ecart);
			document.add(listing);
			DecimalFormatSymbols dfs = new DecimalFormatSymbols();
			dfs.setDecimalSeparator('.');
			dfs.setGroupingSeparator(' ');

			numFormat.setDecimalFormatSymbols(dfs);
			numFormat.setNegativeSuffix("");
			numFormat.setNegativePrefix("-");
			numFormat.setPositiveSuffix(" ");
			numFormat.setGroupingUsed(true);
			numFormat.setGroupingSize(3);

			if (document.isOpen()) {
				document.close();
			}
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		finally {
			s.closeConnection(con, null);	
		}
		return true;


	} // fin service
	class MyPageEvent implements PdfPageEvent {

		Rapprochement rappro;
		String base="";
		String baseDossier;
		String dossierId;
		Connection con=null;
		public MyPageEvent(Rapprochement rappro, String base, Connection con, String baseDossier, String dossierId) {
			this.rappro = rappro;
			this.base=base;
			this.baseDossier=baseDossier;
			this.con=con;
			this.dossierId = dossierId;

		}


		public void onStartPage(PdfWriter writer, Document document) {
			try {			
			
				String raisonSociale="";
				String adresse ="";
				String compAdresse = "";
				String codePostal = "";
				String ville ="";			
				String code_journal="";
				String compte="";
				String datedebutrappro="";
				String datecloture="";
				String datereleve="";
				String typerappro=rappro.getType_Rappro();
				SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
				Date date=new Date();
				String datejour=dateFormat.format(date);
				code_journal=rappro.getCodeJournal();
				compte=rappro.getCompte();			

				if (rappro.getDateRappro()==0){				
					datedebutrappro="";
				}
				else{
					datedebutrappro=DateTime.formatTime(rappro.getDateRappro(),"dd/MM/yyyy");					
				}
				if (rappro.getdateCloture()==0){
					datecloture="  non cltur ";
				}
				else{
					datecloture=DateTime.formatTime(rappro.getDateRappro(),"dd/MM/yyyy");					
				}
				if (rappro.getDateReleve()==0){
					datereleve="";
				}
				else{
					datereleve=DateTime.formatTime(rappro.getDateReleve(),"dd/MM/yyyy");					
				}

				
				PreparedStatement pstmt = con.prepareStatement("select * from "+ baseDossier +".SOCIETE"); 
       
				ResultSet rs = pstmt.executeQuery();
				if (rs.next()) {
					raisonSociale= rs.getString("Denomination");
					adresse = rs.getString("Adresse_1");
					compAdresse = rs.getString("Adresse_2");
					codePostal = rs.getString("Code_Postal");
					ville = rs.getString("Ville");
				}

				PreparedStatement pstmt2 = null;	

				if (typerappro.equals("C")) {
					pstmt2 = con.prepareStatement("select Intitule from "+ baseDossier +".COMPTE where Numero_Compte=?"); 
					pstmt2.setString(1, rappro.getCompte());    
				}
				if (typerappro.equals("J")) {
					pstmt2 = con.prepareStatement("select Intitule from "+ baseDossier +".JOURNAL where Code_Journal=?"); 
					pstmt2.setString(1, rappro.getCodeJournal()); 
				}

				ResultSet rs2 = pstmt2.executeQuery();
				String lbl="";
				if (rs2.next()) {
					lbl=rs2.getString(1);
				}


				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				//Ligne 1
				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);
				cellEntete.setPhrase(new Phrase("Dossier : " + dossierId, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				//Ligne 2
				cellEntete.setColspan(1);
				cellEntete.setPhrase(new Phrase("Date : " + datejour, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				//Ligne 3
				cellEntete.setPhrase(new Phrase("", fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(compAdresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				//Ligne 4
				cellEntete.setColspan(1);
				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(codePostal + " " + ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				//Ligne 5
				cellEntete.setPhrase(new Phrase("Etat de rapprochement du "+datedebutrappro+" au "+datereleve, new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				//Ligne 6
				if(typerappro.equals("J")){
					cellEntete.setPhrase(new Phrase("Journal " +code_journal +" "+lbl, new Font(Font.HELVETICA, 12)));
					cellEntete.setColspan(3);
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
					entete.addCell(cellEntete);
				}
				if(typerappro.equals("C")){
					cellEntete.setPhrase(new Phrase("Compte " +compte +" "+lbl, new Font(Font.HELVETICA, 12)));
					cellEntete.setColspan(3);
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
					entete.addCell(cellEntete);
				}


				//				Ligne 7
				cellEntete.setPhrase(new Phrase("Cltur le : " +datecloture , fontGen));
				cellEntete.setColspan(1);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete Gnrale

				// Titres de colonnes

				PdfPTable titresColonnes = new PdfPTable(7);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widths);
				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(12);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setColspan(7);
				titresColonnes.addCell(cellTitre);

				//Init graph Ligne
				cellTitre.setFixedHeight(20);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

				//Ligne 1
				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setColspan(1);
				cellTitre.setPhrase(new Phrase("Date", fontLine));
				titresColonnes.addCell(cellTitre);

				if (typerappro.equals("C")){
					cellTitre.setPhrase(new Phrase("Journal", fontLine));
				}
				if (typerappro.equals("J")){
					cellTitre.setPhrase(new Phrase("Compte", fontLine));
				}

				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("Libell\u00E9", fontLine));
				cellTitre.setColspan(2);
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("Pi\u00E8ce", fontLine));
				cellTitre.setColspan(1);
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("D\u00E9bit", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("Cr\u00E9dit", fontLine));
				titresColonnes.addCell(cellTitre);


				document.add(titresColonnes);

				// fin Titres de colonnes	




			}
			catch( DocumentException de ) {

				de.printStackTrace();
			}
			catch(Exception de) {
				de.printStackTrace();
			}
		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
		public void onCloseDocument(PdfWriter writer, Document document) {}
		public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
		public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
		public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
		public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}//fin classe MyPageEvent




	/** Ajoute une ligne d'operation au listing */

	private void putLigneRapprochement(PdfPTable listing,long dateOp,String contrepartie,String libelle,String piece,double debit,double credit) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd.MM.yy");

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(formatDatePoint.format(new Date(dateOp)), fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(contrepartie, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPaddingLeft(5);
		cellListing.setPhrase(new Phrase(libelle, fontLine));
		cellListing.setColspan(2);
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(piece, fontLine));
		cellListing.setColspan(1);
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(debit==0?"":numFormat.format(debit), fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(credit==0?"":numFormat.format(credit), fontLine));
		listing.addCell(cellListing);
	}

	/** Ajoute une ligne de total de la periode d'edition du journal au listing */

	private void putTotalPeriode(PdfPTable listing,  double totcredit,double totdebit, double solde_comptable, double soldebanque, double soldeini, double soldefinal, double ecart ) {
		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());


		//Ligne 1
		cellListing.setBorder(PdfPCell.LEFT+PdfPCell.TOP);
		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(new Color(210,210,210));
		cellListing.setColspan(5);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase("Total : ", fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.TOP);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setColspan(1);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(totdebit), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(numFormat.format(totcredit), fontLine));
		cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.TOP);
		listing.addCell(cellListing);


//		Ligne 2
		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(new Color(210,210,210));
		cellListing.setBorder(PdfPCell.LEFT+PdfPCell.BOTTOM);
		cellListing.setColspan(5);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase("Solde comptable : ", fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.BOTTOM);
		cellListing.setColspan(2);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(solde_comptable), fontLine));
		listing.addCell(cellListing);

//		Ligne 3
		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(new Color(210,210,210));
		cellListing.setBorder(PdfPCell.LEFT+PdfPCell.BOTTOM);
		cellListing.setColspan(5);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase("Solde initial banque : ", fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.BOTTOM);
		cellListing.setColspan(2);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(soldeini), fontLine));
		listing.addCell(cellListing);
//		Ligne 4
		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(new Color(210,210,210));
		cellListing.setBorder(PdfPCell.LEFT+PdfPCell.BOTTOM);
		cellListing.setColspan(5);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase("Solde final banque : ", fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.BOTTOM);
		cellListing.setColspan(2);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(soldefinal), fontLine));
		listing.addCell(cellListing);	

		//Ligne 5
		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(new Color(210,210,210));
		cellListing.setBorder(PdfPCell.LEFT+PdfPCell.BOTTOM);
		cellListing.setColspan(5);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase("Solde relev\u00E9 : ", fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.BOTTOM);
		cellListing.setColspan(2);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(soldebanque), fontLine));
		listing.addCell(cellListing);


//		Ligne 6
		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(new Color(210,210,210));
		cellListing.setBorder(PdfPCell.LEFT+PdfPCell.BOTTOM);
		cellListing.setColspan(5);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase("Ecart : ", fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.BOTTOM);
		cellListing.setColspan(2);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(ecart), fontLine));
		listing.addCell(cellListing);

	}

}
