package org.opensi.compta.actions.rapprochementBancaire;

import java.sql.Connection;
import java.sql.Date;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

public class MajRapprochement extends Action {


		 
		
		public boolean serverSide() { return true; }

		  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
			  Connection con = s.getConnection(null);
			
			 
			  try{
				  String base = s.getCookie().get("BaseExo");
				  String basedossier=s.getCookie().get("BaseDossier");				 
				  String req=r.getParameter("req");	
				  String dateCourante;
		    	  SimpleDateFormat formatDate = new SimpleDateFormat("hh'h'mm dd/MM/yyyy");
				  dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
				  
				  if (base == null || basedossier == null){
					  r.addParameter("status", "fail");  
				  }
				  else{
				  if (req.equals("majPointage")){				
					  int opid=new Integer(r.getParameter("opid"));
					  int pointage=new Integer(r.getParameter("pointage"));	
					  String base2=r.getParameter("baseexo2");	
					  LigneRapprochement ligne = new LigneRapprochement(opid,pointage);
					  if (base2.equals("")){
						  ligne.updatePointage(con, base);
					  }
					  //update du pointage d'une opration de l'exercice prcdent
					  else{
						  ligne.updatePointage(con, base2);
					  }
					
					  r.addParameter("status", "1");					  
				  }
				  if (req.equals("majPointageSRB")){	
					 //update du pointage des opSaisies(Ligne_RB)						  
				  	  int ligRBId=new Integer(r.getParameter("ligRBId"));
				  	  int pointage=new Integer(r.getParameter("pointage"));	
				      String base2=r.getParameter("baseexo2");	
				      if (base2.equals("")){
				    	  OpSaisie op=new OpSaisie(con, basedossier);
				    	  op.setLigRBId(ligRBId);
						  op.setPointage(pointage);
						  op.updatePointage(con);
				      } 					  
					  r.addParameter("status", "1");						  
					  }
				  
				  if (req.equals("PointageTot")){				
					  // pointage ou depointage de toutes les operations
					  int valuePointage=new Integer(r.getParameter("valuePointage"));
					  int rapproid=new Integer(r.getParameter("rapproid"));
						  String base2=r.getParameter("baseexo2");
						  Rapprochement rappro=new Rapprochement(rapproid,con,base,basedossier);
						  rappro.updatePointage(valuePointage, s, base2);					  					 
						  r.addParameter("status", "1");  
				  }
				  if (req.equals("RAZ")){
					  //suppression du rappro, des lignes de rapprochements, des pointages, des op saisies sur tous les exercices
					  String TypeRappro=r.getParameter("typerappro");
					  
					 
					  CollectionRapprochement rappros=new CollectionRapprochement(con, basedossier, base);
					  rappros.setTypeRappro(TypeRappro);
					  if (TypeRappro.equals("J")){
						  
						  String code_journal=r.getParameter("comptejournal"); 
						  rappros.setCodeJournal(code_journal);
						  System.out.println("Raz du journal  : " + code_journal  + " - " + dateCourante);
					  }
					  if (TypeRappro.equals("C")){
						  String compte=r.getParameter("comptejournal");
						  rappros.setCompte(compte);
						  System.out.println("Raz du compte  : " + compte  + " - " + dateCourante);
					  }	
					
					  rappros.supprimerRappros();
					  r.addParameter("status", "1");
					
				  }
				  if (req.equals("createCompte")){	
					  //ceation d'un rapprochement pour un compte ou un journal donn en interface
					  String compte="";
					  String journal="";
					  long daterappro=new Long(r.getParameter("daterap"));					  
					  long datereleve=new Long(r.getParameter("daterel"));
					  double soldereleve=new Double(r.getParameter("soldereleve"));
					  String numreleve=r.getParameter("numreleve");
					  String TypeRappro=r.getParameter("typerappro");
					  
					  
					  if (TypeRappro.equals("C")){
						  compte=r.getParameter("compte");
						  Rapprochement rappro=new Rapprochement(compte, daterappro, datereleve, soldereleve,con,base,basedossier);
						  if (daterappro==0){
							  //si pas de date de rappro on initilialise la date de rappro au premier jour de l'exercice 					  
							  rappro.calculDebutRappro();
							 
						  }						  
						  rappro.setNumReleve(numreleve);
						  rappro.setType_Rappro(TypeRappro);
						  int rapproid=rappro.createRappro();
						  r.addParameter("status", "1");
						  System.out.println("creation du rapprochement "+rapproid +"   pour le compte : " + compte  + " - " + dateCourante);
					  }
					  if (TypeRappro.equals("J")){
						  
						  journal=r.getParameter("journal");
						  Rapprochement rappro=new Rapprochement(daterappro, datereleve, soldereleve,con,base,basedossier, journal);
						  if (daterappro==0){
							  //si pas de date de rappro on initilialise la date de rappro au premier jour de l'exercice
							  rappro.calculDebutRappro();
						  }
						  rappro.setNumReleve(numreleve);
						  rappro.setType_Rappro(TypeRappro);						  
						  compte=rappro.getContrepartie(journal);
						
						  if (compte.equals("")){
							  r.addParameter("status", "pasdecompte");  
						  }
						  else{
							  rappro.setCompte(compte);
							  int rapproid=rappro.createRappro();
							  r.addParameter("status", "1");
							  System.out.println("creation du rapprochement "+rapproid +" pour le journal : " + journal  + " - " + dateCourante);
						  }						
					  }
					  
				  }
				
				  if (req.equals("updateRappro")){	
					  
					 //update des champs date rappro, date releve, solde releve					  
					  long daterappro=new Long(r.getParameter("daterap"));					  
					  long datereleve=new Long(r.getParameter("daterel"));
					  double soldereleve=0;
					  if (!r.getParameter("soldereleve").equals("")){
						  soldereleve=Double.parseDouble(r.getParameter("soldereleve").replace(" ", ""));  
					  }
					  					
					  String numreleve=r.getParameter("numreleve");
					  int rapproid=new Integer(r.getParameter("rapproid"));
					  
					  Rapprochement rappro=new Rapprochement(rapproid,con,base,basedossier);
					  rappro.loadRappro(rapproid);
					  rappro.setNumReleve(numreleve);
					  rappro.setDateRappro(daterappro);
					  rappro.setDateReleve(datereleve);
					  rappro.setSoldeReleve(soldereleve);
					  rappro.updateRappro();
					  r.addParameter("status", "1");					
				  }
				  if (req.equals("createOpSaisie")){							
						  String status ="0";
						  int rapproid=new Integer(r.getParameter("rapproid"));
					      long date=new Long(r.getParameter("datelong"));
						  double montantc=new Double(r.getParameter("credit"));
						  double montantd=new Double(r.getParameter("debit"));						  
						  String libelle=r.getParameter("labelrb");						  
						  OpSaisie op=new OpSaisie(rapproid, montantc, montantd, libelle,date,con, basedossier );
						  status=op.createOpSaisie();
						  r.addParameter("status", status);
					  }
				  
				  if (req.equals("DeletelgOpSaisie")){						
						  String status ="0";
					      int lignerb=new Integer(r.getParameter("lignerb"));
						  	  
						  OpSaisie op=new OpSaisie(con, basedossier );
						  op.setLigRBId(lignerb);
						
						  status=op.DeletelgOpSaisie(con);
						  r.addParameter("status", status);
					  }
				  if (req.equals("cloture")){							
					//cloture d'un rapprochement					   					  
					  long datereleve=new Long(r.getParameter("daterel"));					 				 
					  int rapproid=new Integer(r.getParameter("rapproid"));
					  String base2=r.getParameter("baseexo2");	
					  double soldeFinal=0;
					  if (!r.getParameter("soldeFinal").equals("")){
						  soldeFinal=Double.parseDouble(r.getParameter("soldeFinal").replace(" ", ""));  
					  }
					  
					  Rapprochement rappro=new Rapprochement(rapproid,con,base,basedossier);
					  rappro.loadRappro(rapproid);					  
					  rappro.setdateCloture(datereleve);
					  rappro.setSoldeFinal(soldeFinal);
					  rappro.updateRappro();
					 
					  CollectLigneRappro lignes= new  CollectLigneRappro(rapproid,con, base,basedossier) ;
					  lignes.setDateRappro(rappro.getDateRappro());
					  lignes.setdateCloture(datereleve);
					  if(rappro.getType_Rappro().equals("C")){
						  lignes.setCompte(rappro.getCompte());						  
						  lignes.CreateLignesRapproCompte(con, base);
						  if (!base2.equals("")){							
							  lignes.CreateLignesRapproCompte(con, base2);  
						  }
					  }
					  if(rappro.getType_Rappro().equals("J")){
						  lignes.setCode_journal(rappro.getCodeJournal());						
						  lignes.CreateLignesRapproJournaux(con, base);
						  if (!base2.equals("")){
							  lignes.CreateLignesRapproJournaux(con, base2);  
						  }
					  }
					  //creation du rapprochement suivant					 				  
					  rappro.setDateRappro(rappro.getdateCloture()+(1000 * 60 * 60 * 24 ));
					  rappro.setDateReleve(0);
					  rappro.setSoldeReleve(0);
					  int rapproidcloture= 0;
					  rapproidcloture=rappro.getRapproId();
					  rappro.createRappro();
    				  //inserton des operations saisies non pointes dans le nouveau rappro
    				  OpSaisie oprb=new OpSaisie(con, basedossier);
    				  	//rapproid du rapprochement cr
    				  oprb.setRapproId(rappro.getRapproId());
   					  oprb.insertOpSaisieNonPointee(rapproidcloture);    				
					  r.addParameter("status", "1");
					  System.out.println("cloture du rapprochement  " + rapproid  + " - " + dateCourante);
				  }
				  if (req.equals("supRappro")){	
					  //suppression d'un historique de rappro
					  int rapproid=new Integer(r.getParameter("rapproid"));						
					  Rapprochement rappro=new Rapprochement(rapproid,con,base,basedossier);
					  rappro.loadRappro(rapproid);					  
					  rappro.supprimerHistoRappro();
				      r.addParameter("status", "1");
				      System.out.println("suppression du rapprochement  " + rapproid  + " - " + dateCourante);
				  
				  }
				 }
			  }
				  
				  
			  catch (Exception e) {		        	

					 r.addParameter("status", "fail");
					 e.printStackTrace();
					
			 }
			  finally {					
				    
					  s.closeConnection(con,null);
			 }
			 return true;
		} 
				  
	}

