package org.opensi.compta.actions.rapprochementBancaire;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.Arrondi;

public class Rapprochement implements ManageRapprochement{
		
	private long dateRappro;//date dbut
	private long dateReleve;//date fin
	private long dateCloture;//date clture
	private String numReleve="";
	private String typeRappro="";
	private double soldeReleve=0;
	private double SoldeINI=0;
	private double soldeFinal=0;
	private int rapproId=0;
	private String codeJournal;	
	private Connection con;
	private String base;
	private String baseDossier;
	private String compte;
	private int nbreop;
	private int nbreopsaisie;
	private double solde;
	private double soldenonppointe;
	private double soldeRBnonppointe;
	private double soldeopsaisie;
	private double totcredit;
	private double totdebit;
	private double totcreditOp;
	private double totdebitOp;
	private String listop="";
	private String listopsaisie="";		
	private ArrayList <LigneRapprochement> Lignes = new ArrayList<LigneRapprochement>();

	public Rapprochement(long daterappro, long datereleve, double soldereleve,Connection con, String base, String baseDossier, String codeJournal) {
		this.con=con;
		this.base=base;
		this.baseDossier=baseDossier;
		this.codeJournal=codeJournal;
		this.dateRappro = daterappro;
		this.dateReleve = datereleve;
		this.soldeReleve=soldereleve;
	}
	public Rapprochement(String compte, long daterappro, long datereleve, double soldereleve,Connection con, String base,String baseDossier ) {
		this.compte = compte;
		this.dateRappro = daterappro;
		this.dateReleve = datereleve;
		this.codeJournal=null;
		this.con=con;
		this.base=base;
		this.baseDossier=baseDossier;
		this.soldeReleve=soldereleve;
	}
	public Rapprochement(int rapproId,Connection con, String base,String baseDossier) {
		this.rapproId = rapproId;
		this.con=con;
		this.base=base;
		this.baseDossier=baseDossier;
	}
	
	public long getdateCloture() {
		return dateCloture;
	}
	public void setdateCloture(long dateCloture) {
		this.dateCloture = dateCloture;
	}
	public long getDateRappro() {
		return dateRappro;
	}
	public void setDateRappro(long dateRappro) {
		this.dateRappro = dateRappro;
	}	
	public int getRapproId() {
		return rapproId;
	}
	public void setRapproId(int rapproId) {
		this.rapproId = rapproId;
	}
	public String getBase() {
		return base;
	}
	public void setBase(String base) {
		this.base = base;
	}
	public String getNumReleve() {
		return numReleve;
	}
	public void setNumReleve(String numReleve) {
		this.numReleve = numReleve;
	}
	public long getDateReleve() {
		return dateReleve;
	}
	public void setDateReleve(long dateReleve) {
		this.dateReleve = dateReleve;
	}
	public double getSoldeReleve() {
		return soldeReleve;
	}
	public void setSoldeReleve(double soldeReleve) {
		this.soldeReleve = soldeReleve;
	}
	public int getNbreop() {
		return nbreop;
	}
	public void setNbreop(int nbreop) {
		this.nbreop = nbreop;
	}
	public int getNbreopsaisie() {
		return nbreopsaisie;
	}
	public void setNbreopsaisie(int nbreopsaisie) {
		this.nbreopsaisie = nbreopsaisie;
	}
	public double getSolde() {
		return solde;
	}
	public void setSolde(double solde) {
		this.solde = solde;
	}
	public double getTotcredit() {
		return totcredit;
	}
	public void setTotcredit(double totcredit) {
		this.totcredit = totcredit;
	}
	public double getTotdebit() {
		return totdebit;
	}
	public void setTotdebit(double totdebit) {
		this.totdebit = totdebit;
	}
	public String getlistopsaisie() {
		return listopsaisie;
	}
	public void setlistopsaisie(String listopsaisie) {
		this.listopsaisie = listopsaisie;
	}
	public void setListop(String listop) {
		this.listop = listop;
	}
	public String getLisop() {
		return listop;
	}
	public double getSoldenonppointe() {
		return soldenonppointe;
	}
	public void setSoldenonppointe(double soldenonppointe) {
		this.soldenonppointe = soldenonppointe;
	}
	public String getType_Rappro() {
		return typeRappro;
	}
	public void setType_Rappro(String type_Rappro) {
		typeRappro = type_Rappro;
	}
	public String getCodeJournal() {
		return codeJournal;
	}
	public void setCodeJournal(String codeJournal) {
		this.codeJournal = codeJournal;
	}
	public double getSoldeINI() {
		return SoldeINI;
	}
	public void setSoldeINI(double soldeINI) {
		SoldeINI = soldeINI;
	}
	public double getSoldeFinal() {
		return soldeFinal;
	}
	public void setSoldeFinal(double soldeFinal) {
		this.soldeFinal = soldeFinal;
	}
	public double getSoldeopsaisie() {
		return soldeopsaisie;
	}
	public void setSoldeopsaisie(double soldeopsaisie) {
		this.soldeopsaisie = soldeopsaisie;
	}
	public double getSoldeRBnonppointe() {
		return soldeRBnonppointe;
	}
	public void setSoldeRBnonppointe(double soldeRBnonppointe) {
		this.soldeRBnonppointe = soldeRBnonppointe;
	}
	public double getTotcreditOp() {
		return totcreditOp;
	}
	public void setTotcreditOp(double totcreditOp) {
		this.totcreditOp = totcreditOp;
	}
	public double getTotdebitOp() {
		return totdebitOp;
	}
	public void setTotdebitOp(double totdebitOp) {
		this.totdebitOp = totdebitOp;
	}
	public String getListop() {	
		CollectLigneRappro list =new CollectLigneRappro(rapproId,con, base, baseDossier);
		list.setdateCloture(dateCloture);		
		String listop="";	
		list.setDateRappro(dateRappro);		
		list.setDateReleve(dateReleve);	
		ArrayList<String> result = null;
		if (typeRappro.equals("C")){
			list.setCompte(compte);
			result=list.getlisteOpcompte();
		}
		if (typeRappro.equals("J")){			
			list.setCode_journal(codeJournal);		
			result=list.getlisteOpjournaux();			
		}	
		int j=0;
		if(result!= null){
			listop=result.toString();			
			j=result.size();
		}
		
		listop=listop.replaceAll("\\[","");
		listop=listop.replaceAll("\\]","");		
		setNbreop(j);
		setListop(listop);
		return listop;
 	
	}
	
	public String getListopsaisie() {
		
		OpSaisie oprb=new OpSaisie(con, baseDossier);
		oprb.setRapproId(rapproId);
		oprb.listeOpSaisie();
		ArrayList<String> result=oprb.getlistoprb();		
		String List="";
		List=result.toString();
		List=List.replaceAll("\\[","");
		List=List.replaceAll("\\]","");
		int j=0;
		j=result.size();		
		setlistopsaisie(List);
		setNbreopsaisie(j);
		return List;
	}
	public void calculSoldesop() {
		
	//soldes des operations + total debit et total credit
		CollectLigneRappro opsoldes =new CollectLigneRappro(rapproId,con, base, baseDossier);
		opsoldes.setType_Rappro(typeRappro);
		String compteAN="";
		if (typeRappro.equals("C")){
			compteAN=compte;		
			opsoldes.setCompte(compte);
			opsoldes.setDateReleve(dateReleve);
		}
		if (typeRappro.equals("J")){
			compteAN=getContrepartie(codeJournal);
			opsoldes.setCode_journal(codeJournal);
			opsoldes.setDateReleve(dateReleve);				
		}
		opsoldes.calculSoldesOp(getListop());				
	// soldes de l'anouveau pour le compte ou le compte de contrepartie(cas du mode journal)
		opsoldes.calculSoldeAN(compteAN);				
	// soldes des oprations saisies
		OpSaisie opsaisie=new OpSaisie(con, baseDossier);
		opsaisie.calculSoldesOpSaisie(getlistopsaisie());			
		setSoldeopsaisie(opsaisie.getSolde());
		
	//calcul du solde des oprations non pointes
		Arrondi arrondi=new Arrondi(2);
		double soldenonmpointee=0;
		soldenonmpointee=opsoldes.getSoldenonppointe()+opsaisie.getSoldenonppointe();
		soldenonmpointee=arrondi.round(soldenonmpointee);
		setSoldenonppointe(soldenonmpointee);	
	//calcul du solde des oprations non pointes de operations saisies		
		double soldeRBnonmpointee=0;
		soldeRBnonmpointee=opsaisie.getSoldenonppointe();
		soldeRBnonmpointee=arrondi.round(soldeRBnonmpointee);
		setSoldeRBnonppointe(soldeRBnonmpointee);
	//calcul du solde comptable		
		double soldecomptable=0;
				
		soldecomptable=opsoldes.getSolde()+opsoldes.getSoldeAN();
				
		soldecomptable=arrondi.round(soldecomptable);
		setSolde(soldecomptable);
	//calcul du solde initial de banque
		double soldeinitial=0;				
		if (spremierRappro()){					
			if (sDebutExercice()){
				soldeinitial=arrondi.round(opsoldes.getSoldeAN()+opsaisie.getSolde());
			}
			else{							
				soldeinitial=arrondi.round(opsoldes.getsoldesOpInitial(dateRappro) + opsoldes.getSoldeAN());							
			}			
		}
		else{
			soldeinitial=arrondi.round(getsoldeRelevePrecedent());						
		}				
		setSoldeINI(soldeinitial);
	//  calcul du solde final de banque
		double soldefinal=0;
		
		if (typeRappro.equals("C")){
			soldefinal=(opsoldes.getSolde() + opsaisie.getSolde() +opsoldes.getSoldeAN())-soldenonmpointee;		
		}
		if (typeRappro.equals("J")){
			soldefinal=(opsoldes.getSolde() + opsaisie.getSolde() +soldenonmpointee);
		}
		
		soldefinal=arrondi.round(soldefinal);
		setSoldeFinal(soldefinal);		
		
		
	//	calcul total credit et debit des operations + operations saisies
		setTotcredit(arrondi.round(opsoldes.getTotcredit()+ opsaisie.getTotcredit()));
		setTotdebit(arrondi.round(opsoldes.getTotdebit()+opsaisie.getTotdebit()));	
	//	calcul total credit et debit des operations + operations saisies
		setTotcreditOp(arrondi.round(opsoldes.getTotcredit()));
		setTotdebitOp(arrondi.round(opsoldes.getTotdebit()));
	}

	public int createRappro() {		
		 try {

     	 PreparedStatement pstmt = con.prepareStatement("insert into "+ baseDossier +".RAPPROCHEMENT (Num_Releve,Date_Releve,Solde_Releve,Type_Rappro,Code_Journal,Numero_Compte,Date_Rappro) values (?,?,?,?,?,?,?)", PreparedStatement.RETURN_GENERATED_KEYS); 
    	 pstmt.setString(1, numReleve); 
    	 pstmt.setLong(2, dateReleve);   	
    	 pstmt.setDouble(3, soldeReleve);
    	 pstmt.setString(4, typeRappro);
    	 pstmt.setString(5, codeJournal);
    	 pstmt.setString(6, compte);
    	 pstmt.setLong(7, dateRappro);
    	 pstmt.executeUpdate();
    	 ResultSet rsId = pstmt.getGeneratedKeys();
    	 if(rsId.next())
    	 {
    		 rapproId = rsId.getInt(1);
    	 }   	
    	 rsId.close();
    	
		 }
		 
		 catch (SQLException sqle) {		    
		    	sqle.printStackTrace();
		 }
		 return rapproId;
	}
	
	
	public void updateRappro() {		
		 try {
		
	    	 PreparedStatement pstmt = con.prepareStatement("update "+ baseDossier +".RAPPROCHEMENT set Num_Releve=?, Date_Releve=?,Solde_Releve=?,Type_Rappro=?,Code_Journal=?,Numero_Compte=?, Date_Rappro=?, Date_Cloture=?, Solde_Final=? where Rappro_Id=?");      	 
	    	 pstmt.setString(1, numReleve);   	 
	   	     pstmt.setLong(2, dateReleve);  	
		   	 pstmt.setDouble(3, soldeReleve);
		   	 pstmt.setString(4, typeRappro);
		   	 pstmt.setString(5, codeJournal);
		   	 pstmt.setString(6, compte);
		   	 pstmt.setLong(7, dateRappro);	   	
		   	 pstmt.setLong(8, dateCloture);	
		   	 pstmt.setDouble(9, soldeFinal);	
		   	 pstmt.setLong(10, rapproId);
	   	     pstmt.executeUpdate();   
		 }		 
		 catch (SQLException sqle) {
		    	
		    	sqle.printStackTrace();
		 }       
	}


	public int getrapproidencours(){	
		 PreparedStatement pstmt = null;
		 int idprecedent=0;
		 try {
			if (typeRappro.equals("C")) {
					
				pstmt = con.prepareStatement("select Max(Rappro_Id) as dr from "+ baseDossier +".RAPPROCHEMENT where Numero_Compte=?");
				pstmt.setString(1, compte);   
			}		
			else {
				pstmt = con.prepareStatement("select Max(Rappro_Id) as dr from "+ baseDossier +".RAPPROCHEMENT where Code_Journal=?");
				pstmt.setString(1, codeJournal); 
			}	
		    ResultSet rs2 = pstmt.executeQuery();
			if (rs2.next()){
			   	idprecedent=rs2.getInt(1); 
			}	 
		 }
	  

		catch (SQLException sqle) {
		   	sqle.printStackTrace();
	    }
	return idprecedent;
	}
	
	
	public boolean isCloture(){	
		 boolean cloture=false;
		 try {
			
				PreparedStatement pstmt = con.prepareStatement("select Date_Cloture from "+ baseDossier +".RAPPROCHEMENT where Rappro_Id=?");
				pstmt.setLong(1, rapproId);  
				ResultSet rs = pstmt.executeQuery();
				long datecloture=0;
					if (rs.next()){
						
						datecloture=rs.getLong(1); 
					
						if (datecloture!=0){
							
							cloture=true;
					
						}
					}	
			}		
			 		
		catch (SQLException sqle) {
		   	sqle.printStackTrace();
	    }
	
	return cloture;
	
	}
	
	
	public void supprimerHistoRappro() {
		 try {	
		 		 
			 //on supprime les lignes du rapprochement
			 long daterapproasup = dateRappro;
			 CollectLigneRappro lignes = new CollectLigneRappro(rapproId,con,base, baseDossier);
		   	 lignes.DeleteLignesRappro(con, base);		 
		   	 OpSaisie opsaisie=new OpSaisie(con,baseDossier);
		   	 opsaisie.setRapproId(rapproId);
		   	 opsaisie.DeleteOpSaisie(con);
		   	 //on supprime le rapprochement
	     PreparedStatement pstmt = con.prepareStatement("delete from "+ baseDossier +".RAPPROCHEMENT where Rappro_Id=?");   
	     pstmt.setLong(1, rapproId);			   
		   pstmt.executeUpdate();			
			 // on chgt date du rappro en cours 					 
			 int rapproencours=getrapproidencours();
			 loadRappro(rapproencours);
			 setDateRappro(daterapproasup);
			 updateRappro();	
			 
		}		 
		catch (SQLException sqle) {		    
			sqle.printStackTrace();
		}		
	}
	
	
	public void supprimerRappro() {
		try {			 
			 //on supprime les lignes du rapprochement
			
			CollectLigneRappro lignes =new CollectLigneRappro(rapproId,con,base, baseDossier);
			lignes.DeleteLignesRappro(con, base);		 
			OpSaisie opsaisie=new OpSaisie(con,baseDossier);
			opsaisie.setRapproId(rapproId);
			opsaisie.DeleteOpSaisie(con);
			//on supprime le rapprochement

			PreparedStatement pstmt = con.prepareStatement("delete from "+ baseDossier +".RAPPROCHEMENT where Rappro_Id=?");   
			pstmt.setLong(1, rapproId);			   
			pstmt.executeUpdate();
			
		} 
		catch (SQLException sqle) {		    
			sqle.printStackTrace();
		}		
	}
	
	public void loadRappro(int Rappro_Id) {			
		try {			
		
			PreparedStatement pstmt = con.prepareStatement("select * from "+ baseDossier +".RAPPROCHEMENT where Rappro_Id=?");	       
			pstmt.setInt(1, Rappro_Id);
			       
			ResultSet rs = pstmt.executeQuery();
			if (rs.next()) {
				this.rapproId=Rappro_Id;
				this.numReleve = rs.getString("Num_Releve");
				this.dateRappro = rs.getLong("Date_Rappro");
				this.dateReleve = rs.getLong("Date_Releve");
				this.soldeReleve = rs.getDouble("Solde_Releve");
				this.dateCloture = rs.getLong("Date_Cloture");
				this.typeRappro=rs.getString("Type_Rappro");      
				this.codeJournal=rs.getString("Code_Journal");
				this.compte = rs.getString("Numero_Compte");
				this.soldeFinal = rs.getDouble("Solde_Final");
			}

			rs.close();
		}
		catch (SQLException sqle) {	    	
			sqle.printStackTrace();
		}			
	}

	
	public void updatePointage(int pointage,Session s, String base2) {       
		try {
			
			String listop=s.getCookie().get("op");
			String listopsaisies=s.getCookie().get("oprb");
			 
			PreparedStatement pstmt = con.prepareStatement("update "+ base +".OPERATION set Pointage=? where Op_Id in ("+listop+")");	        
			pstmt.setInt(1, pointage);  
			pstmt.executeUpdate();

			PreparedStatement pstmt2 = con.prepareStatement("update "+ baseDossier +".LIGNE_RB set Pointage=? where Ligne_RB_Id in ("+listopsaisies+")");    
			pstmt2.setInt(1, pointage);  
			pstmt2.executeUpdate();
	    
			if(!base2.equals("")){
	    	String listop2=s.getCookie().get("op2");				
				pstmt = con.prepareStatement("update " + base2 +".OPERATION set Pointage=? where Op_Id in ("+listop2+")");	        
		    pstmt.setInt(1, pointage);  
		    pstmt.executeUpdate();
	    }
		
		}
		catch (SQLException sqle) {		    	
			sqle.printStackTrace();
		}	        
	}
	
	
	public String getContrepartie(String codejournal) {
		String compte="";
		try {

			PreparedStatement pstmt = con.prepareStatement("select Contrepartie from "+ baseDossier +".JOURNAL where Code_Journal=?");			
			pstmt.setString(1, codejournal);       
			ResultSet rs = pstmt.executeQuery();
			if (rs.next()) {
				compte = rs.getString(1);
			}	
		}
		catch (SQLException sqle) {
			sqle.printStackTrace();			
		}
		return compte;
	}


	public void calculPremierRappro() {
		try {
			//on regarde s'il existe un rapprochement pour ce compte/journal

			PreparedStatement pstmt = null;

			if (typeRappro.equals("C")) {					
				pstmt = con.prepareStatement("select Rappro_Id from "+ baseDossier +".RAPPROCHEMENT where Compte=?");					
				pstmt.setString(1, compte);    
			}
			else {					
				pstmt = con.prepareStatement("select Rappro_Id from "+ baseDossier +".RAPPROCHEMENT where Code_Journal=?");					
				pstmt.setString(1, codeJournal); 
			}

			ResultSet rs = pstmt.executeQuery();

			if (!rs.next()) {				
				// on initialise la date de rapprochement  la date de dbut de l'exercice (cas d'un premier rapprochement)
				calculDebutRappro();
			}
		}
		catch (SQLException sqle) {
			 sqle.printStackTrace();			
		}			
	}
	
	
	public void calculDebutRappro() {	
		try {
			
			PreparedStatement pstmt = con.prepareStatement("select Debut_Exercice from "+ baseDossier +".EXERCICE where Nom_Base=?");	
			pstmt.setString(1, base); 
			ResultSet rs2 = pstmt.executeQuery();
			if (rs2.next()) {
				dateRappro = rs2.getLong(1);
			}
		}
		catch (SQLException sqle) {
			 sqle.printStackTrace();
		}			
	}
	
	
	public boolean sDebutExercice() {		
		
		boolean debutexo=false;
		 try{
				PreparedStatement pstmt = con.prepareStatement("select Debut_Exercice from "+ baseDossier +".EXERCICE where Nom_Base=?");	
				pstmt.setString(1, base); 
				ResultSet rs2 = pstmt.executeQuery();
				long datedebutexercice=0;
				
				if (rs2.next()) {
					datedebutexercice=rs2.getLong(1);
				}		
				if (dateRappro==datedebutexercice){
					debutexo=true;
				}
				else{
					debutexo=false;
				}
					
			}
			catch (SQLException sqle) {
				 sqle.printStackTrace();
				
			}
		return debutexo;	
	}
	
	public String sEncoursSurDeuxExo(Session s) {		
	
		String deuximebase="";
		 try{
				
				// si la date de rappro est infrieure  la date de dbut de l'exercice
				long datedebutexo=new Long(s.getCookie().get("Debut_Exercice"));

				if (dateRappro < datedebutexo){
//					on vrifie qu'il existe un exercice precedent				
					 
						PreparedStatement pstmt = con.prepareStatement("select Nom_Base from "+ baseDossier +".EXERCICE where Num_Exercice = (select (Num_Exercice - 1) from "+ baseDossier +".EXERCICE where Nom_Base=?)");							
						pstmt.setString(1, base); 
						ResultSet rs = pstmt.executeQuery();
						if (rs.next()) {
							deuximebase=rs.getString(1);
						}	
				}
				else{					
					//rapproid precedent					
					  
					     PreparedStatement pstmt2 = con.prepareStatement("select max(Rappro_Id) as dr from "+ baseDossier +".RAPPROCHEMENT where Numero_Compte=? and Rappro_Id <> ?");
					     pstmt2.setString(1, compte);   
					     pstmt2.setLong(2, rapproId);
					     ResultSet rs2 = pstmt2.executeQuery(); 
					     if (rs2.next()){
							//on vrifie s'il ya plusieurs nom de base dans ligne de rapprochement pour recuperer les opid non pointes du rapprochement precedent
							
								PreparedStatement pstmt = con.prepareStatement("select Nom_Base from "+ baseDossier +".LIGNE_RAPPROCHEMENT where Rappro_Id=? and Nom_Base <> ?");							
								pstmt.setLong(1, rs2.getLong(1));
								pstmt.setString(2, base);
								ResultSet rs = pstmt.executeQuery();
								if (rs.next()) {
									deuximebase=rs.getString(1);
								}
					     }
				}
			}
			catch (SQLException sqle) {
				 sqle.printStackTrace();
				
			}
		return deuximebase;	
	}
	public String sClotureSurDeuxExo(Session s) {		
		
		String deuximebase="";
		 try{
												
					//on vrifie s'il ya plusieurs nom de base pour un rappro_id			
					 
						PreparedStatement pstmt = con.prepareStatement("select Nom_Base from "+ baseDossier +".LIGNE_RAPPROCHEMENT where Rappro_Id=? and Nom_Base<>?");							
						pstmt.setInt(1, rapproId);
						pstmt.setString(2, base);
						ResultSet rs = pstmt.executeQuery();
						if (rs.next()) {
							deuximebase=rs.getString(1);
						}		
					
				}			
	
			catch (SQLException sqle) {
				 sqle.printStackTrace();
				
			}
		return deuximebase;	
	}
	

	public boolean spremierRappro() {
		PreparedStatement pstmt = null;
		boolean premierrappro = false;
			try {			
				if (typeRappro.equals("C")) {
					
					pstmt = con.prepareStatement("select min(Date_Rappro) from "+ baseDossier +".RAPPROCHEMENT where Numero_Compte=?");				
					pstmt.setString(1, compte);   
					
				}
				else {
					
					pstmt = con.prepareStatement("select min(Date_Rappro) from "+ baseDossier +".RAPPROCHEMENT where Code_Journal=?");				
					pstmt.setString(1, codeJournal); 
				}
				ResultSet rs = pstmt.executeQuery();			
				long mindate=0;
				if (rs.next()) {				
					mindate=rs.getLong(1);
				}
				else{
					mindate=0;
				}		
				if (dateRappro==mindate){
					premierrappro=true;
				}
				else{
					premierrappro=false;
				}			
			}
			catch (SQLException sqle) {
				 sqle.printStackTrace();			
			}
		return premierrappro;
	}
	
	
	public double getsoldeRelevePrecedent() {
		PreparedStatement pstmt = null;
		PreparedStatement pstmt2 = null;
		double soldereleveprecedent=0;
		 try{
			 if (typeRappro.equals("C")) {
				 	
			        pstmt = con.prepareStatement("select max(Date_rappro) as dra from "+ baseDossier +".RAPPROCHEMENT where Numero_Compte=? and Date_Rappro < ? group by Numero_Compte");		        
			        pstmt.setString(1, compte); 
			        pstmt.setLong(2, dateRappro); 			        
	   	         	ResultSet rs2 = pstmt.executeQuery();
					if (rs2.next()) {					
						
						 pstmt2 = con.prepareStatement("select Solde_Releve from " + baseDossier +".RAPPROCHEMENT where Numero_Compte=? and Date_Rappro=?");
						 pstmt2.setString(1, compte); 
						 pstmt2.setLong(2, rs2.getLong(1));
						 ResultSet rs3 = pstmt2.executeQuery();
						 
						 if (rs3.next()) {
							 soldereleveprecedent=rs3.getDouble(1);
						 }
					}
			 }
			 else {
				 
			        pstmt = con.prepareStatement("select max(Date_rappro) from "+ baseDossier +".RAPPROCHEMENT where code_Journal=? and Date_Rappro < ? group by Code_Journal");
			        pstmt.setString(1, codeJournal); 
			        pstmt.setLong(2, dateRappro); 
			        ResultSet rs2 = pstmt.executeQuery();
					if (rs2.next()) {					
						
						 pstmt2 = con.prepareStatement("select Solde_Releve from "+ baseDossier +".RAPPROCHEMENT where Code_Journal=? and Date_Rappro=?");
						 pstmt2.setString(1, codeJournal); 
						 pstmt2.setLong(2, rs2.getLong(1));
						 ResultSet rs3 = pstmt2.executeQuery();					 
						 if (rs3.next()) {
							 soldereleveprecedent=rs3.getDouble(1);
						 }
					}
			 } 
								
		}	 
		catch (SQLException sqle) {
			 sqle.printStackTrace();			
		}
		return soldereleveprecedent;	
	}
    
	
	public void loadLigneRappro(int RapproId) {		
		try {
			
		    PreparedStatement pstmt2 = con.prepareStatement("select Ligne_Rappro_Id,Op_Id,Pointage from "+ baseDossier +".LIGNE_RAPPROCHEMENT where Rappro_Id=?");
		    pstmt2.setInt(1, RapproId);       
		    ResultSet rs2 = pstmt2.executeQuery();
		        while (rs2.next()) {       
		        	int opid=rs2.getInt(2);
		            int pointage=rs2.getInt(3);	
		        	LigneRapprochement ligne=new LigneRapprochement(opid,pointage);
		    		Lignes.add(ligne);
		        }
		      rs2.close();
		 }
		catch (SQLException sqle) {
	 
	    	sqle.printStackTrace();
	    }
	  
	}
	public String getCompte() {
		return compte;
	}
	public void setCompte(String compte) {
		this.compte = compte;
	}
	

	
}
