/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/
  
/**
 *  Cre le tableau en Ooo
 */

package org.opensi.compta.actions.suiviActivite;

import java.io.File;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.openoffice.CreateurOpenOffice;
import org.opensi.util.openoffice.OooCellule;
import org.opensi.util.openoffice.OooLigne;
import org.opensi.util.openoffice.OooStyleCellule;


public class compaRecapVersOoo extends Action 
{

	String chemin;
	String nomFichier;
	int nbMois, decalage;
		
	CreateurOpenOffice zeus;
	OooStyleCellule titreStyle, titreNombreStyle, caseStyle;
	String titre;

	String liste;
	String [] tabLib;
	String [][] tabPrevu; //[lib][mois]
	String [][] tabReal; //[lib][mois]
	int [][] tabEcart; //[lib][mois]
	String [][] tabPourcent; //[lib][mois]
	
	int []tabTotauxPrevu,  tabTotauxReal, tabTotauxEcart;
	String [] tabTotauxPourcent;
	
	
  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception 
	{
		
	
		chemin = s.getAppConfiguration().get("opensi.absdir");
	
		nomFichier=r.getParameter("fichierSxc");
		liste=r.getParameter("liste");
		nbMois=Integer.parseInt(r.getParameter("nbMois"));
		decalage=Integer.parseInt(r.getParameter("decal"));
		titre="Budget";

		separerLaListe();
		
		calculeEcarts();
		
		calculeTotaux();

		genererOoo();
		
		return true;
	
	}
	
	
	
	
	public void separerLaListe()
	{
		
		//On enlve le premier ';'
		liste=liste.substring(1);
		String[] parLib=liste.split(";");
		
		
		tabLib=new String[parLib.length];
		tabPrevu=new String[parLib.length][nbMois];
		tabReal=new String[parLib.length][nbMois];
		
		
		
		
		for( int lib=0; lib<parLib.length;lib++)
		{
			String temp=new String(parLib[lib]);
			
			String [] laLigne=temp.split("_");

			tabLib[lib]=new String(laLigne[0]);
			String prevuTemp=laLigne[1];
			String realTemp=laLigne[2];
			
			//On enlve la premire ','
			prevuTemp=prevuTemp.substring(1);
			realTemp=realTemp.substring(1);
			
			String [] tabPrevuTemp=prevuTemp.split(",");
			String [] tabRealTemp=realTemp.split(",");
			
		


			for(int mois=0; mois<nbMois;mois++)
			{
				tabPrevu[lib][mois]=tabPrevuTemp[mois];
				tabReal[lib][mois]=tabRealTemp[mois];
			}


		
		}
		
	}
	
	
	
	
	
	
	
	
	
	public void calculeEcarts()
	{
		
				int realTemp, prevuTemp;
				tabEcart=new int[tabLib.length][nbMois];
				tabPourcent=new String[tabLib.length][nbMois];
		
				for(int lib=0; lib<tabLib.length;lib++)
				{
					for(int mois=0; mois<nbMois;mois++)
					{
						realTemp=Integer.parseInt(tabReal[lib][mois]);
						prevuTemp=Integer.parseInt(tabPrevu[lib][mois]);
						tabEcart[lib][mois]=realTemp-prevuTemp;
						if(prevuTemp!=0)
						{
							tabPourcent[lib][mois]=""+(((realTemp-prevuTemp)/prevuTemp)*100)+" %";
						}
						else
						{
							tabPourcent[lib][mois]="NS";
						}
						
					}

				}
	
	}
	
	
	
	
	
	
	
	
	
	
	

	public void calculeTotaux()
	{
		int totalPrevu, totalReal;
		
		
			tabTotauxPrevu=new int [tabLib.length];
			tabTotauxReal=new int [tabLib.length];
			tabTotauxEcart=new int [tabLib.length];
			tabTotauxPourcent=new String [tabLib.length];
			
			int ecart;
			
			for(int i=0; i<tabLib.length;i++)
			{
				totalPrevu=0;
				totalReal=0;
				for (int a=0; a<nbMois;a++)
				{
					totalReal+=	Integer.parseInt(tabReal[i][a]);
					totalPrevu+=	Integer.parseInt(tabPrevu[i][a]);
				}
				
				
				tabTotauxReal[i]=totalReal;
				tabTotauxPrevu[i]=totalPrevu;
				
				
				//Et le grand ecart
				ecart=totalReal-totalPrevu;
				tabTotauxEcart[i]=ecart;
				if(totalPrevu==0)
				{
					tabTotauxPourcent[i]="NS";
				}
				else
				{
					float toto=totalReal-totalPrevu;
					toto=toto/totalPrevu;
					toto=toto*100;
					Float titi=new Float(toto);
					
				
					tabTotauxPourcent[i]=""+(titi.intValue())+" %";
				}
				
			
			}
		
	}
	
	
	/* *************** GENERATION Ooo ************************ */
	
	public void genererOoo()
	{


		zeus=new CreateurOpenOffice(chemin+"/openoffice");

		creerLesStyles();
		genererEntete();
		ecrireContenu();
		
		zeus.changerLargeurColonne(0,6.0f);
		
		File fichier=zeus.genererDocument(nomFichier);
		fichier.deleteOnExit();

		
	}
	
	
	
	/**
	* Ecris les deux lignes d'entte
	**/
	public void genererEntete()
	{
	
	
	
		OooLigne ligneEnTete=new OooLigne(zeus.getStyleLigneParDefaut());
		OooCellule truc;


		//*************** 1re ligne ******************
		//tableau de gauche:
		truc=new OooCellule(titre, titreStyle);

		truc.setFusion(1, 5);
		ligneEnTete.ajouterCellule(truc);
		
		
		for (int g=0; g<nbMois;g++)
		{
			//espacement
			truc=new OooCellule("", zeus.getStyleCelluleParDefaut());
			ligneEnTete.ajouterCellule(truc);
			
			int mois12=((g+decalage)%12)+1;
			
			
			truc=new OooCellule(leMois(mois12), titreStyle);
			truc.setFusion(1, 4);
			ligneEnTete.ajouterCellule(truc);
	
		}
		
		
		zeus.ajouterLigne(ligneEnTete);

		// ********** 2me ligne ***************
		ligneEnTete=new OooLigne(zeus.getStyleLigneParDefaut());

			truc=new OooCellule("Libell", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Prev", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Real", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Ecart", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Ecart %", titreStyle);
			ligneEnTete.ajouterCellule(truc);
		
		for (int g=0; g<nbMois;g++)
		{
			//espacement
			truc=new OooCellule("", zeus.getStyleCelluleParDefaut());
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Prev", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Real", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Ecart", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Ecart %", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			
		}
		

		zeus.ajouterLigne(ligneEnTete);
		

	}
	
	
	
	
	
	public void ecrireContenu()
	{

			OooCellule vide=new OooCellule("",zeus.getStyleCelluleParDefaut());
			OooLigne enCours;
			OooCellule enCoursAussi;
			String temp;
			int nombre;
			
			OooStyleCellule paschiffreS, ChiffreS;
			
			for (int lib=0; lib<tabLib.length;lib++)
			{
				enCours=new OooLigne(zeus.getStyleLigneParDefaut());
				
				if (styleLigneCouleur(lib))
				{
					paschiffreS=titreStyle;
					ChiffreS=titreNombreStyle;
				}
				else
				{
					paschiffreS=caseStyle;
					ChiffreS=caseStyle;
				}
				
				
				
				//Libell
				enCoursAussi=new OooCellule(tabLib[lib],paschiffreS);
				enCours.ajouterCellule(enCoursAussi);

				//Total prevu
				enCoursAussi=new OooCellule(tabTotauxPrevu[lib],ChiffreS);
				enCours.ajouterCellule(enCoursAussi);
	
				//Total ral
				enCoursAussi=new OooCellule(tabTotauxReal[lib],ChiffreS);
				enCours.ajouterCellule(enCoursAussi);

				//Total ecart
				enCoursAussi=new OooCellule(tabTotauxEcart[lib],ChiffreS);
				enCours.ajouterCellule(enCoursAussi);

				//Total ecart %
				enCoursAussi=new OooCellule(tabTotauxPourcent[lib],paschiffreS);
				enCours.ajouterCellule(enCoursAussi);

				for (int mois=0; mois<nbMois;mois++)
				{
			
					//Prevu
					enCours.ajouterCellule(vide);
					nombre=Integer.parseInt(tabPrevu[lib][mois]);
					enCoursAussi=new OooCellule(nombre,ChiffreS);
					enCours.ajouterCellule(enCoursAussi);
					

					//Realis
					nombre=Integer.parseInt(tabReal[lib][mois]);
					enCoursAussi=new OooCellule(nombre,ChiffreS);
					enCours.ajouterCellule(enCoursAussi);
					
					
					//Ecart
					nombre=tabEcart[lib][mois];
					enCoursAussi=new OooCellule(nombre,ChiffreS);
					enCours.ajouterCellule(enCoursAussi);
					
					
					//Ecart %
					temp=tabPourcent[lib][mois];
					enCoursAussi=new OooCellule(temp,paschiffreS);
					enCours.ajouterCellule(enCoursAussi);
	
				}
				zeus.ajouterLigne(enCours);	

			}
	
		
	}
	
	
	
	public void creerLesStyles()
	{
	
		titreStyle=zeus.creerNewStyleCellule();
		titreStyle.setGras(true); 
		titreStyle.setCouleurFond("#FCD9AF");
		titreStyle.setBordure(true);
		titreStyle.setAlignement(OooStyleCellule.H_CENTRE,OooStyleCellule.V_MILIEU);
		titreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		titreNombreStyle=zeus.creerNewStyleCellule();
		titreNombreStyle.setGras(true); 
		titreNombreStyle.setCouleurFond("#FCD9AF");
		titreNombreStyle.setBordure(true);
		titreNombreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		caseStyle=zeus.creerNewStyleCellule();
		caseStyle.setBordure(true);
		caseStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
	}
	
	
	//Retourne vrai si la ligne doit tre colore, faux sinon
	public boolean styleLigneCouleur(int numLigne)
	{
		return ( numLigne == 2 || numLigne == 8 ) ? true : false;
	
	}
	
	


	
	public String leMois(int lemois)
	{
		String resultat="";
		
		switch (lemois)
		{
			case 1: resultat="Janvier";break;
			case 2: resultat="Fvrier";break;
			case 3: resultat="Mars";break;
			case 4: resultat="Avril";break;
			case 5: resultat="Mai";break;
			case 6: resultat="Juin";break;
			case 7: resultat="Juillet";break;
			case 8: resultat="Aout";break;
			case 9: resultat="Septembre";break;
			case 10: resultat="Octobre";break;
			case 11: resultat="Novembre";break;
			case 12: resultat="Dcembre";break;
			default: resultat="";
		
		}
		
		return resultat;
	}


	
	
}



		
			
			










