/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.compta.actions.suiviActivite;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;


public class reqCompta {


	private HashMap<String, Compte> hashComptes;
	private long dateDebut, dateFin;
	private Connection con;
	private Session session;
	
	public static final String CHARGES_PERSONNEL="CP";
	public static final String CHARGES_FINANCIERES="CF";
	public static final String CHARGES_EXTERNES="CE";
	public static final String AMORTISSEMENTS="AM";
	public static final String IMPOTS_TAXES="IT";
	public static final String ACHATS_DIRECTS="AD";
	public static final String CHIFFRE_AFFAIRES="CA";
	
	
	// Rcupration des donnes
	Object[] tabFinal;
	Vector<String> lesBases;
	String typeCpt;
	String baseDossier;

	public reqCompta(int moisDebut, int anneeDebut, int moisFin, int anneeFin, String typeCompte, String leDossierId, String sessionId) throws Exception {

		
		typeCpt=typeCompte;
		
		hashComptes=new HashMap<String, Compte>();
		
		session = Session.findClient(sessionId);
		con = session.getConnection(null);
		
		this.baseDossier = session.getCookie().get("BaseDossier");
		//Les dates....
		DateTime transfo=new DateTime(1, moisDebut, anneeDebut);
		dateDebut=transfo.getDateInMillis();
		
		transfo=new DateTime(dernierJourDuMois(moisFin, anneeFin), moisFin, anneeFin);
		dateFin=transfo.getDateFullTime();
		
		
		//Recupration des bases sur lesquelles on va requeter
		lesBases=listeBases(leDossierId);
		
		String whereReq=whereRequete(typeCompte);
		String baseCourante;
		
		//Pour qu'il y ai un max de libells
		initHashMap();
		
		
		//variables pour le tant que
		String requete;
		Statement stt;
		ResultSet rset;
		String clef;
		Compte unCompte;
		
			
		// S'il y a d'autres bases, il ne faut ajouter les valeurs des libells identiques 
		for (int i=0; i<lesBases.size();i++) {
			
			baseCourante = lesBases.elementAt(i);
		
			requete="SELECT c.Intitule as lib, SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit, c.Numero_Compte as numero";
			requete+=" FROM "+baseDossier+".COMPTE c, "+baseCourante+".OPERATION o";
			requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND o.Date_Op>"+dateDebut+" AND o.Date_Op<"+dateFin+" AND(";
			requete+=whereReq+" ) GROUP BY c.Numero_Compte";
			
			stt = con.createStatement();
			rset = stt.executeQuery(requete);
	
			while (rset.next())	{
				//Compte(int numero, String libelle, long leCredit, long leDebit)
				unCompte=new Compte(rset.getString("numero"),rset.getString("lib"), rset.getLong("credit"), rset.getLong("debit"));
				clef=new String(rset.getString("numero"));
				
				if (hashComptes.containsKey(clef)) {
					Compte oldCompte = hashComptes.get(clef);
					unCompte.ajouterCompte(oldCompte);
				}
				
				hashComptes.put(clef,unCompte);
			}
		}
		
		session.closeConnection(con, null);		
	}



	//Initialise en mettant tous les libelles avec pour valeur 0
	//Partant sur le principe que generalement tous les libells sont donns dans l'exercice
	public void initHashMap() throws SQLException	{

		//variables pour le tant que
		String requete;
		Statement stt;
		ResultSet rset;
		String clef;
		Compte unCompte;
		String whereReq=whereRequete(typeCpt);
		String baseCourante;
		
		for (int i=0; i<lesBases.size();i++)
		{
			baseCourante=(lesBases.elementAt(i));
		
			requete="SELECT c.Intitule as lib, c.Numero_Compte as numero";
			requete+=" FROM "+baseDossier+".COMPTE c, "+baseCourante+".OPERATION o";
			requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND(";
			requete+=whereReq+" ) GROUP BY c.Numero_Compte";
			
			
			stt = con.createStatement();
			rset = stt.executeQuery(requete);
	
			while (rset.next())	{
				//Compte(int numero, String libelle, long leCredit, long leDebit)
				unCompte=new Compte(rset.getString("numero"),rset.getString("lib"),0, 0);
				clef=new String(rset.getString("numero"));
				hashComptes.put(clef,unCompte);
				
			}
		}		
	
	}

	
	public String whereRequete(String typeCompte)
	{
		conditionsComptes cond= new conditionsComptes();
		String resultat="";
		
		if(typeCompte.equalsIgnoreCase("CP"))
		{
			resultat=cond.chargesDePersonnel("c.");
		}
		else if(typeCompte.equalsIgnoreCase("CF"))
		{
			resultat=cond.chargesFinancieres("c.");
		}
		else if(typeCompte.equalsIgnoreCase("CE"))
		{
			resultat=cond.chargesExternes("c.");
		}
		else if(typeCompte.equalsIgnoreCase("AM"))
		{
			resultat=cond.amortissements("c.");
		}
		else if(typeCompte.equalsIgnoreCase("IT"))
		{
			resultat=cond.impotsEtTaxes("c.");
		}
		else if(typeCompte.equalsIgnoreCase("CA"))
		{
			resultat=cond.chiffreDAffaires("c.");
		}
		else if(typeCompte.equalsIgnoreCase("AD"))
		{
			resultat=cond.matPremiereApproConso("c.")+" AND "+cond.sousTraitDirecte("c.");
		}

		return resultat;
	
	}
	
	
	public Vector<String> listeBases(String dossierId) throws SQLException {
		
		Vector<String> resultat=new Vector<String>();

		Statement stt = con.createStatement();

		String req ="select Debut_Exercice,Fin_Exercice,Nom_Base from "+ baseDossier +".EXERCICE";
		ResultSet rset = stt.executeQuery(req);

		long debutCourant, finCourant;
		String base;
		while (rset.next()) {
			debutCourant=rset.getLong("Debut_Exercice");
			finCourant=rset.getLong("Fin_Exercice");

			if ( dateFin>debutCourant && dateDebut<finCourant)
			{//faut prendre la base;

				base=new String(rset.getString("Nom_Base"));
				resultat.addElement(base);
			}

		}
		rset.close();

		stt.close();
		
		return resultat;
	}
	
	
	
	
	/*
	* Calcule le dernier jour du mois: 
	*/
	public int dernierJourDuMois(int leMois, int lAnnee)
	{
		int result=28;
		switch (leMois)
		{
			case 1:result=31;break;
			case 2:
				if (lAnnee%4==0)
				{
					result=29;//fevrier
				}
				else
				{
					result=28;//fevrier
				}
				break;
			case 3:result=31;break;
			case 4:result=30;break;
			case 5:result=31;break;
			case 6:result=30;break;
			case 7:result=31;break;
			case 8:result=31;break;
			case 9:result=30;break;
			case 10:result=31;break;
			case 11:result=30;break;
			case 12:result=31;break;
			default: 
				//TODO: Implement 'default' statement
				break;
			
		}
	
	return result;

	}



/* ************************** */
/* ** RECUP DES DONNEES    ** */
/* ************************** */

/**
* initialise la rcupration des donnes et retourne le dernier index
**/
public int initEtGetEnum()
{
	int nb=0;
	tabFinal=hashComptes.values().toArray();
	nb+=hashComptes.size();
	
	return nb-1;
	
}


public String getLibelle(int index)
{
	String resultat="";

	Compte temp=(Compte)tabFinal[index];
	resultat=temp.getLibelle();
	
	return resultat;
}

public String getNumCompte(int index)
{
	String resultat="";

	Compte temp=(Compte)tabFinal[index];
	resultat=temp.getNumero();
	
	return resultat;
}

public long getDebit(int index)
{
	long resultat=0;

	Compte temp=(Compte)tabFinal[index];
	resultat=temp.getDebit();
	
	return resultat;
}

public long getCredit(int index)
{
	long resultat=0;

	Compte temp=(Compte)tabFinal[index];
	resultat=temp.getCredit();
	
	return resultat;
}





/**
*    CLASSE PRIVEE
**/

private class Compte
{

	String lib,num;
	long credit, debit;
	
	public Compte(String numero, String libelle, long leCredit, long leDebit)
	{
		num=numero;
		lib=libelle;
		credit=leCredit;
		debit=leDebit;
	}
	
	public String getNumero()
	{
		return num;
	}
	
	public String getLibelle()
	{
		return lib;
	}
	
	public long getCredit()
	{
		return credit;
	}
	
	public long getDebit()
	{
		return debit;
	}
	
	/*
	* Somme le dbit et le crdit des deux comptes
	* Prerequis: les numro de comptes sont identiques
	*/
	public void ajouterCompte(Compte autre)
	{
		this.credit+=autre.getCredit();
		this.debit+=autre.getDebit();
	}
}

}
