package org.opensi.compta.actions.transferts;


import java.util.ArrayList;

import org.opensi.data.exercice.Ecriture;


public class EcrituresOxf {


	ArrayList<Ecriture> ecritures = new ArrayList<Ecriture>();


	public EcrituresOxf() {}

	
	public void addEcriture(Ecriture ecriture) {
	
		ecritures.add(ecriture);
	}
	
	
	public Ecriture getEcriture(int index) {
		
		return ecritures.get(index);
	}
	
	
	public int getSize() {
	
		return ecritures.size();
	}
	
	public int getNbOp() {
		
		int nbOp = 0;
	
		for (int i=0; i<ecritures.size(); i++) {
			nbOp += getEcriture(i).getSize();
		}
		
		return nbOp;
	}
	
	public boolean isStable() {
	
		boolean stable = true;
	
		for (int i=0; i<ecritures.size() && stable; i++) {
			stable = stable && getEcriture(i).isValid();
		}
		 
		return stable;
	}
	

} // fin EcrituresOxf
