/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *   Export d'critures comptables
 */

package org.opensi.compta.actions.transferts;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.StringUtils;
import org.opensi.util.tools.DateTime;


public class ExportCompta extends Action {


	private boolean exocomplet;
	private boolean journauxcomplet;
	private long debutPeriode;
	private long finPeriode;
	private String debutExercice;
	private String finExercice;
	private String codejournal;
	private String base;
	private String baseDossier;
	private Session session;
	private int debutEcriture;
	private int finEcriture;

	private SimpleDateFormat ddmmyy = new SimpleDateFormat("ddMMyy");
	private SimpleDateFormat yyyymmdd = new SimpleDateFormat("yyyyMMdd");
	private SimpleDateFormat ddmmyyyy = new SimpleDateFormat("ddMMyyyy");
	private SimpleDateFormat mmyyyy = new SimpleDateFormat("MMyyyy");


	private DecimalFormatSymbols dfs = new DecimalFormatSymbols();


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		dfs.setDecimalSeparator('.');

		this.session = s;
		this.baseDossier = session.getCookie().get("BaseDossier");
		this.base = r.getParameter("Base");
		this.debutExercice = r.getParameter("Debut_Exercice");
		this.finExercice = r.getParameter("Fin_Exercice");
		String format = r.getParameter("Format");
		String type = r.getParameter("Type");
		String periode = r.getParameter("Periode");
		String periode2 = r.getParameter("Periode2");
		this.codejournal = r.getParameter("Journal");
		this.debutEcriture = (r.getParameter("Debut_Ecriture").equals("")?0:Integer.parseInt(r.getParameter("Debut_Ecriture")));
		this.finEcriture = (r.getParameter("Fin_Ecriture").equals("")?0:Integer.parseInt(r.getParameter("Fin_Ecriture")));

		if (codejournal.equals("0")){
			journauxcomplet=true;
		}
		else{
			journauxcomplet=false;
		}
		if (periode.equals("dd")) {
			debutPeriode = DateTime.parseDate(r.getParameter("Date_Debut"), "dd/MM/yyyy");
			finPeriode = DateTime.parseDate(r.getParameter("Date_Fin"), "dd/MM/yyyy");
			exocomplet = false;
		}
		else if (periode2.equals("pp")) {
			debutPeriode = DateTime.parseDate(r.getParameter("Debut"), "MMyy");
			finPeriode = DateTime.parseDate(r.getParameter("Fin"), "MMyy");
			exocomplet = false;
		}
		else {
			debutPeriode = Long.parseLong(debutExercice);
			finPeriode = Long.parseLong(finExercice);
			exocomplet = true;
		}

		String nomFichier = "opensi_"+ System.currentTimeMillis();

		String fichier = s.getAppConfiguration().get("opensi.absdir") +"/iobuffer/"+ nomFichier;

		FileWriter fw = new FileWriter(fichier);

		BufferedWriter bw = new BufferedWriter(fw);

		Connection con = s.getConnection(null);

		if (format.equalsIgnoreCase("CE_OPENSI_XML")) {
			makeOpensiXml(bw, con);
		}
		else if (format.equalsIgnoreCase("E_QUADRA_ASC")) {
			makeEcrQuadraAsc(bw, con);
		}
		else if (format.equalsIgnoreCase("C_QUADRA_ASC")) {
			makeCpteQuadraAsc(bw, con);
		}
		else if (format.equalsIgnoreCase("CE_QUADRA_ASC")) {
			makeCpteQuadraAsc(bw, con);
			makeEcrQuadraAsc(bw, con);
		}
		else if (format.equalsIgnoreCase("E_EBP_ASC")) {
			//makeEcrEbpAsc(bw, con);
		}
		else if (format.equalsIgnoreCase("C_EBP_ASC")) {
			//makeCpteEbpAsc(bw, con);
		}
		else if (format.equalsIgnoreCase("E_EBP_EDI")) {
			//makeEcrEbpEdi(bw, con);
		}
		else if (format.equalsIgnoreCase("E_CIEL_ASC")) {
			makeEcrCielAsc(bw, con);
		}
		else if (format.equalsIgnoreCase("E_TABLEUR_ASC")) {
			makeEcrTableur(bw, con, type);
		}
		else if (format.equalsIgnoreCase("E_SAGE_ASC")) {
			makeEcrSageAsc(bw, con);
		}
		else if (format.equalsIgnoreCase("C_CIEL_ASC")) {
			//makeCpteCielAsc(bw, con);
		}
		else if (format.equalsIgnoreCase("E_PYCPTA_XML")) {
			//makeEcrPyCptaXml(bw, con);
		}
		bw.close();

		s.closeConnection(con, null);

		r.addParameter("FichierExport", nomFichier);
		r.addParameter("ActionError", "");

		try {
			File file = new File(fichier);
			file.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier  supprimer");
			se.printStackTrace();
		}

		return true;
	}


	private void makeOpensiXml(BufferedWriter bw, Connection con) throws Exception {


		bw.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
		bw.newLine();
		bw.newLine();

		bw.write("<compta_opensi>");
		bw.newLine();
		bw.newLine();


		Statement stt = con.createStatement();


		String reqComptes = "select Numero_Compte, Intitule, Type_Compte, coalesce(Collectif, '') as Collectif from "+ baseDossier +".COMPTE order by Type_Compte, Numero_Compte";

		ResultSet rset = stt.executeQuery(reqComptes);

		while (rset.next()) {

			bw.write("<compte"
											+" numero=\""+ rset.getString("Numero_Compte") +"\""
											+" intitule=\""+ StringUtils.xmlEncode(rset.getString("Intitule")) +"\""
											+" type=\""+ rset.getString("Type_Compte") +"\""
											+" collectif=\""+ rset.getString("Collectif") +"\" />");
			bw.newLine();
		}

		bw.newLine();

		rset.close();

		String reqEcritures = "select e.Ecriture_Id, e.Code_Journal, e.Date_Ecriture from "+ base +".ECRITURE e where 1 ";

		if (!journauxcomplet) {
			reqEcritures += " and e.Code_Journal='"+ codejournal +"'";
		}
		if (!exocomplet) {
			reqEcritures += " and e.Date_Ecriture<="+ finPeriode +" and e.Date_Ecriture>="+ debutPeriode;
		}
		if (finEcriture>0) {
			reqEcritures += " and e.Numero<="+ finEcriture;
		}
		if (debutEcriture>0) {
			reqEcritures += " and e.Numero>="+ debutEcriture;
		}
		reqEcritures += "  order by Ecriture_Id";
		rset = stt.executeQuery(reqEcritures);


		String reqOp = "select Numero_Compte, Date_Op, Num_Piece, Libelle, Montant_D, Montant_C, Date_Echeance, Lettre ";
		reqOp += "from "+ base +".OPERATION where Ecriture_Id=? ";

		reqOp += " order by Montant_D";
		PreparedStatement ps = con.prepareStatement(reqOp);

		while (rset.next()) {
			ps.setInt(1, rset.getInt("Ecriture_Id"));
			ResultSet rset2 = ps.executeQuery();
			bw.write("<ecriture"
					+" periode=\""+ mmyyyy.format(new Date(rset.getLong("Date_Ecriture"))) +"\""
					+" journal=\""+ rset.getString("Code_Journal") +"\">");
					bw.newLine();
			while (rset2.next()) {



				if (rset2.getDouble("Montant_D")==0) {
					bw.write("\t<credit"
													+" date=\""+ ddmmyyyy.format(new Date(rset2.getLong("Date_Op"))) +"\""
													+" libelle=\""+ StringUtils.xmlEncode(rset2.getString("Libelle")) +"\""
													+" compte=\""+ rset2.getString("Numero_Compte") +"\""
													+" montant=\""+ intPart(rset2.getDouble("Montant_C")*100) +"\""
													+" numpiece=\""+StringUtils.xmlEncode(rset2.getString("Num_Piece")) +"\""
													+" echeance=\""+ (rset2.getLong("Date_Echeance")==0?"":ddmmyyyy.format(new Date(rset2.getLong("Date_Echeance")))) +"\""
													+" lettre=\""+ rset2.getString("Lettre") +"\" />");
				}
				else {
					bw.write("\t<debit"
													+" date=\""+ ddmmyyyy.format(new Date(rset2.getLong("Date_Op"))) +"\""
													+" libelle=\""+ StringUtils.xmlEncode(rset2.getString("Libelle")) +"\""
													+" compte=\""+ rset2.getString("Numero_Compte") +"\""
													+" montant=\""+ intPart(rset2.getDouble("Montant_D")*100) +"\""
													+" numpiece=\""+ StringUtils.xmlEncode(rset2.getString("Num_Piece")) +"\""
													+" echeance=\""+ (rset2.getLong("Date_Echeance")==0?"":ddmmyyyy.format(new Date(rset2.getLong("Date_Echeance")))) +"\""
													+" lettre=\""+ rset2.getString("Lettre") +"\" />");
				}
				bw.newLine();

			}
			bw.write("</ecriture>");
			bw.newLine();
			bw.flush();
		}

		bw.newLine();
		bw.write("</compta_opensi>");


		bw.flush();

		stt.close();
	}



	/* Export d'critures au format Ciel Ascii */

	private void makeEcrCielAsc(BufferedWriter bw, Connection con) throws Exception {

		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery("select Debut_Exercice from "+ baseDossier +".EXERCICE where Nom_Base='"+ base +"'");

		rset.next();

		long debutExercice = rset.getLong("Debut_Exercice");


		String reqEcritures = "select Type_Compte, e.Ecriture_Id, c.Numero_Compte, c.Intitule, Code_Journal, Date_Op, Num_Piece,"
													+" Date_Echeance, o.Libelle as LibelleOp, Montant_C, Montant_D"
													+" from "+ baseDossier +".COMPTE c, "+ base +".ECRITURE e, "+ base +".OPERATION o"
													+" where c.Numero_Compte=o.Numero_Compte and e.Ecriture_Id=o.Ecriture_Id";

		if (!exocomplet) {
			reqEcritures += " and e.Date_Ecriture<="+ finPeriode +" and e.Date_Ecriture>="+ debutPeriode;
		}
		if (!journauxcomplet) {
			reqEcritures += " and Code_Journal='"+ codejournal +"'";
		}
		if (finEcriture>0) {
			reqEcritures += " and e.Numero<="+ finEcriture;
		}
		if (debutEcriture>0) {
			reqEcritures += " and e.Numero>="+ debutEcriture;
		}
		reqEcritures += "  order by e.Ecriture_Id, Montant_C";
		rset = stt.executeQuery(reqEcritures);


		while (rset.next()) {

			bw.write(padLeft(Integer.toString(rset.getInt("Ecriture_Id")), 5));
			bw.write(padRight(rset.getString("Code_Journal"), 2));

			if (rset.getLong("Date_Op") < debutExercice) {
				bw.write(yyyymmdd.format(new Date(debutExercice)));
			}
			else {
				bw.write(yyyymmdd.format(new Date(rset.getLong("Date_Op"))));
			}

			bw.write(padRight("", 8)); // date echeance
			bw.write(padRight(rset.getString("Num_Piece"), 12));
			if (rset.getString("Type_Compte").equalsIgnoreCase("F")) {
				bw.write(padRight("401"+ rset.getString("Numero_Compte"), 11));
			}
			else if (rset.getString("Type_Compte").equalsIgnoreCase("C")) {
				bw.write(padRight("411"+ rset.getString("Numero_Compte"), 11));
			}
			else {
				bw.write(padRight(rset.getString("Numero_Compte"), 11));
			}

			bw.write(padRight(rset.getString("LibelleOp"), 25));
			String typeOp = rset.getDouble("Montant_D")==0?"C":"D";
			bw.write(padLeft(rset.getString("Montant_"+typeOp), 13));
			bw.write(typeOp);
			bw.write(padRight("", 12));
			bw.write(padRight("", 6));
			bw.write(padRight(rset.getString("Intitule"), 34));
			bw.write("O"); // euro

			bw.newLine();
		}

		bw.flush();

		stt.close();
	}


	private void makeEcrTableur(BufferedWriter bw, Connection con, String type) throws Exception {

		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery("select Debut_Exercice from "+ baseDossier +".EXERCICE where Nom_Base='"+ base +"'");

		rset.next();

		long debutExercice = rset.getLong("Debut_Exercice");


		String reqEcritures = "select Type_Compte, o.Lettre, e.Ecriture_Id, c.Numero_Compte, c.Intitule, Code_Journal, Date_Op, Num_Piece,"
													+" Date_Echeance, o.Libelle as LibelleOp, Montant_C, Montant_D"
													+" from "+ baseDossier +".COMPTE c, "+ base +".ECRITURE e, "+ base +".OPERATION o"
													+" where c.Numero_Compte=o.Numero_Compte and e.Ecriture_Id=o.Ecriture_Id";

		if (!type.equalsIgnoreCase("T")) {
			reqEcritures +=" and Type_Compte='"+type+"'";
		}
		if (!exocomplet) {
			reqEcritures += " and Date_Op<="+ finPeriode +" and Date_Op>="+ debutPeriode;
		}
		if (finEcriture>0) {
			reqEcritures += " and e.Numero<="+ finEcriture;
		}
		if (debutEcriture>0) {
			reqEcritures += " and e.Numero>="+ debutEcriture;
		}
		reqEcritures += " order by e.Ecriture_Id, Montant_C";

		rset = stt.executeQuery(reqEcritures);


		while (rset.next()) {

			bw.write("\""+Integer.toString(rset.getInt("Ecriture_Id"))+"\";\"");
			bw.write(rset.getString("Code_Journal")+"\";\"");
			if (rset.getLong("Date_Op") < debutExercice) {
				bw.write(yyyymmdd.format(new Date(debutExercice))+"\";\"");
			}
			else {
				bw.write(yyyymmdd.format(new Date(rset.getLong("Date_Op")))+"\";\"");
			}

			bw.write(rset.getString("Num_Piece")+"\";\"");
			bw.write(rset.getString("Numero_Compte")+"\";\"");

			bw.write(rset.getString("LibelleOp")+"\";\"");
			String typeOp = rset.getDouble("Montant_D")==0?"C":"D";
			String Montant=rset.getString("Montant_"+typeOp);
			bw.write(Montant.replace('.',',')+"\";\"");
			bw.write(typeOp+"\";\"");
			bw.write(rset.getString("Lettre")+"\";\"");
			bw.write(rset.getString("Intitule")+"\"");

			bw.newLine();
		}

		bw.flush();

		stt.close();
	}


	/* Export d'critures au format Sage Ascii */

	private void makeEcrSageAsc(BufferedWriter bw, Connection con) throws Exception {


		DecimalFormat number12point2 = new DecimalFormat("0.00");
		number12point2.setDecimalFormatSymbols(dfs);


		Statement stt = con.createStatement();

		String reqSageEcritures = "select Type_Compte,c.Contrepartie,Num_Piece,e.Ecriture_Id, o.Numero_Compte, j.Code_Journal, Date_Echeance, Date_Op, o.Libelle, Montant_D, Montant_C";
						reqSageEcritures += " from "+ base +".ECRITURE e, "+ base +".OPERATION o, "+ baseDossier +".JOURNAL j, "+ baseDossier +".COMPTE c where c.Numero_Compte=o.Numero_Compte and e.Ecriture_Id=o.Ecriture_Id and j.Code_journal=e.Code_journal";

		if (!exocomplet) {
			reqSageEcritures += " and e.Date_Ecriture<="+ finPeriode +" and e.Date_Ecriture>="+ debutPeriode;
		}
		if (!journauxcomplet) {
			reqSageEcritures += " and j.Code_Journal='"+ codejournal +"'";
		}
		if (finEcriture>0) {
			reqSageEcritures += " and e.Numero<="+ finEcriture;
		}
		if (debutEcriture>0) {
			reqSageEcritures += " and e.Numero>="+ debutEcriture;
		}
		reqSageEcritures += "  order by e.Ecriture_Id, o.Op_Id";
		ResultSet rset = stt.executeQuery(reqSageEcritures);


		int i=1;
		bw.write(base);
		bw.write('\r');
		bw.newLine();

		while (rset.next()) {

			bw.write(padRight(rset.getString("Code_Journal"), 3));
			bw.write(ddmmyy.format(new Date(rset.getLong("Date_Op"))));

			bw.write("FC");
			if (rset.getString("Type_Compte").equalsIgnoreCase("F")) {
				bw.write(padRight("40100000", 13));
				bw.write(padRight("X"+rset.getString("Numero_Compte").substring(1,rset.getString("Numero_Compte").length()),14));
			}
			else if (rset.getString("Type_Compte").equalsIgnoreCase("C")) {
				bw.write(padRight("41100000", 13));
				bw.write(padRight("X"+rset.getString("Numero_Compte").substring(1,rset.getString("Numero_Compte").length()),14));
			}
			else {
				bw.write(padRight(rset.getString("Numero_Compte"), 13));
				bw.write(padRight(" ",14));
			}
			bw.write(padRight(rset.getString("Num_Piece"),13));
			bw.write(padRight("VENTES",26));
			if (rset.getLong("Date_Echeance")>0) {
				bw.write(ddmmyy.format(new Date(rset.getLong("Date_Echeance"))));
			}
			else {
				bw.write("      "); //date echeance par defaut 000000 sinon jjmmaa
			}
			String typeOp = rset.getDouble("Montant_D")==0?"C":"D";
			bw.write(typeOp);
			bw.write(padLeft(number12point2.format((rset.getDouble("Montant_"+typeOp))),20));
			bw.write(padRight("N",2));
			bw.write(padRight((new Integer(i)).toString(),32));
			bw.write(padRight("EUR",61));
			bw.write('\r');

			bw.newLine();
			i++;
		}

		bw.flush();

		stt.close();
	}


	/* Export d'critures au format Sage Ascii EN FAIT C EST CIEL */
/*	private void makeEcrSageAsc(BufferedWriter bw, Connection con) throws Exception {


		DecimalFormat number12point2 = new DecimalFormat("0.00");
		number12point2.setDecimalFormatSymbols(dfs);


		Statement stt = con.createStatement();

		String reqSageEcritures = "select Num_Piece,e.Ecriture_Id, o.Numero_Compte, j.Code_Journal,j.Intitule,c.Libelle, Date_Echeance, Date_Op, o.Libelle, Montant_D, Montant_C";
						reqSageEcritures += " from "+ base +".ECRITURE e, "+ base +".OPERATION o, "+ baseDossier +".JOURNAL j, "+ base +".COMPTE c where c.Numero_Compte=o.Numero_Compte and e.Ecriture_Id=o.Ecriture_Id and j.Code_journal=e.Code_journal order by e.Ecriture_Id";

		ResultSet rset = stt.executeQuery(reqSageEcritures);


		while (rset.next()) {

			bw.write(padRight(rset.getString("Num_Piece"), 4));
			bw.write(padLeft(rset.getString("Code_Journal"), 3));
			bw.write(yyyymmdd.format(new Date(rset.getLong("Date_Op"))));
			if (rset.getLong("Date_Echeance")>0) {
				bw.write(yyyymmdd.format(new Date(rset.getLong("Date_Echeance"))));
			}
			else {
				bw.write("        "); //date echeance par defaut 000000 sinon jjmmaa
			}
			bw.write(padRight(rset.getString("Num_Piece"),12));
			bw.write(padRight(rset.getString("Numero_Compte"),11));
			bw.write(padRight(rset.getString("j.Intitule"),28));

			String typeOp = rset.getDouble("Montant_D")==0?"C":"D";

			bw.write(padLeft(number12point2.format((rset.getDouble("Montant_"+typeOp))),10));
			bw.write(padRight(typeOp,19));
			bw.write(padRight(rset.getString("c.Libelle"), 34));

			bw.newLine();
		}

		bw.flush();

		stt.close();
	}
*/	/* Export d'critures au format Quadra Ascii */

	private void makeEcrQuadraAsc(BufferedWriter bw, Connection con) throws Exception {


		DecimalFormat number12 = new DecimalFormat("000000000000");
		number12.setDecimalFormatSymbols(dfs);


		Statement stt = con.createStatement();

		String reqEcritures = "select Contrepartie, Numero_Compte, Code_Journal, Date_Echeance, Date_Op, Num_Piece, Libelle, Montant_D, Montant_C, Lettre";
						reqEcritures += " from "+ base +".ECRITURE e, "+ base +".OPERATION o where e.Ecriture_Id=o.Ecriture_Id";
						if (!exocomplet) {
							reqEcritures += " and e.Date_Ecriture<="+ finPeriode +" and e.Date_Ecriture>="+ debutPeriode;
						}
						if (!journauxcomplet) {
							reqEcritures += " and e.Code_Journal='"+ codejournal +"'";
						}
		if (finEcriture>0) {
			reqEcritures += " and e.Numero<="+ finEcriture;
		}
		if (debutEcriture>0) {
			reqEcritures += " and e.Numero>="+ debutEcriture;
		}
						reqEcritures += " order by e.Ecriture_Id";
		ResultSet rset = stt.executeQuery(reqEcritures);

		while (rset.next()) {

			bw.write("M");
			bw.write(rset.getString("Numero_Compte"));
			bw.write(padRight(rset.getString("Code_Journal"), 2));
			bw.write("000"); // folio par dfaut
			bw.write(ddmmyy.format(new Date(rset.getLong("Date_Op"))));
			bw.write(padRight("", 1));
			bw.write(padRight(rset.getString("Libelle"), 20));

			String typeOp = rset.getDouble("Montant_D")==0?"C":"D";

			bw.write(typeOp);
			bw.write("+");
			bw.write(number12.format(rset.getDouble("Montant_"+typeOp)*100));
			bw.write(padRight(rset.getString("Contrepartie"), 8));
			if (rset.getLong("Date_Echeance")>0) {
				bw.write(ddmmyy.format(new Date(rset.getLong("Date_Echeance"))));
			}
			else {
				bw.write("000000"); //date echeance par defaut 000000 sinon jjmmaa
			}
			bw.write(padRight(rset.getString("Lettre"), 5));
			bw.write(padRight(rset.getString("Num_Piece"), 5));
			bw.write(padRight("", 20));
			bw.write(padRight(rset.getString("Num_Piece"), 8));
			bw.write("EUR");
			bw.write(padRight(rset.getString("Code_Journal"), 2));
			bw.write(padRight("", 4));
			bw.write(padRight(rset.getString("Libelle"), 32));
			bw.write(padRight(rset.getString("Num_Piece"), 10));

			bw.newLine();
		}

		bw.flush();

		stt.close();
	}


	/* Export de comptes au format Quadra Ascii */

	private void makeCpteQuadraAsc(BufferedWriter bw, Connection con) throws Exception {


		Statement stt = con.createStatement();

		String reqComptes = "select c.Numero_Compte, c.Intitule, c.Type_Compte, s.Total_Credit, s.Total_Debit, c.Collectif from "+ baseDossier +".COMPTE c,"+ base +".SOLDE_COMPTE s where s.Numero_Compte=c.Numero_Compte";

		ResultSet rset = stt.executeQuery(reqComptes);


		while (rset.next()) {

			bw.write("C");
			bw.write(rset.getString("Numero_Compte"));
			bw.write(padRight(rset.getString("Intitule"), 30));
			bw.write(padRight("", 7));
			bw.write("+");
			bw.write("000000000000"); // dbit N
			bw.write("+");
			bw.write("000000000000"); // crdit N
			bw.write("+");
			bw.write("000000000000"); // dbit N+1
			bw.write("+");
			bw.write("000000000000"); // crdit N+1
			String typeCompte = rset.getString("Type_Compte");
			if (!typeCompte.equalsIgnoreCase("G"))
				bw.write(rset.getString("Collectif"));
			else
				bw.write(padRight("", 8));
			bw.write(padRight("", 111));
			bw.write(typeCompte);
			bw.write("N");
			bw.write(padRight("", 62));
			bw.write("0 0 0 0 N");
			bw.write(padRight("", 24));

			bw.newLine();
		}

		bw.flush();

		stt.close();
	}



	public String padRight(String str, int len) {

		if (str.length() >= len) {
			return str.substring(0, len);
		}
		else {
			StringBuffer sb = new StringBuffer(str);
			for(int i=str.length(); i<len; i++)
				sb.append(" ");

			return sb.toString();
		}
	}

	public String padLeft(String str, int len) {

		if (str.length() >= len) {
			return str.substring(0, len);
		}
		else {
			StringBuffer sb = new StringBuffer();
			for(int i=str.length(); i<len; i++)
				sb.append(" ");

			sb.append(str);

			return sb.toString();
		}
	}


	public String intPart(double d) {

		DecimalFormat df = new DecimalFormat();
		df.setGroupingUsed(false);
		df.setMaximumFractionDigits(0);
		return df.format(d);
	}


} // fin ExportCompta




