/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *   Import de donnes comptables
 */

package org.opensi.compta.actions.transferts;

import java.io.File;
import java.sql.*;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;

import org.experlog.openeas.api.Session;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.data.dossier.Compte;
import org.opensi.data.dossier.Journal;
import org.opensi.data.dossier.TrancheCollectif;
import org.opensi.bo.BO_Comptes;
import org.opensi.bo.BO_Ecritures;
import org.opensi.bo.BO_Journaux;
import org.opensi.dbm.dossier.DBM_Journal;
import org.opensi.dbm.dossier.DBM_Compte;
import org.opensi.api.SessionOSI;
import org.opensi.dbm.dossier.DBM_TrancheCollectif;



public abstract class ImportCompta {


	protected EcrituresOxf ecritures = new EcrituresOxf();
	protected Hashtable<String, Compte> comptes = new Hashtable<String, Compte>();

	protected CheckCompta cc;

	private String baseExo;
	protected String baseDossier;
	protected String fichier;
	protected Connection con;

	protected long debutExercice;
	protected long periodeDebutExercice;

	private long finExercice;

	protected String journal;

	protected ErrorLog elog = new ErrorLog();
	

	public ImportCompta(SessionOSI sosi, String baseExo, String fichierImport, String journal) {
		try {

			this.baseExo = baseExo;
			this.baseDossier = sosi.getBaseDossier();
			this.journal = journal;
			this.con = sosi.getConnection();
			this.fichier = sosi.getIODirectory() + fichierImport;

			// dates d'exercice

			Statement stt = con.createStatement();

			ResultSet rset = stt.executeQuery("select Debut_Exercice, Fin_Exercice from "+ baseDossier +".EXERCICE where Nom_Base='"+ baseExo +"'");

			rset.next();

			debutExercice = rset.getLong("Debut_Exercice");
			finExercice = rset.getLong("Fin_Exercice");

			Calendar c = Calendar.getInstance();

			c.setTimeInMillis(debutExercice);
			c.set(Calendar.DAY_OF_MONTH, 1);
			periodeDebutExercice = c.getTimeInMillis();

			rset.close();
			stt.close();

			cc = new CheckCompta(debutExercice, finExercice, periodeDebutExercice);
			cc.setErrorLog(elog);

			importer();

			checkComptesDefinis();
			checkNoMvtCF();

			System.out.println("Erreurs : "+ elog.size());
			System.out.println("Nb Ecritures : "+ ecritures.getSize());
			System.out.println("Stabilit des critures : "+ ecritures.isStable());

			if (!ecritures.isStable()) {

				elog.addError("Ecritures non quilibres");
			}
			else if (elog.getNbError()==0) {

       	elog.addInfo(ecritures.getSize() +" critures importes");
        elog.addInfo(ecritures.getNbOp() +" lignes d'critures importes");
				System.out.println("INSERTION");

				checkLettrage();

				creerComptesInexistants(sosi.getDossierId(), sosi.getEntrepriseId());

				creerJournauxInexistants();

				insertEcritures();
			}

		}
		catch(Exception e) {
			e.printStackTrace();
		}
		finally {
					
			// suppression du fichier d'import
			try {
				File file = new File(fichier);
				file.deleteOnExit();
			}
			catch(SecurityException se) {
				System.out.println("Impossible d'enregistrer le fichier  supprimer");
				se.printStackTrace();
			}
		}

	} // fin ImportCompta


	public abstract void importer() throws Exception;


	public ErrorLog getErrorLog() {

		return elog;
	}


	protected String remplace(String elem)  {
		if (elem.startsWith("\"") && (elem.endsWith("\"")) && elem.length()>1) {
			elem=elem.substring(1,elem.length());
			elem=elem.substring(0,elem.length()-1);
		}
		return elem;
	}

	protected String nombre(String elem)  {
		return elem.replace(',','.');
	}

	protected String [] splitmanuel(String elem, int nb)
	{
		int etat=1 ;
		char EC=' ' ;
		int curseur=0;
 		int marqueur=0;
		char separateur=';';
		char delimiteur='"';
		String [] spl=new String[nb];
		int k=0;

		try {
			while (curseur< elem.length())
			{
	  		EC = elem.charAt(curseur);

				switch(etat)
				{
					case 1: {

						if (EC==delimiteur){
							etat=2;
							marqueur= curseur+1;
						}
						else{
							if(EC==separateur||EC=='\n') {
								etat=5;
							}
							else
							{
								etat=4;
								marqueur= curseur;
							}

						}
					} break ;

					case 2:	{

						if (EC==delimiteur){
							etat=3;
						}
						else{
							if(EC=='\n') {
								etat=6 ;
							}
							else{
								etat=2;
							}
						}
					} break ;

					case 3:{
						if (EC==delimiteur){
							etat=2;
						}
						else{
							if(EC==separateur||EC=='\n') {
								etat=1;
								spl[k]=elem.substring(marqueur,curseur-1);
								k++;
							}
							else
							{
								etat=6;
							}
						}
					} break ;
					case 4:	{
						if(EC==separateur||EC=='\n') {
							etat=1;
							spl[k]=elem.substring(marqueur,curseur);
							k++;
						}
						else {
							etat=4;
						}
					} break ;
					case 5:{
						spl[k]="";
						k++;
						etat=1;
						curseur--;
					} break;
					default: curseur=elem.length()-1 ; break ;
				}
					curseur ++ ;
			}
		}
		catch (ArrayIndexOutOfBoundsException e) {
			return new String[1];
		}
		return ( k == nb ) ? spl : new String[1];
	}


	private Hashtable<String, Hashtable<String, ArrayList<Operation>>> getLetSet() {

		Hashtable<String, Hashtable<String, ArrayList<Operation>>> compteSet = new Hashtable<String, Hashtable<String, ArrayList<Operation>>>();

		for (int i=0; i<ecritures.getSize(); i++) {

			Ecriture ecr = ecritures.getEcriture(i);

			for (int j=0; j<ecr.getSize(); j++) {

				Operation op = ecr.getOp(j);

				String compte = op.getNumeroCompte().toLowerCase();
				String lettre = op.getLettre().toUpperCase();

				if (lettre.length() > 0) {

					if (!compteSet.containsKey(compte)) {
						compteSet.put(compte, new Hashtable<String, ArrayList<Operation>>());
					}

					Hashtable<String, ArrayList<Operation>> lettreSet = compteSet.get(compte);

					if (!lettreSet.containsKey(lettre)) {
						lettreSet.put(lettre, new ArrayList<Operation>());
					}

					ArrayList<Operation> opList = lettreSet.get(lettre);

					opList.add(op);
				}
			}
		}

		return compteSet;
	}


	private void checkLettrage() {

		Hashtable<String, Hashtable<String, ArrayList<Operation>>> compteSet = getLetSet();

		for (Enumeration<Hashtable<String, ArrayList<Operation>>> ec = compteSet.elements(); ec.hasMoreElements();) {

			Hashtable<String, ArrayList<Operation>> lettreSet = ec.nextElement();

			for (Enumeration<ArrayList<Operation>> el = lettreSet.elements() ; el.hasMoreElements();) {

				ArrayList<Operation> opList = el.nextElement();

				int credit = 0;
				int debit = 0;

				for (int i=0; i<opList.size(); i++) {
					debit += opList.get(i).getMontantD();
					credit += opList.get(i).getMontantC();
				}

				if (debit!=credit) {
					for (int i=0; i<opList.size(); i++) {
						opList.get(i).setLettre("");
					}
				}
			}
    }
	}


	private void checkComptesDefinis() {

		if (comptes.isEmpty()) {
			elog.addError("Dfinitions des comptes manquantes !");
		}
		else {

			for (int i=0; i<ecritures.getSize(); i++) {

				Ecriture ecr = ecritures.getEcriture(i);

				for (int j=0; j<ecr.getSize(); j++) {

					String compte = ecr.getOp(j).getNumeroCompte();

					if (!comptes.containsKey(compte.toLowerCase())) {
						elog.addError("Compte '"+ compte +"' non dfini");
					}
				}
			}
		}
	}


	private void checkNoMvtCF() throws SQLException {

		PreparedStatement psChkColl = con.prepareStatement("select Numero_Compte from "+ baseDossier +".COMPTE where Numero_Compte=? and Centralisateur=1");
		
		for (int i=0; i<ecritures.getSize(); i++) {

			Ecriture ecr = ecritures.getEcriture(i);

			for (int j=0; j<ecr.getSize(); j++) {

				String compte = ecr.getOp(j).getNumeroCompte();
				
				psChkColl.setString(1, compte);
				ResultSet rset = psChkColl.executeQuery();
				if (rset.next()) {
					elog.addError("Opration sur compte collectif '"+ compte +"'");
				}
			}
		}
		
		psChkColl.close();
	}


	private void insertEcritures() throws Exception {

		BO_Ecritures boEcritures = new BO_Ecritures(con, baseDossier, baseExo);

		for (int i=0; i<ecritures.getSize(); i++) {
			boEcritures.saveEcriture(ecritures.getEcriture(i));
		}
	}


	private void creerComptesInexistants(String dossierId, int entrepriseId) throws Exception {

		// Cration des comptes inexistants (mme ceux qui ne sont pas mouvements)

		BO_Comptes boComptes = new BO_Comptes(con, baseDossier, baseExo);
		DBM_Compte dbmCompte = new DBM_Compte(con, baseDossier);
		PreparedStatement psExTranche = con.prepareStatement("select 1 from "+ baseDossier +".TRANCHE_COLLECTIF where Min_Compte<=? and Max_Compte>=?");

		int nbNewComptes = 0;

		Enumeration<Compte> enumComptes = comptes.elements();

		// cration des collectifs inexistants
		while (enumComptes.hasMoreElements()) {

			String collectif = enumComptes.nextElement().getCollectif();
						
			if (collectif!=null && !dbmCompte.exist(collectif)) {

				nbNewComptes++;
				comptes.get(collectif).setCentralisateur(true);
				boComptes.saveCompte(comptes.get(collectif), dossierId, entrepriseId);				
				
				psExTranche.setString(1, collectif);
				psExTranche.setString(2, collectif);
				ResultSet rset = psExTranche.executeQuery();
				if (!rset.next()) {
				
					TrancheCollectif trancheCollectif = new TrancheCollectif();
					trancheCollectif.setMinCompte(collectif);
					trancheCollectif.setMaxCompte(collectif);
				
					DBM_TrancheCollectif dbmTrancheCollectif = new DBM_TrancheCollectif(con, baseDossier);
					dbmTrancheCollectif.insert(trancheCollectif);
				}
			}		
		}

		psExTranche.close();
		
		enumComptes = comptes.elements();

		// cration des comptes inexistants
		while (enumComptes.hasMoreElements()) {

			Compte compte = enumComptes.nextElement();
			
			if (!dbmCompte.exist(compte.getNumeroCompte())) {

				nbNewComptes++;
				boComptes.saveCompte(compte, dossierId, entrepriseId);
			}
		}	

		elog.addInfo(nbNewComptes +" nouveaux comptes crs");
	}


	private void creerJournauxInexistants() throws Exception {

		// Cration des journaux prsents dans les critures importes et non prsents dans les journaux
		
		// A OPTIMISER par un distinct sur les codes journaux  vrifier
		
		DBM_Journal dbmJournal = new DBM_Journal(con, baseDossier);
		BO_Journaux boJournaux = new BO_Journaux(con, baseDossier);

		for (int j=0; j<ecritures.getSize(); j++) {

			String codeJournal = ecritures.getEcriture(j).getCodeJournal();

			if (!dbmJournal.exist(codeJournal)) {
			
				Journal journal = new Journal();
		
				journal.setCodeJournal(codeJournal);
				journal.setIntitule(codeJournal);
				journal.setTypeJournal("OD");
				journal.setContrepartie(null);		
			
				boJournaux.saveJournal(journal);
			}
		}
	}

//  mettre dans util : dans StringUtils par exemple
	protected String completeWith0(String str) {

		String str2 = new String(str);

		int nb = 8 - str2.length();

		for (int i=0; i<nb; i++) {

			str2 += "0";
		}

		return str2;
	}


} // fin ImportCompta



