package org.opensi.compta.actions.transferts;


import java.util.Hashtable;

import org.opensi.util.tools.DateTime;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.data.dossier.Compte;


public class OxfHandler extends DefaultHandler {

	
	private Locator locator;
	private EcrituresOxf ecrituresOxf;
	private Ecriture currentEcr;
	private Hashtable<String, Compte> comptes;
	private CheckCompta cc;


	public OxfHandler(CheckCompta cc, EcrituresOxf ecrituresOxf, Hashtable<String, Compte> comptes) {
	
		super();
		this.cc = cc;
		this.ecrituresOxf = ecrituresOxf;
		this.comptes = comptes;
	}


	public void setDocumentLocator(Locator locator) {

		this.locator = locator;
	}
	

	public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws	SAXException {
		
		//System.out.println(localName +"/"+namespaceURI+"/"+ qName);
		
		int currentLine = locator.getLineNumber();
		
		cc.setLine(currentLine);
		
		
		if (localName.equals("compte")) {
			
			String type = atts.getValue("type");
			String intitule = atts.getValue("intitule");
			String numero = atts.getValue("numero");
			String collectif = atts.getValue("collectif");
			
			cc.checkIntituleCompte(intitule);
			
			if (cc.checkTypeCompte(type)) {
				cc.checkNumeroCompte(numero, type);
			}	
			
			Compte compte = new Compte();
			compte.setNumeroCompte(numero);
			compte.setIntitule(intitule);
			compte.setTypeCompte(type);
			if (collectif!=null && !collectif.isEmpty()) {
				compte.setCollectif(collectif);
			}
			
			comptes.put(numero.toLowerCase(), compte);					
		}
		else if (localName.equals("ecriture")) {
		
			String codeJournal = atts.getValue("journal");
			long dateEcriture = DateTime.parseDate(atts.getValue("periode"),"MMyyyy");			
			
			cc.checkCodeJournal(codeJournal);
			cc.checkPeriode(dateEcriture);			
			
			currentEcr = new Ecriture();
			currentEcr.setCodeJournal(codeJournal);
			currentEcr.setDateEcriture(dateEcriture);
			
			ecrituresOxf.addEcriture(currentEcr);						
		}
		else if (localName.equals("credit") || localName.equals("debit")) {
			
			long dateOp = DateTime.parseDate(atts.getValue("date"),"ddMMyyyy");			
			String libelle = atts.getValue("libelle");
			String numeroCompte = atts.getValue("compte");
			double montantD = 0;
			double montantC = 0;
			String numPiece = atts.getValue("numpiece");	
			long dateEcheance = atts.getValue("echeance").equals("")?0:DateTime.parseDate(atts.getValue("echeance"),"ddMMyyyy");
			String lettre = atts.getValue("lettre");
			
			if (localName.equals("credit")) {
				montantC = Double.parseDouble(atts.getValue("montant"))/100;
				cc.checkMontantOp(montantC);
			}
			else {
				montantD = Double.parseDouble(atts.getValue("montant"))/100;
				cc.checkMontantOp(montantD);
			}
			
			cc.checkDateOp(dateOp);
			cc.checkLibelleOp(libelle);
			cc.checkNumeroCompte(numeroCompte);
						
			Operation op = new Operation();
			op.setDateOp(dateOp);
			op.setLibelle(libelle);
			op.setNumeroCompte(numeroCompte);
			op.setMontantD(montantD);
			op.setMontantC(montantC);
			op.setNumPiece(numPiece);
			op.setDateEcheance(dateEcheance);
			op.setLettre(lettre);
			
			currentEcr.addOperation(op);			
		}
		
		
	} // fin startElement
	
	
	public void endElement(String uri, String localName, String qname) throws SAXException {}
	
	
				
} // fin OxfHandler
