/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.compta.actions.transferts;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;


public class PlanHandler extends DefaultHandler {

	private Connection con;
	private int code;
	private Locator locator;


	PlanHandler (Connection con) {
		this.con=con;
		code=0;
	}
	
	public void setDocumentLocator(Locator locator) {
		
		this.locator = locator;
	}

	public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws	SAXException {
		try {	
			if (localName.equals("classe")) {
				if (code != 0) {
					String num = atts.getValue("numero");
					if (num.length() < 1 || num.length() > 8) {
						System.out.println ("Le numro"+" ligne : "+locator.getLineNumber()+" colonne : "+locator.getColumnNumber()+" est incorrect");
					}
					else {
						try {
							int numero = Integer.parseInt(num);
							String nom = atts.getValue("nom");
							if (nom==null) {
								System.out.println ("Le nom de la balise n\u00B0 "+numero+" est manquant"+" ligne : "+locator.getLineNumber()+" colonne :"+locator.getColumnNumber());
							}
							else {	
								if (num.length()==1) {
									PreparedStatement psCpc = con.prepareStatement("insert into TITRE_CLASSE_PLAN_COMPTABLE (Code_Plan,Numero_Titre,Libelle_Titre)values(?,?,?)");
									psCpc.setInt(1,code);
									psCpc.setInt(2,numero);
									psCpc.setString(3,nom);
									psCpc.executeUpdate();
								}
								else {
									PreparedStatement psCpc = con.prepareStatement("insert into CLASSE_PLAN_COMPTABLE (Code_Plan,Numero_Classe,Libelle_Classe,Niveau,Code)values(?,?,?,?,?)");
									psCpc.setInt(1,code);
									psCpc.setInt(2,numero);
									psCpc.setString(3,nom);
									psCpc.setInt(4,num.length());
									String num2=num;
										for (int i=num.length();i<8;i++)
										{
												num2 += "0";							
										}
										int numero2=Integer.parseInt(num2);
	
									psCpc.setInt(5,numero2);
									psCpc.executeUpdate();
								}
							}
						}
						catch(NullPointerException e){	
							System.out.println ("Le numro"+" ligne : "+locator.getLineNumber()+" colonne : "+locator.getColumnNumber()+" est manquant");
						}
						catch(NumberFormatException e){	
							System.out.println ("Le numro"+" ligne : "+locator.getLineNumber()+" colonne : "+locator.getColumnNumber()+" est incorrect");
						}
					}
				}
			}
			else if (localName.equals("plan-comptable")) {
				if (code==0) {
					String libelle = atts.getValue("libelle");

					PreparedStatement psPcl = con.prepareStatement("select Code_plan from PLAN_COMPTABLE where Libelle=?");
					psPcl.setString(1,libelle);
      		ResultSet rs = psPcl.executeQuery();
					if (rs.next()) {
						System.out.println ("ce plan comptable existe dj ligne : "+locator.getLineNumber()+" colonne : "+locator.getColumnNumber());
					}
					else {				
						PreparedStatement psPc = con.prepareStatement("insert into PLAN_COMPTABLE (Libelle) values (?)");
						psPc.setString(1,libelle);
						psPc.executeUpdate();

						PreparedStatement psPcc = con.prepareStatement("select Code_plan from PLAN_COMPTABLE where Libelle=?");
						psPcc.setString(1,libelle);
      			ResultSet rsc = psPcc.executeQuery();
						rsc.next();
						code=rsc.getInt(1);
					}
				}
			}
			else {
				throw new SAXException ("erreur de balise : balise ' "+localName+" ' inconnu"+" ligne : "+locator.getLineNumber()+" colonne :"+locator.getColumnNumber());
			}
 		}
		catch(Exception e){	
			System.out.println (e);
		}		
	} // fin startElement
	
} // fin PlanHandler
