/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.dossier;

import java.util.HashMap;

import org.opensi.data.dossier.Adresse;
import org.opensi.data.dossier.Contact;


public class Avoir implements org.opensi.api.DataOSI {


	private int avoirId;
	private int numUnique;
	private long dateAvoir;
	private int numero;
	private String numEntier;
	private String commentairesFin;
	private String commentairesInt;
	private String commentairesHid;
	private String nomResp;
	private String prenomResp;
	private String clientId;
	private long dateC;
	private long dateM;
	private int utilC;
	private int utilM;
	private int utilR;
	private Adresse adresseFact;
	private Contact contactFact;
	private Adresse adresseLiv;
	private Contact contactLiv;
	private Adresse adresseEnvoi;
	private Contact contactEnvoi;
	private double remise;
	private double montantRemise;
	private double pRemiseFP;
	private double mRemiseFP;
	private double escompte;
	private double fraisPort;
	private double tauxTVAPort;
	private int codeTVAPort;
	private double totalHT;
	private double totalTVA;
	private double totalTTC;
	private boolean direct;
	private int codeTarif;
	private boolean transfere;
	private String etat;
	private double montantRestant;
	private double rembourser;
	private boolean editionTTC;
	private double tauxIndicatif;
	private boolean assujettiTVA;
	private boolean tvaLiv;
	private String numTVAIntra;
	private String regimeTVA;
	private String mentions;
	private String modeEnvoiAvoir;
	private long dateEnvoi;
	private int versCalc;
	private HashMap<Integer, LigneAvoir> lignesAvoir;

	
	public Avoir(int avoirId,
				int numUnique,
				long dateAvoir,
				int numero,
				String numEntier,
				String commentairesFin,
				String commentairesInt,
				String commentairesHid,
				String nomResp,
				String prenomResp,
				String clientId,
				long dateC,
				long dateM,
				int utilC,
				int utilM,
				int utilR,
				Adresse adresseFact,
				Contact contactFact,
				Adresse adresseLiv,
				Contact contactLiv,
				Adresse adresseEnvoi,
				Contact contactEnvoi,
				double remise,
				double montantRemise,
				double pRemiseFP,
				double mRemiseFP,
				double escompte,
				double fraisPort,
				double tauxTVAPort,
				int codeTVAPort,
				double totalHT,
				double totalTVA,
				double totalTTC,
				boolean direct,
				int codeTarif,
				boolean transfere,
				String etat,
				double montantRestant,
				double rembourser,
				boolean editionTTC,
				double tauxIndicatif,
				boolean assujettiTVA,
				boolean tvaLiv,
				String numTVAIntra,
				String regimeTVA,
				String mentions,
				String modeEnvoiAvoir,
				long dateEnvoi,
				int versCalc) {
		
		this.avoirId = avoirId;
		this.numUnique = numUnique;
		this.dateAvoir = dateAvoir;
		this.numero = numero;
		this.numEntier = numEntier;
		this.commentairesFin = commentairesFin;
		this.commentairesInt = commentairesInt;
		this.commentairesHid = commentairesHid;
		this.nomResp = nomResp;
		this.prenomResp = prenomResp;
		this.clientId = clientId;
		this.dateC = dateC;
		this.dateM = dateM;
		this.utilC = utilC;
		this.utilM = utilM;
		this.utilR = utilR;
		this.adresseFact = adresseFact;
		this.contactFact = contactFact;
		this.adresseLiv = adresseLiv;
		this.contactLiv = contactLiv;
		this.adresseEnvoi = adresseEnvoi;
		this.contactEnvoi = contactEnvoi;
		this.remise = remise;
		this.montantRemise = montantRemise;
		this.pRemiseFP = pRemiseFP;
		this.mRemiseFP = mRemiseFP;
		this.escompte = escompte;
		this.fraisPort = fraisPort;
		this.tauxTVAPort = tauxTVAPort;
		this.codeTVAPort = codeTVAPort;
		this.totalHT = totalHT;
		this.totalTVA = totalTVA;
		this.totalTTC = totalTTC;
		this.direct = direct;
		this.codeTarif = codeTarif;
		this.transfere = transfere;
		this.etat = etat;
		this.montantRestant = montantRestant;
		this.rembourser = rembourser;
		this.editionTTC = editionTTC;
		this.tauxIndicatif = tauxIndicatif;
		this.assujettiTVA = assujettiTVA;
		this.tvaLiv = tvaLiv;
		this.numTVAIntra = numTVAIntra;
		this.regimeTVA = regimeTVA;
		this.mentions = mentions;
		this.modeEnvoiAvoir = modeEnvoiAvoir;
		this.dateEnvoi = dateEnvoi;
		this.versCalc = versCalc;
		
	}
	
	
	public boolean isValid() {
	
		return true;
	}
	
	
	public void addLigne(int ligneId, LigneAvoir ligneAvoir) { this.lignesAvoir.put(ligneId, ligneAvoir); }
	
	public int getAvoirId() { return avoirId; }
	public int getNumUnique() { return numUnique; }
	public long getDateAvoir() { return dateAvoir; }
	public int getNumero() { return numero; }
	public String getNumEntier() { return numEntier; }
	public String getCommentairesFin() { return commentairesFin; }
	public String getCommentairesInt() { return commentairesInt; }
	public String getCommentairesHid() { return commentairesHid; }
	public String getNomResp() { return nomResp; }
	public String getPrenomResp() { return prenomResp; }
	public String getClientId() { return clientId; }
	public long getDateC() { return dateC; }
	public long getDateM() { return dateM; }
	public int getUtilC() { return utilC; }
	public int getUtilM() { return utilM; }
	public int getUtilR() { return utilR; }
	public Adresse getAdresseFact() { return adresseFact; }
	public Contact getContactFact() { return contactFact; }
	public Adresse getAdresseLiv() { return adresseLiv; }
	public Contact getContactLiv() { return contactLiv; }
	public Adresse getAdresseEnvoi() { return adresseEnvoi; }
	public Contact getContactEnvoi() { return contactEnvoi; }
	public double getRemise() { return remise; }
	public double getMontantRemise() { return montantRemise; }
	public double getPRemiseFP() { return pRemiseFP; }
	public double getMRemiseFP() { return mRemiseFP; }
	public double getEscompte() { return escompte; }
	public double getFraisPort() { return fraisPort; }
	public double getTauxTVAPort() { return tauxTVAPort; }
	public int getCodeTVAPort() { return codeTVAPort; }
	public double getTotalHT() { return totalHT; }
	public double getTotalTVA() { return totalTVA; }
	public double getTotalTTC() { return totalTTC; }
	public boolean getDirect() { return direct; }
	public int getCodeTarif() { return codeTarif; }
	public boolean getTransfere() { return transfere; }
	public String getEtat() { return etat; }
	public double getMontantRestant() { return montantRestant; }
	public double getRembourser() { return rembourser; }
	public boolean getEditionTTC() { return editionTTC; }
	public double getTauxIndicatif() { return tauxIndicatif; }
	public boolean getAssujettiTVA() { return assujettiTVA; }
	public boolean getTvaLiv() { return tvaLiv; }
	public String getNumTVAIntra() { return numTVAIntra; }
	public String getRegimeTVA() { return regimeTVA; }
	public String getMentions() { return mentions; }
	public String getModeEnvoiAvoir() { return modeEnvoiAvoir; }
	public long getDateEnvoi() { return dateEnvoi; }
	public int getVersCalc() { return versCalc; }
	public HashMap<Integer, LigneAvoir> getLignesAvoir() { return lignesAvoir; }
	

} // fin Avoir
