/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.dossier;

import java.util.HashMap;

import org.opensi.data.dossier.Adresse;
import org.opensi.data.dossier.Contact;


public class AvoirFournisseur implements org.opensi.api.DataOSI {


	private int avoirId;
	private long dateAvoir;
	private int numero;
	private String numEntier;
	private String commentaires;
	private boolean impCom;
	private String nomResp;
	private String prenomResp;
	private Contact contactFact;
	private Adresse adresseFact;
	private String fournisseurId;
	private long dateC;
	private long dateM;
	private int utilC;
	private int utilM;
	private int utilR;
	private double totalHT;
	private double totalTTC;
	private int codeTarif;
	private String typeAchat;
	private double montantRestant;
	private double rembourser;
	private String etat;
	private double remise;
	private double escompte;
	private double fraisPort;
	private double tauxTVAPort;
	private int codeTVAPort;
	private String mentions;
	private int versCalc;
	private HashMap<Integer, LigneAvoirFournisseur> lignesAvoirFournisseur;

	
	public AvoirFournisseur(int avoirId,
				long dateAvoir,
				int numero,
				String numEntier,
				String commentaires,
				boolean impCom,
				String nomResp,
				String prenomResp,
				Contact contactFact,
				Adresse adresseFact,
				String fournisseurId,
				long dateC,
				long dateM,
				int utilC,
				int utilM,
				int utilR,
				double totalHT,
				double totalTTC,
				int codeTarif,
				String typeAchat,
				double montantRestant,
				double rembourser,
				String etat,
				double remise,
				double escompte,
				double fraisPort,
				double tauxTVAPort,
				int codeTVAPort,
				String mentions,
				int versCalc) {
		
		this.avoirId = avoirId;
		this.dateAvoir = dateAvoir;
		this.numero = numero;
		this.numEntier = numEntier;
		this.commentaires = commentaires;
		this.impCom = impCom;
		this.nomResp = nomResp;
		this.prenomResp = prenomResp;
		this.contactFact = contactFact;
		this.adresseFact = adresseFact;
		this.fournisseurId = fournisseurId;
		this.dateC = dateC;
		this.dateM = dateM;
		this.utilC = utilC;
		this.utilM = utilM;
		this.utilR = utilR;
		this.totalHT = totalHT;
		this.totalTTC = totalTTC;
		this.codeTarif = codeTarif;
		this.typeAchat = typeAchat;
		this.montantRestant = montantRestant;
		this.rembourser = rembourser;
		this.etat = etat;
		this.remise = remise;
		this.escompte = escompte;
		this.fraisPort = fraisPort;
		this.tauxTVAPort = tauxTVAPort;
		this.codeTVAPort = codeTVAPort;
		this.mentions = mentions;
		this.versCalc = versCalc;
		
	}


	public boolean isValid() {
	
		return true;
	}
	
	
	public void addLigne(int ligneId, LigneAvoirFournisseur ligneAvoirFournisseur) { this.lignesAvoirFournisseur.put(ligneId, ligneAvoirFournisseur); }
	
	public int getAvoirId() { return avoirId; }
	public long getDateAvoir() { return dateAvoir; }
	public int getNumero() { return numero; }
	public String getNumEntier() { return numEntier; }
	public String getCommentaires() { return commentaires; }
	public boolean getImpCom() { return impCom; }
	public String getNomResp() { return nomResp; }
	public String getPrenomResp() { return prenomResp; }
	public Contact getContactFact() { return contactFact; }
	public Adresse getAdresseFact() { return adresseFact; }
	public String getFournisseurId() { return fournisseurId; }
	public long getDateC() { return dateC; }
	public long getDateM() { return dateM; }
	public int getUtilC() { return utilC; }
	public int getUtilM() { return utilM; }
	public int getUtilR() { return utilR; }
	public double getTotalHT() { return totalHT; }
	public double getTotalTTC() { return totalTTC; }
	public int getCodeTarif() { return codeTarif; }
	public String getTypeAchat() { return typeAchat; }
	public double getMontantRestant() { return montantRestant; }
	public double getRembourser() { return rembourser; }
	public String getEtat() { return etat; }
	public double getRemise() { return remise; }
	public double getEscompte() { return escompte; }
	public double getFraisPort() { return fraisPort; }
	public double getTauxTVAPort() { return tauxTVAPort; }
	public int getCodeTVAPort() { return codeTVAPort; }
	public String getMentions() { return mentions; }
	public int getVersCalc() { return versCalc; }
	public HashMap<Integer, LigneAvoirFournisseur> getLignesAvoirFournisseur() { return lignesAvoirFournisseur; }
	

} // fin AvoirFournisseur
