/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.dossier;

import java.util.HashMap;

import org.opensi.data.dossier.Adresse;
import org.opensi.data.dossier.Contact;


public class FactureFournisseur implements org.opensi.api.DataOSI {
	
	
	private int factureId;
	private long dateFacture;
	private long echeance;
	private String modeReg;
	private int numero;
	private String numEntier;
	private String commentaires;
	private boolean impCom;
	private String nomResp;
	private String prenomResp;
	private String fournisseurId;
	private Adresse adresseFact;
	private Contact contactFact;
	private long dateC;
	private long dateM;
	private int utilC;
	private int utilM;
	private int utilR;
	private double acompte;
	private double remise;
	private double escompte;
	private double fraisPort;
	private double totalHT;
	private double totalTTC;
	private boolean transferee;
	private double tauxTVAPort;
	private int codeTVAPort;
	private String typeAchat;
	private String mentions;
	private int versCalc;
	private HashMap<Integer, LigneFactureFournisseur> lignesFactureFournisseur;

	
	public FactureFournisseur(int factureId,
							long dateFacture,
							long echeance,
							String modeReg,
							int numero,
							String numEntier,
							String commentaires,
							boolean impCom,
							String nomResp,
							String prenomResp,
							String fournisseurId,
							Adresse adresseFact,
							Contact contactFact,
							long dateC,
							long dateM,
							int utilC,
							int utilM,
							int utilR,
							double acompte,
							double remise,
							double escompte,
							double fraisPort,
							double totalHT,
							double totalTTC,
							boolean transferee,
							double tauxTVAPort,
							int codeTVAPort,
							String typeAchat,
							String mentions,
							int versCalc) {
		
		this.factureId = factureId;
		this.dateFacture = dateFacture;
		this.echeance = echeance;
		this.modeReg = modeReg;
		this.numero = numero;
		this.numEntier = numEntier;
		this.commentaires = commentaires;
		this.impCom = impCom;
		this.nomResp = nomResp;
		this.prenomResp = prenomResp;
		this.fournisseurId = fournisseurId;
		this.adresseFact = adresseFact;
		this.contactFact = contactFact;
		this.dateC = dateC;
		this.dateM = dateM;
		this.utilC = utilC;
		this.utilM = utilM;
		this.utilR = utilR;
		this.acompte = acompte;
		this.remise = remise;
		this.escompte = escompte;
		this.fraisPort = fraisPort;
		this.totalHT = totalHT;
		this.totalTTC = totalTTC;
		this.transferee = transferee;
		this.tauxTVAPort = tauxTVAPort;
		this.codeTVAPort = codeTVAPort;
		this.typeAchat = typeAchat;
		this.mentions = mentions;
		this.versCalc = versCalc;		
	}
	
	
	public boolean isValid() {
	
		return true;
	}
	
	
	public void addLigne(int ligneId, LigneFactureFournisseur ligneFactureFournisseur) { this.lignesFactureFournisseur.put(ligneId, ligneFactureFournisseur); }
	
	public int getFactureId() { return factureId; }
	public long getDateFacture() { return dateFacture; }
	public long getEcheance() { return echeance; }
	public String getModeReg() { return modeReg; }
	public int getNumero() { return numero; }
	public String getNumEntier() { return numEntier; }
	public String getCommentaires() { return commentaires; }
	public boolean getImpCom() { return impCom; }
	public String getNomResp() { return nomResp; }
	public String getPrenomResp() { return prenomResp; }
	public String getFournisseurId() { return fournisseurId; }
	public Adresse getAdresseFact() { return adresseFact; }
	public Contact getContactFact() { return contactFact; }
	public long getDateC() { return dateC; }
	public long getDateM() { return dateM; }
	public int getUtilC() { return utilC; }
	public int getUtilM() { return utilM; }
	public int getUtilR() { return utilR; }
	public double getAcompte() { return acompte; }
	public double getRemise() { return remise; }
	public double getEscompte() { return escompte; }
	public double getFraisPort() { return fraisPort; }
	public double getTotalHT() { return totalHT; }
	public double getTotalTTC() { return totalTTC; }
	public boolean getTransferee() { return transferee; }
	public double getTauxTVAPort() { return tauxTVAPort; }
	public int getCodeTVAPort() { return codeTVAPort; }
	public String getTypeAchat() { return typeAchat; }
	public String getMentions() { return mentions; }
	public int getVersCalc() { return versCalc; }
	public HashMap<Integer, LigneFactureFournisseur> getLignesFactureFournisseur() { return lignesFactureFournisseur; }
	

} // fin FactureFournisseur
