/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.dossier;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.opensi.api.DBM_Object;
import org.opensi.data.dossier.Adresse;
import org.opensi.data.dossier.CommandeClient;
import org.opensi.data.dossier.CommandeClientWeb;
import org.opensi.data.dossier.Contact;
import org.opensi.data.dossier.LigneCommandeClient;


public class DBM_CommandeClient implements DBM_Object {

	private Connection con;
	private String baseDossier;


	public DBM_CommandeClient(Connection con, String baseDossier) {
		this.con = con;
		this.baseDossier = baseDossier;
	}
	
	
	public void majModifCommande(int commandeId, int utilM) throws SQLException {
		PreparedStatement psMajModif = con.prepareStatement("update "+ baseDossier +".COMMANDE_CLIENT set Date_M=?, Util_M=? where Commande_Id=?");
		psMajModif.setLong(1, System.currentTimeMillis());
		psMajModif.setInt(2, utilM);
		psMajModif.setInt(3, commandeId);
		psMajModif.executeUpdate();
		
		psMajModif.close();
	}
	

	public void save(CommandeClient commandeClient) throws SQLException {
		// A FAIRE : Client_Id n'est pas gr lors de la maj d'une commande, mais lors de la cration de commande en java,
		// penser  tenir compte qu'il puisse tre NULL
		
		if (commandeClient.isValid()) {
			PreparedStatement psUpCom = con.prepareStatement("update "+ baseDossier +".COMMANDE_CLIENT set " +
					" Util_R=?, Util_M=?, Date_M=?, Ref_Commande=?, Edition_TTC=?, Regime_TVA=?, Assujetti_TVA=?, Num_TVA_Intra=?, Code_Tarif=?, Delai=?," +
					" Mode_Reg_Id=?, Commentaires_Fin=?, Commentaires_Int=?, Mentions=?, Remise=?, Montant_Remise=?, PRemise_FP=?, MRemise_FP=?, Escompte=?, Frais_Port=?," +
					" Code_TVA_Port=?, Taux_TVA_Port=?, Mode_Expedition=?, Secteur_Activite=?, " +
					" Denomination=?, Adresse_1=?, Adresse_2=?, Adresse_3=?, Code_Postal=?, Ville=?, Code_Pays=?, Civ_Inter=?, Nom_Inter=?, Prenom_Inter=?, Tel_Inter=?, Fax_Inter=?, Email_Inter=?," +
					" Denomination_Liv=?, Adresse_1_Liv=?, Adresse_2_Liv=?, Adresse_3_Liv=?, Code_Postal_Liv=?, Ville_Liv=?, Code_Pays_Liv=?, Civ_Inter_Liv=?, Nom_Inter_Liv=?, Prenom_Inter_Liv=?, Tel_Inter_Liv=?, Fax_Inter_Liv=?, Email_Inter_Liv=?," +
					" Denomination_Envoi=?, Adresse_1_Envoi=?, Adresse_2_Envoi=?, Adresse_3_Envoi=?, Code_Postal_Envoi=?, Ville_Envoi=?, Code_Pays_Envoi=?, Civ_Inter_Envoi=?, Nom_Inter_Envoi=?, Prenom_Inter_Envoi=?, Tel_Inter_Envoi=?, Fax_Inter_Envoi=?, Email_Inter_Envoi=?, Bloque=? " +
					" where Commande_Id=?"); //64?
	
			int posparam = 1;
			psUpCom.setInt(posparam++,commandeClient.getUtilR());
			psUpCom.setInt(posparam++,commandeClient.getUtilM());
			psUpCom.setLong(posparam++,commandeClient.getDateM());
			psUpCom.setString(posparam++,commandeClient.getRefCommande());
			psUpCom.setInt(posparam++,commandeClient.getEditionTTC()?1:0);
			psUpCom.setString(posparam++,commandeClient.getRegimeTVA());
			psUpCom.setInt(posparam++,commandeClient.getAssujettiTVA()?1:0);
			psUpCom.setString(posparam++,commandeClient.getNumTVAIntra());
			psUpCom.setInt(posparam++,commandeClient.getCodeTarif());
			psUpCom.setLong(posparam++,commandeClient.getDelai());
			psUpCom.setInt(posparam++,commandeClient.getModeReglement());
			psUpCom.setString(posparam++,commandeClient.getCommentairesFin());
			psUpCom.setString(posparam++,commandeClient.getCommentairesInt());
			psUpCom.setString(posparam++,commandeClient.getMentions());
			psUpCom.setDouble(posparam++,commandeClient.getRemise());
			psUpCom.setDouble(posparam++,commandeClient.getMontantRemise());
			psUpCom.setDouble(posparam++,commandeClient.getPRemiseFP());
			psUpCom.setDouble(posparam++,commandeClient.getMRemiseFP());
			psUpCom.setDouble(posparam++,commandeClient.getEscompte());
			psUpCom.setDouble(posparam++,commandeClient.getFraisPort());
			psUpCom.setInt(posparam++,commandeClient.getCodeTVAPort());
			psUpCom.setDouble(posparam++,commandeClient.getTauxTVAPort());
			if (commandeClient.getModeExpedition()==0) {
				psUpCom.setNull(posparam++,java.sql.Types.INTEGER);
			}
			else {
				psUpCom.setInt(posparam++,commandeClient.getModeExpedition());
			}
			if (commandeClient.getSecteurActivite()==0) {
				psUpCom.setNull(posparam++,java.sql.Types.INTEGER);
			}
			else {
				psUpCom.setInt(posparam++,commandeClient.getSecteurActivite());
			}
			psUpCom.setString(posparam++,commandeClient.getAdresseFact().getDenomination());
			psUpCom.setString(posparam++,commandeClient.getAdresseFact().getAdresse1());
			psUpCom.setString(posparam++,commandeClient.getAdresseFact().getAdresse2());
			psUpCom.setString(posparam++,commandeClient.getAdresseFact().getAdresse3());
			psUpCom.setString(posparam++,commandeClient.getAdresseFact().getCodePostal());
			psUpCom.setString(posparam++,commandeClient.getAdresseFact().getVille());
			psUpCom.setString(posparam++,commandeClient.getAdresseFact().getCodePays());
			psUpCom.setInt(posparam++,commandeClient.getContactFact().getCivilite());
			psUpCom.setString(posparam++,commandeClient.getContactFact().getNom());
			psUpCom.setString(posparam++,commandeClient.getContactFact().getPrenom());
			psUpCom.setString(posparam++,commandeClient.getContactFact().getTel());
			psUpCom.setString(posparam++,commandeClient.getContactFact().getFax());
			psUpCom.setString(posparam++,commandeClient.getContactFact().getEmail());
			psUpCom.setString(posparam++,commandeClient.getAdresseLiv().getDenomination());
			psUpCom.setString(posparam++,commandeClient.getAdresseLiv().getAdresse1());
			psUpCom.setString(posparam++,commandeClient.getAdresseLiv().getAdresse2());
			psUpCom.setString(posparam++,commandeClient.getAdresseLiv().getAdresse3());
			psUpCom.setString(posparam++,commandeClient.getAdresseLiv().getCodePostal());
			psUpCom.setString(posparam++,commandeClient.getAdresseLiv().getVille());
			psUpCom.setString(posparam++,commandeClient.getAdresseLiv().getCodePays());
			psUpCom.setInt(posparam++,commandeClient.getContactLiv().getCivilite());
			psUpCom.setString(posparam++,commandeClient.getContactLiv().getNom());
			psUpCom.setString(posparam++,commandeClient.getContactLiv().getPrenom());
			psUpCom.setString(posparam++,commandeClient.getContactLiv().getTel());
			psUpCom.setString(posparam++,commandeClient.getContactLiv().getFax());
			psUpCom.setString(posparam++,commandeClient.getContactLiv().getEmail());
			psUpCom.setString(posparam++,commandeClient.getAdresseEnvoi().getDenomination());
			psUpCom.setString(posparam++,commandeClient.getAdresseEnvoi().getAdresse1());
			psUpCom.setString(posparam++,commandeClient.getAdresseEnvoi().getAdresse2());
			psUpCom.setString(posparam++,commandeClient.getAdresseEnvoi().getAdresse3());
			psUpCom.setString(posparam++,commandeClient.getAdresseEnvoi().getCodePostal());
			psUpCom.setString(posparam++,commandeClient.getAdresseEnvoi().getVille());
			psUpCom.setString(posparam++,commandeClient.getAdresseEnvoi().getCodePays());
			psUpCom.setInt(posparam++,commandeClient.getContactEnvoi().getCivilite());
			psUpCom.setString(posparam++,commandeClient.getContactEnvoi().getNom());
			psUpCom.setString(posparam++,commandeClient.getContactEnvoi().getPrenom());
			psUpCom.setString(posparam++,commandeClient.getContactEnvoi().getTel());
			psUpCom.setString(posparam++,commandeClient.getContactEnvoi().getFax());
			psUpCom.setString(posparam++,commandeClient.getContactEnvoi().getEmail());
			psUpCom.setInt(posparam++,commandeClient.getBloque()?1:0);
			psUpCom.setInt(posparam++,commandeClient.getCommandeId());
			psUpCom.executeUpdate();
			
			psUpCom.close();
		}
	}
	
	public CommandeClient load(int commandeClientId) throws SQLException {

		CommandeClient commandeClient = null;

		PreparedStatement psCom = con.prepareStatement("select *, coalesce(Client_Id,'') as ClientId from "+ baseDossier +".COMMANDE_CLIENT where Commande_Id=?");
		PreparedStatement psLigCom = con.prepareStatement("select Ligne_Id from "+ baseDossier +".LIGNE_COMMANDE_CLIENT where Commande_Id=? and Statut='V' order by Rank");

		psCom.setInt(1, commandeClientId);

		ResultSet rsC = psCom.executeQuery();

		if (rsC.next()) {

			DBM_CommandeClientWeb dbmComCliWeb = new DBM_CommandeClientWeb(con, baseDossier);
			CommandeClientWeb commandeClientWeb = dbmComCliWeb.load(commandeClientId);

			Adresse adresseFact = new Adresse (rsC.getString("Denomination"),rsC.getString("Adresse_1"),rsC.getString("Adresse_2"),rsC.getString("Adresse_3"),rsC.getString("Code_Postal"),rsC.getString("Ville"),rsC.getString("Code_Pays"));
			Contact contactFact = new Contact (rsC.getInt("Civ_Inter"),rsC.getString("Nom_Inter"),rsC.getString("Prenom_Inter"),rsC.getString("Tel_Inter"),rsC.getString("Fax_Inter"),rsC.getString("Email_Inter"));
			Adresse adresseLiv = new Adresse (rsC.getString("Denomination_Liv"),rsC.getString("Adresse_1_Liv"),rsC.getString("Adresse_2_Liv"),rsC.getString("Adresse_3_Liv"),rsC.getString("Code_Postal_Liv"),rsC.getString("Ville_Liv"),rsC.getString("Code_Pays_Liv"));
			Contact contactLiv = new Contact (rsC.getInt("Civ_Inter_Liv"),rsC.getString("Nom_Inter_Liv"),rsC.getString("Prenom_Inter_Liv"),rsC.getString("Tel_Inter_Liv"),rsC.getString("Fax_Inter_Liv"),rsC.getString("Email_Inter_Liv"));
			Adresse adresseEnvoi = new Adresse (rsC.getString("Denomination_Envoi"),rsC.getString("Adresse_1_Envoi"),rsC.getString("Adresse_2_Envoi"),rsC.getString("Adresse_3_Envoi"),rsC.getString("Code_Postal_Envoi"),rsC.getString("Ville_Envoi"),rsC.getString("Code_Pays_Envoi"));
			Contact contactEnvoi = new Contact (rsC.getInt("Civ_Inter_Envoi"),rsC.getString("Nom_Inter_Envoi"),rsC.getString("Prenom_Inter_Envoi"),rsC.getString("Tel_Inter_Envoi"),rsC.getString("Fax_Inter_Envoi"),rsC.getString("Email_Inter_Envoi"));
			

			commandeClient = new CommandeClient(
					rsC.getInt("Commande_Id"),
					rsC.getString("ClientId"),
					rsC.getInt("Util_C"),
					rsC.getInt("Util_M"),
					rsC.getInt("Util_R"),
					rsC.getLong("Date_C"),
					rsC.getLong("Date_M"),
					rsC.getString("Etat"),
					rsC.getString("Statut_Logistique"),
					rsC.getLong("Date_Commande"),
					rsC.getLong("Date_Validation"),
					rsC.getLong("Date_Annulation"),
					rsC.getString("Ref_Commande"),
					rsC.getString("Numero"),
					rsC.getBoolean("Edition_TTC"),
					rsC.getString("Regime_TVA"),
					rsC.getBoolean("Assujetti_TVA"),
					rsC.getString("Num_TVA_Intra"),
					rsC.getBoolean("Bloque"),
					rsC.getInt("Code_Tarif"),
					rsC.getLong("Delai"),
					rsC.getBoolean("Soldee"),
					rsC.getBoolean("Facturee"),
					rsC.getInt("Mode_Expedition"),
					rsC.getInt("Secteur_Activite"),
					rsC.getDouble("Taux_Indicatif"),
					rsC.getInt("Statut_Paiement"),
					rsC.getInt("Mode_Reg_Id"),
					rsC.getString("Commentaires_Fin"),
					rsC.getString("Commentaires_Int"),
					rsC.getString("Commentaires_Hid"),
					rsC.getString("Mentions"),
					rsC.getDouble("Remise"),
					rsC.getDouble("Montant_Remise"),
					rsC.getDouble("PRemise_FP"),
					rsC.getDouble("MRemise_FP"),
					rsC.getDouble("Escompte"),
					rsC.getDouble("Frais_Port"),
					rsC.getInt("Code_TVA_Port"),
					rsC.getDouble("Taux_TVA_Port"),
					rsC.getDouble("Old_Acompte"),
					rsC.getDouble("Total_HT"),
					rsC.getDouble("Total_TTC"),
					rsC.getInt("Vers_Calc"),
					adresseFact,
					contactFact,
					adresseLiv,
					contactLiv,
					adresseEnvoi,
					contactEnvoi,
					commandeClientWeb
					);

			DBM_LigneCommandeClient dbmLigComCli = new DBM_LigneCommandeClient(con, baseDossier);
			psLigCom.setInt(1, commandeClientId);
			ResultSet rsLC = psLigCom.executeQuery();

			while (rsLC.next()) {
				LigneCommandeClient lcc = dbmLigComCli.load(rsLC.getInt("Ligne_Id"));
				commandeClient.addLigne(rsLC.getInt("Ligne_Id"),lcc);
			}
			rsLC.close();
		}
		rsC.close();
		
		psLigCom.close();
		psCom.close();

		return commandeClient;
	}

} // fin DBM_CommandeClient
