/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.general;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.data.general.Dossier;


public class DBM_Dossier implements DBM_Object {

	private Connection con;
	
	
	public DBM_Dossier(Connection con) {
		
		this.con = con;		
	}


	public boolean exist(String dossierId) throws SQLException {
		
		PreparedStatement psExDossier = con.prepareStatement("select 1 from DOSSIER where Dossier_Id=?");
			
		psExDossier.setString(1, dossierId);
		ResultSet rset = psExDossier.executeQuery();
		
		boolean exist = rset.next();
		
		psExDossier.close();
		
		return exist;
	}

	
	public void save(Dossier dossier) throws SQLException {
	
		if (dossier.isValid()) {
			PreparedStatement psNewDossier = con.prepareStatement("insert into DOSSIER (Dossier_Id, Nom, Base) values (?,?,?)");
			psNewDossier.setString(1, dossier.getDossierId());
			psNewDossier.setString(2, dossier.getNom());
			psNewDossier.setString(3, dossier.getBase());
			psNewDossier.executeUpdate();
			psNewDossier.close();
		}
	}
	
	
	public String getBase(String dossierId) throws SQLException {
		
		PreparedStatement psBase = con.prepareStatement("select Base from DOSSIER where Dossier_Id=?");
		psBase.setString(1, dossierId);
		ResultSet rset = psBase.executeQuery();
		rset.next();
		String base = rset.getString(1);
		psBase.close();
		
		return base;
	}
	
} // fin DBM_Dossier
