/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;


public class GenDocNumber {

	private long debutPeriode;
	private long finPeriode;
	private long dateDoc;

	private int numeroPeriode = -1;

	private Connection con;
	private String base;

	private Session s;

	private String prefixeFacture;
	private String prefixeAvoir;


	public GenDocNumber(long dateDoc, String s_) throws Exception {

		DateTime dt = new DateTime(dateDoc);
		dt.setDay(1);
		debutPeriode = dt.getDateInMillis();
		dt.setMonth(dt.getMonth()+1);
		finPeriode = dt.getDateInMillis();

		s = Session.findClient(s_);

		con = s.getConnection(null);
		base = s.getCookie().get("BaseDossier");
		this.dateDoc = dateDoc;

		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery("select Prefixe_Facture, Prefixe_Avoir from "+ base +".PARAM_DOSSIER");

		rset.next();

		this.prefixeFacture = rset.getString("Prefixe_Facture");
		this.prefixeAvoir = rset.getString("Prefixe_Avoir");
	}

	public GenDocNumber(long dateDoc, Connection con, String base, String dossierId) throws Exception {

		DateTime dt = new DateTime(dateDoc);
		dt.setDay(1);
		debutPeriode = dt.getDateInMillis();
		dt.setMonth(dt.getMonth()+1);
		finPeriode = dt.getDateInMillis();

		this.con = con;
		this.base = base;
		this.dateDoc = dateDoc;

		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery("select Prefixe_Facture, Prefixe_Avoir from "+ base +".PARAM_DOSSIER");

		rset.next();

		this.prefixeFacture = rset.getString("Prefixe_Facture");
		this.prefixeAvoir = rset.getString("Prefixe_Avoir");
	}


	public int getNumeroPeriode() {

		return numeroPeriode;
	}


	public synchronized int getNumUnique() throws SQLException {

		Statement stt = con.createStatement();

		ResultSet rsNU = stt.executeQuery("select coalesce(max(nu), 0)+1 from (select max(Num_Unique) as nu from "+ base +".FACTURE union select max(Num_Unique) as nu from "+ base +".AVOIR) as tnu");

		rsNU.next();

		return rsNU.getInt(1);
	}


	private void getMaxNumeroAF() throws SQLException {

		PreparedStatement psDernierAvoir = con.prepareStatement("select count(Num_Entier) from "+ base +".AVOIR where Date_Avoir>=? and Date_Avoir<? and Numero>0");

		psDernierAvoir.setLong(1, debutPeriode);
		psDernierAvoir.setLong(2, finPeriode);

		ResultSet rsDA = psDernierAvoir.executeQuery();
		rsDA.next();

		PreparedStatement psDernierFacture = con.prepareStatement("select count(Num_Entier) from "+ base +".FACTURE where Date_Facture>=? and Date_Facture<? and Numero>0");

		psDernierFacture.setLong(1, debutPeriode);
		psDernierFacture.setLong(2, finPeriode);

		ResultSet rsDF = psDernierFacture.executeQuery();
		rsDF.next();

		numeroPeriode = rsDA.getInt(1) + rsDF.getInt(1) + 1;
	}


	public synchronized String getNumeroFacture() throws SQLException {

		getMaxNumeroAF();

		DecimalFormat nf = new DecimalFormat("0000");

		return prefixeFacture + DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}


	public synchronized String getNumeroAvoir() throws SQLException {

		getMaxNumeroAF();

		DecimalFormat nf = new DecimalFormat("0000");

		return prefixeAvoir + DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}


	public synchronized String getNumeroProforma() throws SQLException {

		PreparedStatement psDernierProforma = con.prepareStatement("select count(Num_Entier) from "+ base +".PROFORMA where Date_Proforma>=? and Date_Proforma<? and Numero>0");

		psDernierProforma.setLong(1, debutPeriode);
		psDernierProforma.setLong(2, finPeriode);

		ResultSet rsDP = psDernierProforma.executeQuery();
		rsDP.next();

		numeroPeriode = rsDP.getInt(1) + 1;

		DecimalFormat nf = new DecimalFormat("0000");

		return "P"+ DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}


	public synchronized String getNumeroAffaire() throws SQLException {

		// on prend le max car une affaire ayant un numro peut tre supprime
		PreparedStatement psDerniereAffaire = con.prepareStatement("select max(Numero) from "+ base +".AFFAIRE where Date_C>=? and Date_C<? and Numero>0");

		psDerniereAffaire.setLong(1, debutPeriode);
		psDerniereAffaire.setLong(2, finPeriode);

		ResultSet rsAff = psDerniereAffaire.executeQuery();
		rsAff.next();

		numeroPeriode = rsAff.getInt(1) + 1;

		DecimalFormat nf = new DecimalFormat("0000");

		return "AC"+ DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}


	// Numro de commande client
	public synchronized String getNumeroCC() throws SQLException {

		PreparedStatement psDerniereCommande = con.prepareStatement("select count(Numero) from "+ base +".COMMANDE_CLIENT where Date_C>=? and Date_C<?");

		psDerniereCommande.setLong(1, debutPeriode);
		psDerniereCommande.setLong(2, finPeriode);

		ResultSet rsCom = psDerniereCommande.executeQuery();
		rsCom.next();

		numeroPeriode = rsCom.getInt(1) + 1;

		DecimalFormat nf = new DecimalFormat("0000");

		return "CC"+ DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}
	
	
	// Numro d'acompte client
	public synchronized String getNumeroAcompte() throws SQLException {

		PreparedStatement psDernierAcompte = con.prepareStatement("select count(Numero) from "+ base +".ACOMPTE_CLIENT where Date_C>=? and Date_C<?");

		psDernierAcompte.setLong(1, debutPeriode);
		psDernierAcompte.setLong(2, finPeriode);

		ResultSet rsAcompte = psDernierAcompte.executeQuery();
		rsAcompte.next();

		numeroPeriode = rsAcompte.getInt(1) + 1;

		DecimalFormat nf = new DecimalFormat("0000");

		return "FA"+ DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}


	public synchronized String getNumeroCommande() throws SQLException {

		// on prend le max car une commande fournisseur ayant un numro peut tre supprime
		PreparedStatement psDerniereCommande = con.prepareStatement("select max(Numero) from "+ base +".COMMANDE_FOURNISSEUR where Date_Commande>=? and Date_Commande<? and Numero>0");

		psDerniereCommande.setLong(1, debutPeriode);
		psDerniereCommande.setLong(2, finPeriode);

		ResultSet rsCom = psDerniereCommande.executeQuery();
		rsCom.next();

		numeroPeriode = rsCom.getInt(1) + 1;

		DecimalFormat nf = new DecimalFormat("0000");

		return "CF"+ DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}


	public synchronized String getNumeroDevis() throws SQLException {

		// on prend le max car un devis ayant un numro peut tre supprim
		PreparedStatement psDernierDevis = con.prepareStatement("select max(Numero) from "+ base +".DEVIS where Date_Devis>=? and Date_Devis<? and Numero>0");

		psDernierDevis.setLong(1, debutPeriode);
		psDernierDevis.setLong(2, finPeriode);

		ResultSet rsDevis = psDernierDevis.executeQuery();
		rsDevis.next();

		numeroPeriode = rsDevis.getInt(1) + 1;

		DecimalFormat nf = new DecimalFormat("0000");

		return "D"+ DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}


	public synchronized String getNumeroBL() throws SQLException {

		PreparedStatement psDernierBL = con.prepareStatement("select count(Num_Entier) from "+ base +".BON_LIVRAISON where Date_Liv>=? and Date_Liv<? and Numero>0");

		psDernierBL.setLong(1, debutPeriode);
		psDernierBL.setLong(2, finPeriode);

		ResultSet rsBL = psDernierBL.executeQuery();
		rsBL.next();

		numeroPeriode = rsBL.getInt(1) + 1;

		DecimalFormat nf = new DecimalFormat("0000");

		return "BL"+ DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}

	
	public synchronized String getNumeroOL() throws SQLException {
		
		PreparedStatement psDernierBL = con.prepareStatement("select count(Num_Entier) from "+ base +".BON_LIVRAISON where Date_Liv>=? and Date_Liv<? and Numero>0");
		
		psDernierBL.setLong(1, debutPeriode);
		psDernierBL.setLong(2, finPeriode);
		
		ResultSet rsBL = psDernierBL.executeQuery();
		rsBL.next();
		
		numeroPeriode = rsBL.getInt(1) + 1;
		
		DecimalFormat nf = new DecimalFormat("0000");
			
		return "OL"+ DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}
	
	
	public synchronized String getNumeroLF() throws SQLException {
		
		PreparedStatement psDernierBL = con.prepareStatement("select count(Num_Entier) from "+ base +".BON_LIVRAISON where Date_Liv>=? and Date_Liv<? and Numero>0");
		
		psDernierBL.setLong(1, debutPeriode);
		psDernierBL.setLong(2, finPeriode);
		
		ResultSet rsBL = psDernierBL.executeQuery();
		rsBL.next();
		
		numeroPeriode = rsBL.getInt(1) + 1;
		
		DecimalFormat nf = new DecimalFormat("0000");
			
		return "LF"+ DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}
	
	
	public synchronized String getNumeroRC() throws SQLException {

		PreparedStatement psDernierRC = con.prepareStatement("select count(Numero) from "+ base +".BON_RETOUR_CLIENT where Date_Bon>=? and Date_Bon<? and Etat<>'N'");

		psDernierRC.setLong(1, debutPeriode);
		psDernierRC.setLong(2, finPeriode);

		ResultSet rsRC = psDernierRC.executeQuery();
		rsRC.next();

		numeroPeriode = rsRC.getInt(1) + 1;

		DecimalFormat nf = new DecimalFormat("0000");

		return "RC"+ DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}
	
	
	public synchronized String getNumeroBR() throws SQLException {

		PreparedStatement psDernierBR = con.prepareStatement("select count(Num_Entier) from "+ base +".BON_RECEPTION where Date_BR>=? and Date_BR<? and Numero>0");

		psDernierBR.setLong(1, debutPeriode);
		psDernierBR.setLong(2, finPeriode);

		ResultSet rsBR = psDernierBR.executeQuery();
		rsBR.next();

		numeroPeriode = rsBR.getInt(1) + 1;

		DecimalFormat nf = new DecimalFormat("0000");

		return "BR"+ DateTime.formatTime(dateDoc, "yyMM") + nf.format(numeroPeriode);
	}


	public synchronized String getNumeroClient() throws SQLException {
		
		String numClient = "";
		
		PreparedStatement psPattern = con.prepareStatement("select fn.Pattern, fn.Periode_Init, fn.Numero_Init from "+ base +".FORMAT_NUMEROTATION fn, "+ base +".PARAM_DOSSIER p where fn.Format_Id=p.Format_NC");
		ResultSet rsPattern = psPattern.executeQuery();
		if (rsPattern.next()) {
			
			numClient = rsPattern.getString("Pattern");
			String periodeInit = rsPattern.getString("Periode_Init");
			int numeroInit = rsPattern.getInt("Numero_Init");
			
			String reqNbClients = "select count(*) as Numero from "+ base +".FICHE_CLIENT";
			if (!periodeInit.equals("N")) { reqNbClients += " where Date_C>=? and Date_C<=?"; }
			PreparedStatement psNbClients = con.prepareStatement(reqNbClients);
			if (!periodeInit.equals("N")) {
				DateTime dtDebut = new DateTime(dateDoc);
				DateTime dtFin = new DateTime(dateDoc);
				
				if (periodeInit.equals("A")) {
					dtDebut.setMonth(1);
				}
				dtDebut.setDay(1);
				
				psNbClients.setLong(1, dtDebut.getDateInMillis());
				psNbClients.setLong(2, dtFin.getDateFullTime());
			}
			ResultSet rsNbClients = psNbClients.executeQuery();
			rsNbClients.next();
			numeroPeriode = numeroInit+rsNbClients.getInt("Numero");
			rsNbClients.close();
			psNbClients.close();
			
			numClient = numClient.replace("[aaaa]", DateTime.formatTime(dateDoc, "yyyy"));
			numClient = numClient.replace("[aa]", DateTime.formatTime(dateDoc, "yy"));
			numClient = numClient.replace("[mm]", DateTime.formatTime(dateDoc, "MM"));
			int longueurNumClient = numClient.length()-2; // on tient pas compte des crochets du numro incrmental
			
			// le dernier groupe restant entre crochets correspond au format du numro incrmental
			int posDebutInc = numClient.indexOf('[');
			int posFinInc = numClient.indexOf(']');
			int nbChiffresIncrement = posFinInc-posDebutInc-1;
			String patternIncrementInitial = "";
			for (int i=0; i<nbChiffresIncrement; i++) {
				patternIncrementInitial += "0";
			}
			
			String patternIncrementReel = patternIncrementInitial;
			while (longueurNumClient<10 && (""+numeroPeriode).length()>nbChiffresIncrement) {
				nbChiffresIncrement++;
				longueurNumClient++;
				patternIncrementReel += "0";
			}
			DecimalFormat nf = new DecimalFormat(patternIncrementReel);
			String numero = numClient.replace("["+ patternIncrementInitial +"]", nf.format(numeroPeriode));
			
			PreparedStatement psCheckNumClient = con.prepareStatement("select Client_Id from "+ base +".FICHE_CLIENT where Client_Id=?");
			ResultSet rsCheck;
			boolean numUtilise = true;
			boolean depassementPattern = false;
			while (numUtilise && !depassementPattern) {
				psCheckNumClient.setString(1, numero);
				rsCheck = psCheckNumClient.executeQuery();
				if (rsCheck.next()) {
					numeroPeriode++;
					if (longueurNumClient<10 && (""+numeroPeriode).length()>nbChiffresIncrement) {
						nbChiffresIncrement++;
						longueurNumClient++;
						patternIncrementReel += "0";
						nf = new DecimalFormat(patternIncrementReel);
					} else if ((""+numeroPeriode).length()>nbChiffresIncrement) {
						depassementPattern = true;
					}
					numero = numClient.replace("["+ patternIncrementInitial +"]", nf.format(numeroPeriode));
				} else {
					numUtilise = false;
				}
			}
			
			numClient = (depassementPattern?"":numero);
		}
		rsPattern.close();
		psPattern.close();
		
		return numClient;
	}
	
	
	public synchronized String getNumeroFournisseur() throws SQLException {
		
		String numFournisseur = "";
		
		PreparedStatement psPattern = con.prepareStatement("select fn.Pattern, fn.Periode_Init, fn.Numero_Init from "+ base +".FORMAT_NUMEROTATION fn, "+ base +".PARAM_DOSSIER p where fn.Format_Id=p.Format_NF");
		ResultSet rsPattern = psPattern.executeQuery();
		if (rsPattern.next()) {
			
			numFournisseur = rsPattern.getString("Pattern");
			String periodeInit = rsPattern.getString("Periode_Init");
			int numeroInit = rsPattern.getInt("Numero_Init");
			
			String reqNbFournisseurs = "select count(*) as Numero from "+ base +".FICHE_FOURNISSEUR";
			if (!periodeInit.equals("N")) { reqNbFournisseurs += " where Date_C>=? and Date_C<=?"; }
			PreparedStatement psNbFournisseurs = con.prepareStatement(reqNbFournisseurs);
			if (!periodeInit.equals("N")) {
				DateTime dtDebut = new DateTime(dateDoc);
				DateTime dtFin = new DateTime(dateDoc);
				
				if (periodeInit.equals("A")) {
					dtDebut.setMonth(1);
				}
				dtDebut.setDay(1);
				
				psNbFournisseurs.setLong(1, dtDebut.getDateInMillis());
				psNbFournisseurs.setLong(2, dtFin.getDateFullTime());
			}
			ResultSet rsNbFournisseurs = psNbFournisseurs.executeQuery();
			rsNbFournisseurs.next();
			numeroPeriode = numeroInit+rsNbFournisseurs.getInt("Numero");
			rsNbFournisseurs.close();
			psNbFournisseurs.close();
			
			numFournisseur = numFournisseur.replace("[aaaa]", DateTime.formatTime(dateDoc, "yyyy"));
			numFournisseur = numFournisseur.replace("[aa]", DateTime.formatTime(dateDoc, "yy"));
			numFournisseur = numFournisseur.replace("[mm]", DateTime.formatTime(dateDoc, "MM"));
			int longueurNumFournisseur = numFournisseur.length()-2; // on tient pas compte des crochets du numro incrmental
			
			// le dernier groupe restant entre crochets correspond au format du numro incrmental
			int posDebutInc = numFournisseur.indexOf('[');
			int posFinInc = numFournisseur.indexOf(']');
			int nbChiffresIncrement = posFinInc-posDebutInc-1;
			String patternIncrementInitial = "";
			for (int i=0; i<nbChiffresIncrement; i++) {
				patternIncrementInitial += "0";
			}
			
			String patternIncrementReel = patternIncrementInitial;
			while (longueurNumFournisseur<10 && (""+numeroPeriode).length()>nbChiffresIncrement) {
				nbChiffresIncrement++;
				longueurNumFournisseur++;
				patternIncrementReel += "0";
			}
			DecimalFormat nf = new DecimalFormat(patternIncrementReel);
			String numero = numFournisseur.replace("["+ patternIncrementInitial +"]", nf.format(numeroPeriode));
			
			PreparedStatement psCheckNumFournisseur = con.prepareStatement("select Fournisseur_Id from "+ base +".FICHE_FOURNISSEUR where Fournisseur_Id=?");
			ResultSet rsCheck;
			boolean numUtilise = true;
			boolean depassementPattern = false;
			while (numUtilise && !depassementPattern) {
				psCheckNumFournisseur.setString(1, numero);
				rsCheck = psCheckNumFournisseur.executeQuery();
				if (rsCheck.next()) {
					numeroPeriode++;
					if (longueurNumFournisseur<10 && (""+numeroPeriode).length()>nbChiffresIncrement) {
						nbChiffresIncrement++;
						longueurNumFournisseur++;
						patternIncrementReel += "0";
						nf = new DecimalFormat(patternIncrementReel);
					} else if ((""+numeroPeriode).length()>nbChiffresIncrement) {
						depassementPattern = true;
					}
					numero = numFournisseur.replace("["+ patternIncrementInitial +"]", nf.format(numeroPeriode));
				} else {
					numUtilise = false;
				}
			}
			
			numFournisseur = (depassementPattern?"":numero);
		}
		rsPattern.close();
		psPattern.close();
		
		return numFournisseur;
	}

	
	public synchronized String getNumeroRemise() throws SQLException {
		
		String reqNbRemises = "select count(*) as Numero from "+ base +".REMISE_BANQUE";
		reqNbRemises += " where Date_Remise>=? and Date_Remise<=?";
		PreparedStatement psNbRemises = con.prepareStatement(reqNbRemises);
		
		DateTime dtDebut = new DateTime(dateDoc);
		DateTime dtFin = new DateTime(dateDoc);
		dtDebut.setDay(1);
		psNbRemises.setLong(1, dtDebut.getDateInMillis());
		psNbRemises.setLong(2, dtFin.getDateFullTime());
		
		ResultSet rsNbRemises = psNbRemises.executeQuery();
		rsNbRemises.next();
		numeroPeriode = rsNbRemises.getInt("Numero")+1;
		rsNbRemises.close();
		psNbRemises.close();
		
		DecimalFormat nf = new DecimalFormat("0000");
		
		String numRemise = "R" + DateTime.formatTime(dateDoc, "yy") + DateTime.formatTime(dateDoc, "MM") + nf.format(numeroPeriode);

		return numRemise;
		
	}
	

	protected void finalize() throws SQLException {

		s.closeConnection(con, null);
	}


} // fin GenDocNumber

