/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un bon de rception
 */

package org.opensi.facturation.actions.documents;


import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.facturation.actions.documents.modeles.BonReceptionPDF;
import org.opensi.facturation.actions.documents.modeles.BonReceptionStd;
import org.opensi.facturation.actions.documents.modeles.DataBonReception;
import org.opensi.util.pdf.GlobalDocument;


public class GenBonReception extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
	  	String fichierPdf = "br_"+ r.getParameter("Id_BR") +".pdf";
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		String base = s.getCookie().get("BaseDossier");
		
		String repPdf = absdir +"/pdf/";
		String repTemp = repPdf;

		boolean multi = r.getParameter("MultiEx")!=null;
		boolean bonChiffre = (r.getParameter("BR_Chiffre")!=null?r.getParameter("BR_Chiffre").equals("1"):false);
		
		String reqModeleBR = "select mbr.Modele_Id, mbr.Class from "+ base +".MODELE_BON_RECEPTION mbr, "+ base +".PARAM_DOSSIER d";
		reqModeleBR += " where mbr.Modele_Id=d.Modele_Pdf_BR";
		Connection con = s.getConnection(null);
		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery(reqModeleBR);
		rset.next();
		String modele = rset.getString("Modele_Id");
		String chemin = rset.getString("Class");
		rset.close();
		stt.close();
		s.closeConnection(con, null);
		
		GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);
		
		String[] bons = r.getParameter("BR_Id").split(",");
		for (int z=0;z<bons.length;z++) {
			
			BonReceptionPDF bon;
			DataBonReception dbr = new DataBonReception(s, bons[z], bonChiffre);
			if (modele.equals("STD01")) {
				bon = new BonReceptionStd(repTemp, dbr);
			}
			else {
				Object[] o = {repTemp, dbr};
				Class<?> cl = Class.forName(chemin);
				Constructor<?> c = cl.getConstructors()[0];
				bon = (BonReceptionPDF)c.newInstance(o);
			}
			bon.setMultiEx(multi);
	
			gd.addInternal(bon);
		}
		
		gd.close(GlobalDocument.ON_EXIT);
	
		return true;
		
	} // fin service


} // fin GenBonReception
