/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un bon de retour
 */

package org.opensi.facturation.actions.documents;


import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.opensi.api.SessionOSI;
import org.opensi.facturation.actions.documents.modeles.BonRetourPDF;
import org.opensi.facturation.actions.documents.modeles.BonRetourStd;
import org.opensi.facturation.actions.documents.modeles.DataBonRetour;
import org.opensi.util.pdf.GlobalDocument;


public class GenBonRetour {


	public GenBonRetour(SessionOSI sosi, String nomFichier, int bonId, int chiffre, String langue) throws Exception {
	
		String base = sosi.getBaseDossier();
		
		String repPdf = sosi.getPdfDirectory();
		String repTemp = repPdf;
		
		String reqModeleBR = "select mbr.Modele_Id, mbr.Class from "+ base +".MODELE_BON_RETOUR_CLIENT mbr, "+ base +".PARAM_DOSSIER d";
		reqModeleBR += " where mbr.Modele_Id=d.Modele_Pdf_RC";
		Connection con = sosi.getConnection();
		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery(reqModeleBR);
		rset.next();
		String modele = rset.getString("Modele_Id");
		String chemin = rset.getString("Class");
		rset.close();
		stt.close();
		
		GlobalDocument gd = new GlobalDocument(repPdf, nomFichier);
		
		boolean multi = false;

		BonRetourPDF bonRetour;
		DataBonRetour dbr = new DataBonRetour(sosi, bonId);
		if (modele.equals("STD01")) {
			bonRetour = new BonRetourStd(repTemp, dbr);
		}
		else {
			Object[] o = {repTemp, dbr};
			Class<?> cl = Class.forName(chemin);
			Constructor<?> c = cl.getConstructors()[0];
			bonRetour = (BonRetourPDF)c.newInstance(o);
		}
		bonRetour.setMultiEx(multi);
		bonRetour.setBonChiffre(chiffre == 1);
		gd.addInternal(bonRetour);
		
		
		gd.close(GlobalDocument.ON_EXIT);
		
	}


} // fin GenBonRetour
