/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'une commande fournisseur
 */

package org.opensi.facturation.actions.documents;


import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.facturation.actions.documents.modeles.CommandeFournisseurPDF;
import org.opensi.facturation.actions.documents.modeles.CommandeFournisseurStd;
import org.opensi.facturation.actions.documents.modeles.DataCommandeFournisseur;
import org.opensi.util.pdf.GlobalDocument;


public class GenCommandeFournisseur extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String fichierPdf = r.getParameter("FichierPDF");
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		String base = s.getCookie().get("BaseDossier");

		String repPdf = absdir +"/pdf/";
		String repTemp = repPdf;
		
		boolean chiffre = (r.getParameter("Chiffre")!=null && r.getParameter("Chiffre").equals("1"));
		
		String reqModeleCommande = "select mcf.Modele_Id, mcf.Class from "+ base +".MODELE_COMMANDE_FOURNISSEUR mcf, "+ base +".PARAM_DOSSIER d";
		reqModeleCommande += " where mcf.Modele_Id=d.Modele_Pdf_CF";
		Connection con = s.getConnection(null);
		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery(reqModeleCommande);
		rset.next();
		String modele = rset.getString("Modele_Id");
		String chemin = rset.getString("Class");
		rset.close();
		stt.close();
		s.closeConnection(con, null);

		GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);
		
		CommandeFournisseurPDF commande;
		DataCommandeFournisseur dcf = new DataCommandeFournisseur(s, r.getParameter("Commande_Id"), chiffre);
		if (modele.equals("STD01")) {
			commande = new CommandeFournisseurStd(repTemp, dcf);
		}
		else {
			Object[] o = {repTemp, dcf};
			Class<?> cl = Class.forName(chemin);
			Constructor<?> c = cl.getConstructors()[0];
			commande = (CommandeFournisseurPDF)c.newInstance(o);
		}

		gd.addInternal(commande);

		gd.close(GlobalDocument.ON_EXIT);

		return true;

	} // fin service


} // fin GenCommandeFournisseur
