/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un acompte client standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;

public class DataAcompteClient {

	// coordonnes socit mettrice

	public String raisonSociale;
	public String adresse1;
	public String adresse2;
	public String adresse3;
	public String codePostal;
	public String ville;
	public String tel;
	public String fax;
	public String email;
	public String web;
	
	public double capital;
	public String typeSociete;
	public String tvaIntra;
	public String rcs;
	public String siren;
	
	// coordonnes du destinataire
	
	public String clientId;
	public String denominationFact;
	public String adresse1Fact;
	public String adresse2Fact;
	public String adresse3Fact;
	public String codePostalFact;
	public String villeFact;
	public String paysFact;
	
	// coordonnes d'envoi
	
	public String denominationEnvoi;
	public String adresse1Envoi;
	public String adresse2Envoi;
	public String adresse3Envoi;
	public String codePostalEnvoi;
	public String villeEnvoi;
	public String paysEnvoi;
	
	// infos acompte
	
	public String numAcompte;
	public long dateAcompte;
	public String libelle;
	public String comFin = "";
	public String refCommande;
	public String numCommande;
	public String modeReglement;
	public String interlocuteur = "";
	
	public double tauxTVA = 0;
	public double totalHT = 0;
	public double totalTVA = 0;
	public double totalTTC = 0;
	
	public boolean logoAdr;
	public String urlLogo = "";
	public String urlAnnule = "";
	public boolean annule;
	
	public int nbex;
			
	public String absdir;
	
	
	
	public DataAcompteClient(Session s, String acompteId) {	
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			this.absdir = s.getAppConfiguration().get("opensi.absdir");
			
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossierId +".jpg";
			this.urlAnnule = s.getAppConfiguration().get("opensi.absdir") +"/images/annule.jpg";
			
			ResultSet rset;
			
			
			// Paramtres dossier

			String reqLogo = "select Logo_Adr from "+ base +".PARAM_DOSSIER";
			rset = stt.executeQuery(reqLogo);
			rset.next();
			this.logoAdr = rset.getInt("Logo_Adr")==1;
			rset.close();
			
      
			// coordonnes de l'entreprise facturante
      
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			
			rset = stt.executeQuery(reqFacturante);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");		
			rset.close();
			
			
			// Elments de l'acompte
			
			String reqAcompte = "select ac.Date_Acompte, ac.Numero, ac.Libelle, ac.Commentaires_Fin, coalesce(ac.Client_Id,'') as ClientId, ac.Statut,";
			reqAcompte += " ac.Taux_TVA, ac.Total_HT, ac.Total_TVA, ac.Total_TTC, cc.Numero as Num_Commande, cc.Ref_Commande,";
			reqAcompte += " ac.Denomination, ac.Adresse_1, ac.Adresse_2, ac.Adresse_3, ac.Code_Postal, ac.Ville,";
			reqAcompte += " p1.Nom_FR as Pays, c1.civ_Courte, ac.Nom_Inter, ac.Prenom_Inter, mr.Libelle as Mode_Reglement,";
			reqAcompte += " ac.Denomination_Envoi, ac.Adresse_1_Envoi, ac.Adresse_2_Envoi, ac.Adresse_3_Envoi, ac.Code_Postal_Envoi, ac.Ville_Envoi, p2.Nom_FR as Pays_Envoi";
			reqAcompte += " from "+ base +".ACOMPTE_CLIENT ac, "+ base +".COMMANDE_CLIENT cc, "+ base +".MODE_REGLEMENT mr, PAYS p1, PAYS p2, CIVILITE c1";
			reqAcompte += " where ac.Commande_Id=cc.Commande_Id and ac.Mode_Reg_Id=mr.Mode_Reg_Id and ac.Code_Pays=p1.Code_Pays and ac.Code_Pays_Envoi=p2.Code_Pays and ac.Civ_Inter=c1.Civ_Id and ac.Acompte_Id="+ acompteId;
			
			rset = stt.executeQuery(reqAcompte);
			rset.next();
			this.dateAcompte = rset.getLong("Date_Acompte");
			this.numAcompte = rset.getString("Numero");
			this.libelle = rset.getString("Libelle");
			this.clientId = rset.getString("ClientId");
			this.numCommande = rset.getString("Num_Commande");
			this.refCommande = rset.getString("Ref_Commande");
			this.modeReglement = rset.getString("Mode_Reglement");
			
			this.denominationFact = rset.getString("Denomination");
			this.adresse1Fact = rset.getString("Adresse_1");
			this.adresse2Fact = rset.getString("Adresse_2");
			this.adresse3Fact = rset.getString("Adresse_3");
			this.codePostalFact = rset.getString("Code_Postal");
			this.villeFact = rset.getString("Ville");
			this.paysFact = rset.getString("Pays");
			this.denominationEnvoi = rset.getString("Denomination_Envoi");
			this.adresse1Envoi = rset.getString("Adresse_1_Envoi");
			this.adresse2Envoi = rset.getString("Adresse_2_Envoi");
			this.adresse3Envoi = rset.getString("Adresse_3_Envoi");
			this.codePostalEnvoi = rset.getString("Code_Postal_Envoi");
			this.villeEnvoi = rset.getString("Ville_Envoi");
			this.paysEnvoi = rset.getString("Pays_Envoi");
			
			this.tauxTVA = rset.getDouble("Taux_TVA");
			this.totalHT = rset.getDouble("Total_HT");
			this.totalTVA = rset.getDouble("Total_TVA");
			this.totalTTC = rset.getDouble("Total_TTC");
			
			if (!rset.getString("Commentaires_Fin").equals("")) {
				this.comFin = "\n"+ rset.getString("Commentaires_Fin");
			}

			this.annule = rset.getString("Statut").equals("A");
			
			if (rset.getString("Nom_Inter").equals("")) {
				this.interlocuteur = "";
			}
			else {
				this.interlocuteur = rset.getString("Civ_Courte") +" "+ rset.getString("Nom_Inter").toUpperCase() + " " + rset.getString("Prenom_Inter");
			}
			
			rset.close();

			stt.close();			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	public int getNbEx() {	
		return nbex;
	}
	
	
} // fin DataAcompteClient
