/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes pour l'edition du bon de rception
 */

package org.opensi.facturation.actions.documents.modeles;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.calcul.CalculVentilTVA;
import org.opensi.util.tools.StringUtils;


public class DataBonReception {


	// liste des articles du bon de rception

	protected ArrayList<LigneBonReception> lignes = new ArrayList<LigneBonReception>(10);

	// infos socit

	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;
	
	// infos fournisseur
	
	protected String fournisseurId;
	protected String societeFact;
	protected String adresseFact1;
	protected String adresseFact2;
	protected String adresseFact3;
	protected String codePostalFact;
	protected String villeFact;
	protected String paysFact;
	
	// Infos bon de rception
	
	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;
	
	protected String numBR;
	protected long dateBR;
	//protected String responsable;
	protected String comFin = "";
	protected String mentions = "";
	
	protected int nbex;
	protected boolean bonChiffre = false;	
	
	protected boolean rist = false;
	protected boolean coul = false;
	protected boolean tail = false;
	protected boolean unite = false;
	protected boolean nbPieces = false;
	protected boolean numLot = false;
	protected boolean datePeremption = false;

	protected boolean logoAdr;
	protected String urlLogo = "";
	
	protected String refCommande;
	protected String refBL;
	
	protected double tRemise = 0;
	protected double mRemise = 0;
	protected double montantBase = 0;
	protected double totalBase = 0;
	protected double totalTVA = 0;
	protected double montantTTC = 0;
	protected Calcul calc;
	protected HashMap<Integer, CalculVentilTVA> ventilTVA;
	
	
	public DataBonReception(Session s, String brId, boolean bonChiffre) {	
		try {			
      			
			String base = s.getCookie().get("BaseDossier");
			String dossier = s.getCookie().get("Dossier_Id");
			
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossier +".jpg";
			this.bonChiffre = bonChiffre;
			
			Connection con = s.getConnection(null);
			
			Statement stt = con.createStatement();
			Statement stt2 = con.createStatement();
			Statement stt3 = con.createStatement();
			
			ResultSet rset;			
			
			// Elments du bon de rception
			
			String reqBR = "select Date_BR, Num_Entier, Commentaires_Fin, Mentions, Num_BL, Commande_Id from "+ base +".BON_RECEPTION where BR_Id="+ brId;
			
			rset = stt.executeQuery(reqBR);
			
			rset.next();
			
			this.numBR = rset.getString("Num_Entier");
			this.dateBR = rset.getLong("Date_BR");
			this.refBL = rset.getString("Num_BL");
			int commandeId = rset.getInt("Commande_Id");
			
			if (!rset.getString("Commentaires_Fin").equals("")) {
				this.comFin = StringUtils.removeHtmlTags("\n"+ rset.getString("Commentaires_Fin"));
			}
			this.mentions = "\n" + rset.getString("Mentions");
			
			rset.close();
			
      
			// coordonnes de la socit
      
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			rset = stt.executeQuery(reqFacturante);
			
			rset.next();
			
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");
			
			rset.close();
			
			
			// Elments de la commande
			
			String reqCommande = "select c.Fournisseur_Id, c.Num_Entier, c.Remise, c.Soldee, f.Denomination, f.Adresse_1, f.Adresse_2, f.Adresse_3, f.Code_Postal, f.Ville, p.Nom_FR as Pays ";
			reqCommande += "from PAYS p, "+ base +".COMMANDE_FOURNISSEUR c, "+ base +".FICHE_FOURNISSEUR f where c.Code_Pays=p.Code_Pays and c.Fournisseur_Id=f.Fournisseur_Id and c.Commande_Id="+ commandeId;
			
			rset = stt.executeQuery(reqCommande);
			
			rset.next();
			
			// coordonnes du fournisseur
			
			this.societeFact = rset.getString("Denomination");
			this.adresseFact1 = rset.getString("Adresse_1");
			this.adresseFact2 = rset.getString("Adresse_2");
			this.adresseFact3 = rset.getString("Adresse_3");
			this.codePostalFact = rset.getString("Code_Postal");
			this.villeFact = rset.getString("Ville");
			this.paysFact = rset.getString("Pays");			
			this.fournisseurId = rset.getString("Fournisseur_Id");
			this.refCommande = rset.getString("Num_Entier");
			this.tRemise = rset.getDouble("Remise");
			//int utilR = rset.getInt("Util_R");
			
			int soldee = rset.getInt("Soldee");
			
			rset.close();			
			
			
			// nombre d'exemplaires  sortir      

			this.nbex = 1;
			
			
			// Paramtres dossier
      
			String reqCom = "select Logo_Adr from "+ base +".PARAM_DOSSIER";
			rset = stt.executeQuery(reqCom);			
			rset.next();			
			logoAdr = rset.getInt("Logo_Adr")==1;			
			rset.close();			
			
			
	      // slection des articles appartenant au bon de rception
			  
			String reqArticles = "select c.Prix, c.Ristourne, c.Code_TVA, c.Ligne_Id, c.Reference, c.Designation, b.Quantite, c.Quantite as QteCom, c.Unite, b.Num_Lot, b.Nb_Pieces, b.Date_Peremption,"
												 + " c.Type_Ligne, c.Commentaire, c.Commentaire_Avant from "+ base +".LIGNE_BON_RECEPTION b,"+ base +".LIGNE_COMMANDE_FOURNISSEUR c"
												 + " where b.Ref_Ligne=c.Ligne_Id and b.BR_Id="+ brId +" order by b.Rank";
			
			rset = stt.executeQuery(reqArticles);
			
			String reqInfosSup = "select coalesce(ca.Libelle,'') as Couleur, coalesce(ta.Libelle,'') as Taille from "+ base +".FICHE_ARTICLE fa";
			reqInfosSup += " left join "+ base +".COULEUR_ARTICLE ca on fa.Couleur_Id=ca.Couleur_Id left join "+ base +".TAILLE_ARTICLE ta on fa.Taille_Id=ta.Taille_Id";
			reqInfosSup += " where fa.Article_Id=?";
			PreparedStatement psInfosSup = con.prepareStatement(reqInfosSup);
			
			while (rset.next()) {
				
				LigneBonReception lbr = new LigneBonReception();

				lbr.setPrice(rset.getDouble("Prix"));
				lbr.setReference(rset.getString("Reference"));
				lbr.setDesignation(rset.getString("Designation"));
				lbr.setQte(rset.getDouble("Quantite"));
				lbr.setRistourne(rset.getDouble("Ristourne"));
				lbr.setType(rset.getString("Type_Ligne"));				
				lbr.setTva(rset.getInt("Code_TVA"));				
				lbr.setMontant(lbr.price*lbr.qte*(1-lbr.ristourne/100));
				lbr.setDetail_1("");
				lbr.setDetail_2("");
				lbr.setCommentaire(rset.getString("Commentaire"));
				lbr.setCommentaireAvant(rset.getString("Commentaire_Avant"));
				lbr.setQteCom(rset.getDouble("QteCom"));
				lbr.setUnite(rset.getString("Unite"));
				lbr.setNumLot(rset.getString("Num_Lot"));
				lbr.setNbPieces(rset.getInt("Nb_Pieces"));
				lbr.setDatePeremption(rset.getLong("Date_Peremption"));
				lbr.setType('A');
				
				if (lbr.ristourne != 0) rist = true;
				if (!lbr.unite.equals("U")) unite = true;
				if (!lbr.num_lot.equals("")) numLot = true;
				if (lbr.nb_pieces != 0) nbPieces = true;
				if (lbr.date_peremption != 0) datePeremption = true;
				
				montantBase += lbr.montant;
				lbr.setSousTotal(montantBase);
				
				String reqReliquat = "select sum(a.Quantite) as Quantite from "+ base +".BON_RECEPTION b, "+ base +".LIGNE_BON_RECEPTION a "
													 + "where (b.Etat='V' or b.BR_Id="+ brId +") and b.Date_BR<="+ dateBR +" and b.BR_Id=a.BR_Id and b.Commande_Id="+ commandeId +" and a.Ref_Ligne="+ rset.getInt("Ligne_Id");
								
				ResultSet rset2 = stt2.executeQuery(reqReliquat);
				rset2.next();
				
				lbr.setReliquat(lbr.qteCom - rset2.getDouble("Quantite"));
				
				rset2.close();
				
				if (soldee==1 && lbr.reliquat>0) {
				
					String reqDerBR = "select max(Date_BR) as DerDate from "+ base +".BON_RECEPTION where Commande_Id="+ commandeId;

					rset2 = stt2.executeQuery(reqDerBR);

					rset2.next();

					if (dateBR==rset2.getLong("DerDate")) {
						lbr.setReliquat(-1);
					}

					rset2.close();
				}
				
				lignes.add(lbr);
				
				
				if (rset.getString("Type_Ligne").equalsIgnoreCase("S")) {					
				
					psInfosSup.setString(1, rset.getString("Reference"));
					ResultSet rsIS = psInfosSup.executeQuery();

					if (rsIS.next()) {

						lbr.setCouleur(rsIS.getString("Couleur"));
						lbr.setTaille(rsIS.getString("Taille"));

						if (rsIS.getString("Couleur").length()>0) {
							coul = true;
						}

						if (rsIS.getString("Taille").length()>0) {
							tail = true;
						}
					}
						
				}
			}
			
			calc = new Calcul(s, Integer.parseInt(brId), "Bon_Reception");
			ventilTVA = calc.getLignesTVA();

			mRemise = calc.getRemiseM();
			totalBase = calc.getTotalHT();
			
			totalTVA = calc.getTotalTVA();
			
			montantTTC = calc.getMontantTTC();
			
			rset.close();
			stt.close();
			stt2.close();
			stt3.close();
			s.closeConnection(con, null);
			
		} catch(Exception e) { e.printStackTrace();	}
	
	}
	
	public double calcSousTotal(int derniereLigne) {		
		if (derniereLigne<0) 
			return 0;
		return lignes.get(derniereLigne).sousTotal;		
	}
	
	public int getNbLignes() {
		return lignes.size();
	}


} // fin DataBonReception
