/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un bon de retour standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;

import org.opensi.api.SessionOSI;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.calcul.CalculVentilTVA;
import org.opensi.util.tools.StringUtils;


public class DataBonRetour {


	private DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
	
	private DecimalFormat numFormatQte = new DecimalFormat("0.##");



	// les lignes du bon de retour
	protected ArrayList<LigneBonRetour> lignes = new ArrayList<LigneBonRetour>(10);
	


	// coordonnes socit mettrice

	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;	
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;
	
	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;
	
	// coordonnes du destinataire
	

	protected String clientId;
	protected String raisonSocialeDest;
	protected String adresse1Dest;
	protected String adresse2Dest;
	protected String adresse3Dest;
	protected String codePostalDest;
	protected String villeDest;
	protected String paysDest;
	private String codePaysLiv;
	
	// infos facture
	
	protected String raisonSocialeFact;
	protected String numeroBon;
	protected String comFin = "";
	protected String mentions = "";
	protected String codeFournisseur;
	protected String refCommande;
	protected String refAffaire;
	protected String refBL;
	
	protected long dateBon;
	
	// contact de livraison
	protected String interlocuteurLiv = "";
	protected String telInterLiv;
	protected String faxInterLiv;
	protected String emailInterLiv;
	
	protected double tRemise = 0;
	protected double mRemise = 0;
	protected double montantBase = 0;
	protected double totalBase = 0;
	protected double totalTVA = 0;
	protected double montantTTC = 0;
	
	protected boolean bonChiffreClient = false;
	protected boolean editionTTC = false;
	protected boolean coul = false;
	protected boolean tail = false;
	protected boolean unite = false;
	protected boolean nbPieces = false;
	protected boolean numLot = false;
	protected boolean datePeremption = false;
	protected boolean logoAdr;
	protected String urlLogo = "";
	protected String urlAnnule = "";
	
	protected int nbex;
	
	protected int commandeId;
	
	protected boolean annule;

	protected String modeExpedition;
	protected int affaireId = 0;
	protected int soldee = 0;

	private Calcul calc;

	protected HashMap<Integer, CalculVentilTVA> ventilTVA;
	

	public DataBonRetour(SessionOSI sosi, int bonId) {	
		try {
		
			Connection con = sosi.getConnection();
			Statement stt = con.createStatement();
			
			String dossierId = sosi.getDossierId();
			String base = sosi.getBaseDossier();
			
			this.urlLogo = sosi.getLogosDirectory() + dossierId +".jpg";
			this.urlAnnule = sosi.getImagesDirectory() + "annule.jpg";
			
			ResultSet rset;
			
			dfs2.setDecimalSeparator('.');
			numFormatQte.setDecimalFormatSymbols(dfs2);
			
      
			// coordonnes de l'entreprise facturante
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			rset = stt.executeQuery(reqFacturante);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");		
			rset.close();
			
			// Elments du bon de retour
			String reqBon = "select cc.Commande_Id, coalesce(cc.Client_Id,'') as Client_Id,cc.Ref_Commande,cc.Soldee,cc.Remise,cc.Denomination,cc.Affaire_Id,br.*, p.Nom_FR, trim(concat(c.Civ_Courte,' ',br.Nom_Inter,' ',br.Prenom_Inter)) as interlocuteur";
			reqBon += " from "+ base +".BON_RETOUR_CLIENT br join "+ base +".BON_LIVRAISON bl on br.BL_Id=bl.Bon_Id join "+ base +".COMMANDE_CLIENT cc on bl.Commande_Id=cc.Commande_Id join PAYS p on br.Code_Pays=p.Code_Pays join CIVILITE c on c.Civ_Id=br.Civ_Inter where br.Bon_Id="+ bonId;
			rset = stt.executeQuery(reqBon);
			rset.next();
			this.raisonSocialeFact = rset.getString("Denomination");
			this.refCommande = rset.getString("Ref_Commande");
			this.soldee = rset.getInt("Soldee");
			this.tRemise = rset.getDouble("Remise");
			this.clientId = rset.getString("Client_Id");
			this.numeroBon = rset.getString("Numero");
			this.dateBon = rset.getLong("Date_Bon");
			this.annule = rset.getString("Etat").equals("A");
			this.affaireId = rset.getInt("Affaire_Id");
			this.commandeId = rset.getInt("Commande_Id");
			this.interlocuteurLiv = rset.getString("interlocuteur");
			this.telInterLiv = rset.getString("Tel_Inter");
			this.faxInterLiv = rset.getString("Fax_Inter");
			this.emailInterLiv = rset.getString("Email_Inter");
			this.raisonSocialeDest = rset.getString("Denomination");
			this.adresse1Dest = rset.getString("Adresse_1");
			this.adresse2Dest = rset.getString("Adresse_2");
			this.adresse3Dest = rset.getString("Adresse_3");
			this.codePostalDest = rset.getString("Code_Postal");
			this.villeDest = rset.getString("Ville");
			this.paysDest = rset.getString("Nom_FR");
			this.codePaysLiv = rset.getString("Code_Pays");
			if (rset.getString("Commentaires_Fin").length()>0) {
			  this.comFin = "\n"+ rset.getString("Commentaires_Fin");
			}
			this.mentions = "\n" + rset.getString("Mentions");
			rset.close();
			
			// modification des coordonnes de l'entreprise facturante si code_pays reli a un site_id dans PARAM_PAYS_WEB
			if (!this.codePaysLiv.equals("")) {
				String reqParamPaysWeb = "select s.* from "+ base +".SITE s,"+ base +".PARAM_PAYS_WEB ppw where ppw.Site_Id=s.Site_Id and ppw.Code_Pays='"+ this.codePaysLiv +"'";
				rset = stt.executeQuery(reqParamPaysWeb);
				if (rset.next()) {
					this.raisonSociale = rset.getString("Denomination");
					this.adresse1 = rset.getString("Adresse_1");
					this.adresse2 = rset.getString("Adresse_2");
					this.adresse3 = rset.getString("Adresse_3");
					this.codePostal = rset.getString("Code_Postal");
					this.ville = rset.getString("Ville");
					this.tel = rset.getString("Tel");
					this.fax = rset.getString("Fax");
					this.email = rset.getString("Email");
				}
				rset.close();
			}
			
			// Numro de bl
			String reqNumFacture = "select bl.Num_Entier from " + base + ".BON_LIVRAISON bl join "+ base +".BON_RETOUR_CLIENT brc on bl.Bon_Id=brc.BL_Id";
			reqNumFacture += " where brc.Bon_Id = " + bonId;
			rset = stt.executeQuery(reqNumFacture);
			rset.next();
			this.refBL = rset.getString("Num_Entier");
			rset.close();
			
			String reqAffaire = "select Num_Entier from "+ base +".AFFAIRE where Affaire_Id="+ affaireId;
			rset = stt.executeQuery(reqAffaire);
			rset.next();
			this.refAffaire = rset.getString("Num_Entier");
			rset.close();
			
			// Paramtres dossier
			String reqLogo = "select Logo_Adr from "+ base +".PARAM_DOSSIER";
			rset = stt.executeQuery(reqLogo);
			rset.next();
			logoAdr = rset.getInt("Logo_Adr")==1;
			rset.close();		
			
			
			// nombre d'exemplaires  sortir
			this.nbex = 1;
			String reqEx = "select Code_Fournisseur, Bon_Chiffre from "+ base +".FICHE_CLIENT where Client_Id='"+ clientId +"'";
			rset = stt.executeQuery(reqEx);
			if (rset.next()) {
				this.codeFournisseur = rset.getString("Code_Fournisseur");
				this.bonChiffreClient = rset.getInt("Bon_Chiffre")==1;
			}
			else {
				this.codeFournisseur = "";
			}
			rset.close();

			// slection des articles appartenant au bon de retour
			String reqArticles = "select lbrc.Rank, lcc.Prix_Unitaire, lcc.Ristourne, lcc.Code_TVA, lcc.Ligne_Id, lcc.Libelle, lcc.Reference, lcc.Designation, lbrc.Quantite, lcc.Type_Ligne, lcc.Commentaire_Apres, lcc.Commentaire_Avant, lcc.Unite, coalesce(lbl.Num_Lot,'') as Num_Lot, coalesce(lbrc.Nb_Pieces,0) as Nb_Pieces, coalesce(lbl.Date_Peremption,0) as Date_Peremption";
			reqArticles += " from "+ base +".LIGNE_BON_RETOUR_CLIENT lbrc join "+ base +".LIGNE_BON_LIVRAISON lbl on lbrc.Ligne_BL=lbl.Ligne_Id";
			reqArticles += " join "+ base +".LIGNE_COMMANDE_CLIENT lcc on lbl.Ref_Ligne=lcc.Ligne_Id where lbrc.Bon_Id="+ bonId +" order by lbrc.Rank";
			
			String reqInfosSup = "select coalesce(ma.Libelle,'') as Marque, coalesce(ca.Libelle,'') as Couleur, coalesce(ta.Libelle,'') as Taille, fa.Descrip_1, fa.Descrip_2, fa.Imp_Nom_Bon, fa.Imp_Desc1_Bon, fa.Imp_Desc2_Bon, if(fa.Mesure_Poids='K',fa.Poids_Brut,if(fa.Mesure_Poids='G',fa.Poids_Brut/1000,fa.Poids_Brut*1000)) as Poids_Brut";
			reqInfosSup += " from "+ base +".FICHE_ARTICLE fa left join "+ base +".MARQUE_ARTICLE ma on fa.Marque_Id=ma.Marque_Id";
			reqInfosSup += " left join "+ base +".COULEUR_ARTICLE ca on fa.Couleur_Id=ca.Couleur_Id";
			reqInfosSup += " left join "+ base +".TAILLE_ARTICLE ta on fa.Taille_Id=ta.Taille_Id where fa.Article_Id=?";
			PreparedStatement psInfosSup = con.prepareStatement(reqInfosSup);
			
			String reqNomenclature = "select n.ArticleComp_Id, n.Quantite, f.Designation";
			reqNomenclature += " from "+ base +".FICHE_ARTICLE f join "+ base +".COMPOSANT_ARTICLE n on f.Article_Id=n.ArticleComp_Id where n.Article_Id=?";
			PreparedStatement psNomenclature = con.prepareStatement(reqNomenclature);
					
			rset = stt.executeQuery(reqArticles);
			while (rset.next()) {
				
				LigneBonRetour lb = new LigneBonRetour();
        
				String libelle = rset.getString("Libelle");
				if (libelle.length()>0) {
					libelle = "\n"+ libelle;
				}			
				lb.setReference(rset.getString("Reference"));
				lb.setDesignation(rset.getString("Designation") + libelle);
				lb.setQuantite(rset.getDouble("Quantite"));
				lb.setPrixUnitaire(rset.getDouble("Prix_Unitaire") * (1-rset.getDouble("Ristourne")/100));
				lb.setCommentaire(rset.getString("Commentaire_Apres"));
				lb.setCommentaireAvant(rset.getString("Commentaire_Avant"));
				lb.setType('A');	
				lb.setMontant(lb.prixUnitaire * lb.quantite);
				lb.setUnite(rset.getString("Unite"));
				lb.setNumLot(rset.getString("Num_Lot"));
				lb.setNbPieces(rset.getInt("Nb_Pieces"));
				lb.setDatePeremption(rset.getLong("Date_Peremption"));
				
				if (!lb.unite.equals("U")) unite = true;
				if (!lb.num_lot.equals("")) numLot = true;
				if (lb.nb_pieces != 0) nbPieces = true;
				if (lb.date_peremption != 0) datePeremption = true;
				
				montantBase += lb.montant;
				lb.setSousTotal(montantBase);						
				lignes.add(lb);			
				
				
				if (rset.getString("Type_Ligne").equalsIgnoreCase("S")) {					
					// rcupration infos supplmentaires si existent
					psInfosSup.setString(1, lb.reference);
					ResultSet rsIS = psInfosSup.executeQuery();

					if (rsIS.next()) {
						lb.setMarque(rsIS.getString("Marque"));
						lb.setCouleur(rsIS.getString("Couleur"));
						lb.setTaille(rsIS.getString("Taille"));
						if (rsIS.getString("Couleur").length()>0) {
							coul = true;
						}
						if (rsIS.getString("Taille").length()>0) {
							tail = true;
						}
						if (rsIS.getInt("Imp_Desc1_Bon")==1) {
							lb.setDetail_1(StringUtils.removeHtmlTags(rsIS.getString("Descrip_1")));
						}
						if (rsIS.getInt("Imp_Desc2_Bon")==1) {
							lb.setDetail_2(StringUtils.removeHtmlTags(rsIS.getString("Descrip_2")));
						}

						// gestion de la nomenclature
						if (rsIS.getInt("Imp_Nom_Bon")==1)	{
							psNomenclature.setString(1, lb.reference);
							ResultSet rsN = psNomenclature.executeQuery();
							while (rsN.next()) {
								LigneBonRetour ln = new LigneBonRetour();

								ln.setReference(rsN.getString("ArticleComp_Id"));
								ln.setDesignation(rsN.getString("Designation"));
								ln.setQuantite(rsN.getDouble("Quantite"));
								ln.setType('N');
								ln.setSousTotal(montantBase);			

								lignes.add(ln);
							}
							rsN.close();
						}
					}
					rsIS.close();								
				}				
			}
			rset.close();
			
			calc = new Calcul(sosi, bonId, "Bon_Retour");
			ventilTVA = calc.getLignesTVA();
			mRemise = calc.getRemiseM();
			totalBase = calc.getTotalHT();
			totalTVA = calc.getTotalTVA();
			montantTTC = calc.getMontantTTC();
			
			stt.close();
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	
	public double calcSousTotal(int derniereLigne) {
		return (derniereLigne<0)?0:lignes.get(derniereLigne).sousTotal;		
	}	
	
	
	public int getNbLignes() {
		return lignes.size();
	}
	
	
	public int getNbEx() {
		return nbex;
	}
	
	
} // fin DataBonRetour
