/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un devis standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.calcul.CalculVentilTVA;
import org.opensi.util.tools.StringUtils;


public class DataDevis {


	// les lignes du devis
	protected ArrayList<LigneDevis> lignes = new ArrayList<LigneDevis>(10);
	


	// coordonnes socit mettrice

	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;
	
	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;
	
	// coordonnes du destinataire
	
	protected String clientId;
	protected String raisonSocialeClient;
	
	protected String raisonSocialeDest;
	protected String adresseDest;
	protected String compAdresseDest;
	protected String adresseDest3;
	protected String codePostalDest;
	protected String villeDest;
	protected String paysDest;
	
	// coordonnes de livraison
	
	protected String denominationLiv;
	protected String adresse1Liv;
	protected String adresse2Liv;
	protected String adresse3Liv;
	protected String codePostalLiv;
	protected String villeLiv;
	protected String codePaysLiv;
	protected String paysLiv;
	
	// coordonnes d'envoi
	
	protected String denominationEnvoi;
	protected String adresse1Envoi;
	protected String adresse2Envoi;
	protected String adresse3Envoi;
	protected String codePostalEnvoi;
	protected String villeEnvoi;
	protected String paysEnvoi;
	
	// infos devis	
	
	protected String numeroDevis;	
	protected String responsable = "";
	protected String telResponsable = "";
	protected String emailResponsable = "";
	protected String interlocuteur = "";
	protected String interTel = "";
	protected String interFax = "";
	protected String interMail = "";
	protected String interlocuteurLiv = "";
	protected String interTelLiv = "";
	protected String interFaxLiv = "";
	protected String interMailLiv = "";
	protected String interlocuteurEnvoi = "";
	protected String interTelEnvoi = "";
	protected String interFaxEnvoi = "";
	protected String interMailEnvoi = "";
	protected boolean zoneUE=false;
	protected String regimeTVA = "G";
	
	protected long dateDevis;
	protected long dateExp;	
	
	protected double tRemise = 0;
	protected double tEscompte = 0;
	protected double mRemise = 0;
	protected double mEscompte = 0;
	protected double acompte = 0;
	protected double fraisPort = 0;
	protected double tRemiseFP = 0;
	protected double mRemiseFP = 0;
	protected double montantBase = 0;
	protected double totalBase = 0;
	protected double totalTVA = 0;
	protected double montantTTC = 0;
	protected double netAPayer = 0;
	protected double tauxTvaPort = 0;
	protected String numTvaClient = "";
	
	protected boolean editionTTC = false;
	protected boolean exonerationTVA = false;
	
	protected boolean rist = false;
	protected boolean coul = false;
	protected boolean tail = false;
	protected boolean unite = false;
	protected boolean nbPieces = false;
	protected boolean numLot = false;
	protected boolean datePeremption = false;
	protected boolean logoAdr;
	protected String urlLogo = "";
	
	protected String comFin = "";
	protected String mentions = "";
	
		
	protected boolean imprimerAdrLiv;
	
	protected Calcul calc;

	protected HashMap<Integer, CalculVentilTVA> ventilTVA;
	
	
	
	public DataDevis(Session s, String devisId) {	
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
      
			
			String base = s.getCookie().get("BaseDossier");
			String dossierId = s.getCookie().get("Dossier_Id");
			
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossierId +".jpg";
      
			ResultSet rset;
			
      
			// coordonnes de l'entreprise facturante
      
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			rset = stt.executeQuery(reqFacturante);
			
			rset.next();
			
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");
			
			rset.close();
			
			
			// Elments du devis
			
			String reqDevis = "select d.*, coalesce(d.Client_Id,'') as ClientId, coalesce(d.Util_R, 0) as UtilR, coalesce(fc.Denomination, '') as Denomination_Client, c1.Civ_Courte as Civ_Courte_Fact, c2.Civ_Courte as Civ_Courte_Liv, c3.Civ_Courte as Civ_Courte_Envoi, p1.Nom_FR, p2.Nom_FR as Pays_Liv, p3.Nom_FR as Pays_Envoi, p2.Zone_UE from "+ base +".DEVIS d";
			reqDevis += " left join "+ base +".FICHE_CLIENT fc on d.Client_Id=fc.Client_Id, CIVILITE c1, CIVILITE c2, CIVILITE c3, PAYS p1, PAYS p2, PAYS p3";
			reqDevis += " where c1.Civ_Id=d.Civ_Inter and c2.Civ_Id=d.Civ_Inter_Liv and c3.Civ_Id=d.Civ_Inter_Envoi and d.Code_Pays=p1.Code_Pays and d.Code_Pays_Liv=p2.Code_Pays and d.Code_Pays_Envoi=p3.Code_Pays and d.Devis_Id="+ devisId;
			
			rset = stt.executeQuery(reqDevis);
			
			rset.next();
			
			this.numeroDevis = rset.getString("Num_Entier");
			this.dateDevis = rset.getLong("Date_Devis");
			this.tEscompte = rset.getDouble("Escompte");
			this.acompte = rset.getDouble("Old_Acompte");
			this.tRemise = rset.getDouble("Remise");
			this.fraisPort = rset.getDouble("Frais_Port");
			this.dateExp = rset.getLong("Date_Exp");
			
			this.raisonSocialeDest = rset.getString("Denomination");
			this.adresseDest = rset.getString("Adresse_1");
			this.compAdresseDest = rset.getString("Adresse_2");
			this.adresseDest3 = rset.getString("Adresse_3");
			this.codePostalDest = rset.getString("Code_Postal");
			this.villeDest = rset.getString("Ville");
			this.paysDest = rset.getString("Nom_FR");
			this.denominationLiv = rset.getString("Denomination_Liv");
			this.adresse1Liv = rset.getString("Adresse_1_Liv");
			this.adresse2Liv = rset.getString("Adresse_2_Liv");
			this.adresse3Liv = rset.getString("Adresse_3_Liv");
			this.codePostalLiv = rset.getString("Code_Postal_Liv");
			this.villeLiv = rset.getString("Ville_Liv");
			this.codePaysLiv = rset.getString("Code_Pays_Liv");
			this.paysLiv = rset.getString("Pays_Liv");
			this.denominationEnvoi = rset.getString("Denomination_Envoi");
			this.adresse1Envoi = rset.getString("Adresse_1_Envoi");
			this.adresse2Envoi = rset.getString("Adresse_2_Envoi");
			this.adresse3Envoi = rset.getString("Adresse_3_Envoi");
			this.codePostalEnvoi = rset.getString("Code_Postal_Envoi");
			this.villeEnvoi = rset.getString("Ville_Envoi");
			this.paysEnvoi = rset.getString("Pays_Envoi");
			
			this.clientId = rset.getString("ClientId");
			this.raisonSocialeClient = rset.getString("Denomination_Client");
			this.zoneUE = (rset.getInt("Zone_UE")==1);
			this.regimeTVA = rset.getString("Regime_TVA");
			this.tauxTvaPort = rset.getDouble("Taux_TVA_Port");
			this.numTvaClient = rset.getString("Num_TVA_Intra");
			this.editionTTC = rset.getInt("Edition_TTC")==1;
				
			if (rset.getString("Nom_Inter").equals("")) {
				this.interlocuteur = "";
			}
			else {
				this.interlocuteur = rset.getString("Civ_Courte_Fact") +" "+ rset.getString("Nom_Inter").toUpperCase() + " " + rset.getString("Prenom_Inter");
			}
			this.interFax = rset.getString("Fax_Inter");
			this.interTel = rset.getString("Tel_Inter");
			this.interMail = rset.getString("Email_Inter");
			
			if (rset.getString("Nom_Inter_Liv").equals("")) {
				this.interlocuteurLiv = "";
			}
			else {
				this.interlocuteurLiv = rset.getString("Civ_Courte_Liv") +" "+ rset.getString("Nom_Inter_Liv").toUpperCase() + " " + rset.getString("Prenom_Inter_Liv");
			}
			this.interFaxLiv = rset.getString("Fax_Inter_Liv");
			this.interTelLiv = rset.getString("Tel_Inter_Liv");
			this.interMailLiv = rset.getString("Email_Inter_Liv");
			
			if (rset.getString("Nom_Inter_Envoi").equals("")) {
				this.interlocuteurEnvoi = "";
			}
			else {
				this.interlocuteurEnvoi = rset.getString("Civ_Courte_Envoi") +" "+ rset.getString("Nom_Inter_Envoi").toUpperCase() + " " + rset.getString("Prenom_Inter_Envoi");
			}
			this.interFaxEnvoi = rset.getString("Fax_Inter_Envoi");
			this.interTelEnvoi = rset.getString("Tel_Inter_Envoi");
			this.interMailEnvoi = rset.getString("Email_Inter_Envoi");
			
			int utilR = rset.getInt("UtilR");
			
			if (!rset.getString("Commentaires_Fin").equals("")) {
				this.comFin = StringUtils.removeHtmlTags("\n"+ rset.getString("Commentaires_Fin"));
			}
			this.mentions = "\n\n"+ rset.getString("Mentions");
			
			rset.close();
			
			this.exonerationTVA = this.regimeTVA.equals("E") || (this.regimeTVA.equals("G") && !this.zoneUE);
			
			if (utilR!=0) {
				// responsable entreprise
				
				String reqResp = "select Civ_Courte, Nom, Prenom, Telephone, Email from UTILISATEUR, CIVILITE where Civ_Id=Civilite and Utilisateur_Id="+ utilR;
				
				
				rset = stt.executeQuery(reqResp);
				
				if (rset.next()) {
				
					this.responsable = rset.getString("Civ_Courte") +" "+ rset.getString("Nom").toUpperCase() +" "+ rset.getString("Prenom");
					this.telResponsable = rset.getString("Telephone");
					this.emailResponsable =rset.getString("Email");
				}
				
				rset.close();
			}
			      
			
			// Paramtres dossier
      
			String reqCom = "select Com_Devis, Logo_Adr, Imprimer_Adr_Liv from "+ base +".PARAM_DOSSIER";
			
			rset = stt.executeQuery(reqCom);
			
			rset.next();
			
			logoAdr = rset.getInt("Logo_Adr")==1;
			
			if (rset.getString("Com_Devis").length()>0) {
				this.comFin += "\n\n"+rset.getString("Com_Devis");
			}
			
			this.imprimerAdrLiv = (rset.getInt("Imprimer_Adr_Liv")==1 || !this.codePaysLiv.equals("FR"));
			
			rset.close();					
      
      
			// selection des articles appartenant au devis
			  
			String reqArticles = "select * from "+ base +".LIGNE_DEVIS where Devis_Id="+ devisId +" order by Rank";
			rset = stt.executeQuery(reqArticles);


			String reqInfosSup = "select coalesce(ca.Libelle,'') as Couleur, coalesce(ta.Libelle,'') as Taille, coalesce(ma.Libelle,'') as Marque, fa.Descrip_1, fa.Descrip_2, fa.Imp_Nom_Devis, fa.Imp_Desc1_Devis, fa.Imp_Desc2_Devis";
			reqInfosSup += " from "+ base +".FICHE_ARTICLE fa left join "+ base +".COULEUR_ARTICLE ca on fa.Couleur_Id=ca.Couleur_Id";
			reqInfosSup += " left join "+ base +".TAILLE_ARTICLE ta on fa.Taille_Id=ta.Taille_Id left join "+ base +".MARQUE_ARTICLE ma on fa.Marque_Id=ma.Marque_Id";
			reqInfosSup += " where fa.Article_Id=?";
			PreparedStatement psInfosSup = con.prepareStatement(reqInfosSup);
			
			
			String reqNomenclature = "select n.ArticleComp_Id, n.Quantite, f.Designation "
														 + "from "+ base +".FICHE_ARTICLE f,"+ base +".COMPOSANT_ARTICLE n where f.Article_Id=n.ArticleComp_Id and n.Article_Id=?";
			
			PreparedStatement psNomenclature = con.prepareStatement(reqNomenclature);
					
			
			while (rset.next()) {
				
				String commentaireAvant = rset.getString("Commentaire_Avant");				
				
				if (commentaireAvant.length()>0) {
				
					String tabCom[] = commentaireAvant.split("\n");
					
					for (int i=0; i<tabCom.length; i++) {
					
						LigneDevis ld = new LigneDevis();
						ld.setType('C');
						ld.setDesignation(tabCom[i]);
						ld.setSousTotal(montantBase);
						lignes.add(ld);
					}
				}
				
				LigneDevis ld = new LigneDevis();
        
				String libelle = rset.getString("Libelle");
				
				if (libelle.length()>0) {
					libelle = "\n"+libelle;
				}			
				
				ld.setReference(rset.getString("Reference"));
				ld.setDesignation(rset.getString("Designation") + libelle);

				ld.setQuantite(rset.getDouble("Quantite"));
				ld.setPrixUnitaire(rset.getDouble("Prix"));
				ld.setRistourne(rset.getDouble("Ristourne"));
				ld.setUnite(rset.getString("Unite"));
				ld.setNumLot(rset.getString("Num_Lot"));
				ld.setNbPieces(rset.getInt("Nb_Pieces"));
				ld.setDatePeremption(rset.getLong("Date_Peremption"));
				ld.setType('A');				
				
				if (ld.ristourne!=0) rist = true;
				if (!ld.unite.equals("U")) unite = true;
				if (!ld.num_lot.equals("")) numLot = true;
				if (ld.nb_pieces != 0) nbPieces = true;
				if (ld.date_peremption != 0) datePeremption = true;
				
				ld.setMontant(ld.prixUnitaire * ld.quantite * (1-ld.ristourne/100));
				
				montantBase += ld.montant;
				
				ld.setSousTotal(montantBase);
				
				lignes.add(ld);
				
				
				String commentaireApres = rset.getString("Commentaire");				
				
				if (commentaireApres.length()>0) {
				
					String tabCom[] = commentaireApres.split("\n");
					
					for (int i=0; i<tabCom.length; i++) {
					
						LigneDevis lc = new LigneDevis();
						lc.setType('C');
						lc.setDesignation(tabCom[i]);
						lc.setSousTotal(montantBase);
						lignes.add(lc);
					}
				}
				
				
				if (rset.getString("Type_Ligne").equalsIgnoreCase("S")) {					
				
					// rcupration infos supplmentaires si existent
					psInfosSup.setString(1, ld.reference);
					ResultSet rsIS = psInfosSup.executeQuery();

					if (rsIS.next()) {

						ld.setCouleur(rsIS.getString("Couleur"));
						ld.setTaille(rsIS.getString("Taille"));
						
						if (rsIS.getString("Marque").length()>0) {
							ld.setMarque(rsIS.getString("Marque"));
						}
						if (rsIS.getString("Couleur").length()>0) {
							coul = true;
						}

						if (rsIS.getString("Taille").length()>0) {
							tail = true;
						}
						
						if (rsIS.getInt("Imp_Desc1_Devis")==1) {
							ld.setDetail_1(StringUtils.removeHtmlTags(rsIS.getString("Descrip_1")));
						}
						if (rsIS.getInt("Imp_Desc2_Devis")==1) {
							ld.setDetail_2(StringUtils.removeHtmlTags(rsIS.getString("Descrip_2")));
						}

						// gestion de la nomenclature
						if (rsIS.getInt("Imp_Nom_Devis")==1)	{

							psNomenclature.setString(1, ld.reference);
							ResultSet rsN = psNomenclature.executeQuery();

							while (rsN.next()) {
								LigneDevis ln = new LigneDevis();

								ln.setReference(rsN.getString("ArticleComp_Id"));
								ln.setDesignation(rsN.getString("Designation"));
								ln.setQuantite(rsN.getDouble("Quantite"));
								ln.setType('N');
								ln.setSousTotal(montantBase);			

								lignes.add(ln);
							}

							rsN.close();
						}
						
					}
					rsIS.close();								
				}				
			}
			
			
			calc = new Calcul(s, Integer.parseInt(devisId), "Devis");
			ventilTVA = calc.getLignesTVA();

			mRemise = calc.getRemiseM();
			totalBase = (editionTTC)?calc.getTotalTTC():calc.getTotalHT();
			
			totalTVA = calc.getTotalTVA();
			
			tRemiseFP = calc.getPRemise_FP();
			mRemiseFP = calc.getMRemise_FP();
			
			montantTTC = calc.getMontantTTC();
			mEscompte = calc.getEscompteM();
			netAPayer = calc.getMontantNet();
			
			
			rset.close();
			stt.close();			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	
	public double calcSousTotal(int derniereLigne) {
	
		if (derniereLigne<0) 
			return 0;
		return lignes.get(derniereLigne).sousTotal;		
	}
	
	
	
	public int getNbLignes() {
		return lignes.size();
	}
	
	

} // fin DataDevis
