/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Informations utiles pour l'edition de la facture
 */

package org.opensi.facturation.actions.documents.modeles;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.calcul.CalculVentilTVA;
import org.opensi.util.tools.StringUtils;


public class DataFactureFournisseur {

	private DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
	private DecimalFormat numFormat2 = new DecimalFormat("0.00");
	private DecimalFormat numFormatQte = new DecimalFormat("0.##");
	private SimpleDateFormat formatDate = new SimpleDateFormat("dd.MM.yy");

	// liste des articles de la facture

	protected ArrayList<LigneFactureFournisseur> lignes = new ArrayList<LigneFactureFournisseur>(10);

	// infos socit facturante

	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;

	// infos socit facture

	protected String fournisseurId;
	protected String societeFact;
	protected String adresseFact1;
	protected String adresseFact2;
	protected String adresseFact3;
	protected String codePostalFact;
	protected String villeFact;
	protected String paysFact;
	protected String numTvaFournisseur = "";

	// Infos facture

	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;
	protected String numFact;
	protected long dateFact;
	//protected String responsable;
	protected String interlocuteur;
	protected String modeReglement;
	protected long echeance;

	protected String comFin = "";
	protected String mentions = "";
	protected String typeVente;

	protected double tRemise;
	protected double tEscompte = 0;
	protected double mRemise = 0;
	protected double mEscompte = 0;
	protected double fraisPort;
	protected double acompte;
	protected double tauxTvaPort;
	protected double montantBase = 0;
	protected double totalBase = 0;
	protected double totalTVA = 0;
	protected double netAPayer = 0;
	protected double montantTTC = 0;

	protected boolean rist = false;
	protected boolean coul = false;
	protected boolean tail = false;
	protected boolean unite = false;
	protected boolean nbPieces = false;
	protected boolean numLot = false;
	protected boolean datePeremption = false;
	protected boolean logoAdr;
	protected String urlLogo = "";
	protected int nbex;

	protected String refCommande;
	protected String refAffaire;
	protected String refBL;
	
	private Calcul calc;
	protected HashMap<Integer, CalculVentilTVA> ventilTVA;
	

	public DataFactureFournisseur(Session s, String Facture_Id) {

		try {

			dfs2.setDecimalSeparator('.');

			numFormat2.setDecimalFormatSymbols(dfs2);
			numFormatQte.setDecimalFormatSymbols(dfs2);

			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			Statement stt2 = con.createStatement();
			Statement stt3 = con.createStatement();

			String dossier = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossier +".jpg";
			
			ResultSet rset;


			// Elments de la facture

			String reqFacture = "select f.*, coalesce(mr.Libelle,'') as Mode_Reg, c.Civ_Courte, p.Nom_FR as Pays from "+ base +".FACTURE_FOURNISSEUR f";
			reqFacture += " left join "+ base +".MODE_REGLEMENT mr on f.Mode_Reg_Id=mr.Mode_Reg_Id, CIVILITE c, PAYS p";
			reqFacture += " where c.Civ_Id=f.Civ_Inter and f.Code_Pays=p.Code_Pays and f.Facture_Id="+ Facture_Id;
			
			rset = stt.executeQuery(reqFacture);

			rset.next();

			this.numFact = rset.getString("Numero");
			this.dateFact = rset.getLong("Date_Facture");
			this.tEscompte = rset.getDouble("Escompte");
			this.tRemise = rset.getDouble("Remise");
			this.fraisPort = rset.getDouble("Frais_Port");
			this.echeance = rset.getLong("Echeance");
			this.acompte = rset.getDouble("Acompte");
			this.modeReglement = rset.getString("Mode_Reg");
			this.fournisseurId = rset.getString("Fournisseur_Id");
			this.typeVente = rset.getString("Type_Achat");
			this.tauxTvaPort = rset.getDouble("Taux_TVA_Port");

			if (!rset.getString("Commentaires_Fin").equals("")) {
				this.comFin = StringUtils.removeHtmlTags("\n"+ rset.getString("Commentaires_Fin"));
			}
			this.mentions = "\n" + rset.getString("Mentions");

			this.societeFact = rset.getString("Denomination");
			this.adresseFact1 = rset.getString("Adresse_1");
			this.adresseFact2 = rset.getString("Adresse_2");
			this.adresseFact3 = rset.getString("Adresse_3");
			this.codePostalFact = rset.getString("Code_Postal");
			this.villeFact = rset.getString("Ville");
			this.paysFact = rset.getString("Pays");

			if (rset.getString("Nom_Inter").equals("")) {
				this.interlocuteur = "";
			}
			else {
				this.interlocuteur = rset.getString("Civ_Courte") +" "+ rset.getString("Nom_Inter").toUpperCase() + " " + rset.getString("Prenom_Inter");
			}

			rset.close();


			// coordonnes de l'entreprise facturante

	      String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination,";
	      reqFacturante += " s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
	      reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";

			rset = stt.executeQuery(reqFacturante);

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");

			rset.close();

			// rfrences affaire, BL et commandes

			this.refAffaire = "";
			this.refCommande = "";
			this.refBL = "";

			int nbBons = 0;

			// nombre d'exemplaires  sortir

	      if (fournisseurId.equals("")) {
	        this.comFin += "\n\n";
	        this.nbex = 1;
	      }
	      else {

	    	  String reqEx = "select Nb_Ex, Num_TVA_Intra from "+ base +".FICHE_FOURNISSEUR where Fournisseur_Id='"+ fournisseurId +"'";
			  rset = stt.executeQuery(reqEx);

			  if (rset.next()) {
			    this.nbex = rset.getInt("Nb_Ex") + 1;
					this.numTvaFournisseur = rset.getString("Num_TVA_Intra");
			  } else {
				  this.comFin += "\n\n";
				  this.nbex = 1;
				  this.numTvaFournisseur = "";
			  }
			  rset.close();
	      }

			// commentaires sur facture (dossier)

	      String reqCom = "select Logo_Adr from "+ base +".PARAM_DOSSIER";

			rset = stt.executeQuery(reqCom);

			rset.next();

			logoAdr = rset.getInt("Logo_Adr")==1;

			rset.close();
			
			
			// selection des articles appartenant  la facture

			String reqArticles = "select * from "+ base +".LIGNE_FACTURE_FOURNISSEUR where Facture_Id="+ Facture_Id +" order by Rank";
			rset = stt.executeQuery(reqArticles);

			String reqInfosSup = "select coalesce(ca.Libelle,'') as Couleur, coalesce(ta.Libelle,'') as Taille from "+ base +".FICHE_ARTICLE fa";
			reqInfosSup += " left join "+ base +".COULEUR_ARTICLE ca on fa.Couleur_Id=ca.Couleur_Id left join "+ base +".TAILLE_ARTICLE ta on fa.Taille_Id=ta.Taille_Id";
			reqInfosSup += " where fa.Article_Id=?";
			PreparedStatement psInfosSup = con.prepareStatement(reqInfosSup);

			while (rset.next()) {
				
				String commentaireAvant = rset.getString("Commentaire_Avant");				
				
				if (commentaireAvant.length()>0) {
				
					String tabCom[] = commentaireAvant.split("\n");
					
					for (int i=0; i<tabCom.length; i++) {
					
						LigneFactureFournisseur la = new LigneFactureFournisseur();
						la.setType('C');
						la.setDesignation(tabCom[i]);
						la.setSousTotal(montantBase);
						lignes.add(la);
					}
				}

				LigneFactureFournisseur lf = new LigneFactureFournisseur();

				lf.setPrice(rset.getDouble("Prix"));
				lf.setReference(rset.getString("Reference"));
				lf.setRef_Fournisseur(rset.getString("Ref_Fournisseur"));
				lf.setDesignation(rset.getString("Designation"));
				lf.setQte(rset.getDouble("Quantite"));
				lf.setRistourne(rset.getDouble("Ristourne"));
				lf.setTypeLigne(rset.getString("Type_Ligne"));
				lf.setTva(rset.getDouble("Taux_TVA"));
				lf.setMontant(lf.price*lf.qte*(1-lf.ristourne/100));
				lf.setDetail_1("");
				lf.setDetail_2("");
				lf.setRefBL("");
				lf.setUnite(rset.getString("Unite"));
				lf.setNumLot(rset.getString("Num_Lot"));
				lf.setNbPieces(rset.getInt("Nb_Pieces"));
				lf.setDatePeremption(rset.getLong("Date_Peremption"));
				lf.setType('A');
				
				montantBase += lf.montant;
				
				lf.setSousTotal(montantBase);
				
				if (lf.ristourne!=0) { rist = true; }
				if (!lf.unite.equals("U")) unite = true;
				if (!lf.num_lot.equals("")) numLot = true;
				if (lf.nb_pieces != 0) nbPieces = true;
				if (lf.date_peremption != 0) datePeremption = true;

				ResultSet rset2;

				if (nbBons>1) {
					String reqRefBL = "select b.Num_Entier, ab.Quantite, b.Date_Liv from "+ base +".BON_RECEPTION b, "+ base +".LIGNE_BON_RECEPTION ab ";
					reqRefBL += "where b.BR_Id=ab.BR_Id and b.Facture_Id="+ Facture_Id +" and ab.Ref_Ligne="+ rset.getString("Ref_Ligne");

					rset2 = stt2.executeQuery(reqRefBL);

					while (rset2.next()) {
						lf.setRefBL(lf.refBL + formatDate.format(new Date(rset2.getLong("Date_Liv"))) +" BL N\u00B0 "+ rset2.getString("Num_Entier") +" : Qt = "+ numFormatQte.format(rset2.getDouble("Quantite")) +"\n");
					}

					rset2.close();
				}
				
				lignes.add(lf);
				
				
				String commentaireApres = rset.getString("Commentaire");				
				
				if (commentaireApres.length()>0) {
				
					String tabCom[] = commentaireApres.split("\n");
					
					for (int i=0; i<tabCom.length; i++) {
					
						LigneFactureFournisseur lc = new LigneFactureFournisseur();
						lc.setType('C');
						lc.setDesignation(tabCom[i]);
						lc.setSousTotal(montantBase);
						lignes.add(lc);
					}
				}


				if (rset.getString("Type_Ligne").equalsIgnoreCase("S")) {


					psInfosSup.setString(1, lf.reference);
					ResultSet rsIS = psInfosSup.executeQuery();

					if (rsIS.next()) {

						lf.setCouleur(rsIS.getString("Couleur"));
						lf.setTaille(rsIS.getString("Taille"));

						if (rsIS.getString("Couleur").length()>0) {
							coul = true;
						}

						if (rsIS.getString("Taille").length()>0) {
							tail = true;
						}
					}


					rset2 = stt2.executeQuery("select Descrip_1, Descrip_2, Imp_Desc1_Facture, Imp_Desc2_Facture, Imp_Nom_Facture from "+ base +".FICHE_ARTICLE where Article_Id='"+ rset.getString("Reference") +"'");
					rset2.next();

					if (rset2.getInt("Imp_Desc1_Facture")==1) {
						lf.setDetail_1(StringUtils.removeHtmlTags(rset2.getString("Descrip_1")));
					}
					if (rset2.getInt("Imp_Desc2_Facture")==1) {
						lf.setDetail_2(StringUtils.removeHtmlTags(rset2.getString("Descrip_2")));
					}

					// gestion de la nomenclature

					if (rset2.getInt("Imp_Nom_Facture")==1)	{

						ResultSet rset3 = stt3.executeQuery("select n.ArticleComp_Id, n.Quantite, f.Designation from "+ base +".FICHE_ARTICLE f,"+ base +".COMPOSANT_ARTICLE n where f.Article_Id=n.ArticleComp_Id and n.Article_Id='"+ rset.getString("Reference") +"'");

						while (rset3.next()) {
							LigneFactureFournisseur ln = new LigneFactureFournisseur();

							ln.setReference(rset3.getString("ArticleComp_Id"));
							ln.setDesignation(rset3.getString("Designation"));
							ln.setQte(rset3.getDouble("Quantite"));
							ln.setType('N');
							ln.setSousTotal(montantBase);	

							lignes.add(ln);
						}

						rset3.close();
					}

					rset2.close();
				}
				
			}
			
			calc = new Calcul(s, Integer.parseInt(Facture_Id), "Facture_Fournisseur");

			ventilTVA = calc.getLignesTVA();

			mRemise = calc.getRemiseM();
			totalBase = calc.getTotalHT();
			
			totalTVA = calc.getTotalTVA();
			
			montantTTC = calc.getMontantTTC();
			mEscompte = calc.getEscompteM();
			netAPayer = calc.getMontantNet();


			rset.close();
			stt.close();
			stt2.close();
			stt3.close();
			s.closeConnection(con, null);

		} catch(Exception e) { e.printStackTrace();	}

	}
	
	public double calcSousTotal(int derniereLigne) {		
		if (derniereLigne<0) 
			return 0;
		return lignes.get(derniereLigne).sousTotal;		
	}	
	

	public int getNbLignes() {
		return lignes.size();
	}


} // fin DataFactureFournisseur
