/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes d'une ligne de bon de reliquats standard
 */

package org.opensi.facturation.actions.documents.modeles;


import org.opensi.util.tools.Arrondi;
import org.opensi.util.tools.StringUtils;


public class LigneBonReliquats {	

	protected String reference = "";
	protected String designation = "";
	protected String couleur = "";
	protected long dateCommande = 0;
	protected String numCommande = "";
	protected double quantiteCde = 0;
	protected double reliquat = 0;
	protected String unite = "";
	protected double prixUnitaire = 0;
	protected double ristourne = 0;
	protected double montant = 0;
	protected double sousTotal = 0;
	protected String detail_1 = "";
	protected String detail_2 = "";
	protected char type;
	
	
	private Arrondi r = new Arrondi(2);
	
	public void setReference(String reference) {	this.reference = reference;	}
	public void setDesignation(String designation) {	this.designation = StringUtils.removeHtmlTags(designation);	}
	public void setCouleur(String couleur) { this.couleur = couleur; }
	public void setDateCommande(long dateCommande) { this.dateCommande = dateCommande; }
	public void setNumCommande(String numCommande) { this.numCommande = numCommande; }
	public void setQuantiteCde(double quantiteCde) {	this.quantiteCde = quantiteCde;	}
	public void setReliquat(double reliquat) {	this.reliquat = reliquat;	}
	public void setUnite(String unite) { this.unite = unite; }
	public void setPrixUnitaire(double prixUnitaire) {	this.prixUnitaire = prixUnitaire;	}
	public void setRistourne(double ristourne) { this.ristourne = ristourne; }
	public void setMontant(double montant) { this.montant = r.round(montant); }
	public void setSousTotal(double sousTotal) { this.sousTotal = sousTotal; }
	public void setDetail_1(String detail_1) { this.detail_1 = detail_1; }
	public void setDetail_2(String detail_2) { this.detail_2 = detail_2; }
	public void setType(char type) { this.type = type; }
	
}
