/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un palmars fournisseur
 */

package org.opensi.facturation.actions.editions;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;


public class DataPalmaresFournisseur {
	
	// les lignes du palmars fournisseur
	protected ArrayList<LignePalmaresFournisseur> lignes = new ArrayList<LignePalmaresFournisseur>(10);
	
	protected String dossierId;
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String monnaie;

	protected String finPeriodeStr;
	protected String debutPeriodeStr;
	protected String dateCourante;
	
	protected String criteres = "";
	
	protected String familleFournisseur = "";
	protected String typeDetail;
	protected boolean detail;
	protected String titreDetail;
	
	
	public DataPalmaresFournisseur(Session s, long debutPeriode, long finPeriode, int familleId, String typeDetail) {
		
		try {

			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			this.dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			
			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			this.finPeriodeStr = formatDate.format(new Date(finPeriode));
			this.debutPeriodeStr = formatDate.format(new Date(debutPeriode));

			this.typeDetail = typeDetail;
			
			this.detail = !typeDetail.equals("N");
			
			ResultSet rset;
			
			if (familleId != 0) {
				String reqFamille = "select Libelle from "+ base +".FAMILLE_FOURNISSEUR where Famille_Id="+ familleId;
				rset = stt.executeQuery(reqFamille);
				rset.next();
				this.familleFournisseur = rset.getString("Libelle");
				rset.close();
			}
			
			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ base +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";
			rset = stt.executeQuery(reqLeDossier);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.monnaie = rset.getString("Devise");

			rset.close();
		
			String reqFournisseurCA = "select f.Fournisseur_Id, f.Denomination, sum(c.Total_HT) as CA_HT, sum(c.Total_TTC) as CA_TTC from "+ base +".FICHE_FOURNISSEUR f, "+ base +".COMMANDE_FOURNISSEUR c where ";

			if (familleId != 0) {
				reqFournisseurCA += "f.Famille_Id="+ familleId +" and ";
				criteres += "Famille : "+ familleFournisseur;
			}

			reqFournisseurCA += "f.Fournisseur_Id=c.Fournisseur_Id and c.Numero<>0 and c.Date_Commande<="+ finPeriode +" and c.Date_Commande>="+ debutPeriode
				+" group by f.Fournisseur_Id, f.Denomination order by CA_HT desc";

			String reqDetail;

			if (this.typeDetail.equals("D")) {
				titreDetail = " date";
				reqDetail = "select Date_Commande, sum(Total_HT) as CA_HT from "+ base +".COMMANDE_FOURNISSEUR where Fournisseur_Id=? and Date_Commande<="+ finPeriode +" and Date_Commande>="+ debutPeriode +" and Numero<>0 group by Date_Commande order by Date_Commande";
			}
			else {
				String selection;
				String condition;

				if (this.typeDetail.equals("F1")) {
					selection = "coalesce(fa1.Libelle,'') as LblFamille1";
					condition = "LblFamille1";
					titreDetail = " famille 1 d'article";
				} else if (this.typeDetail.equals("F2")) {
					selection = "coalesce(fa1.Libelle,'') as LblFamille1, coalesce(fa2.Libelle,'') as LblFamille2";
					condition = "LblFamille1, LblFamille2";
					titreDetail = " familles 1 et 2 d'article";
				} else if (this.typeDetail.equals("F3")) {
					selection = "coalesce(fa1.Libelle,'') as LblFamille1, coalesce(fa2.Libelle,'') as LblFamille2, coalesce(fa3.Libelle,'') as LblFamille3";
					condition = "LblFamille1, LblFamille2, LblFamille3";
					titreDetail = " familles 1, 2 et 3 d'article";
				} else {
					selection = "coalesce(a.Article_Id,'') as LblArticle";
					condition = "LblArticle";
					titreDetail = " article";
				}

				reqDetail = "select "+ selection +", sum(Montant_Ligne * (1-Remise/100)) as CA_HT from "+ base +".COMMANDE_FOURNISSEUR c, "+ base +".LIGNE_COMMANDE_FOURNISSEUR ac"
					+" left join "+ base +".FICHE_ARTICLE a on ac.Reference=a.Article_Id"
					+" left join "+ base +".FAMILLE_ARTICLE fa1 on a.Famille_1=fa1.Famille_Id"
					+" left join "+ base +".FAMILLE_ARTICLE fa2 on a.Famille_2=fa2.Famille_Id"
					+" left join "+ base +".FAMILLE_ARTICLE fa3 on a.Famille_3=fa3.Famille_Id"
					+" where c.Fournisseur_Id=? and c.Numero<>0 and c.Date_Commande<="+ finPeriode +" and c.Date_Commande>="+ debutPeriode +" and c.Commande_Id=ac.Commande_Id group by "+ condition +" order by "+ condition;
			}
			
			PreparedStatement psDetail = con.prepareStatement(reqDetail);
			rset = stt.executeQuery(reqFournisseurCA);
			while (rset.next()) {
				if (detail) {
					psDetail.setString(1, rset.getString("Fournisseur_Id"));

					ResultSet rset2 = psDetail.executeQuery();

					String gp;

					if (rset2.next()) {
						LignePalmaresFournisseur lp = new LignePalmaresFournisseur();
						
						lp.setNumero(rset.getString("Fournisseur_Id"));
						lp.setFournisseur(rset.getString("Denomination"));
						lp.setCaHT(rset.getDouble("CA_HT"));
						lp.setCaTTC(rset.getDouble("CA_TTC"));
						lp.setDetailSeulement(false); // on affichera une ligne complte
						
						if (this.typeDetail.equals("D")) {
							gp = formatDate.format(new Date(rset2.getLong("Date_Commande")));
						}
						else {
							if (this.typeDetail.equals("F1")) {
								gp = rset2.getString("LblFamille1");
							} else if (this.typeDetail.equals("F2")) {
								gp = rset2.getString("LblFamille1");
								if (!gp.isEmpty() && !rset2.getString("LblFamille2").isEmpty()) {
									gp +=", "+ rset2.getString("LblFamille2");
								}
							} else if (this.typeDetail.equals("F3")) {
								gp = rset2.getString("LblFamille1");
								if (!gp.isEmpty() && !rset2.getString("LblFamille2").isEmpty()) {
									gp +=", "+ rset2.getString("LblFamille2");
									if (!gp.isEmpty() && !rset2.getString("LblFamille3").isEmpty()) {
										gp +=", "+ rset2.getString("LblFamille3");
									}
								}
							} else {
								gp = rset2.getString("LblArticle");
							}
						}
						lp.setGroupe(gp);
						lp.setHtGp(rset2.getDouble("CA_HT"));
						
						lignes.add(lp);
					}
					
					while (rset2.next()) {
						LignePalmaresFournisseur lp = new LignePalmaresFournisseur();
						
						lp.setNumero(rset.getString("Fournisseur_Id"));
						lp.setFournisseur(rset.getString("Denomination"));
						lp.setCaHT(rset.getDouble("CA_HT"));
						lp.setCaTTC(rset.getDouble("CA_TTC"));
						lp.setDetailSeulement(true); // on n'affichera que les dtails
						
						if (this.typeDetail.equals("D")) {
							gp = formatDate.format(new Date(rset2.getLong("Date_Commande")));
						}
						else {
							if (this.typeDetail.equals("F1")) {
								gp = rset2.getString("LblFamille1");
							} else if (this.typeDetail.equals("F2")) {
								gp = rset2.getString("LblFamille1");
								if (!gp.isEmpty() && !rset2.getString("LblFamille2").isEmpty()) {
									gp +=", "+ rset2.getString("LblFamille2");
								}
							} else if (this.typeDetail.equals("F3")) {
								gp = rset2.getString("LblFamille1");
								if (!gp.isEmpty() && !rset2.getString("LblFamille2").isEmpty()) {
									gp +=", "+ rset2.getString("LblFamille2");
									if (!gp.isEmpty() && !rset2.getString("LblFamille3").isEmpty()) {
										gp +=", "+ rset2.getString("LblFamille3");
									}
								}
							} else {
								gp = rset2.getString("LblArticle");
							}
						}
						lp.setGroupe(gp);
						lp.setHtGp(rset2.getDouble("CA_HT"));
						
						lignes.add(lp);
					}
				}
				else {
					LignePalmaresFournisseur lp = new LignePalmaresFournisseur();
					
					lp.setNumero(rset.getString("Fournisseur_Id"));
					lp.setFournisseur(rset.getString("Denomination"));
					lp.setCaHT(rset.getDouble("CA_HT"));
					lp.setCaTTC(rset.getDouble("CA_TTC"));
					lp.setDetailSeulement(false); // on affichera une ligne complte
					lp.setGroupe(""); // initialisation
					lp.setHtGp(0); // initialisation
					
					lignes.add(lp);
				}
			}
			
			
			rset.close();
			stt.close();
			s.closeConnection(con, null);
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public int getNbLignes() {
		return lignes.size();
	}


} // fin DataPalmaresFournisseur
