/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un listing inventaire
 */

package org.opensi.facturation.actions.inventaire;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;

public class CsvInventaire {
	
	public CsvInventaire(String buffer, String fichier, DataInventaire di) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("R\u00E9f\u00E9rence");
		lf.addToLine("D\u00E9signation");
		lf.addToLine("Unit\u00E9");
		lf.addToLine("Quantit\u00E9 informatique");
		lf.addToLine("Quantit\u00E9 physique");
		if (di.typeEdition.equals("R")) { lf.addToLine("Valorisation"); }
		
		int nbLignes = di.getNbLignes();				
		for (int j=0; j<nbLignes; j++) {
			LigneInventaire li = di.lignes.get(j);
			
			lf.newLine();
			lf.addToLine("\""+li.refArticle+"\"");
			lf.addToLine("\""+li.designation+"\"");
			lf.addToLine("\""+li.unite+"\"");
			lf.addToLine(("" + li.stockInfo).replaceAll("\\.", ","));
			lf.addToLine(("" + li.stockPhysique).replaceAll("\\.", ","));
			if (di.typeEdition.equals("R")) { lf.addToLine(("" + li.valorisation).replaceAll("\\.", ",")); }
		}
		
		lf.write(buffer, fichier, true);
	}



} // fin CsvInventaire
