/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.facturation.actions.majtarifs;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;

public class MajTarifs {
	
	//les lignes de l'article
	protected ArrayList<LigneArticle> lignesTarifs = new ArrayList<LigneArticle>(10);
	protected ArrayList<LigneTarifSpecifique> lignesTarifsSpecifiques = new ArrayList<LigneTarifSpecifique>(10);
	
	protected int element;
	protected boolean repercution;
	protected boolean perte;
	
	/* FONCTIONS APPELEES DEPUIS LES TEMPLATES */
	public int getNbArticles() { return this.lignesTarifs.size(); }
	public String getRefArticle(int rg) { return this.lignesTarifs.get(rg).refArticle; }
	public double getAncPrixAchat(int rg) { return this.lignesTarifs.get(rg).ancPrixAchat; }
	public double getNvPrixAchat(int rg) { return this.lignesTarifs.get(rg).nvPrixAchat; }
	public double getAncCoeff1(int rg) { return this.lignesTarifs.get(rg).ancCoeff1; }
	public double getNvCoeff1(int rg) { return this.lignesTarifs.get(rg).nvCoeff1; }
	public double getAncCoeff2(int rg) { return this.lignesTarifs.get(rg).ancCoeff2; }
	public double getNvCoeff2(int rg) { return this.lignesTarifs.get(rg).nvCoeff2; }
	public double getAncCoeff3(int rg) { return this.lignesTarifs.get(rg).ancCoeff3; }
	public double getNvCoeff3(int rg) { return this.lignesTarifs.get(rg).nvCoeff3; }
	public double getAncCoeff4(int rg) { return this.lignesTarifs.get(rg).ancCoeff4; }
	public double getNvCoeff4(int rg) { return this.lignesTarifs.get(rg).nvCoeff4; }
	public double getAncCoeff5(int rg) { return this.lignesTarifs.get(rg).ancCoeff5; }
	public double getNvCoeff5(int rg) { return this.lignesTarifs.get(rg).nvCoeff5; }
	public double getAncPVHT1(int rg) { return this.lignesTarifs.get(rg).ancTarifHT1; }
	public double getNvPVHT1(int rg) { return this.lignesTarifs.get(rg).nvTarifHT1; }
	public double getAncPVHT2(int rg) { return this.lignesTarifs.get(rg).ancTarifHT2; }
	public double getNvPVHT2(int rg) { return this.lignesTarifs.get(rg).nvTarifHT2; }
	public double getAncPVHT3(int rg) { return this.lignesTarifs.get(rg).ancTarifHT3; }
	public double getNvPVHT3(int rg) { return this.lignesTarifs.get(rg).nvTarifHT3; }
	public double getAncPVHT4(int rg) { return this.lignesTarifs.get(rg).ancTarifHT4; }
	public double getNvPVHT4(int rg) { return this.lignesTarifs.get(rg).nvTarifHT4; }
	public double getAncPVHT5(int rg) { return this.lignesTarifs.get(rg).ancTarifHT5; }
	public double getNvPVHT5(int rg) { return this.lignesTarifs.get(rg).nvTarifHT5; }
	public double getAncPVTTC1(int rg) { return this.lignesTarifs.get(rg).ancTarifTTC1; }
	public double getNvPVTTC1(int rg) { return this.lignesTarifs.get(rg).nvTarifTTC1; }
	public double getAncPVTTC2(int rg) { return this.lignesTarifs.get(rg).ancTarifTTC2; }
	public double getNvPVTTC2(int rg) { return this.lignesTarifs.get(rg).nvTarifTTC2; }
	public double getAncPVTTC3(int rg) { return this.lignesTarifs.get(rg).ancTarifTTC3; }
	public double getNvPVTTC3(int rg) { return this.lignesTarifs.get(rg).nvTarifTTC3; }
	public double getAncPVTTC4(int rg) { return this.lignesTarifs.get(rg).ancTarifTTC4; }
	public double getNvPVTTC4(int rg) { return this.lignesTarifs.get(rg).nvTarifTTC4; }
	public double getAncPVTTC5(int rg) { return this.lignesTarifs.get(rg).ancTarifTTC5; }
	public double getNvPVTTC5(int rg) { return this.lignesTarifs.get(rg).nvTarifTTC5; }
	public double getAncMarge1(int rg) { return this.lignesTarifs.get(rg).ancMarge1; }
	public double getNvMarge1(int rg) { return this.lignesTarifs.get(rg).nvMarge1; }
	public double getAncMarge2(int rg) { return this.lignesTarifs.get(rg).ancMarge2; }
	public double getNvMarge2(int rg) { return this.lignesTarifs.get(rg).nvMarge2; }
	public double getAncMarge3(int rg) { return this.lignesTarifs.get(rg).ancMarge3; }
	public double getNvMarge3(int rg) { return this.lignesTarifs.get(rg).nvMarge3; }
	public double getAncMarge4(int rg) { return this.lignesTarifs.get(rg).ancMarge4; }
	public double getNvMarge4(int rg) { return this.lignesTarifs.get(rg).nvMarge4; }
	public double getAncMarge5(int rg) { return this.lignesTarifs.get(rg).ancMarge5; }
	public double getNvMarge5(int rg) { return this.lignesTarifs.get(rg).nvMarge5; }
	public double getTauxTVA(int rg) { return this.lignesTarifs.get(rg).tauxTVA; }
	
	public String getPerte() { return (this.perte?"y":"n"); }
	/* --------------------------------------- */
	
	
	public MajTarifs(String s, int element,
						String pourcPVT1, String pourcPVT2, String pourcPVT3, String pourcPVT4, String pourcPVT5, String pourcPVTS,
						String eurPVT1, String eurPVT2, String eurPVT3, String eurPVT4, String eurPVT5,
						String coeffT1, String coeffT2, String coeffT3, String coeffT4, String coeffT5,
						String margeT1, String margeT2, String margeT3, String margeT4, String margeT5,
						boolean repercution, int typeRepercution, boolean chkTarifsSpec, int typeRepercutionSpec, int modeCalcul, String valeur,
						int critere, String refArticle, int famille1, int famille2, int famille3, int marque, String fournisseur,
						boolean valider, boolean calculerTarifsSpec, int rgDebut) {

		this(org.experlog.openeas.api.Session.findClient(s), element,
						pourcPVT1, pourcPVT2, pourcPVT3, pourcPVT4, pourcPVT5, pourcPVTS,
						eurPVT1, eurPVT2, eurPVT3, eurPVT4, eurPVT5,
						coeffT1, coeffT2, coeffT3, coeffT4, coeffT5,
						margeT1, margeT2, margeT3, margeT4, margeT5,
						repercution, typeRepercution, chkTarifsSpec, typeRepercutionSpec, modeCalcul, valeur,
						critere, refArticle, famille1, famille2, famille3, marque, fournisseur,
						valider, calculerTarifsSpec, rgDebut);
		
	}
	
	public MajTarifs(Session s, int element,
			String pourcPVT1, String pourcPVT2, String pourcPVT3, String pourcPVT4, String pourcPVT5, String pourcPVTS,
			String eurPVT1, String eurPVT2, String eurPVT3, String eurPVT4, String eurPVT5,
			String coeffT1, String coeffT2, String coeffT3, String coeffT4, String coeffT5,
			String margeT1, String margeT2, String margeT3, String margeT4, String margeT5,
			boolean repercution, int typeRepercution, boolean chkTarifsSpec, int typeRepercutionSpec, int modeCalcul, String valeur,
			int critere, String refArticle, int famille1, int famille2, int famille3, int marque, String fournisseur,
			boolean valider, boolean calculerTarifsSpec, int rgDebut) {

		try {
			
			// Ces 2 variables sont rendues accessibles pour l'dition PDF car elles permettent
			// de conditionner l'affichage des colonnes selon l'lment choisi,
			// et si l'lment est le Prix d'Achat, les colonnes peuvent  nouveau
			// diffrer selon qu'il y ait rpercution sur les PV ou non
			this.element = element;
			this.repercution = repercution;
			
			this.perte = false;
			
			boolean calculerTarifsSpecifiques = ((valider || calculerTarifsSpec) && (((element==0 || element==1) && (!pourcPVTS.equals(""))) || (element==4)));

			Connection con = s.getConnection(null);	
			String base = s.getCookie().get("BaseDossier");
			
			String reqArticles = "select f.Article_Id, f.Tarif_1, f.Tarif_2, f.Tarif_3, f.Tarif_4, f.Tarif_5,";
			reqArticles += " f.Tarif_1_TTC, f.Tarif_2_TTC, f.Tarif_3_TTC, f.Tarif_4_TTC, f.Tarif_5_TTC,";
			reqArticles += " f.Coeff_1, f.Coeff_2, f.Coeff_3, f.Coeff_4, f.Coeff_5,";
			reqArticles += " f.Marge_1, f.Marge_2, f.Marge_3, f.Marge_4, f.Marge_5,";
			reqArticles += " f.Prix_Achat, f.Code_TVA";
			reqArticles += " from "+ base +".FICHE_ARTICLE f";
	
			if (critere==3) {
				reqArticles += ", "+ base +".FOURNISSEUR_ARTICLE fa where f.Article_Id=fa.Article_Id";
			} else {
				reqArticles += " where 1";
			}
	
			switch (critere) {
				case 1:
					reqArticles += " and Article_Id like ?";
					break;
				
				case 2:
					if (famille1 != 0) {
						reqArticles += " and Famille_1=?";
						if (famille2 != 0) {
							reqArticles += " and Famille_2=?";
							if (famille3 != 0) {
								reqArticles += " and Famille_3=?";
							}
						}
					}
					if (marque != 0) {
						reqArticles += " and Marque_Id=?";
					}
					break;
				
				case 3:
					reqArticles += " and fa.Fournisseur_Id=?";
					break;
			}
			
			if (rgDebut!=-1) {
				reqArticles += " limit "+ rgDebut +",30";
			}

			PreparedStatement psArticles = con.prepareStatement(reqArticles);
			
			switch (critere) {
				case 1:
					psArticles.setString(1, refArticle+"%");
					break;
				
				case 2:
					int i=1;
					if (famille1 != 0) {
						psArticles.setInt(i, famille1);
						i++;
						if (famille2 != 0) {
							psArticles.setInt(i, famille2);
							i++;
							if (famille3 != 0) {
								psArticles.setInt(i, famille3);
								i++;
							}
						}
					}
					if (marque != 0) {
						psArticles.setInt(i, marque);
					}
					break;
				
				case 3:
					psArticles.setString(1, fournisseur);
					break;
			}
			
			String reqTVA = "select Taux_TVA from "+ base +".TAUX_TVA where Code_TVA=?";
			PreparedStatement psTVA = con.prepareStatement(reqTVA);
			
			String reqTarifsSpecifiques = "select fc.Denomination, ca.Client_Id, ca.Prix, ca.Coeff, ca.Prix_TTC, ca.Marge, fc.Code_Tarif";
			reqTarifsSpecifiques += " from "+ base +".CLIENT_ARTICLE ca, "+ base +".FICHE_CLIENT fc, "+ base +".FICHE_ARTICLE fa";
			reqTarifsSpecifiques += " where ca.Client_Id=fc.Client_Id and ca.Article_Id=fa.Article_Id and ca.Article_Id=?";
			
			PreparedStatement psTarifsSpecifiques = con.prepareStatement(reqTarifsSpecifiques);
			
			ResultSet rset = psArticles.executeQuery();
			
			while (rset.next()) {
				
				psTVA.setDouble(1,rset.getDouble("Code_TVA"));
				ResultSet rset2 = psTVA.executeQuery();
				rset2.next();
				double tauxTVA = rset2.getDouble("Taux_TVA");
				rset2.close();
				
				String articleId = rset.getString("Article_Id");
				double ancPrixAchat = rset.getDouble("Prix_Achat");
				double nvPrixAchat = rset.getDouble("Prix_Achat");
				double ancCoeff1 = rset.getDouble("Coeff_1");
				double nvCoeff1 = rset.getDouble("Coeff_1");
				double ancCoeff2 = rset.getDouble("Coeff_2");
				double nvCoeff2 = rset.getDouble("Coeff_2");
				double ancCoeff3 = rset.getDouble("Coeff_3");
				double nvCoeff3 = rset.getDouble("Coeff_3");
				double ancCoeff4 = rset.getDouble("Coeff_4");
				double nvCoeff4 = rset.getDouble("Coeff_4");
				double ancCoeff5 = rset.getDouble("Coeff_5");
				double nvCoeff5 = rset.getDouble("Coeff_5");
				double ancTarifHT1 = rset.getDouble("Tarif_1");
				double nvTarifHT1 = rset.getDouble("Tarif_1");
				double ancTarifHT2 = rset.getDouble("Tarif_2");
				double nvTarifHT2 = rset.getDouble("Tarif_2");
				double ancTarifHT3 = rset.getDouble("Tarif_3");
				double nvTarifHT3 = rset.getDouble("Tarif_3");
				double ancTarifHT4 = rset.getDouble("Tarif_4");
				double nvTarifHT4 = rset.getDouble("Tarif_4");
				double ancTarifHT5 = rset.getDouble("Tarif_5");
				double nvTarifHT5 = rset.getDouble("Tarif_5");
				double ancTarifTTC1 = rset.getDouble("Tarif_1_TTC");
				double nvTarifTTC1 = rset.getDouble("Tarif_1_TTC");
				double ancTarifTTC2 = rset.getDouble("Tarif_2_TTC");
				double nvTarifTTC2 = rset.getDouble("Tarif_2_TTC");
				double ancTarifTTC3 = rset.getDouble("Tarif_3_TTC");
				double nvTarifTTC3 = rset.getDouble("Tarif_3_TTC");
				double ancTarifTTC4 = rset.getDouble("Tarif_4_TTC");
				double nvTarifTTC4 = rset.getDouble("Tarif_4_TTC");
				double ancTarifTTC5 = rset.getDouble("Tarif_5_TTC");
				double nvTarifTTC5 = rset.getDouble("Tarif_5_TTC");
				double ancMarge1 = rset.getDouble("Marge_1");
				double nvMarge1 = rset.getDouble("Marge_1");
				double ancMarge2 = rset.getDouble("Marge_2");
				double nvMarge2 = rset.getDouble("Marge_2");
				double ancMarge3 = rset.getDouble("Marge_3");
				double nvMarge3 = rset.getDouble("Marge_3");
				double ancMarge4 = rset.getDouble("Marge_4");
				double nvMarge4 = rset.getDouble("Marge_4");
				double ancMarge5 = rset.getDouble("Marge_5");
				double nvMarge5 = rset.getDouble("Marge_5");
				
				// Les PVs, Coeffs et Marges ne seront modifies que pour les articles
				// ayant un PA > 0
				switch (element) {
					case 0: // PV HT
					if (nvPrixAchat>0) {
						// mise  jour des prix de vente ht
						
						boolean majT1 = true;
						boolean majT2 = true;
						boolean majT3 = true;
						boolean majT4 = true;
						boolean majT5 = true;
						
						if (!pourcPVT1.equals("")) {
							double val = Double.parseDouble(pourcPVT1);
							nvTarifHT1 *= (val<0?1-(val*-1)/100:1+val/100);
						} else if (!eurPVT1.equals("")) {
							double val = Double.parseDouble(eurPVT1);
							nvTarifHT1 += val;
							if (nvTarifHT1<0) { nvTarifHT1=0; }
						} else {
							majT1 = false;
						}
						
						if (!pourcPVT2.equals("")) {
							double val = Double.parseDouble(pourcPVT2);
							nvTarifHT2 *= (val<0?1-(val*-1)/100:1+val/100);
						} else if (!eurPVT2.equals("")) {
							double val = Double.parseDouble(eurPVT2);
							nvTarifHT2 += val;
							if (nvTarifHT2<0) { nvTarifHT2=0; }
						} else {
							majT2 = false;
						}
						
						if (!pourcPVT3.equals("")) {
							double val = Double.parseDouble(pourcPVT3);
							nvTarifHT3 *= (val<0?1-(val*-1)/100:1+val/100);
						} else if (!eurPVT3.equals("")) {
							double val = Double.parseDouble(eurPVT3);
							nvTarifHT3 += val;
							if (nvTarifHT3<0) { nvTarifHT3=0; }
						} else {
							majT3 = false;
						}
						
						if (!pourcPVT4.equals("")) {
							double val = Double.parseDouble(pourcPVT4);
							nvTarifHT4 *= (val<0?1-(val*-1)/100:1+val/100);
						} else if (!eurPVT4.equals("")) {
							double val = Double.parseDouble(eurPVT4);
							nvTarifHT4 += val;
							if (nvTarifHT4<0) { nvTarifHT4=0; }
						} else {
							majT4 = false;
						}
						
						if (!pourcPVT5.equals("")) {
							double val = Double.parseDouble(pourcPVT5);
							nvTarifHT5 *= (val<0?1-(val*-1)/100:1+val/100);
						} else if (!eurPVT5.equals("")) {
							double val = Double.parseDouble(eurPVT5);
							nvTarifHT5 += val;
							if (nvTarifHT5<0) { nvTarifHT5=0; }
						} else {
							majT5 = false;
						}
						
						// mise  jour des prix de vente ttc, coeffs et marges
						if (majT1) {
							nvTarifTTC1=nvTarifHT1*(1+tauxTVA/100);
							nvCoeff1=nvTarifHT1/nvPrixAchat;
							nvMarge1=(nvTarifHT1==0?100:(nvTarifHT1-nvPrixAchat)/nvTarifHT1*100);
						}
						if (majT2) {
							nvTarifTTC2=nvTarifHT2*(1+tauxTVA/100);
							nvCoeff2=nvTarifHT2/nvPrixAchat;
							nvMarge2=(nvTarifHT2==0?100:(nvTarifHT2-nvPrixAchat)/nvTarifHT2*100);
						}
						if (majT3) {
							nvTarifTTC3=nvTarifHT3*(1+tauxTVA/100);
							nvCoeff3=nvTarifHT3/nvPrixAchat;
							nvMarge3=(nvTarifHT3==0?100:(nvTarifHT3-nvPrixAchat)/nvTarifHT3*100);
						}
						if (majT4) {
							nvTarifTTC4=nvTarifHT4*(1+tauxTVA/100);
							nvCoeff4=nvTarifHT4/nvPrixAchat;
							nvMarge4=(nvTarifHT4==0?100:(nvTarifHT4-nvPrixAchat)/nvTarifHT4*100);
						}
						if (majT5) {
							nvTarifTTC5=nvTarifHT5*(1+tauxTVA/100);
							nvCoeff5=nvTarifHT5/nvPrixAchat;
							nvMarge5=(nvTarifHT5==0?100:(nvTarifHT5-nvPrixAchat)/nvTarifHT5*100);
						}
					}
					break;
					
					case 1: // PV TTC
					if (nvPrixAchat>0) {
						// mise  jour des prix de vente ttc
						
						boolean majT1 = true;
						boolean majT2 = true;
						boolean majT3 = true;
						boolean majT4 = true;
						boolean majT5 = true;
						
						if (!pourcPVT1.equals("")) {
							double val = Double.parseDouble(pourcPVT1);
							nvTarifTTC1 *= (val<0?1-(val*-1)/100:1+val/100);
						} else if (!eurPVT1.equals("")) {
							double val = Double.parseDouble(eurPVT1);
							nvTarifTTC1 += val;
							if (nvTarifTTC1<0) { nvTarifTTC1=0; }
						} else {
							majT1 = false;
						}
						
						if (!pourcPVT2.equals("")) {
							double val = Double.parseDouble(pourcPVT2);
							nvTarifTTC2 *= (val<0?1-(val*-1)/100:1+val/100);
						} else if (!eurPVT2.equals("")) {
							double val = Double.parseDouble(eurPVT2);
							nvTarifTTC2 += val;
							if (nvTarifTTC2<0) { nvTarifTTC2=0; }
						} else {
							majT2 = false;
						}
						
						if (!pourcPVT3.equals("")) {
							double val = Double.parseDouble(pourcPVT3);
							nvTarifTTC3 *= (val<0?1-(val*-1)/100:1+val/100);
						} else if (!eurPVT3.equals("")) {
							double val = Double.parseDouble(eurPVT3);
							nvTarifTTC3 += val;
							if (nvTarifTTC3<0) { nvTarifTTC3=0; }
						} else {
							majT3 = false;
						}
						
						if (!pourcPVT4.equals("")) {
							double val = Double.parseDouble(pourcPVT4);
							nvTarifTTC4 *= (val<0?1-(val*-1)/100:1+val/100);
						} else if (!eurPVT4.equals("")) {
							double val = Double.parseDouble(eurPVT4);
							nvTarifTTC4 += val;
							if (nvTarifTTC4<0) { nvTarifTTC4=0; }
						} else {
							majT4 = false;
						}
						
						if (!pourcPVT5.equals("")) {
							double val = Double.parseDouble(pourcPVT5);
							nvTarifTTC5 *= (val<0?1-(val*-1)/100:1+val/100);
						} else if (!eurPVT5.equals("")) {
							double val = Double.parseDouble(eurPVT5);
							nvTarifTTC5 += val;
							if (nvTarifTTC5<0) { nvTarifTTC5=0; }
						} else {
							majT5 = false;
						}
						

						// mise  jour des prix de vente ht, coeffs et marges
						if (majT1) {
							nvTarifHT1=nvTarifTTC1/(1+tauxTVA/100);
							nvCoeff1=nvTarifHT1/nvPrixAchat;
							nvMarge1=(nvTarifHT1==0?100:(nvTarifHT1-nvPrixAchat)/nvTarifHT1*100);
						}
						if (majT2) {
							nvTarifHT2=nvTarifTTC2/(1+tauxTVA/100);
							nvCoeff2=nvTarifHT2/nvPrixAchat;
							nvMarge2=(nvTarifHT2==0?100:(nvTarifHT2-nvPrixAchat)/nvTarifHT2*100);
						}
						if (majT3) {
							nvTarifHT3=nvTarifTTC3/(1+tauxTVA/100);
							nvCoeff3=nvTarifHT3/nvPrixAchat;
							nvMarge3=(nvTarifHT3==0?100:(nvTarifHT3-nvPrixAchat)/nvTarifHT3*100);
						}
						if (majT4) {
							nvTarifHT4=nvTarifTTC4/(1+tauxTVA/100);
							nvCoeff4=nvTarifHT4/nvPrixAchat;
							nvMarge4=(nvTarifHT4==0?100:(nvTarifHT4-nvPrixAchat)/nvTarifHT4*100);
						}
						if (majT5) {
							nvTarifHT5=nvTarifTTC5/(1+tauxTVA/100);
							nvCoeff5=nvTarifHT5/nvPrixAchat;
							nvMarge5=(nvTarifHT5==0?100:(nvTarifHT5-nvPrixAchat)/nvTarifHT5*100);
						}
					}
					break;
					
					case 2: // Coeff
					if (nvPrixAchat>0) {
						// mise  jour des coefficients,
						// prix de vente ht, ttc et marges
						if (!coeffT1.equals("")) {
							nvCoeff1 = Double.parseDouble(coeffT1);
							nvTarifHT1=nvPrixAchat*nvCoeff1;
							nvTarifTTC1=nvTarifHT1*(1+tauxTVA/100);
							nvMarge1=(nvTarifHT1==0?100:(nvTarifHT1-nvPrixAchat)/nvTarifHT1*100);
						}
						if (!coeffT2.equals("")) {
							nvCoeff2 = Double.parseDouble(coeffT2);
							nvTarifHT2=nvPrixAchat*nvCoeff2;
							nvTarifTTC2=nvTarifHT2*(1+tauxTVA/100);
							nvMarge2=(nvTarifHT2==0?100:(nvTarifHT2-nvPrixAchat)/nvTarifHT2*100);
						}
						if (!coeffT3.equals("")) {
							nvCoeff3 = Double.parseDouble(coeffT3);
							nvTarifHT3=nvPrixAchat*nvCoeff3;
							nvTarifTTC3=nvTarifHT3*(1+tauxTVA/100);
							nvMarge3=(nvTarifHT3==0?100:(nvTarifHT3-nvPrixAchat)/nvTarifHT3*100);
						}
						if (!coeffT4.equals("")) {
							nvCoeff4 = Double.parseDouble(coeffT4);
							nvTarifHT4=nvPrixAchat*nvCoeff4;
							nvTarifTTC4=nvTarifHT4*(1+tauxTVA/100);
							nvMarge4=(nvTarifHT4==0?100:(nvTarifHT4-nvPrixAchat)/nvTarifHT4*100);
						}
						if (!coeffT5.equals("")) {
							nvCoeff5 = Double.parseDouble(coeffT5);
							nvTarifHT5=nvPrixAchat*nvCoeff5;
							nvTarifTTC5=nvTarifHT5*(1+tauxTVA/100);
							nvMarge5=(nvTarifHT5==0?100:(nvTarifHT5-nvPrixAchat)/nvTarifHT5*100);
						}
					}
					break;
					
					case 3: // Marge HT
					if (nvPrixAchat>0) {
						// mise  jour des marges,
						// prix de vente ht, ttc et coeffs
						if (!margeT1.equals("")) {
							nvMarge1 = Double.parseDouble(margeT1);
							nvTarifHT1=nvPrixAchat/(1-nvMarge1/100);
							nvTarifTTC1=nvTarifHT1*(1+tauxTVA/100);
							nvCoeff1=nvTarifHT1/nvPrixAchat;
						}
						if (!margeT2.equals("")) {
							nvMarge2 = Double.parseDouble(margeT2);
							nvTarifHT2=nvPrixAchat/(1-nvMarge2/100);
							nvTarifTTC2=nvTarifHT2*(1+tauxTVA/100);
							nvCoeff2=nvTarifHT2/nvPrixAchat;
						}
						if (!margeT3.equals("")) {
							nvMarge3 = Double.parseDouble(margeT3);
							nvTarifHT3=nvPrixAchat/(1-nvMarge3/100);
							nvTarifTTC3=nvTarifHT3*(1+tauxTVA/100);
							nvCoeff3=nvTarifHT3/nvPrixAchat;
						}
						if (!margeT4.equals("")) {
							nvMarge4 = Double.parseDouble(margeT4);
							nvTarifHT4=nvPrixAchat/(1-nvMarge4/100);
							nvTarifTTC4=nvTarifHT4*(1+tauxTVA/100);
							nvCoeff4=nvTarifHT4/nvPrixAchat;
						}
						if (!margeT5.equals("")) {
							nvMarge5 = Double.parseDouble(margeT5);
							nvTarifHT5=nvPrixAchat/(1-nvMarge5/100);
							nvTarifTTC5=nvTarifHT5*(1+tauxTVA/100);
							nvCoeff5=nvTarifHT5/nvPrixAchat;
						}
					}
					break;
					
					case 4: // PA HT
					// mise  jour des prix d'achat ht
					double val = Double.parseDouble(valeur);
					if (modeCalcul==0) {
						nvPrixAchat *= (val<0?1-(val*-1)/100:1+val/100);
					} else {
						nvPrixAchat += val;
						if (nvPrixAchat<0) { nvPrixAchat=0; }
					}
					
					// si rpercution sur les tarifs 1  5 des prix de ventes...
					if (repercution) {
						switch (typeRepercution) {
							case 0: // en fonction des coefficients
								nvTarifHT1=nvPrixAchat*nvCoeff1;
								nvTarifTTC1=nvTarifHT1*(1+tauxTVA/100);
								nvMarge1=(nvTarifHT1==0?100:(nvTarifHT1-nvPrixAchat)/nvTarifHT1*100);
								nvTarifHT2=nvPrixAchat*nvCoeff2;
								nvTarifTTC2=nvTarifHT2*(1+tauxTVA/100);
								nvMarge2=(nvTarifHT2==0?100:(nvTarifHT2-nvPrixAchat)/nvTarifHT2*100);
								nvTarifHT3=nvPrixAchat*nvCoeff3;
								nvTarifTTC3=nvTarifHT3*(1+tauxTVA/100);
								nvMarge3=(nvTarifHT3==0?100:(nvTarifHT3-nvPrixAchat)/nvTarifHT3*100);
								nvTarifHT4=nvPrixAchat*nvCoeff4;
								nvTarifTTC4=nvTarifHT4*(1+tauxTVA/100);
								nvMarge4=(nvTarifHT4==0?100:(nvTarifHT4-nvPrixAchat)/nvTarifHT4*100);
								nvTarifHT5=nvPrixAchat*nvCoeff5;
								nvTarifTTC5=nvTarifHT5*(1+tauxTVA/100);
								nvMarge5=(nvTarifHT5==0?100:(nvTarifHT5-nvPrixAchat)/nvTarifHT5*100);
							break;
							
							case 1: // en fonction des marges HT
								nvTarifHT1=nvPrixAchat/(1-nvMarge1/100);
								nvTarifTTC1=nvTarifHT1*(1+tauxTVA/100);
								nvCoeff1=(nvPrixAchat==0?0:nvTarifHT1/nvPrixAchat);
								nvTarifHT2=nvPrixAchat/(1-nvMarge2/100);
								nvTarifTTC2=nvTarifHT2*(1+tauxTVA/100);
								nvCoeff2=(nvPrixAchat==0?0:nvTarifHT2/nvPrixAchat);
								nvTarifHT3=nvPrixAchat/(1-nvMarge3/100);
								nvTarifTTC3=nvTarifHT3*(1+tauxTVA/100);
								nvCoeff3=(nvPrixAchat==0?0:nvTarifHT3/nvPrixAchat);
								nvTarifHT4=nvPrixAchat/(1-nvMarge4/100);
								nvTarifTTC4=nvTarifHT4*(1+tauxTVA/100);
								nvCoeff4=(nvPrixAchat==0?0:nvTarifHT4/nvPrixAchat);
								nvTarifHT5=nvPrixAchat/(1-nvMarge5/100);
								nvTarifTTC5=nvTarifHT5*(1+tauxTVA/100);
								nvCoeff5=(nvPrixAchat==0?0:nvTarifHT5/nvPrixAchat);
							break;
						}
					} else { // pas de rpercution, mais on met qd mme  jour les coeffs et les marges
						nvCoeff1=(nvPrixAchat==0?0:nvTarifHT1/nvPrixAchat);
						nvMarge1=(nvTarifHT1==0?100:(nvTarifHT1-nvPrixAchat)/nvTarifHT1*100);
						nvCoeff2=(nvPrixAchat==0?0:nvTarifHT2/nvPrixAchat);
						nvMarge2=(nvTarifHT2==0?100:(nvTarifHT2-nvPrixAchat)/nvTarifHT2*100);
						nvCoeff3=(nvPrixAchat==0?0:nvTarifHT3/nvPrixAchat);
						nvMarge3=(nvTarifHT3==0?100:(nvTarifHT3-nvPrixAchat)/nvTarifHT3*100);
						nvCoeff4=(nvPrixAchat==0?0:nvTarifHT4/nvPrixAchat);
						nvMarge4=(nvTarifHT4==0?100:(nvTarifHT4-nvPrixAchat)/nvTarifHT4*100);
						nvCoeff5=(nvPrixAchat==0?0:nvTarifHT5/nvPrixAchat);
						nvMarge5=(nvTarifHT5==0?100:(nvTarifHT5-nvPrixAchat)/nvTarifHT5*100);
					}
					break;
				}
				
				if (!perte && (nvTarifHT1<nvPrixAchat || nvTarifHT2<nvPrixAchat || nvTarifHT3<nvPrixAchat || nvTarifHT4<nvPrixAchat || nvTarifHT5<nvPrixAchat)) { perte = true; }
				
				LigneArticle la = new LigneArticle();
				la.setRefArticle(articleId);
				la.setAncPrixAchat(ancPrixAchat);
				la.setNvPrixAchat(nvPrixAchat);
				la.setAncCoeff1(ancCoeff1);
				la.setNvCoeff1(nvCoeff1);
				la.setAncCoeff2(ancCoeff2);
				la.setNvCoeff2(nvCoeff2);
				la.setAncCoeff3(ancCoeff3);
				la.setNvCoeff3(nvCoeff3);
				la.setAncCoeff4(ancCoeff4);
				la.setNvCoeff4(nvCoeff4);
				la.setAncCoeff5(ancCoeff5);
				la.setNvCoeff5(nvCoeff5);
				la.setAncTarifHT1(ancTarifHT1);
				la.setNvTarifHT1(nvTarifHT1);
				la.setAncTarifHT2(ancTarifHT2);
				la.setNvTarifHT2(nvTarifHT2);
				la.setAncTarifHT3(ancTarifHT3);
				la.setNvTarifHT3(nvTarifHT3);
				la.setAncTarifHT4(ancTarifHT4);
				la.setNvTarifHT4(nvTarifHT4);
				la.setAncTarifHT5(ancTarifHT5);
				la.setNvTarifHT5(nvTarifHT5);
				la.setAncTarifTTC1(ancTarifTTC1);
				la.setNvTarifTTC1(nvTarifTTC1);
				la.setAncTarifTTC2(ancTarifTTC2);
				la.setNvTarifTTC2(nvTarifTTC2);
				la.setAncTarifTTC3(ancTarifTTC3);
				la.setNvTarifTTC3(nvTarifTTC3);
				la.setAncTarifTTC4(ancTarifTTC4);
				la.setNvTarifTTC4(nvTarifTTC4);
				la.setAncTarifTTC5(ancTarifTTC5);
				la.setNvTarifTTC5(nvTarifTTC5);
				la.setAncMarge1(ancMarge1);
				la.setNvMarge1(nvMarge1);
				la.setAncMarge2(ancMarge2);
				la.setNvMarge2(nvMarge2);
				la.setAncMarge3(ancMarge3);
				la.setNvMarge3(nvMarge3);
				la.setAncMarge4(ancMarge4);
				la.setNvMarge4(nvMarge4);
				la.setAncMarge5(ancMarge5);
				la.setNvMarge5(nvMarge5);
				la.setTauxTVA(tauxTVA);
				lignesTarifs.add(la);
				
				if (calculerTarifsSpecifiques) {
					// soit on modifie le PV HT ou TTC des tarifs spcifiques...
					if ((element==0 || element==1) && nvPrixAchat>0) {
						psTarifsSpecifiques.setString(1, articleId);
						rset2 = psTarifsSpecifiques.executeQuery();
						while (rset2.next()) {
							String clientId = rset2.getString("Client_Id");
							String raisonSociale = rset2.getString("Denomination");
							int codeTarif = rset2.getInt("Code_Tarif");
							double ancPrixHT = rset2.getDouble("Prix");
							double nvPrixHT = rset2.getDouble("Prix");
							double ancPrixTTC = rset2.getDouble("Prix_TTC");
							double nvPrixTTC = rset2.getDouble("Prix_TTC");
							double ancCoeff = rset2.getDouble("Coeff");
							double nvCoeff = rset2.getDouble("Coeff");
							double ancMarge = rset2.getDouble("Marge");
							double nvMarge = rset2.getDouble("Marge");
							
							double baseHT = 0;
							switch (codeTarif) {
								case 1:
									baseHT = nvTarifHT1;
									break;
								case 2:
									baseHT = nvTarifHT2;
									break;
								case 3:
									baseHT = nvTarifHT3;
									break;
								case 4:
									baseHT = nvTarifHT4;
									break;
								case 5:
									baseHT = nvTarifHT5;
									break;
							}
							
							double val = Double.parseDouble(pourcPVTS);
							switch (element) {
								case 0: // PV HT
									// mise  jour des prix de vente ht en %
									nvPrixHT *= (val<0?1-(val*-1)/100:1+val/100);
									nvPrixTTC=nvPrixHT*(1+tauxTVA/100);
								break;
								case 1: // PV TTC
									// mise  jour des prix de vente ttc en %
									nvPrixTTC *= (val<0?1-(val*-1)/100:1+val/100);
									nvPrixHT=nvPrixTTC/(1+tauxTVA/100);
								break;
							}
							
							double pourcPV = (nvPrixHT >= baseHT ? (nvPrixHT / baseHT -1) * 100 : (baseHT / nvPrixHT -1) * (-100));
							nvCoeff = (pourcPV>=0?1+pourcPV/100:1-Math.abs(pourcPV)/100);
							nvMarge=(nvPrixHT==0?100:(nvPrixHT-nvPrixAchat)/nvPrixHT*100);
							
							if (!perte && nvPrixHT<nvPrixAchat) { perte = true; }
							
							LigneTarifSpecifique lts = new LigneTarifSpecifique();
							lts.setRefArticle(articleId);
							lts.setRefClient(clientId);
							lts.setRaisonSociale(raisonSociale);
							lts.setAncPrixAchat(ancPrixAchat);
							lts.setNvPrixAchat(nvPrixAchat);
							lts.setAncPrixHT(ancPrixHT);
							lts.setNvPrixHT(nvPrixHT);
							lts.setAncPrixTTC(ancPrixTTC);
							lts.setNvPrixTTC(nvPrixTTC);
							lts.setAncCoeff(ancCoeff);
							lts.setNvCoeff(nvCoeff);
							lts.setAncMarge(ancMarge);
							lts.setNvMarge(nvMarge);
							lts.setTauxTVA(tauxTVA);
							lignesTarifsSpecifiques.add(lts);
						}
						rset2.close();
					}
					// ...soit on modifie le PA
					else if (element==4) {
						psTarifsSpecifiques.setString(1, articleId);
						rset2 = psTarifsSpecifiques.executeQuery();
						while (rset2.next()) {
							String clientId = rset2.getString("Client_Id");
							String raisonSociale = rset2.getString("Denomination");
							int codeTarif = rset2.getInt("Code_Tarif");
							double ancPrixHT = rset2.getDouble("Prix");
							double nvPrixHT = rset2.getDouble("Prix");
							double ancPrixTTC = rset2.getDouble("Prix_TTC");
							double nvPrixTTC = rset2.getDouble("Prix_TTC");
							double ancCoeff = rset2.getDouble("Coeff");
							double nvCoeff = rset2.getDouble("Coeff");
							double ancMarge = rset2.getDouble("Marge");
							double nvMarge = rset2.getDouble("Marge");
							
							double baseHT = 0;
							switch (codeTarif) {
								case 1:
									baseHT = nvTarifHT1;
									break;
								case 2:
									baseHT = nvTarifHT2;
									break;
								case 3:
									baseHT = nvTarifHT3;
									break;
								case 4:
									baseHT = nvTarifHT4;
									break;
								case 5:
									baseHT = nvTarifHT5;
									break;
							}
							
							// si on veut appliquer la rpercution du PA sur les tarifs spcifiques...
							if (chkTarifsSpec) {
								double pourcPV = (nvPrixHT >= baseHT ? (nvPrixHT / baseHT -1) * 100 : (baseHT / nvPrixHT -1) * (-100));
								double coeffPV = (pourcPV>=0?1+pourcPV/100:1-Math.abs(pourcPV)/100);

								// si rpercution sur les prix de ventes...
								switch (typeRepercutionSpec) {
									case 0: // en fonction du pourcentage du PV
										nvPrixHT=baseHT*coeffPV;
										nvMarge=(nvPrixHT==0?100:(nvPrixHT-nvPrixAchat)/nvPrixHT*100);
									break;
									case 1: // en fonction des marges HT
										nvPrixHT=nvPrixAchat/(1-nvMarge/100);
										pourcPV = (nvPrixHT >= baseHT ? (nvPrixHT / baseHT -1) * 100 : (baseHT / nvPrixHT -1) * (-100));
										nvCoeff = (pourcPV>=0?1+pourcPV/100:1-Math.abs(pourcPV)/100);
									break;
								}
								nvPrixTTC=nvPrixHT*(1+tauxTVA/100);
								
								if (!perte && nvPrixHT<nvPrixAchat) { perte = true; }
							}
							// ...sinon on doit quand-mme mettre  jour les coeffs et les marges des tarifs spcifiques
							else {
								double pourcPV = (nvPrixHT >= baseHT ? (nvPrixHT / baseHT -1) * 100 : (baseHT / nvPrixHT -1) * (-100));
								nvCoeff = (pourcPV>=0?1+pourcPV/100:1-Math.abs(pourcPV)/100);
								nvMarge=(nvPrixHT==0?100:(nvPrixHT-nvPrixAchat)/nvPrixHT*100);
							}

							LigneTarifSpecifique lts = new LigneTarifSpecifique();
							lts.setRefArticle(articleId);
							lts.setRefClient(clientId);
							lts.setRaisonSociale(raisonSociale);
							lts.setAncPrixAchat(ancPrixAchat);
							lts.setNvPrixAchat(nvPrixAchat);
							lts.setAncPrixHT(ancPrixHT);
							lts.setNvPrixHT(nvPrixHT);
							lts.setAncPrixTTC(ancPrixTTC);
							lts.setNvPrixTTC(nvPrixTTC);
							lts.setAncCoeff(ancCoeff);
							lts.setNvCoeff(nvCoeff);
							lts.setAncMarge(ancMarge);
							lts.setNvMarge(nvMarge);
							lts.setTauxTVA(tauxTVA);
							lignesTarifsSpecifiques.add(lts);
						}
						rset2.close();
					}
				}
			}
			rset.close();
			psTVA.close();
			psTarifsSpecifiques.close();
			psArticles.close();
			
			
			if (valider) {
				// enregistrement des donnes en base
				
				String reqModifierTarifs = "update "+ base +".FICHE_ARTICLE";
				reqModifierTarifs += " set Coeff_1=?, Coeff_2=?, Coeff_3=?, Coeff_4=?, Coeff_5=?,";
				reqModifierTarifs += " Tarif_1=?, Tarif_2=?, Tarif_3=?, Tarif_4=?, Tarif_5=?,";
				reqModifierTarifs += " Tarif_1_TTC=?, Tarif_2_TTC=?, Tarif_3_TTC=?, Tarif_4_TTC=?, Tarif_5_TTC=?,";
				reqModifierTarifs += " Marge_1=?, Marge_2=?, Marge_3=?, Marge_4=?, Marge_5=?,";
				reqModifierTarifs += " Prix_Achat=? where Article_Id=?";
				PreparedStatement psModifierTarifs = con.prepareStatement(reqModifierTarifs);
				
				int lg=lignesTarifs.size();
				for (int i=0; i<lg; i++) {
					LigneArticle la = lignesTarifs.get(i);
					psModifierTarifs.setDouble(1, la.nvCoeff1);
					psModifierTarifs.setDouble(2, la.nvCoeff2);
					psModifierTarifs.setDouble(3, la.nvCoeff3);
					psModifierTarifs.setDouble(4, la.nvCoeff4);
					psModifierTarifs.setDouble(5, la.nvCoeff5);
					psModifierTarifs.setDouble(6, la.nvTarifHT1);
					psModifierTarifs.setDouble(7, la.nvTarifHT2);
					psModifierTarifs.setDouble(8, la.nvTarifHT3);
					psModifierTarifs.setDouble(9, la.nvTarifHT4);
					psModifierTarifs.setDouble(10, la.nvTarifHT5);
					psModifierTarifs.setDouble(11, la.nvTarifTTC1);
					psModifierTarifs.setDouble(12, la.nvTarifTTC2);
					psModifierTarifs.setDouble(13, la.nvTarifTTC3);
					psModifierTarifs.setDouble(14, la.nvTarifTTC4);
					psModifierTarifs.setDouble(15, la.nvTarifTTC5);
					psModifierTarifs.setDouble(16, la.nvMarge1);
					psModifierTarifs.setDouble(17, la.nvMarge2);
					psModifierTarifs.setDouble(18, la.nvMarge3);
					psModifierTarifs.setDouble(19, la.nvMarge4);
					psModifierTarifs.setDouble(20, la.nvMarge5);
					psModifierTarifs.setDouble(21, la.nvPrixAchat);
					psModifierTarifs.setString(22, la.refArticle);
					psModifierTarifs.executeUpdate();
				}
				psModifierTarifs.close();
				
				String reqModifierTarifsSpec = "update "+ base +".CLIENT_ARTICLE";
				reqModifierTarifsSpec += " set Coeff=?, Prix=?, Prix_TTC=?, Marge=?";
				reqModifierTarifsSpec += " where Article_Id=? and Client_Id=?";
				PreparedStatement psModifierTarifsSpec = con.prepareStatement(reqModifierTarifsSpec);
				
				lg=lignesTarifsSpecifiques.size();
				for (int i=0; i<lg; i++) {
					LigneTarifSpecifique lts = lignesTarifsSpecifiques.get(i);
					psModifierTarifsSpec.setDouble(1, lts.nvCoeff);
					psModifierTarifsSpec.setDouble(2, lts.nvPrixHT);
					psModifierTarifsSpec.setDouble(3, lts.nvPrixTTC);
					psModifierTarifsSpec.setDouble(4, lts.nvMarge);
					psModifierTarifsSpec.setString(5, lts.refArticle);
					psModifierTarifsSpec.setString(6, lts.refClient);
					psModifierTarifsSpec.executeUpdate();
				}
				psModifierTarifsSpec.close();
			}
			s.closeConnection(con,null);
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
}
