/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Traitement des fichiers des logos des entreprises
 */

package org.opensi.facturation.actions.photos;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;


public class ManageLogos extends Action {


	private static final int LARGEUR = 150;
	

  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		String chemin = s.getAppConfiguration().get("opensi.absdir");
		
		String fichierImage = r.getParameter("Fichier");
		
		String dossier = s.getCookie().get("Dossier_Id");
		
		File tempFile = new File(chemin +"/iobuffer/"+ fichierImage);
		
		BufferedImage imageOrigine = ImageIO.read(tempFile);
		
		if (imageOrigine == null) {		
			r.addParameter("Action_Error","Fichier image non lisible !");			
		}
		else {
		
			int w = imageOrigine.getWidth();
			int h = imageOrigine.getHeight();

			if (w > LARGEUR || h > LARGEUR) {		
				if (w > h) {
					h = (h * LARGEUR) / w;
					w = LARGEUR;				
				}
				else {
					w = (w * LARGEUR) / h;
					h = LARGEUR;				
				}
			}

			BufferedImage imageVignette = makeBufferedImage(imageOrigine.getScaledInstance(w, h, BufferedImage.SCALE_FAST));

			try {
				ImageIO.write(imageVignette, "JPG", new File(chemin +"/logos/"+ dossier +"_small.jpg"));
			}
			catch (IOException ioe) { r.addParameter("Action_Error","Erreur d'criture sur le serveur !");	}
		
		}
		
		tempFile.renameTo(new File(chemin +"/logos/"+ dossier +".jpg"));
		
		return true;			
	}
	
	
	BufferedImage makeBufferedImage(Image image) {
    
    /** On cre la nouvelle image */
    BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), BufferedImage.TYPE_INT_RGB);
    Graphics g = bufferedImage.createGraphics();
    g.drawImage(image,0,0,null);
    g.dispose();

    return(bufferedImage);     
	}


} // fin ManageLogos











