/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.api.SessionOSI;

import org.opensi.util.sql.SqlUtils;


public class TransfertAnnulAcomptesClient extends TransfertVentes {

	private String codeJournal;
	private String listeId;

	private PreparedStatement psMarqueAcpte;


	public TransfertAnnulAcomptesClient(SessionOSI sosi, String codeJournal, String listeId) throws Exception {

		super(sosi);
		this.codeJournal = codeJournal;
		this.listeId = (listeId.length()==0?"-1":SqlUtils.normalizeCSList(listeId));
	}


	public void transfert() throws Exception {

		Statement stt = con.createStatement();

		psMarqueAcpte = con.prepareStatement("update "+ baseDossier +".ACOMPTE_CLIENT set Compta_Annul=1 where Acompte_Id=?");

		ResultSet rset = stt.executeQuery("select * from "+ baseDossier +".ACOMPTE_CLIENT where Statut='A' and Comptabilise=1 and Compta_Annul=0 and Acompte_Id in ("+ listeId +") order by Date_Acompte");

		while (rset.next()) {

			long dateAcompte = rset.getLong("Date_Acompte");
			int acompteId = rset.getInt("Acompte_Id");
			String clientId = rset.getString("Client_Id");
			String numPiece = rset.getString("Numero");
			double montantTTC = rset.getDouble("Total_TTC");
			double montantHT = rset.getDouble("Total_HT");
			double montantTVA = rset.getDouble("Total_TVA");

			Ecriture ecriture = new Ecriture();
			ecriture.setCodeJournal(codeJournal);
			ecriture.setDateEcriture(dateAcompte);

			String compteClient = getCompteClient(clientId);

			Operation op = new Operation();
			op.setDateOp(dateAcompte);
			op.setNumPiece(numPiece);
			op.setNumeroCompte(compteClient);
			op.setLibelle(getIntitule(compteClient));
			op.setMontantC(montantTTC);

			ecriture.addOperation(op);

			op = new Operation();
			op.setDateOp(dateAcompte);
			op.setNumPiece(numPiece);
			op.setNumeroCompte(compteAcompteVE);
			op.setLibelle(getIntitule(compteAcompteVE));
			op.setMontantD(montantHT);

			ecriture.addOperation(op);

			if (montantTVA>0) {

				String compteTVA = cptesTva.get(new Integer(rset.getInt("Code_TVA")));

				op = new Operation();
				op.setDateOp(dateAcompte);
				op.setNumPiece(numPiece);
				op.setNumeroCompte(compteTVA);
				op.setLibelle(getIntitule(compteTVA));
				op.setMontantD(montantTVA);

				ecriture.addOperation(op);
			}

			validerEcriture(ecriture, acompteId, dateAcompte);
		}

		stt.close();
	}


	protected void marquerDocument(int acompteId) throws SQLException {

		psMarqueAcpte.setInt(1, acompteId);
		psMarqueAcpte.executeUpdate();
	}


} // fin TransfertAnnulAcomptesClient
