/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.api.SessionOSI;


public class TransfertReglementsFournisseur extends TransfertCompta {


	private String compteFournisseursDivers;

	private PreparedStatement psCpteFournisseur;
	private PreparedStatement psCpteJournal;
	private PreparedStatement psMarqueRegl;

	private String liste;
	private String codeJournal;


	public TransfertReglementsFournisseur(SessionOSI sosi, String codeJournal, String liste) throws Exception {

		super(sosi);
  	this.liste = liste;
		this.codeJournal = codeJournal;
	}


	public void transfert() throws Exception {

		Statement stt = con.createStatement();

		String reqComptesDefaut = "select Numero_Compte_Fournisseurs from "+ baseDossier +".PARAM_DOSSIER";

		ResultSet rset = stt.executeQuery(reqComptesDefaut);
		rset.next();

		compteFournisseursDivers = rset.getString("Numero_Compte_Fournisseurs");


		String reqCpteFournisseur = "select c.Numero_Compte from "+ baseDossier +".FICHE_FOURNISSEUR e,"+ baseDossier +".COMPTE c where e.Fournisseur_Id=? and e.Numero_Compte=c.Numero_Compte";

		String reqCpteJournal = "select Contrepartie from "+ baseDossier +".JOURNAL where Code_Journal=?";

		String majReglement = "update "+ baseDossier +".REGLEMENT_FOURNISSEUR set Comptabilise=1 where Reglement_Id=?";

		psCpteFournisseur = con.prepareStatement(reqCpteFournisseur);
		psCpteJournal = con.prepareStatement(reqCpteJournal);
		psMarqueRegl = con.prepareStatement(majReglement);

		// GENERATION DES ECRITURES DE REGLEMENTS

		String reqReglements="";

		//transfert des rglements slctionns

		String[] reglements = liste.split(",");
		if (reglements.length>0) {
			reqReglements = "select * from "+ baseDossier +".REGLEMENT_FOURNISSEUR where Comptabilise=0 and Reglement_Id="+ reglements[0];
			for (int z=1;z<reglements.length;z++) {
				reqReglements += " or Reglement_Id="+reglements[z];
			}
			reqReglements += " order by Date_Reg";
		}

		rset = stt.executeQuery(reqReglements);

		while (rset.next()) {

			long dateReglement = rset.getLong("Date_Reg");
			int reglementId = rset.getInt("Reglement_Id");

			String fournisseurId = rset.getString("Fournisseur_Id");
			String numPiece = rset.getString("Num_Piece");
			double montant = rset.getDouble("Montant");
			int modeRegId = rset.getInt("Mode_Reg_Id");

			Ecriture ecriture = new Ecriture();
			ecriture.setCodeJournal(codeJournal);
			ecriture.setDateEcriture(dateReglement);

			// ajout des oprations  l'ecriture comptable

			// operation du compte fournisseur

			if (montant>0) {
				String compteFournisseur = getCompteFournisseur(fournisseurId);

				Operation op = new Operation();
				op.setDateOp(dateReglement);
				op.setNumPiece(numPiece);
				op.setModeRegId(modeRegId);

				op.setNumeroCompte(compteFournisseur);
				op.setLibelle(getIntitule(compteFournisseur));
				op.setMontantD(montant);

				ecriture.addOperation(op);

				// operation du compte banque/caisse

				String compteJournal = getContrePartieJournal(codeJournal);

				op = new Operation();
				op.setDateOp(dateReglement);
				op.setNumPiece(numPiece);
				op.setNumeroCompte(compteJournal);
				op.setLibelle(getIntitule(compteJournal));
				op.setMontantC(montant);

				ecriture.addOperation(op);
			}

			validerEcriture(ecriture, reglementId, dateReglement);

		}

	}

	protected void marquerDocument(int reglementId) throws SQLException {

		psMarqueRegl.setInt(1, reglementId);
		psMarqueRegl.executeUpdate();
	}

	private String getCompteFournisseur(String fournisseurId) throws SQLException {

		if (fournisseurId.equals("")) {
			return compteFournisseursDivers;
		}
		else {
			psCpteFournisseur.setString(1, fournisseurId);
			ResultSet rset = psCpteFournisseur.executeQuery();

			if (rset.next()) {
				return rset.getString("Numero_Compte");
			}
			else {
				return compteFournisseursDivers;
			}
		}
	}

	private String getContrePartieJournal(String codeJournal) throws SQLException {
		if (codeJournal.equals("")) {
			return "";
		}
		else {
			psCpteJournal.setString(1, codeJournal);
			ResultSet rset = psCpteJournal.executeQuery();
			if (rset.next()) {
				return rset.getString("Contrepartie");
			}
			else {
				return "";
			}
		}
	}


} // fin TransfertReglementsFournisseur
