/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.api.SessionOSI;

import org.opensi.util.sql.SqlUtils;


public class TransfertRemisesEspeces extends TransfertCompta {

	private String codeJournal;
	private String listeId;
	private String compteEspeces;

	private PreparedStatement psCpteJournal;
	private PreparedStatement psMarqueRemise;


	public TransfertRemisesEspeces(SessionOSI sosi, String codeJournal, String listeId) throws Exception {

		super(sosi);
		this.codeJournal = codeJournal;
		this.listeId = (listeId.length()==0?"-1":SqlUtils.normalizeCSList(listeId));
	}


	public void transfert() throws Exception {

		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery("select Numero_Compte_Especes, Ecr_Glob_Rem from "+ baseDossier +".PARAM_DOSSIER");
		rset.next();

		compteEspeces = rset.getString("Numero_Compte_Especes");
		boolean ecrGroupe = rset.getBoolean("Ecr_Glob_Rem");

		psCpteJournal = con.prepareStatement("select Contrepartie from "+ baseDossier +".JOURNAL where Code_Journal=?");
		psMarqueRemise = con.prepareStatement("update "+ baseDossier +".REMISE_BANQUE set Comptabilise=1 where Remise_Id=?");


		rset = stt.executeQuery("select rb.*, coalesce(b.Code_Journal,'') as Journal_Rem from "+ baseDossier +".REMISE_BANQUE rb"
														+" join "+ baseDossier +".BANQUE b on rb.Banque_Remise=b.Banque_Id"
														+" where rb.Montant>0 and rb.Comptabilise=0 and rb.Remise_Id in ("+ listeId +") order by rb.Date_Remise");

		while (rset.next()) {

			long dateRemise = rset.getLong("Date_Remise");
			int remiseId = rset.getInt("Remise_Id");
			String numPiece = rset.getString("Numero");
			double montant = rset.getDouble("Montant");
			String journalRem = codeJournal.isEmpty()?rset.getString("Journal_Rem"):codeJournal;
			
			Ecriture ecriture = new Ecriture();
			ecriture.setCodeJournal(journalRem);
			ecriture.setDateEcriture(dateRemise);

			Operation op = new Operation();
			op.setNumeroCompte(compteEspeces);
			op.setLibelle(getIntitule(compteEspeces));
			op.setDateOp(dateRemise);
			op.setNumPiece(numPiece);
			op.setMontantC(montant);
			ecriture.addOperation(op);

			
			String compteBanque = getContrepartieJournal(journalRem);
			op = new Operation();
			op.setDateOp(dateRemise);
			op.setNumPiece(numPiece);
			op.setNumeroCompte(compteBanque);
			op.setLibelle(getIntitule(compteBanque));
			op.setMontantD(montant);
			ecriture.addOperation(op);

			validerEcriture(ecriture, remiseId, dateRemise);
		}
	}


	protected void marquerDocument(int remiseId) throws SQLException {

		psMarqueRemise.setInt(1, remiseId);
		psMarqueRemise.executeUpdate();
	}
	

	private String getContrepartieJournal(String codeJournal) throws SQLException {
		if (codeJournal.equals("")) {
			return "";
		}
		else {
			psCpteJournal.setString(1, codeJournal);
			ResultSet rset = psCpteJournal.executeQuery();
			if (rset.next()) {
				return rset.getString("Contrepartie");
			}
			else {
				return "";
			}
		}
	}


} // fin TransfertRemisesEspeces
