/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import org.opensi.api.SessionOSI;

import java.util.HashMap;
import java.util.Iterator;


public abstract class TransfertVentes extends TransfertCompta {


	protected String compteLivraison;
	protected String compteEscompteVE;
	protected String compteAcompteVE;
	protected boolean intituleTiers;

	private String compteClientsDivers;
	private PreparedStatement psCpteClient;
	private PreparedStatement psCpteArticleN;
	private PreparedStatement psCpteFamilleN;
	private PreparedStatement psCpteArticleNatUE;
	private PreparedStatement psCpteFamilleNatUE;
	private PreparedStatement psCpteNatUE;
	private PreparedStatement psCodeN;

	private HashMap<Integer, String> cptesVTva = new HashMap<Integer, String>(100);

	protected HashMap<Integer, String> cptesTva = new HashMap<Integer, String>(100);


  public TransfertVentes(SessionOSI sosi) throws Exception {

		super(sosi);

		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery("select Numero_Compte_Clients, Numero_Compte_Escompte_VE, Numero_Compte_Port_VE, Intitule_Ecr_Tiers, Numero_Compte_Acompte_VE from "+ baseDossier +".PARAM_DOSSIER");
		rset.next();

		this.compteClientsDivers = rset.getString("Numero_Compte_Clients");
    this.compteLivraison = rset.getString("Numero_Compte_Port_VE");
    this.compteEscompteVE = rset.getString("Numero_Compte_Escompte_VE");
		this.compteAcompteVE = rset.getString("Numero_Compte_Acompte_VE");
		this.intituleTiers = rset.getInt("Intitule_Ecr_Tiers")==1;

		rset.close();
		stt.close();

		String reqCpteClient = "select c.Numero_Compte from "+ baseDossier +".FICHE_CLIENT e,"+ baseDossier +".COMPTE c "
												 + "where e.Client_Id=? and e.Numero_Compte=c.Numero_Compte";

		String reqCpteArticleN = "select ca.Compte_Vente from "+ baseDossier +".COMPTE_ARTICLE ca,"+ baseDossier +".COMPTE c "
														+ "where c.Numero_Compte=ca.Compte_Vente and Article_Id=? and ca.Code_TVA=?";

		String reqCpteFamilleN = "select cf.Compte_Vente from "+ baseDossier +".COMPTE_FAMILLE_ARTICLE cf,"+ baseDossier +".COMPTE c,"+ baseDossier +".FICHE_ARTICLE a "
														+ "where c.Numero_Compte=cf.Compte_Vente and a.Famille_?=cf.Famille_Id and a.Article_Id=? and cf.Code_TVA=?";

		String reqCpteArticleNatUE = "select ca.Compte_Vente from "+ baseDossier +".COMPTE_ARTICLE_TVA_NATIONAL_UE ca,"+ baseDossier +".COMPTE c "
														+ "where c.Numero_Compte=ca.Compte_Vente and Article_Id=? and ca.Code_TVA=? and ca.Code_Pays=?";

		String reqCpteFamilleNatUE = "select cf.Compte_Vente from "+ baseDossier +".COMPTE_FAMILLE_ARTICLE_TVA_NATIONAL_UE cf,"+ baseDossier +".COMPTE c,"+ baseDossier +".FICHE_ARTICLE a "
														+ "where c.Numero_Compte=cf.Compte_Vente and a.Famille_?=cf.Famille_Id and a.Article_Id=? and cf.Code_TVA=? and cf.Code_Pays=?";


		psCpteClient = con.prepareStatement(reqCpteClient);
		psCpteArticleN = con.prepareStatement(reqCpteArticleN);
		psCpteFamilleN = con.prepareStatement(reqCpteFamilleN);
		psCpteArticleNatUE = con.prepareStatement(reqCpteArticleNatUE);
		psCpteFamilleNatUE = con.prepareStatement(reqCpteFamilleNatUE);


		String reqCpteNatUE = "select Compte_Vente from "+ baseDossier +".VENTIL_TVA_NATIONAL_UE where Code_TVA=? and Code_Pays=?";

		String reqCodeN = "select Code_TVA from "+ baseDossier +".TAUX_TVA where Code_TVA=? and Code_Pays='FR'";

		psCpteNatUE = con.prepareStatement(reqCpteNatUE);
		psCodeN = con.prepareStatement(reqCodeN);

		PreparedStatement psCptesTva = con.prepareStatement("select Compte_TVA_Vente, Compte_Vente, Code_TVA from "+ baseDossier +".TAUX_TVA");

		ResultSet rsCT = psCptesTva.executeQuery();

		while (rsCT.next()) {
			cptesTva.put(new Integer(rsCT.getInt("Code_TVA")), rsCT.getString("Compte_TVA_Vente"));
			cptesVTva.put(new Integer(rsCT.getInt("Code_TVA")), rsCT.getString("Compte_Vente"));
		}

		rsCT.close();
		psCptesTva.close();
	}


	public abstract void transfert() throws Exception;

	protected abstract void marquerDocument(int documentId) throws SQLException;


	protected final void ajusterHT(double montant, char sens, HashMap<String, Double> vventes) throws SQLException {

		Iterator<String> li = vventes.keySet().iterator();

		while (li.hasNext() && montant>0) {

			String compteHT = li.next();

			double montantHT = vventes.get(compteHT).doubleValue();

			if (sens=='P') {
				montantHT += montant;
				montant = 0;
			}
			else {
				montantHT = (montantHT>montant?montantHT - montant:0);
				montant -= montantHT;
			}

			if (montantHT>0)
				vventes.put(compteHT, new Double(montantHT));
			else
				vventes.put(compteHT, new Double(0));
		}
	}


	protected final String getCompteClient(String clientId) throws SQLException {

		if (clientId==null || clientId.equals("")) {
			return compteClientsDivers;
		}
		else {
			psCpteClient.setString(1, clientId);
			ResultSet rset = psCpteClient.executeQuery();

    	if (rset.next()) {
      	return rset.getString("Numero_Compte");
    	}
			else {
				return compteClientsDivers;
			}
		}
	}


	private final String getCompteFamilleN(String reference, int codeTVA, int niveauFamille) throws SQLException {

		psCpteFamilleN.setInt(1, niveauFamille);
    psCpteFamilleN.setString(2, reference);
		psCpteFamilleN.setInt(3, codeTVA);
    ResultSet rset = psCpteFamilleN.executeQuery();

    if (rset.next()) {
      return rset.getString("Compte_Vente");
    }
		else if (niveauFamille>1) {
			return getCompteFamilleN(reference, codeTVA, niveauFamille-1);
		}
		else {
			return cptesVTva.get(new Integer(codeTVA));
		}
  }


	private final String getCompteArticleN(String reference, int codeTVA) throws SQLException {

		psCpteArticleN.setString(1, reference);
		psCpteArticleN.setInt(2, codeTVA);
    ResultSet rset = psCpteArticleN.executeQuery();

    if (rset.next()) {
      return rset.getString("Compte_Vente");
    }
		else {
			return getCompteFamilleN(reference, codeTVA, 3);
		}
  }


	private final String getCompteFamilleNatUE(String reference, int codeTVA, String codePays, int niveauFamille) throws SQLException {

		psCpteFamilleNatUE.setInt(1, niveauFamille);
    psCpteFamilleNatUE.setString(2, reference);
		psCpteFamilleNatUE.setInt(3, codeTVA);
		psCpteFamilleNatUE.setString(4, codePays);
    ResultSet rset = psCpteFamilleNatUE.executeQuery();

    if (rset.next()) {
      return rset.getString("Compte_Vente");
    }
		else if (niveauFamille>1) {
			return getCompteFamilleNatUE(reference, codeTVA, codePays, niveauFamille-1);
		}
		else {
			psCpteNatUE.setInt(1, codeTVA);
			psCpteNatUE.setString(2, codePays);
			ResultSet rsNUE = psCpteNatUE.executeQuery();
			rsNUE.next();
			return rsNUE.getString("Compte_Vente");
		}
  }


	private final String getCompteArticleNatUE(String reference, int codeTVA, String codePays) throws SQLException {

		psCpteArticleNatUE.setString(1, reference);
		psCpteArticleNatUE.setInt(2, codeTVA);
		psCpteArticleNatUE.setString(3, codePays);
    ResultSet rset = psCpteArticleNatUE.executeQuery();

    if (rset.next()) {
      return rset.getString("Compte_Vente");
    }
		else {
			return getCompteFamilleNatUE(reference, codeTVA, codePays, 3);
		}
  }


	protected final String getCompteHT(String reference, int codeTVA, double tauxTVA, boolean zoneUE, String codePays) throws SQLException {

		if (zoneUE && tauxTVA>0) {
			psCodeN.setInt(1, codeTVA);
			ResultSet rsCN = psCodeN.executeQuery();

			if (rsCN.next()) {
				return getCompteArticleNatUE(reference, codeTVA, codePays);
			}
			else {
				return getCompteArticleN(reference, codeTVA);
			}
		}
		else {
			return getCompteArticleN(reference, codeTVA);
		}
	}


	protected final String getCompteDefault(int codeTVA, double tauxTVA, boolean zoneUE, String codePays) throws SQLException {

		if (zoneUE && tauxTVA>0) {

			psCodeN.setInt(1, codeTVA);
			ResultSet rsCN = psCodeN.executeQuery();

			if (rsCN.next()) {
				psCpteNatUE.setInt(1, codeTVA);
				psCpteNatUE.setString(2, codePays);
				ResultSet rsNUE = psCpteNatUE.executeQuery();
				rsNUE.next();
				return rsNUE.getString("Compte_Vente");
			}
			else {
				return cptesVTva.get(new Integer(codeTVA));
			}
		}
		else {
			return cptesVTva.get(new Integer(codeTVA));
		}
	}



} // fin TransfertVentes

