/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.commerciaux;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.pdf.GlobalDocument;


public class GenRemuneration extends Action {


	public boolean serverSide() { return true; }

	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String absdir = s.getAppConfiguration().get("opensi.absdir");
		int commissionId = Integer.parseInt(r.getParameter("Commission_Id"));

		String fichierPdf = r.getParameter("Fichier");
		String repPdf = absdir + "/pdf/";
		String repTemp = repPdf;

		GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);
		gd.addInternal(new CommissionStd(repTemp, new DataCommission(s, commissionId)));		
		gd.close(GlobalDocument.ON_EXIT);

		return true;
	}

}
