/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.reglements.clients;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.Arrondi;



public class CalculEcheance {

	private String clientId;
	private String denomination;
	private int modeRegId;
	private double montant;
	private double montantInitial;
	private double montantReglement;
	private String base;
	private Session s;
	private int nb;
	private HashMap<String, String> tab=new HashMap<String, String>();
	private ResultSet rset;
	private LinkedHashMap<Integer, String[]> liste=new LinkedHashMap<Integer, String[]>();
	private Statement st;
	private Arrondi arrondi=new Arrondi(2);
	private ArrayList<String> liste_fini=new ArrayList<String>();
	private ArrayList<String[]> listesomme=new ArrayList<String[]>();



	public CalculEcheance (String sess, String base, String clientId, String denomination, int modeRegId, double montant, double montantReglement) {
		try {
			this.base=base;
			this.clientId=clientId;
			this.denomination=denomination;
			this.modeRegId=modeRegId;
			this.montant=montant;
			this.montantInitial=montant;
			this.montantReglement=montantReglement;
			
			this.nb=0;
			this.s = Session.findClient(sess);
			Connection c = s.getConnection(null);
			st = c.createStatement();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public boolean liste () {
		try {

			String sqlCountEch = "select count(Echeance_Id) as nb from " + base + ".ECHEANCE_CLIENT where Etat in ('N','P')";
			if (clientId.equals("")) {
				sqlCountEch+=" and Client_Id is null and Denomination = '"+s.sqlEncode(denomination)+"'";
			} else {
				sqlCountEch+=" and Client_Id = '"+s.sqlEncode(clientId)+"'";
			}
			rset = st.executeQuery(sqlCountEch);
			if (rset.next()) {
				nb=rset.getInt("nb");
			}
			
			String sqlListeEch = "select ec.Echeance_Id, ec.Date_Echeance, ec.Mode_Reg_Id, ec.Montant_Restant,";
			sqlListeEch += " if(f.Facture_Id is null,'Acompte','Facture') as Type, coalesce(f.Num_Entier,ac.Numero) as Num_Entier";
			sqlListeEch += " from " + base + ".ECHEANCE_CLIENT ec";
			sqlListeEch += " left join " + base + ".FACTURE_ECHEANCE_CLIENT fec on ec.Echeance_Id=fec.Echeance_Id left join " + base + ".FACTURE f on fec.Facture_Id=f.Facture_Id";
			sqlListeEch += " left join " + base + ".ACOMPTE_ECHEANCE_CLIENT aec on ec.Echeance_Id=aec.Echeance_Id left join " + base + ".ACOMPTE_CLIENT ac on aec.Acompte_Id=ac.Acompte_Id and ac.Statut='V'";
			sqlListeEch += " where (f.Facture_Id is not null or ac.Acompte_Id is not null) and ec.Etat in ('N','P')";
			if (clientId.equals("")) {
				sqlListeEch+=" and ec.Client_Id is null and ec.Denomination = '"+s.sqlEncode(denomination)+"'";
			} else {
				sqlListeEch+=" and ec.Client_Id = '"+s.sqlEncode(clientId)+"'";
			}
			sqlListeEch+=" order by Type, ec.Date_Echeance, Num_Entier";
			rset = st.executeQuery(sqlListeEch);

			
			while (rset.next()) {
				String tree[]=new String [5];
				tree[0]=rset.getString("Echeance_Id");
				tree[1]=rset.getString("Type");
				tree[2]=rset.getString("Montant_Restant");
				tree[3]=rset.getString("Mode_Reg_Id");
				tree[4]=rset.getString("Date_Echeance");
				liste.put(rset.getInt("Echeance_Id"),tree);
				tab.put(tree[0],"0.00");
				
				int modeR = Integer.parseInt(tree[3]);

				int nbsomme=listesomme.size();
				if (nb<15) {
					for (int i=0;i<nbsomme;i++)
					{
						double val=new Double(listesomme.get(i)[2]).doubleValue();
						double somme=rset.getDouble("Montant_Restant")+val;
						somme=arrondi.round(somme);
						if (somme<=montant) {
							int Mode=Integer.parseInt(listesomme.get(i)[1]);
							String cle=listesomme.get(i)[0];
							Mode=(Mode==modeR)?Mode:0;

							String som[]={cle+";"+tree[0],""+Mode,""+somme};
							listesomme.add(som);
						}
					}
				}
				if (rset.getDouble("Montant_Restant")<montant) {
					String nouv []={tree[0],tree[3],tree[2]};
					listesomme.add(nouv);
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}

	public boolean calcul () {
		try {

			boolean suite=false;
			impute_egal(true);
			if (montant!=0){
				if (montant==montantInitial) {
					suite=somme_egal(true,montantReglement);
					if (montant!=0 && montant==montantInitial){
						if (suite) {somme_egal(true,montant);}
					}
				}
				if (montant!=0){
					trouve_diff(true);
					if (montant!=0){
						if (montant==montantInitial) {
							impute_egal(false);
							if (montant!=0){
								if (montant==montantInitial) {
									suite=somme_egal(false,montantReglement);
									if (montant!=0 && montant==montantInitial){
										if (suite) {somme_egal(false,montant);}
									}
								}
							}
						}
						if (montant!=0){
							trouve_diff(false);
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}


	public boolean impute_egal(boolean meme_mode) {
		try {

			String [] ech=trouve_egal(meme_mode,montantReglement);
			String [] ech_avo=trouve_egal(meme_mode,montant);

			if (!ech[1].equals("") && !ech_avo[1].equals("")) {
				if ((new Long (ech[1]).longValue())<=(new Long (ech_avo[1]).longValue())) {
					tab.put(ech[0],(new Double(montantReglement)).toString());
					montant-=montantReglement;
					montant=arrondi.round(montant);
					montantReglement=0;
					liste_fini.add(ech[0]);
				}
				else {
					tab.put(ech_avo[0],(new Double(montant)).toString());
					montant=0;
					montantReglement=0;
					liste_fini.add(ech_avo[0]);
				}
			}
			else if (!ech[1].equals("") || !ech_avo[1].equals("")) {
				if (ech_avo[1].equals("")) {
					tab.put(ech[0],(new Double(montantReglement)).toString());
					montant-=montantReglement;
					montant=arrondi.round(montant);
					montantReglement=0;
					liste_fini.add(ech[0]);
				}
				else {
					tab.put(ech_avo[0],(new Double(montant)).toString());
					montant=0;
					montantReglement=0;
					liste_fini.add(ech_avo[0]);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}


	public String [] trouve_egal(boolean meme_mode,double mont) {
		String [] ech=new String [2];
		ech[0]="";
		ech[1]="";
		boolean trouve=false;
		int i=0;
		try {
			Iterator<Integer> it = liste.keySet().iterator();
			while (it.hasNext() && !trouve)
			{
				String [] elem = liste.get(it.next());
				boolean egal;
				double Restant=Double.parseDouble(elem[2]);
				int Mode=Integer.parseInt(elem[3]);
				String Id=elem[0];
				String date=elem[4];
				if (meme_mode)
					egal=(modeRegId==Mode);
				else
					egal=(modeRegId!=Mode);
				if (egal)
				{
					if (Restant==mont && mont!=0)
					{
						trouve=true;
						ech[0]=Id;
						ech[1]=date;
					}
				}
				i++;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ech;
	}


	public boolean somme_egal(boolean meme_mode,double mont) {
		boolean suite=true;
		try {
			if (meme_mode){

				for (int i=0;i<listesomme.size();i++)
				{
					double val=new Double(listesomme.get(i)[2]).doubleValue();
					int Mode=Integer.parseInt(listesomme.get(i)[1]);
					String Id=listesomme.get(i)[0];
					if (modeRegId==Mode)
					{
						if (val==mont && mont!=0 && montant!=0)
						{
							suite=false;
							int nombre=1;
							for (int j=0;j<Id.length();j++)
							{
								if ((Id.charAt(j))==';')
									nombre++;

							}
							String Ech []=Id.split(";");
							for (int k=0;k<nombre;k++)
							{
								Integer value = new Integer(Ech[k]);
								double Restant=(Double.parseDouble(liste.get(value)[2]));
								tab.put(Ech[k],liste.get(value)[2]);
								liste_fini.add(Ech[k]);
								montant-=Restant;
								montant=arrondi.round(montant);
								if (Restant<=montantReglement) {
									montantReglement-=Restant;
									montantReglement=arrondi.round(montantReglement);
								}
								else {
									montantReglement=0;
								}
							}
						}
					}
				}
			}
			else
			{
				for (int i=0;i<listesomme.size();i++)
				{
					double val=new Double(listesomme.get(i)[2]).doubleValue();
					int Mode=Integer.parseInt(listesomme.get(i)[1]);
					String Id=listesomme.get(i)[0];
					if (modeRegId!=Mode)
					{
						if (val==mont && mont!=0 && montant!=0)
						{
							suite=false;
							int nombre=1;
							for (int j=0;j<Id.length();j++)
							{
								if ((Id.charAt(j))==';')
									nombre++;

							}
							String Ech []=Id.split(";");
							for (int k=0;k<nombre;k++)
							{
								Integer value = new Integer(Ech[k]);
								double Restant=(Double.parseDouble(liste.get(value)[2]));
								tab.put(Ech[k],liste.get(value)[2]);
								liste_fini.add(Ech[k]);
								montant-=Restant;
								montant=arrondi.round(montant);
								if (Restant<=montantReglement) {
									montantReglement-=Restant;
									montantReglement=arrondi.round(montantReglement);
								}
								else {
									montantReglement=0;
								}

							}
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return suite;
	}

	public boolean trouve_diff(boolean meme_mode) {
		try {
			Iterator<Integer> it = liste.keySet().iterator();
			while (it.hasNext())
			{
				String [] elem = liste.get(it.next());
				boolean egal;
				double Restant=Double.parseDouble(elem[2]);
				String Type=elem[1];
				int Mode=Integer.parseInt(elem[3]);
				String Id=elem[0];
				if (meme_mode)
					egal=(modeRegId==Mode);
				else
					egal=(modeRegId!=Mode);
				if (egal && !liste_fini.contains(Id))
				{
					if (Restant<=montant)
					{
						tab.put(Id,(new Double(Restant)).toString());
						liste_fini.add(Id);
						montant-=Restant;
						montant=arrondi.round(montant);
						if (Restant<=montantReglement) {
							montantReglement-=Restant;
							montantReglement=arrondi.round(montantReglement);
						}
						else {
							montantReglement=0;
						}
					}
					else if (montant!=0)
					{
						if (Type.equals("Echeance") || !meme_mode) {
							tab.put(Id,(new Double(montant)).toString());
							montantReglement=0;
							montant=0;
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}
	public String getMontant_Impute(String ech_Id) {
		return tab.get(ech_Id);
	}
}
