/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.facturation.reglements.clients;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.tools.Arrondi;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfRelances extends Action {


	private static final Font fontAdrFacture = new Font(Font.HELVETICA, 11, Font.BOLD);
	private static final Font fontAdrSociete = new Font(Font.HELVETICA, 10, Font.NORMAL);
	private static final Font fontAdrSocieteGras = new Font(Font.HELVETICA, 11, Font.BOLD);
	private static final Font fontWeb = new Font(Font.HELVETICA, 10, Font.ITALIC);
	private static final Font fontLegale = new Font(Font.HELVETICA , 8, Font.NORMAL);
	private static final Font fontTexte = new Font(Font.HELVETICA, 11, Font.NORMAL);
	private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);		// font pour lignes de listing

	private DecimalFormat numFormat = new DecimalFormat("0.00");
	private DecimalFormat numFormatCap = new DecimalFormat("0.##");
	private SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
	private Arrondi arrondi=new Arrondi(2);

	private String absdir;
	private String dossierId;

	// le logo contient les coordonn\u00E9es de l'entreprise
	private boolean logoAdr;

	// coordonn\u00E9es et infos l\u00E9gales de l'entreprise
	private String raisonSociale;
	private String adresse1;
	private String adresse2;
	private String adresse3;
	private String codePostal;
	private String ville;
	private String tel;
	private String fax;
	private String email;
	private String web;
	private String siren;
	private String typeSociete;
	private double capital;
	private String tvaIntra;
	private String rcs;
	private boolean grouper;
	private Image logo;

	private ArrayList<String[]> liste=new ArrayList<String[]>();

	private PreparedStatement psReglement;
	private PreparedStatement psRelance;
	private PreparedStatement psDestinataire;
	private PreparedStatement psDestinataireNonClient;


	public boolean serverSide() { return true; }

	public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		this.dossierId = s.getCookie().get("Dossier_Id");
		String base = s.getCookie().get("BaseDossier");

		this.absdir = s.getAppConfiguration().get("opensi.absdir");

		try {
			logo = Image.getInstance(absdir+ "/logos/"+ dossierId +".jpg");
			if (logo.getDpiX()!=0 && logo.getDpiY()!=0)
				logo.scaleAbsolute(logo.getPlainWidth() * 72 / logo.getDpiX(), logo.getPlainHeight() * 72 / logo.getDpiY());
		}
		catch (IOException e) {
			logo=null;
		}

		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("-");
		numFormat.setNegativePrefix("");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);

		numFormatCap.setDecimalFormatSymbols(dfs);
		numFormatCap.setGroupingUsed(true);
		numFormatCap.setGroupingSize(3);


		Connection con = s.getConnection(null);

		String reqReglement = "select ec.Date_Echeance, coalesce(ec.Client_Id,'') as Client_Id, ec.Denomination,";
		reqReglement += " ec.Montant as Montant_Du, ec.Montant_Restant, (ec.Montant-ec.Montant_Restant) as Montant_Regle,";
		reqReglement += " f.Num_Entier, f.Facture_Id as Piece_Id, f.Date_Facture as Date_Piece, 'Facture' as Type";
		reqReglement += " from "+ base +".ECHEANCE_CLIENT ec join "+ base +".FACTURE_ECHEANCE_CLIENT fec on ec.Echeance_Id=fec.Echeance_Id";
		reqReglement += " join "+ base +".FACTURE f on fec.Facture_Id=f.Facture_Id where ec.Echeance_Id=?";
		reqReglement += " union";
		reqReglement += " select ec.Date_Echeance, coalesce(ec.Client_Id,'') as Client_Id, ec.Denomination,";
		reqReglement += " ec.Montant as Montant_Du, ec.Montant_Restant, (ec.Montant-ec.Montant_Restant) as Montant_Regle,";
		reqReglement += " ac.Numero as Num_Entier, ac.Acompte_Id as Piece_Id, ac.Date_Acompte as Date_Piece, 'Acompte' as Type";
		reqReglement += " from "+ base +".ECHEANCE_CLIENT ec join "+ base +".ACOMPTE_ECHEANCE_CLIENT aec on ec.Echeance_Id=aec.Echeance_Id";
		reqReglement += " join "+ base +".ACOMPTE_CLIENT ac on aec.Acompte_Id=ac.Acompte_Id where ec.Echeance_Id=?";
		
		String reqRelance = "select Date_Relance from "+ base +".RELANCE where Echeance_Id=? order by Date_Relance";
		
		String reqDestinataire = "select ef.Denomination as Denomination, ef.Adresse_1, ef.Adresse_2, ef.Adresse_3, ef.Code_Postal, ef.Ville, p.Nom_FR as Pays";
		reqDestinataire += " from "+ base +".ECHEANCE_CLIENT ec,"+ base +".ADRESSE_CLIENT ef, PAYS p where ef.Code_Pays=p.Code_Pays and ef.Defaut_Fact=1 and ec.Echeance_Id=? and ec.Client_Id=ef.Client_Id";

		String reqDestinataireNonClient = "select f.Denomination, f.Adresse_1, f.Adresse_2, f.Adresse_3, f.Code_Postal, f.Ville, p.Nom_FR as Pays_Fact";
		reqDestinataireNonClient += " from "+ base +".ECHEANCE_CLIENT ec join "+ base +".FACTURE_ECHEANCE_CLIENT fec on ec.Echeance_Id=fec.Echeance_Id join "+ base +".FACTURE f on fec.Facture_Id=f.Facture_Id";
		reqDestinataireNonClient += " join PAYS p on f.Code_Pays=p.Code_Pays where ec.Echeance_Id=?";
		reqDestinataireNonClient += " union";
		reqDestinataireNonClient += " select ac.Denomination, ac.Adresse_1, ac.Adresse_2, ac.Adresse_3, ac.Code_Postal, ac.Ville, p.Nom_FR as Pays_Fact";
		reqDestinataireNonClient += " from "+ base +".ECHEANCE_CLIENT ec join "+ base +".ACOMPTE_ECHEANCE_CLIENT aec on ec.Echeance_Id=aec.Echeance_Id join "+ base +".ACOMPTE_CLIENT ac on aec.Acompte_Id=ac.Acompte_Id";
		reqDestinataireNonClient += " join PAYS p on ac.Code_Pays=p.Code_Pays where ec.Echeance_Id=?";

		psReglement = con.prepareStatement(reqReglement);
		psRelance = con.prepareStatement(reqRelance);
		psDestinataire = con.prepareStatement(reqDestinataire);
		psDestinataireNonClient = con.prepareStatement(reqDestinataireNonClient);


		Statement stt = con.createStatement();

		String reqLogo = "select Logo_Adr from "+ base +".PARAM_DOSSIER";

		ResultSet rset = stt.executeQuery(reqLogo);

		rset.next();

		this.logoAdr = rset.getInt("Logo_Adr")==1;

		rset.close();

		// coordonn\u00E9es de l'entreprise

		String reqSociete = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination,"
			+ " s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web"
			+ " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";

		rset = stt.executeQuery(reqSociete);

		rset.next();

		this.raisonSociale = rset.getString("Denomination");
		this.adresse1 = rset.getString("Adresse_1");
		this.adresse2 = rset.getString("Adresse_2");
		this.adresse3 = rset.getString("Adresse_3");
		this.codePostal = rset.getString("Code_Postal");
		this.ville = rset.getString("Ville");
		this.tel = rset.getString("Telephone");
		this.fax = rset.getString("Fax");
		this.email = rset.getString("Email");
		this.web = rset.getString("Site_Web");
		this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
		this.typeSociete = rset.getString("Type_Societe");
		this.capital = rset.getDouble("Montant_Capital");
		this.tvaIntra = rset.getString("Num_TVA_Intra");
		this.rcs = rset.getString("Ville_RCS");

		rset.close();

		Document document = new Document(PageSize.A4, 20, 20, 20, 20);
		String chemin = s.getAppConfiguration().get("opensi.absdir") + "/pdf/";

		String fichierPdf = "relances_"+ r.getParameter("id") +".pdf";

		PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

		Phrase foot=new Phrase(raisonSociale +" - "+ typeSociete +" au capital de "+ numFormatCap.format(capital) +" Euros - immatricul\u00E9e au RCS "+ rcs +" "+ siren +" - N\u00B0 TVA : "+ tvaIntra, fontLegale);
		HeaderFooter footer = new HeaderFooter(foot,false);
		footer.setAlignment(HeaderFooter.ALIGN_CENTER);
		footer.setBorder(HeaderFooter.TOP);
		footer.setBorderWidth(1);
		document.setFooter(footer);
		document.open();

		grouper=r.getParameter("Type_Edition").equals("G");
		String[] relances1 = r.getParameter("ListeRelances1").split(",");
		String[] relances2 = r.getParameter("ListeRelances2").split(",");
		String[] relances3 = r.getParameter("ListeRelances3").split(",");
		makeLettre(document,relances1,1);
		makeLettre(document,relances2,2);
		makeLettre(document,relances3,3);
		s.closeConnection(con, null);

		document.close();
		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		} catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier \u00E0 supprimer");
			se.printStackTrace();
		}

		return true;

	} // fin service


	private void makeLettre(Document document,String[] relance,int num) throws Exception {

		liste = new ArrayList<String[]>();
		ResultSet rset;
		int id = 0;
		int idprecedent = 0;
		double total = 0;
		boolean premier = true;
		for (int z=0;z<relance.length;z++) {
			String idregl = relance[z];
			if (!idregl.equals("")) {
				id=Integer.parseInt(idregl);
				psReglement.setInt(1, id);
				psReglement.setInt(2, id);
				rset = psReglement.executeQuery();
				if (rset.next()) {
					String tree[] = new String [11];
					tree[0]= formatDate.format(new Date(rset.getLong("Date_Echeance")));
					tree[1]= rset.getString("Client_Id");
					tree[2]= rset.getString("Denomination");
					tree[3]= rset.getString("Num_Entier");
					tree[4]= rset.getString("Montant_Du");
					tree[5]= rset.getString("Montant_Regle");
					tree[6]= rset.getString("Montant_Restant");
					tree[7]= formatDate.format(new Date(rset.getLong("Date_Piece")));
					tree[8]= rset.getString("Type");
					tree[9]= rset.getString("Piece_Id");
					tree[10]= idregl;
					
					if (grouper) {
						if (premier) {
							liste.add(tree);
							total += rset.getDouble("Montant_Restant");
							total = arrondi.round(total);
							premier=false;
						}
						else {
							if (liste.get(0)[0].equals(tree[0]) &&
									liste.get(0)[1].equals(tree[1]) &&
									liste.get(0)[2].equals(tree[2]) && grouper) {
								liste.add(tree);
								total += rset.getDouble("Montant_Restant");
								total = arrondi.round(total);
							}
							else {
								document.newPage();
								document.add(makeHeader(idprecedent));
								document.add(makeLettre(liste,idprecedent,total,num));
								liste = new ArrayList<String[]>();
								total = rset.getDouble("Montant_Restant");
								total = arrondi.round(total);
								liste.add(tree);
							}
						}
					}
					else {
						liste = new ArrayList<String[]>();
						liste.add(tree);
						total = rset.getDouble("Montant_Restant");
						total = arrondi.round(total);
						document.newPage();
						document.add(makeHeader(id));
						document.add(makeLettre(liste,id,total,num));
					}
					rset.close();
					
					idprecedent=Integer.parseInt(idregl);
				}
			}			
		}
		if (id!=0 && grouper && liste.size()!=0) {
			document.newPage();
			document.add(makeHeader(id));
			document.add(makeLettre(liste,id,total,num));
		}
	}


	private PdfPTable makeHeader(int id) throws Exception {

		PdfPTable pptHeader = new PdfPTable(1);

		pptHeader.setWidthPercentage(100);

		PdfPCell cell;

		cell = new PdfPCell(makeEntete(id));
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPadding(0);
		pptHeader.addCell(cell);

		cell = new PdfPCell(makeSpace(50));
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPadding(0);
		pptHeader.addCell(cell);

		return pptHeader;
	}


	private PdfPTable makeEntete(int id) throws Exception {

		PdfPTable pptEntete = new PdfPTable(2);

		pptEntete.setWidthPercentage(100);
		int[] widths = {55,45};
		pptEntete.setWidths(widths);

		PdfPCell cellSociete = new PdfPCell(makeInfosSociete());
		cellSociete.setBorder(PdfPCell.NO_BORDER);

		PdfPCell cellFacture = new PdfPCell(makeInfosFacture(id));
		cellFacture.setBorder(PdfPCell.NO_BORDER);

		pptEntete.addCell(cellSociete);
		pptEntete.addCell(cellFacture);

		return pptEntete;
	}


	private PdfPTable makeSpace(int space) throws DocumentException {

		PdfPTable pptSpace = new PdfPTable(1);

		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(space);
		cell.setPhrase(new Phrase(""));

		pptSpace.addCell(cell);

		return pptSpace;
	}


	private PdfPTable makeInfosSociete() throws Exception {

		PdfPTable pptInfos = new PdfPTable(1);

		PdfPCell cell;

		if (logo!=null) {
			cell = new PdfPCell(logo, false);
			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

			pptInfos.addCell(cell);
		}
		else {
			cell = new PdfPCell(pptInfos.getDefaultCell());
			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		}

		cell.setImage(null);

		cell.setMinimumHeight(5);
		cell.setPhrase(new Phrase("", fontAdrSociete));
		pptInfos.addCell(cell);
		cell.setMinimumHeight(0);

		if (!logoAdr) {
			cell.setPhrase(new Phrase(raisonSociale, fontAdrSocieteGras));
			pptInfos.addCell(cell);
			cell.setPhrase(new Phrase(adresse1, fontAdrSociete));
			pptInfos.addCell(cell);
			if (!adresse2.equals("")) {
				cell.setPhrase(new Phrase(adresse2, fontAdrSociete));
				pptInfos.addCell(cell);
			}
			if (!adresse3.equals("")) {
				cell.setPhrase(new Phrase(adresse3, fontAdrSociete));
				pptInfos.addCell(cell);
			}
			cell.setPhrase(new Phrase(codePostal +" "+ ville, fontAdrSociete));
			pptInfos.addCell(cell);

			String telfax = "";

			if (tel.length()>0) {
				telfax = "T\u00E9l: "+ tel;
				if (fax.length()>0) {
					telfax += " - Fax: "+ fax;
				}
			}
			else if (fax.length()>0) {
				telfax = "Fax: "+ fax;
			}

			if (telfax.length()>0) {
				cell.setPhrase(new Phrase(telfax, fontAdrSociete));
				pptInfos.addCell(cell);
			}

			if (!email.equals("")) {
				cell.setPhrase(new Phrase("e-mail: "+ email, fontAdrSociete));
				pptInfos.addCell(cell);
			}
			if (!web.equals("")) {
				cell.setPhrase(new Phrase(web, fontWeb));
				pptInfos.addCell(cell);
			}
		}

		cell.setPhrase(new Phrase(""));
		pptInfos.addCell(cell);

		return pptInfos;
	}


	private PdfPTable makeInfosFacture(int id) throws SQLException {

		PdfPTable pptInfosFacture = new PdfPTable(1);
		PdfPCell cell = new PdfPCell(pptInfosFacture.getDefaultCell());

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setPaddingBottom(4);
		cell.setBorder(PdfPCell.NO_BORDER);

		String societeFact ="";
		String adresseFact1="";
		String adresseFact2="";
		String adresseFact3="";
		String codePostalFact="";
		String villeFact="";
		String paysFact="";

		psDestinataire.setInt(1, id);
		ResultSet rset = psDestinataire.executeQuery();
		if (rset.next()) {

			societeFact = rset.getString("Denomination");
			adresseFact1 = rset.getString("Adresse_1");
			adresseFact2 = rset.getString("Adresse_2");
			adresseFact3 = rset.getString("Adresse_3");
			codePostalFact = rset.getString("Code_Postal");
			villeFact = rset.getString("Ville");
			paysFact = rset.getString("Pays");
		}
		else {
			psDestinataireNonClient.setInt(1, id);
			psDestinataireNonClient.setInt(2, id);
			rset = psDestinataireNonClient.executeQuery();

			if (rset.next()) {
				societeFact = rset.getString("Denomination");
				adresseFact1 = rset.getString("Adresse_1");
				adresseFact2 = rset.getString("Adresse_2");
				adresseFact3 = rset.getString("Adresse_3");
				codePostalFact = rset.getString("Code_Postal");
				villeFact = rset.getString("Ville");
				paysFact = rset.getString("Pays_Fact");
			}


		}
		rset.close();


		cell.setPhrase(new Phrase("", fontTexte));
		cell.setFixedHeight(120);
		pptInfosFacture.addCell(cell);
		cell.setMinimumHeight(0);

		cell.setPhrase(new Phrase(societeFact, fontAdrFacture));
		pptInfosFacture.addCell(cell);

		cell.setPhrase(new Phrase(adresseFact1, fontAdrFacture));
		pptInfosFacture.addCell(cell);

		if (!adresseFact2.equals("")) {
			cell.setPhrase(new Phrase(adresseFact2, fontAdrFacture));
			pptInfosFacture.addCell(cell);
		}
		if (!adresseFact3.equals("")) {
			cell.setPhrase(new Phrase(adresseFact3, fontAdrFacture));
			pptInfosFacture.addCell(cell);
		}

		cell.setPhrase(new Phrase(codePostalFact+" "+villeFact, fontAdrFacture));
		pptInfosFacture.addCell(cell);

		if (!paysFact.equals("")) {
			cell.setPhrase(new Phrase(paysFact, fontAdrFacture));
			pptInfosFacture.addCell(cell);
		}

		cell.setPhrase(new Phrase("", fontTexte));
		pptInfosFacture.addCell(cell);
		return pptInfosFacture;
	}

	private PdfPTable makeLettre(ArrayList<String[]> liste,int id,double total,int num) throws SQLException {
		PdfPTable table=new PdfPTable(2);
		if (num==1) {
			table=makeLettre1(liste,id,total);
		}
		else if (num==2) {
			table=makeLettre2(liste,id,total);
		}
		else if (num==3) {
			table=makeLettre3(liste,id,total);
		}
		return table;
	}

	private PdfPTable makeLettre1(ArrayList<String[]> liste,int id,double total) throws SQLException {
		
		String dateLettre;
		psRelance.setInt(1, id);
		ResultSet rset = psRelance.executeQuery();
		if (rset.next()) {
			dateLettre = formatDate.format(new Date(rset.getLong("Date_Relance")));
		} else {
			dateLettre = formatDate.format(new Date(System.currentTimeMillis()));
		}
		rset.close();

		String texte = "Madame, Monsieur,\n\n\n\n";

		PdfPTable tab = new PdfPTable(2);
		tab.setWidthPercentage(100);

		PdfPCell cel = new PdfPCell(tab.getDefaultCell());
		cel.setBorder(PdfPCell.NO_BORDER);

		cel.setPhrase(new Phrase("Objet : Lettre de relance", fontTexte));
		tab.addCell(cel);

		cel.setPhrase(new Phrase("Date : "+ dateLettre, fontTexte));
		tab.addCell(cel);

		cel.setColspan(2);
		cel.setPhrase(new Phrase(""));
		cel.setFixedHeight(15);
		tab.addCell(cel);
		cel.setMinimumHeight(0);
		
		if (!(liste.get(0))[1].isEmpty()) {
			cel.setPhrase(new Phrase("N\u00B0 Client : "+ (liste.get(0))[1], fontTexte));
			tab.addCell(cel);
		}

		cel.setPhrase(new Phrase(""));
		cel.setFixedHeight(40);
		tab.addCell(cel);
		cel.setMinimumHeight(0);

		int nb=liste.size();
		if (nb==1) {

			String echeance =(liste.get(0))[0];
			String numfact =(liste.get(0))[3];
			double montant_rest = Double.parseDouble((liste.get(0))[6]);
			String datefact =(liste.get(0))[7];
			String prov =(liste.get(0))[8];


			texte += "Par la pr\u00E9sente, nous nous permettons de vous signaler que votre compte-client pr\u00E9sente \u00E0 ce jour un solde d\u00E9biteur de "+ numFormat.format(montant_rest) +" \u20AC TTC.";
			if (prov.equals("Facture"))
				texte += "\n\nEn effet, la facture n\u00B0 "+ numfact +" que nous vous avons adress\u00E9e le "+ datefact +" et payable au "+ echeance +", n'a pas encore \u00E9t\u00E9 honor\u00E9e.";
			else
				texte += "\n\nEn effet, l'acompte n\u00B0 "+ numfact +" que nous vous avons adress\u00E9e le "+ datefact +" et payable au "+ echeance +", n'a pas encore \u00E9t\u00E9 honor\u00E9e.";
		}
		else {
			texte += "Par la pr\u00E9sente, nous nous permettons de vous signaler que votre compte-client pr\u00E9sente \u00E0 ce jour un solde d\u00E9biteur de "+ numFormat.format(total) +" \u20AC TTC.";

			texte += "\n\nD\u00E9tail des \u00E9ch\u00E9ances : \n\n";
			cel.setHorizontalAlignment(PdfPCell.ALIGN_JUSTIFIED);
			cel.setPhrase(new Phrase(texte, fontTexte));
			tab.addCell(cel);
			texte="";
			PdfPTable tabtitre = new PdfPTable(5);
			tabtitre.setWidthPercentage(100);
			tabtitre=putTitre(tabtitre);
			PdfPCell celtitre = new PdfPCell(tabtitre);
			celtitre.setColspan(2);
			tab.addCell(celtitre);

			for (int i=0;i<nb;i++) {
				PdfPTable tabech = new PdfPTable(5);
				tabech.setWidthPercentage(100);
				String echeance =(liste.get(i))[0];
				String numfact =(liste.get(i))[3];
				double montant = Double.parseDouble((liste.get(i))[4]);
				double montant_regl = Double.parseDouble((liste.get(i))[5]);
				double montant_rest = Double.parseDouble((liste.get(i))[6]);
				tabech=putLigneEcheance(tabech,echeance,numfact,montant,montant_regl,montant_rest);
				PdfPCell cel2 = new PdfPCell(tabech);
				cel2.setColspan(2);
				tab.addCell(cel2);
			}
		}
		texte += "\nNous sommes persuad\u00E9s qu'il s'agit d'un oubli de votre part, toutefois, l'\u00E9ch\u00E9ance \u00E9tant d\u00E9pass\u00E9e, ";
		texte += "nous vous demandons de nous faire parvenir son r\u00E8glement sous huitaine.";

		texte += "\n\nNous nous permettons de vous pr\u00E9ciser qu'\u00E0 d\u00E9faut de paiement apr\u00E8s cette premi\u00E8re relance ";
		texte += "nous serions amen\u00E9s \u00E0 vous facturer les int\u00E9rts de retard pr\u00E9vus par nos conditions g\u00E9n\u00E9rales de vente.";

		texte += "\nNous vous invitons \u00E0 nous contacter au cas o ce retard serait volontaire ";
		texte += "afin de nous en communiquer les motifs, et de pouvoir prendre d'un commun accord de nouvelles dispositions.";

		texte += "\n\nDans le cas o votre r\u00E8glement nous parviendrait avant r\u00E9ception de ce courrier ";
		texte += "veuillez consid\u00E9rer cette lettre comme nulle et non avenue.";

		texte += "\n\n\nNous vous prions d'agr\u00E9er, Madame, Monsieur, l'assurance de notre consid\u00E9ration distingu\u00E9e.";

		texte += "\n\n\n\nLa comptabilit\u00E9";
		cel.setHorizontalAlignment(PdfPCell.ALIGN_JUSTIFIED);
		cel.setPhrase(new Phrase(texte, fontTexte));
		tab.addCell(cel);

		return tab;
	}


	private PdfPTable makeLettre2(ArrayList<String[]> liste,int id,double total) throws SQLException {

		String dateLettre;
		
		psRelance.setInt(1, id);
		ResultSet rset = psRelance.executeQuery();
		rset.next();
		String relance = formatDate.format(new Date(rset.getLong("Date_Relance")));
		if (rset.next()) {
			dateLettre = formatDate.format(new Date(rset.getLong("Date_Relance")));
		} else {
			dateLettre = formatDate.format(new Date(System.currentTimeMillis()));
		}
		rset.close();

		PdfPTable tab = new PdfPTable(2);
		tab.setWidthPercentage(100);

		PdfPCell cel = new PdfPCell(tab.getDefaultCell());
		cel.setBorder(PdfPCell.NO_BORDER);

		cel.setPhrase(new Phrase("Objet : Lettre de relance n\u00B0 2", fontTexte));
		tab.addCell(cel);

		cel.setPhrase(new Phrase("Date : "+ dateLettre, fontTexte));
		tab.addCell(cel);

		cel.setColspan(2);
		cel.setPhrase(new Phrase(""));
		cel.setFixedHeight(15);
		tab.addCell(cel);
		cel.setMinimumHeight(0);

		if (!(liste.get(0))[1].isEmpty()) {
			cel.setPhrase(new Phrase("N\u00B0 Client : "+ (liste.get(0))[1], fontTexte));
			tab.addCell(cel);
		}

		cel.setPhrase(new Phrase(""));
		cel.setFixedHeight(40);
		tab.addCell(cel);
		cel.setMinimumHeight(0);

		String texte="";
		int nb=liste.size();
		if (nb==1) {
			String echeance =(liste.get(0))[0];
			String numfact =(liste.get(0))[3];
			String prov =(liste.get(0))[8];
			texte = "Madame, Monsieur,\n\n\n\n";
			texte += "Faisant suite \u00E0 notre courrier du "+ relance;

			if (prov.equals("Facture"))
				texte += " nous sommes au regret de constater que concernant la facture N\u00B0 "+ numfact +" \u00E9chue";
			else
				texte += " nous sommes au regret de constater que concernant l'acompte N\u00B0 "+ numfact +" \u00E9chu";
			texte += " le "+ echeance +", la somme de "+ numFormat.format(total) +" \u20AC TTC n'a toujours pas \u00E9t\u00E9 r\u00E9gl\u00E9e.";
			texte += "\n\n\nNous vous saurions donc gr\u00E9 de r\u00E9gulariser cette facture dans les meilleurs d\u00E9lais.";
			texte += "\n\n\nNous vous prions d'agr\u00E9er, Madame, Monsieur, l'assurance de notre consid\u00E9ration distingu\u00E9e.";
		}
		else {
			texte = "Madame, Monsieur,\n\n\n\n";
			texte += "Faisant suite \u00E0 notre pr\u00E9c\u00E9dent courrier de relance du "+ relance;
			texte += ", rest\u00E9 \u00E0 ce jour sans r\u00E9ponse de votre part,";
			texte += " nous vous prions de bien vouloir constater sur le tableau ci-dessous";
			texte += " les factures qui n\u2019ont toujours pas \u00E9t\u00E9 r\u00E9gl\u00E9es.\n\n";

			cel.setHorizontalAlignment(PdfPCell.ALIGN_JUSTIFIED);
			cel.setPhrase(new Phrase(texte, fontTexte));
			tab.addCell(cel);
			texte="";
			PdfPTable tabtitre = new PdfPTable(5);
			tabtitre.setWidthPercentage(100);
			tabtitre=putTitre(tabtitre);
			PdfPCell celtitre = new PdfPCell(tabtitre);
			celtitre.setColspan(2);
			tab.addCell(celtitre);

			for (int i=0;i<nb;i++) {
				PdfPTable tabech = new PdfPTable(5);
				tabech.setWidthPercentage(100);
				String echeance =(liste.get(i))[0];
				String numfact =(liste.get(i))[3];
				double montant = Double.parseDouble((liste.get(i))[4]);
				double montant_regl = Double.parseDouble((liste.get(i))[5]);
				double montant_rest = Double.parseDouble((liste.get(i))[6]);
				tabech=putLigneEcheance(tabech,echeance,numfact,montant,montant_regl,montant_rest);
				PdfPCell cel2 = new PdfPCell(tabech);
				cel2.setColspan(2);
				tab.addCell(cel2);
			}
			texte += "\n\nNous vous serions reconnaissant de bien vouloir r\u00E9gulariser ces factures";
			texte += " d\u2019un montant total de : "+ numFormat.format(total) +" \u20ac dans les meilleurs d\u00E9lais.";
			texte += "\n\n\nNous vous saurions donc gr\u00E9 de r\u00E9gulariser ces factures dans les meilleurs d\u00E9lais.";
			texte += "\n\n\nNous vous prions d'agr\u00E9er, Madame, Monsieur, l'assurance de notre consid\u00E9ration distingu\u00E9e.";
		}
		texte += "\n\n\n\nLa comptabilit\u00E9";
		cel.setHorizontalAlignment(PdfPCell.ALIGN_JUSTIFIED);
		cel.setPhrase(new Phrase(texte, fontTexte));
		tab.addCell(cel);

		return tab;

	}


	private PdfPTable makeLettre3(ArrayList<String[]> liste,int id,double total) throws SQLException {

		String dateLettre;
		String relances = "";
		psRelance.setInt(1, id);
		ResultSet rset = psRelance.executeQuery();
		rset.next();
		relances += formatDate.format(new Date(rset.getLong("Date_Relance")));
		rset.next();
		relances += " et " + formatDate.format(new Date(rset.getLong("Date_Relance")));
		if (rset.next()) {
			dateLettre = formatDate.format(new Date(rset.getLong("Date_Relance")));
		} else {
			dateLettre = formatDate.format(new Date(System.currentTimeMillis()));
		}
		rset.close();

		PdfPTable tab = new PdfPTable(2);
		tab.setWidthPercentage(100);

		PdfPCell cel = new PdfPCell(tab.getDefaultCell());
		cel.setBorder(PdfPCell.NO_BORDER);

		cel.setPhrase(new Phrase("Objet : Lettre de relance n\u00B0 3", fontTexte));
		tab.addCell(cel);

		cel.setPhrase(new Phrase("Date : "+ dateLettre, fontTexte));
		tab.addCell(cel);

		cel.setColspan(2);
		cel.setPhrase(new Phrase(""));
		cel.setFixedHeight(15);
		tab.addCell(cel);
		cel.setMinimumHeight(0);

		if (!(liste.get(0))[1].isEmpty()) {
			cel.setPhrase(new Phrase("N\u00B0 Client : "+ (liste.get(0))[1], fontTexte));
			tab.addCell(cel);
		}

		cel.setPhrase(new Phrase(""));
		cel.setFixedHeight(40);
		tab.addCell(cel);
		cel.setMinimumHeight(0);

		String texte="";

		int nb=liste.size();
		if (nb==1) {
			String echeance =(liste.get(0))[0];
			String numfact =(liste.get(0))[3];
			String prov =(liste.get(0))[8];

			texte = "Madame, Monsieur,\n\n\n\n";
			texte += "Nous constatons avec regret qu'en d\u00E9pit de nos courriers de relance des "+ relances;
			if (prov.equals("Facture"))
				texte += ", votre soci\u00E9t\u00E9 n'a toujours pas proc\u00E9d\u00E9 au r\u00E8glement de notre facture N\u00B0 "+ numfact +", \u00E9chue";
			else
				texte += ", votre soci\u00E9t\u00E9 n'a toujours pas proc\u00E9d\u00E9 au r\u00E8glement de notre acompte N\u00B0 "+ numfact +", \u00E9chu";
			texte += " le "+ echeance +".";
			texte += "\n\nEn cons\u00E9quence, nous vous mettons en demeure par la pr\u00E9sente lettre de nous r\u00E9gler";
			texte += " la somme de "+ numFormat.format(total) +" \u20AC, dans un d\u00E9lai maximum de huit jours \u00E0 compter de ce jour.";
			texte += "\n\nA d\u00E9faut, nous serons contraints d'engager une action judiciaire \u00E0 votre encontre.";
			texte += "\n\nNous vous rappelons que le pr\u00E9sent courrier fait courir les int\u00E9rts l\u00E9gaux et conventionnels.";
			texte += "\n\n\nNous vous prions d'agr\u00E9er, Madame, Monsieur, l'assurance de notre consid\u00E9ration distingu\u00E9e.";
		}
		else {
			texte = "Madame, Monsieur,\n\n\n\n";
			texte += "Faisant suite \u00E0 nos pr\u00E9c\u00E9dents courriers de relance des "+ relances;
			texte += ", rest\u00E9 \u00E0 ce jour sans r\u00E9ponse de votre part,";
			texte += " nous vous prions de bien vouloir constater sur le tableau ci-dessous";
			texte += " les factures qui n\u2019ont toujours pas \u00E9t\u00E9 r\u00E9gl\u00E9es.\n\n";

			cel.setHorizontalAlignment(PdfPCell.ALIGN_JUSTIFIED);
			cel.setPhrase(new Phrase(texte, fontTexte));
			tab.addCell(cel);
			texte="";
			PdfPTable tabtitre = new PdfPTable(5);
			tabtitre.setWidthPercentage(100);
			tabtitre=putTitre(tabtitre);
			PdfPCell celtitre = new PdfPCell(tabtitre);
			celtitre.setColspan(2);
			tab.addCell(celtitre);

			for (int i=0;i<nb;i++) {
				PdfPTable tabech = new PdfPTable(5);
				tabech.setWidthPercentage(100);
				String echeance =(liste.get(i))[0];
				String numfact =(liste.get(i))[3];
				double montant = Double.parseDouble((liste.get(i))[4]);
				double montant_regl = Double.parseDouble((liste.get(i))[5]);
				double montant_rest = Double.parseDouble((liste.get(i))[6]);
				tabech=putLigneEcheance(tabech,echeance,numfact,montant,montant_regl,montant_rest);
				PdfPCell cel2 = new PdfPCell(tabech);
				cel2.setColspan(2);
				tab.addCell(cel2);
			}
			texte += "\n\nEn cons\u00E9quence, nous vous mettons en demeure par la pr\u00E9sente lettre";
			texte += " de bien vouloir r\u00E9gler le total de ces factures soit : ";
			texte += numFormat.format(total) +" \u20ac dans un d\u00E9lai maximum de huit jours \u00E0 compter de ce jour.";
			texte += "\n\nA d\u00E9faut, nous serons contraints d'engager une action judiciaire \u00E0 votre encontre.";
			texte += "\n\nNous vous rappelons que le pr\u00E9sent courrier fait courir les int\u00E9rts l\u00E9gaux et conventionnels.";
			texte += "\n\n\nNous vous prions d'agr\u00E9er, Madame, Monsieur, l'assurance de notre consid\u00E9ration distingu\u00E9e.";
		}
		texte += "\n\n\n\nLa comptabilit\u00E9";
		cel.setHorizontalAlignment(PdfPCell.ALIGN_JUSTIFIED);
		cel.setPhrase(new Phrase(texte, fontTexte));
		tab.addCell(cel);

		return tab;
	}

	private PdfPTable putLigneEcheance(PdfPTable listing,
			String dateEch,
			String numFact,
			double montant,
			double regle,
			double rest) {


		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(dateEch, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(numFact, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(numFormat.format(montant), fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(numFormat.format(regle), fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(numFormat.format(rest), fontLine));
		listing.addCell(cellListing);
		return listing;
	}

	private PdfPTable putTitre(PdfPTable titresColonnes) {

		PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

		cellTitre.setColspan(1);
		cellTitre.setFixedHeight(20);
		cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
		cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellTitre.setBorder(PdfPCell.BOX);
		cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellTitre.setPhrase(new Phrase("DATE", fontLine));
		titresColonnes.addCell(cellTitre);

		cellTitre.setPhrase(new Phrase("N\u00B0 FACTURE", fontLine));
		titresColonnes.addCell(cellTitre);

		cellTitre.setPhrase(new Phrase("MONTANT", fontLine));
		titresColonnes.addCell(cellTitre);

		cellTitre.setPhrase(new Phrase("MONTANT REGLE", fontLine));
		titresColonnes.addCell(cellTitre);

		cellTitre.setPhrase(new Phrase("MONTANT RESTANT", fontLine));
		titresColonnes.addCell(cellTitre);

		return titresColonnes;
	}

} // fin GenPdfRelances



