/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.facturation.reglements.clients;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfRemise extends Action {


	class MyPageEvent implements PdfPageEvent {

	private String dateCourante;

	private String raisonSociale;
	private String adresse1;
	private String adresse2;
	private String adresse3;
	private String codePostal;
	private String ville;
	private String typer;
	private String adresseBanque;
	private String codeAgence;
	private String codeGuichet;
	private String compte;
	private String cleRib;
	private String iban;
	private String bic;
	private boolean banque;


		public MyPageEvent(String dossierId,int type_r, int banque) throws SQLException {

			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery("select * from "+ base +".SOCIETE");

			if (rset.next()) {

				this.raisonSociale = rset.getString("Denomination");
				this.adresse1 = rset.getString("Adresse_1");
				this.adresse2 = rset.getString("Adresse_2");
				this.adresse3 = rset.getString("Adresse_3");
				this.codePostal = rset.getString("Code_Postal");
				this.ville = rset.getString("Ville");
			}
			rset.close();

			rset = stt.executeQuery("select Libelle from "+ base +".TYPE_REGLEMENT where Type_Reg_Id="+ type_r);
			rset.next();
			this.typer = rset.getString("Libelle");
			rset.close();		
			
			this.banque = false;
			
			rset = stt.executeQuery("select * from "+ base +".BANQUE where Banque_Id="+ banque);

			if (rset.next()) {
				this.adresseBanque = rset.getString("Adresse");
				this.codeAgence = rset.getString("Code_Agence");
				this.codeGuichet = rset.getString("Code_Guichet");
				this.compte = rset.getString("Num_Compte");
				this.cleRib = rset.getString("Cle_RIB");
				this.iban = rset.getString("IBAN");
				this.bic = rset.getString("BIC");
				this.banque = true;
				rset.close();
			}
			
			stt.close();
			
			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
		}


		public void onStartPage(PdfWriter writer, Document document) {

			try {
				// Entete G\u00E9n\u00E9rale

				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setColspan(1);
				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setColspan(1);
				cellEntete.setPhrase(new Phrase("", fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse1, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse2, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);
				
				cellEntete.setPhrase(new Phrase("", fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);
				
				if (!adresse3.equals("")) {
					cellEntete.setPhrase(new Phrase(adresse3, fontGen));
					cellEntete.setColspan(2);
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
					entete.addCell(cellEntete);
					cellEntete.setColspan(1);
					
					cellEntete.setPhrase(new Phrase("", fontGen));
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
					entete.addCell(cellEntete);
				}

				cellEntete.setPhrase(new Phrase(codePostal + " " + ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("BORDEREAU DE REMISE " + typer+" en Euros", new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete G\u00E9n\u00E9rale

				//debut RIB
				if (banque) {
					PdfPTable RIBHaut = new PdfPTable(6);
					RIBHaut.setWidthPercentage(100);
					RIBHaut.setWidths(widthsHaut);
					PdfPCell cellRIB = new PdfPCell(RIBHaut.getDefaultCell());

					cellRIB.setColspan(6);
					cellRIB.setFixedHeight(20);
					cellRIB.setBorder(PdfPCell.NO_BORDER);
					cellRIB.setPhrase(new Phrase("", fontLine));
					RIBHaut.addCell(cellRIB);

					cellRIB.setFixedHeight(15);
					cellRIB.setBorder(PdfPCell.BOX);

					cellRIB.setColspan(1);
					cellRIB.setBackgroundColor(Color.LIGHT_GRAY);
					cellRIB.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
					cellRIB.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

					cellRIB.setPhrase(new Phrase("C/ETAB'", fontLine));
					RIBHaut.addCell(cellRIB);

					cellRIB.setPhrase(new Phrase("C/GUICHET", fontLine));
					RIBHaut.addCell(cellRIB);

					cellRIB.setPhrase(new Phrase("N\u00B0 COMPTE", fontLine));
					RIBHaut.addCell(cellRIB);

					cellRIB.setPhrase(new Phrase("CLE RIB", fontLine));
					RIBHaut.addCell(cellRIB);

					cellRIB.setBackgroundColor(Color.WHITE);
					cellRIB.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
					cellRIB.setPhrase(new Phrase("", fontLine));
					RIBHaut.addCell(cellRIB);
					cellRIB.setBorder(PdfPCell.BOX);
					cellRIB.setBackgroundColor(Color.LIGHT_GRAY);

					cellRIB.setPhrase(new Phrase("DOMICILIATION", fontLine));
					RIBHaut.addCell(cellRIB);

					cellRIB.setBackgroundColor(Color.WHITE);

					cellRIB.setPhrase(new Phrase(codeAgence, fontLine));
					RIBHaut.addCell(cellRIB);

					cellRIB.setPhrase(new Phrase(codeGuichet, fontLine));
					RIBHaut.addCell(cellRIB);

					cellRIB.setPhrase(new Phrase(compte, fontLine));
					RIBHaut.addCell(cellRIB);

					cellRIB.setPhrase(new Phrase(cleRib, fontLine));
					RIBHaut.addCell(cellRIB);

					cellRIB.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
					cellRIB.setPhrase(new Phrase("", fontLine));
					RIBHaut.addCell(cellRIB);
					cellRIB.setBorder(PdfPCell.BOX);

					cellRIB.setPhrase(new Phrase(adresseBanque, fontLine));
					RIBHaut.addCell(cellRIB);

					document.add(RIBHaut);

					PdfPTable RIBBas = new PdfPTable(9);
					RIBBas.setWidthPercentage(100);
					RIBBas.setWidths(widthsBas);
					cellRIB = new PdfPCell(RIBBas.getDefaultCell());

					cellRIB.setColspan(7);
					cellRIB.setFixedHeight(5);
					cellRIB.setBorder(PdfPCell.TOP);
					cellRIB.setBackgroundColor(Color.WHITE);
					cellRIB.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
					cellRIB.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

					cellRIB.setPhrase(new Phrase("", fontLine));
					RIBBas.addCell(cellRIB);

					cellRIB.setBorder(PdfPCell.NO_BORDER);
					cellRIB.setColspan(1);
					cellRIB.setPhrase(new Phrase("", fontLine));
					RIBBas.addCell(cellRIB);

					cellRIB.setBorder(PdfPCell.TOP);
					cellRIB.setColspan(1);
					cellRIB.setPhrase(new Phrase("", fontLine));
					RIBBas.addCell(cellRIB);

					cellRIB.setFixedHeight(15);
					cellRIB.setBorder(PdfPCell.BOX);
					cellRIB.setBackgroundColor(Color.LIGHT_GRAY);
					cellRIB.setColspan(7);
					cellRIB.setPhrase(new Phrase("IBAN", fontLine));
					RIBBas.addCell(cellRIB);

					cellRIB.setColspan(1);

					cellRIB.setBackgroundColor(Color.WHITE);
					cellRIB.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
					cellRIB.setPhrase(new Phrase("", fontLine));
					RIBBas.addCell(cellRIB);
					cellRIB.setBorder(PdfPCell.BOX);
					cellRIB.setBackgroundColor(Color.LIGHT_GRAY);

					cellRIB.setPhrase(new Phrase("BIC", fontLine));
					RIBBas.addCell(cellRIB);


					if (iban.equals("")) {
						cellRIB.setColspan(7);
						cellRIB.setBackgroundColor(Color.WHITE);
						cellRIB.setBorder(PdfPCell.BOX);
						cellRIB.setPhrase(new Phrase("", fontLine));
						RIBBas.addCell(cellRIB);

					}
					else {
						cellRIB.setColspan(1);
						cellRIB.setBackgroundColor(Color.WHITE);

						cellRIB.setBorder(PdfPCell.BOX-PdfPCell.RIGHT);
						cellRIB.setPhrase(new Phrase(iban, fontLine));
						RIBBas.addCell(cellRIB);

						cellRIB.setBorder(PdfPCell.BOX-PdfPCell.LEFT-PdfPCell.RIGHT);
						cellRIB.setPhrase(new Phrase(codeAgence.substring(0,4), fontLine));
						RIBBas.addCell(cellRIB);

						cellRIB.setPhrase(new Phrase(codeAgence.substring(4)+""+codeGuichet.substring(0,3), fontLine));
						RIBBas.addCell(cellRIB);

						cellRIB.setPhrase(new Phrase(codeGuichet.substring(3)+""+compte.substring(0,2), fontLine));
						RIBBas.addCell(cellRIB);

						cellRIB.setPhrase(new Phrase(compte.substring(2,6), fontLine));
						RIBBas.addCell(cellRIB);

						cellRIB.setPhrase(new Phrase(compte.substring(6,10), fontLine));
						RIBBas.addCell(cellRIB);
						cellRIB.setBorder(PdfPCell.BOX-PdfPCell.LEFT);
						cellRIB.setPhrase(new Phrase(compte.substring(10)+""+cleRib, fontLine));
						RIBBas.addCell(cellRIB);
					}
					cellRIB.setBackgroundColor(Color.WHITE);
					cellRIB.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
					cellRIB.setPhrase(new Phrase("", fontLine));
					cellRIB.setColspan(1);
					RIBBas.addCell(cellRIB);
					cellRIB.setBorder(PdfPCell.BOX);

					cellRIB.setColspan(1);
					cellRIB.setPhrase(new Phrase(bic, fontLine));
					RIBBas.addCell(cellRIB);

					document.add(RIBBas);
				}
				//fin RIB
				// Titres de colonnes

				PdfPTable titresColonnes = new PdfPTable(4);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widths);
				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(15);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setColspan(8);
				titresColonnes.addCell(cellTitre);
				cellTitre.setColspan(1);

				cellTitre.setFixedHeight(20);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

				cellTitre.setPhrase(new Phrase("TIREUR", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("ETABLISSEMENT PAYEUR", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("N\u00B0 PIECE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("MONTANT", fontLine));
				titresColonnes.addCell(cellTitre);

				document.add(titresColonnes);

				// fin Titres de colonnes

			} catch(DocumentException de) {
				de.printStackTrace();
			}
		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
		public void onCloseDocument(PdfWriter writer, Document document) {}
		public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
		public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
		public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
		public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);		// font pour lignes de listing
private DecimalFormat numFormat = new DecimalFormat("0.00");

private int widths[] = {30,25,20,25}; // largeurs des colonnes du listing
private int widthsHaut[] = {14,14,11,10,1,50}; // largeurs des colonnes du RIB Haut
private int widthsBas[] = {7,7,7,7,7,7,7,1,50}; // largeurs des colonnes du RIB Bas


private Connection con;
private String base;


	public boolean serverSide() { return true; }

	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		try {
		con = s.getConnection(null);

		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("-");
		numFormat.setNegativePrefix("");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);

		base = s.getCookie().get("BaseDossier");
		String dossierId = s.getCookie().get("Dossier_Id");

		String fichierPdf = r.getParameter("FichierPdf");
		int remiseId = Integer.parseInt(r.getParameter("Remise_Id"));

		ResultSet rset;	// reglements

		PdfPTable listing;


		Document document = new Document(PageSize.A4, 25, 25, 25, 25);

		String chemin = s.getAppConfiguration().get("opensi.absdir") + "/pdf/";


		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));
		
		String reqRemise = "select rb.Type_Reg_Id, rb.Banque_Remise from "+ base +".REMISE_BANQUE rb";
		reqRemise += " where rb.Remise_Id="+ remiseId +" limit 1";
		Statement stt = con.createStatement();
		rset = stt.executeQuery(reqRemise);

		rset.next();
		int typeReg = rset.getInt("Type_Reg_Id");
		int banqueRemise = rset.getInt("Banque_Remise");
		rset.close();

		MyPageEvent event = new MyPageEvent(dossierId,typeReg,banqueRemise);

		writer.setPageEvent(event);

		double total = 0;
		listing = new PdfPTable(4);
		listing.setWidthPercentage(100);
		listing.setWidths(widths);
		String reqCountReglements = "select count(*) as nb from "+ base +".REGLEMENT_CLIENT rc";
		reqCountReglements += " join "+ base +".REMISE_REGLEMENT_CLIENT rrc on rc.Reglement_Id=rrc.Reglement_Id";
		reqCountReglements += " where rrc.Remise_Id="+ remiseId;
		rset = stt.executeQuery(reqCountReglements);
		rset.next();
		int nbReglements = rset.getInt("nb");
		rset.close();
		
		String reqReglements = "select * from " + base + ".REGLEMENT_CLIENT rc";
		reqReglements += " join "+ base +".REMISE_REGLEMENT_CLIENT rrc on rc.Reglement_Id=rrc.Reglement_Id";
		reqReglements += " where rrc.Remise_Id="+ remiseId +" order by rc.Date_Reg";
		rset = stt.executeQuery(reqReglements);
		while (rset.next()) {
			String banque = rset.getString("Banque_Client");
			String raisonSociale = rset.getString("Denomination");
			String numPiece = rset.getString("Num_Piece");
			double montant = rset.getDouble("Montant");
			putLigneRemise(listing,raisonSociale,banque,numPiece,montant);
			total += montant;
		}
		rset.close();


		putTotalRemise(listing,total,nbReglements);

		if (!document.isOpen()) {
			document.open();
		}

		document.add(listing);

		s.closeConnection(con, null);


		if (document.isOpen()) {
			document.close();
		}

		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier \u00E0 supprimer");
			se.printStackTrace();
		}

		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;


	} // fin service



	/** Ajoute une ligne d'operation au listing */

	private void putLigneRemise(PdfPTable listing,
				    String raisonSociale,
				    String banque,
				    String numPiece,
				    double montant) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBorder(PdfPCell.LEFT);

		cellListing.setPaddingRight(0);

		cellListing.setPhrase(new Phrase(raisonSociale, fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(banque, fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(numPiece, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
		cellListing.setHorizontalAlignment(montant==0?PdfPCell.ALIGN_LEFT:PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(montant), fontLine));
		listing.addCell(cellListing);

	}

		/** Ajoute une ligne de total de la periode d'edition du journal au listing */

	private void putTotalRemise(PdfPTable listing, double total, int nbReglements) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(new Color(210,210,210));
		
		cellListing.setPaddingLeft(5);
		cellListing.setPaddingRight(5);
		
		cellListing.setColspan(2);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase("Nombre de pi\u00E8ces : "+ nbReglements, fontLine));
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase("TOTAL", fontLine));
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(total), fontLine));
		listing.addCell(cellListing);

	}

} // fin GenPdfRemise
