/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'une facture standard
 */

package org.opensi.util.calcul;


public class CalculDocumentV2 extends CalculDocument {

	
	public CalculDocumentV2(double acompte, double escompte, double remise, double fraisPort, double tauxTvaPort, int codeTvaPort, double mRemise, boolean editionTTC, double pRemise_FP, double mRemise_FP) {
		super(acompte, escompte, remise, fraisPort, tauxTvaPort, codeTvaPort, mRemise, editionTTC, pRemise_FP, mRemise_FP);
		if (fraisPort>0) {
			mRemiseFP = r2.round(fraisPort* (pRemise_FP/100));
			mFraisPort = r2.round(fraisPort - mRemiseFP);
			setLigneTVA(codeTvaPort,tauxTvaPort,mFraisPort,mFraisPortHR,0,true);
		}
	}

	public void addLigne(int ligneId, double quantite, double prixUnitaire, double ristourne, int codeTVA, double tauxTVA, double commission, double prixAchat) {

		LigneDocumentV2 ld1 = (LigneDocumentV2) lignes.get(new Integer(ligneId));
		if (ld1!=null && lignes.containsKey(new Integer(ligneId))) {
			ld1.addLigne(quantite, prixUnitaire, ristourne, tauxTVA, commission, tTVACommission, prixAchat, editionTTC);
			lignes.put(new Integer(ligneId),ld1);  
		}
		else {
			LigneDocumentV2 ld2 = new LigneDocumentV2();
			ld2.addLigne(quantite, prixUnitaire, ristourne, tauxTVA, commission, tTVACommission, prixAchat, editionTTC);
			lignes.put(new Integer(ligneId),ld2);
		}
		
		LigneDocumentV2 ld = (LigneDocumentV2) lignes.get(new Integer(ligneId));
		if (ld.mQuantifieLigne>0) {
			setLigneTVA(codeTVA,tauxTVA,ld.mQuantifieLigne ,ld.mQuantifieHorsRistourneLigne ,pRemise, false);
		}
		
		if (ld.mQuantifieHorsRistourneLigne>0 && (ristourne>0 || pRemise>0)) {
			setLigneRemise(codeTVA,tauxTVA,ld.mQuantifieHorsRistourneLigne,ristourne);
		}
		if (commission>0) {
			setLigneCommission(cTVACommission,tTVACommission,ld.mQuantifieCommissionLigne ,pRemise);
		}
	}
	

	private void setLigneTVA(int codeTVA,double tauxTVA, double montantBase, double montantBaseHorsRemise,double pRemise, boolean port) {

		CalculVentilTVAV2 vt = (CalculVentilTVAV2)lignesTVA.get(new Integer(codeTVA));
		if (vt!=null && lignesTVA.containsKey(new Integer(codeTVA))) {
			vt.addLigne(tauxTVA, montantBase, editionTTC,montantBaseHorsRemise, pRemise, port);
			lignesTVA.put(new Integer(codeTVA),vt);  
		}
		else {
			CalculVentilTVAV2 vt2 = new CalculVentilTVAV2();
			vt2.addLigne(tauxTVA, montantBase, editionTTC,montantBaseHorsRemise, pRemise, port);
			lignesTVA.put(new Integer(codeTVA),vt2);
		}
	}

	private void setLigneRemise(int codeTVA,double tauxTVA, double montantBase, double ristourne) {

		CalculVentilTVARemiseV2 vt = (CalculVentilTVARemiseV2)lignesTVARemise.get(new Integer(codeTVA));
		if (vt!=null && lignesTVARemise.containsKey(new Integer(codeTVA))) {
			vt.addLigne(tauxTVA, montantBase,ristourne, pRemise, editionTTC);
			lignesTVARemise.put(new Integer(codeTVA),vt);  
		}
		else {
			CalculVentilTVARemiseV2 vt2 = new CalculVentilTVARemiseV2();
			vt2.addLigne(tauxTVA, montantBase,ristourne, pRemise, editionTTC);
			lignesTVARemise.put(new Integer(codeTVA),vt2);
		}
	}

	private void setLigneCommission(int codeTVA,double tauxTVA, double montantBase, double pRemise) {

		CalculVentilTVACommissionV2 vt = (CalculVentilTVACommissionV2)lignesTVACommission.get(new Integer(codeTVA));
		if (vt!=null && lignesTVACommission.containsKey(new Integer(codeTVA))) {
			vt.addLigne(tauxTVA, montantBase,pRemise, editionTTC);
			lignesTVACommission.put(new Integer(codeTVA),vt);  
		}
		else {
			CalculVentilTVACommissionV2 vt2 = new CalculVentilTVACommissionV2();
			vt2.addLigne(tauxTVA, montantBase,pRemise, editionTTC);
			lignesTVACommission.put(new Integer(codeTVA),vt2);
		}
	}

	public void calculTotaux() {
		this.montantHT = 0;
		this.totalTVA = 0;
		this.mRemise = 0;
		double tPrixAchat = 0;
		double tHT = 0;
		
		li = getLignesTVA().keySet().iterator();
		while (li.hasNext()) {
			cv = getLignesTVA().get(li.next());
			if (editionTTC) {
				this.montantTTC += cv.getMontantTTCB();
			}
			else {
				this.montantHT += cv.getMontantHTB();				
			}
			this.montantHTN += cv.getMontantHTN();				
			this.montantTTCN += cv.getMontantTTCN();				
			this.mRemise += cv.getMontantRemise();
			this.totalTVA +=cv.getMontantTVA();	
		}
		
		li = getLignes().keySet().iterator();
		while (li.hasNext()) {
			ld = getLignes().get(li.next());
			tPrixAchat += ld.prixAchat * ld.quantite;
		}
		li = getLignesTVA().keySet().iterator();
		while (li.hasNext()) {
			cv = getLignesTVA().get(li.next());
			tHT += cv.getMontantHTHF();
		}

		mMarge = r2.round((tHT - mRemise) - (tPrixAchat));
		pMarge = r2.round(((tHT - mRemise)!=0)?((mMarge / ((tHT - mRemise)) * 100)):100);
		
		li = getLignesTVACommission().keySet().iterator();
		while (li.hasNext()) {
			cvc = getLignesTVACommission().get(li.next());
			this.totalHTC += cvc.getTotalHTC();				
			this.totalTVAC += cvc.getTotalTVAC();				
			this.totalTTCC += cvc.getTotalTTCC();
		}
		
		if (editionTTC) {
			this.montantTTC= r2.round(montantTTC);
			this.mRemise= r2.round(mRemise);
			this.totalTTC = r2.round(montantTTC - mRemise + mFraisPort - totalTTCC);
			this.totalTVA= r2.round(totalTVA - totalTVAC);
			this.mEscompte = r2.round(totalTTC * pEscompte/100);
			this.netAPayer = r2.round(totalTTC - acompte - mEscompte);			
			this.totalHT = r2.round(totalTTC - totalTVA);
			this.totalTTC = r2.round(totalTTC - mEscompte);
			this.totalHTTable = totalHT;
			this.totalTTCTable = totalTTC;

			mHTRemiseFP = mRemiseFP/(1+(tTVAFraisPort/100));
			mTTCRemiseFP = mRemiseFP;

			mHTFraisPort = mFraisPort/(1+(tTVAFraisPort/100));
			mTTCFraisPort = mFraisPort;

			mHTFraisPortHR = mFraisPortHR/(1+(tTVAFraisPort/100));
			mTTCFraisPortHR = mFraisPortHR;
		}
		else {
			this.montantHT= r2.round(montantHT);
			this.mRemise= r2.round(mRemise);
			tPrixAchat= r2.round(tPrixAchat);

			this.totalHT= r2.round(montantHT - mRemise + mFraisPort);
			this.totalHTCommissionne= r2.round(totalHT - totalHTC);
			this.totalTVA= r2.round(totalTVA - totalTVAC);
			this.montantTTC = r2.round((totalHT - totalHTC) + totalTVA);
			this.mEscompte = r2.round(montantTTC * pEscompte/100);
			this.totalTTC = r2.round(montantTTC - mEscompte);
			this.netAPayer = r2.round(totalTTC - acompte);
			this.totalHTTable = totalHT;
			this.totalTTCTable = totalTTC;

			mHTRemiseFP = mRemiseFP;
			mTTCRemiseFP = mRemiseFP*(1+(tTVAFraisPort/100));

			mHTFraisPort = mFraisPort;
			mTTCFraisPort = mFraisPort *(1+(tTVAFraisPort/100));

			mHTFraisPortHR = mFraisPortHR;
			mTTCFraisPortHR = mFraisPortHR *(1+(tTVAFraisPort/100));

		}
		mTVARemiseFP = mTTCRemiseFP-mHTRemiseFP;
		mTVAFraisPortHR = mTTCFraisPortHR-mHTFraisPortHR;
		mTVAFraisPort = mTTCFraisPort-mHTFraisPort;

	}

	public double getRemisePCalcul() {
		return ((editionTTC)?montantTTC>0:montantHT>0)?(r6.round(mRemise*100/((editionTTC)?montantTTC:montantHT))):0;
	}
	public double getPRemise_FPCalcul() {
		return (mFraisPort>0)?r6.round((mRemiseFPBase/mFraisPort)*100):0;
	}
}
